/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultHighlighter;

public abstract class AbstractDJPane
extends JTextPane
implements OptionConstants {
    private static final double SCROLL_UNIT = 0.05;
    static DefaultHighlighter.DefaultHighlightPainter MATCH_PAINTER;
    static DefaultHighlighter.DefaultHighlightPainter ERROR_PAINTER;
    protected HighlightManager _highlightManager;
    protected CaretListener _matchListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            AbstractDJPane.this.getDJDocument().setCurrentLocation(AbstractDJPane.this.getCaretPosition());
            AbstractDJPane.this._removePreviousHighlight();
            AbstractDJPane.this._updateMatchHighlight();
        }
    };
    protected HighlightManager.HighlightInfo _matchHighlight = null;
    protected final SwingDocument NULL_DOCUMENT = new SwingDocument();

    AbstractDJPane(SwingDocument doc) {
        super(doc);
        this.setContentType("text/java");
        this.addCaretListener(this._matchListener);
    }

    protected void _addHighlight(int from, int to) {
        this._matchHighlight = this._highlightManager.addHighlight(from, to, MATCH_PAINTER);
    }

    protected abstract void _updateMatchHighlight();

    protected void _removePreviousHighlight() {
        if (this._matchHighlight != null) {
            this._matchHighlight.remove();
            this._matchHighlight = null;
        }
    }

    public void setCaretPosition(int pos) {
        super.setCaretPosition(pos);
        this.getDJDocument().setCurrentLocation(pos);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRectangle, int orientation, int direction) {
        return (int)(visibleRectangle.getHeight() * 0.05);
    }

    public void moveCaretPosition(int pos) {
        super.moveCaretPosition(pos);
    }

    public void indent() {
        this.indent(0);
    }

    public void indent(int reason) {
        this.getDJDocument().setCurrentLocation(this.getCaretPosition());
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        ProgressMonitor pm = null;
        if (this.shouldIndent(selStart, selEnd)) {
            this.indentLines(selStart, selEnd, reason, pm);
        }
    }

    protected abstract void indentLines(int var1, int var2, int var3, ProgressMonitor var4);

    protected abstract boolean shouldIndent(int var1, int var2);

    public abstract DJDocument getDJDocument();

    static {
        Color highColor = DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR);
        MATCH_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(highColor);
        ERROR_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(DrJava.getConfig().getSetting(COMPILER_ERROR_COLOR));
    }
}

