/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.platform;

import edu.rice.cs.drjava.platform.DefaultPlatform;
import java.net.URL;

class WindowsPlatform
extends DefaultPlatform {
    public static WindowsPlatform ONLY = new WindowsPlatform();

    protected WindowsPlatform() {
    }

    public boolean isWindowsPlatform() {
        return true;
    }

    public boolean openURL(URL address) {
        if (super.openURL(address)) {
            return true;
        }
        try {
            String addressString = address.toString();
            if (addressString.startsWith("file:/")) {
                String suffix = addressString.substring("file:/".length(), addressString.length());
                addressString = "file://" + suffix;
            }
            Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", addressString});
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }
}

