/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.AbstractReducedModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import java.util.Stack;

public class ReducedModelBrace
extends AbstractReducedModel {
    private ReducedModelControl _parent;

    public ReducedModelBrace(ReducedModelControl parent) {
        this._parent = parent;
    }

    public void insertChar(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this._insertBrace(String.valueOf(ch));
                break;
            }
            default: {
                this._insertGap(1);
            }
        }
    }

    private void _insertBrace(String text) {
        if (this._cursor.atStart() || this._cursor.atEnd()) {
            this._cursor.insertNewBrace(text);
        } else if (((ReducedToken)this._cursor.current()).isGap()) {
            this._cursor.insertBraceToGap(text);
        } else {
            this._cursor.insertNewBrace(text);
        }
    }

    protected void insertGapBetweenMultiCharBrace(int length) {
        throw new RuntimeException("ReducedModelBrace does not keep track of multi-character braces.");
    }

    public void move(int count) {
        this._cursor.move(count);
    }

    public void delete(int count) {
        if (count == 0) {
            return;
        }
        this._cursor.delete(count);
    }

    private boolean _isCurrentBraceMatchable() {
        String type = ((ReducedToken)this._cursor.current()).getType();
        return (type.equals("{") || type.equals("}") || type.equals("(") || type.equals(")") || type.equals("[") || type.equals("]")) && this._parent.getStateAtCurrent() == FREE;
    }

    public int previousBrace() {
        int dist = 0;
        this.resetWalkerLocationToCursor();
        TokenList.Iterator copyCursor = this._cursor._copy();
        if (!copyCursor.atStart()) {
            copyCursor.prev();
        }
        if (copyCursor.atStart()) {
            copyCursor.dispose();
            return -1;
        }
        int relDistance = dist += this._cursor.getBlockOffset();
        while (!copyCursor.atStart()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist + ((ReducedToken)copyCursor.current()).getSize();
                }
                relDistance = 0;
            }
            dist += ((ReducedToken)copyCursor.current()).getSize();
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.prev();
        }
        copyCursor.dispose();
        return -1;
    }

    public int nextBrace() {
        int relDistance = 0;
        int dist = 0;
        TokenList.Iterator copyCursor = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        if (copyCursor.atStart()) {
            copyCursor.next();
        }
        if (this._cursor.getBlockOffset() > 0) {
            relDistance = dist = ((ReducedToken)copyCursor.current()).getSize() - this._cursor.getBlockOffset();
            copyCursor.next();
        }
        while (!copyCursor.atEnd()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist;
                }
                relDistance = 0;
            }
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            dist += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.next();
        }
        copyCursor.dispose();
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int balanceForward() {
        Stack braceStack = new Stack();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = 0;
        if (iter.atStart() || iter.atFirstItem() || !this.openBraceImmediatelyLeft()) {
            iter.dispose();
            return -1;
        }
        iter.prev();
        int relDistance = -((ReducedToken)iter.current()).getSize();
        if (!((ReducedToken)iter.current()).isOpenBrace()) {
            iter.dispose();
            return -1;
        }
        if (this.moveWalkerGetState(relDistance) != FREE) {
            iter.dispose();
            return -1;
        }
        braceStack.push(iter.current());
        iter.next();
        this.moveWalkerGetState(-relDistance);
        relDistance = 0;
        while (!iter.atEnd() && !braceStack.isEmpty()) {
            if (!((ReducedToken)iter.current()).isGap()) {
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    if (((ReducedToken)iter.current()).isClosedBrace()) {
                        ReducedToken popped = (ReducedToken)braceStack.pop();
                        if (!((ReducedToken)iter.current()).isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(iter.current());
                    }
                }
                relDistance = 0;
            }
            distance += ((ReducedToken)iter.current()).getSize();
            relDistance += ((ReducedToken)iter.current()).getSize();
            iter.next();
        }
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    public boolean openBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        this._cursor.prev();
        boolean isLeft = this._cursor.getBlockOffset() == 0 && ((ReducedToken)this._cursor.current()).isOpen() && this._isCurrentBraceMatchable();
        this._cursor.next();
        return isLeft;
    }

    public boolean closedBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        this._cursor.prev();
        boolean isLeft = this._cursor.getBlockOffset() == 0 && ((ReducedToken)this._cursor.current()).isClosed() && this._isCurrentBraceMatchable();
        this._cursor.next();
        return isLeft;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int balanceBackward() {
        Stack braceStack = new Stack();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = 0;
        if (iter.atStart() || iter.atFirstItem() || !this.closedBraceImmediatelyLeft()) {
            iter.dispose();
            return -1;
        }
        iter.prev();
        int relDistance = ((ReducedToken)iter.current()).getSize();
        if (!((ReducedToken)iter.current()).isClosedBrace()) {
            iter.dispose();
            return -1;
        }
        if (this.moveWalkerGetState(-relDistance) != FREE) {
            iter.dispose();
            return -1;
        }
        braceStack.push(iter.current());
        distance += ((ReducedToken)iter.current()).getSize();
        iter.prev();
        if (!iter.atStart()) {
            distance += ((ReducedToken)iter.current()).getSize();
            relDistance = ((ReducedToken)iter.current()).getSize();
        }
        while (!iter.atStart() && !braceStack.isEmpty()) {
            if (!((ReducedToken)iter.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (((ReducedToken)iter.current()).isOpenBrace()) {
                        ReducedToken popped = (ReducedToken)braceStack.pop();
                        if (!((ReducedToken)iter.current()).isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(iter.current());
                    }
                }
                relDistance = 0;
            }
            iter.prev();
            if (iter.atStart() || braceStack.isEmpty()) continue;
            distance += ((ReducedToken)iter.current()).getSize();
            relDistance += ((ReducedToken)iter.current()).getSize();
        }
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    protected ReducedModelState moveWalkerGetState(int relDistance) {
        return this._parent.moveWalkerGetState(relDistance);
    }

    protected void resetWalkerLocationToCursor() {
        this._parent.resetLocation();
    }

    protected void getDistToEnclosingBrace(IndentInfo braceInfo) {
        int relDistance;
        Stack braceStack = new Stack();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = braceInfo.distToNewline + 1;
        if (braceInfo.distToNewline == -1) {
            iter.dispose();
            return;
        }
        iter.move(-braceInfo.distToNewline - 1);
        relDistance += iter.getBlockOffset();
        distance += iter.getBlockOffset();
        braceInfo.distToNewline = -1;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return;
        }
        iter.prev();
        while (!iter.atStart()) {
            distance += ((ReducedToken)iter.current()).getSize();
            relDistance += ((ReducedToken)iter.current()).getSize();
            if (!((ReducedToken)iter.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (((ReducedToken)iter.current()).isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            braceInfo.braceType = ((ReducedToken)iter.current()).getType();
                            braceInfo.distToBrace = distance;
                            iter.dispose();
                            return;
                        }
                        ReducedToken popped = (ReducedToken)braceStack.pop();
                        if (!((ReducedToken)iter.current()).isMatch(popped)) {
                            iter.dispose();
                            return;
                        }
                    } else {
                        braceStack.push(iter.current());
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
    }

    protected void getDistToEnclosingBraceCurrent(IndentInfo braceInfo) {
        int relDistance;
        Stack braceStack = new Stack();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = 0;
        relDistance += iter.getBlockOffset();
        distance += iter.getBlockOffset();
        braceInfo.distToNewlineCurrent = -1;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return;
        }
        iter.prev();
        while (!iter.atStart()) {
            distance += ((ReducedToken)iter.current()).getSize();
            relDistance += ((ReducedToken)iter.current()).getSize();
            if (!((ReducedToken)iter.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (((ReducedToken)iter.current()).isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            braceInfo.braceTypeCurrent = ((ReducedToken)iter.current()).getType();
                            braceInfo.distToBraceCurrent = distance;
                            iter.dispose();
                            return;
                        }
                        ReducedToken popped = (ReducedToken)braceStack.pop();
                        if (!((ReducedToken)iter.current()).isMatch(popped)) {
                            iter.dispose();
                            return;
                        }
                    } else {
                        braceStack.push(iter.current());
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
    }
}

