/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.util.swing.Utilities;
import java.util.LinkedList;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager {
    private static int counter = 0;
    private int id = ++counter;
    private LinkedList<CompoundEdit> _compoundEdits = new LinkedList();
    private LinkedList<Integer> _keys = new LinkedList();
    private int _nextKey = 0;
    private UndoableEdit _savePoint = null;
    private final GlobalEventNotifier _notifier;

    public CompoundUndoManager(GlobalEventNotifier notifier) {
        this._notifier = notifier;
    }

    public synchronized int startCompoundEdit() {
        this._compoundEdits.add(0, new CompoundEdit());
        this._keys.add(0, new Integer(this._nextKey));
        this._nextKey = this._nextKey < Integer.MAX_VALUE ? ++this._nextKey : Integer.MIN_VALUE;
        return this._keys.get(0);
    }

    public synchronized void endLastCompoundEdit() {
        if (this._keys.size() == 0) {
            return;
        }
        this.endCompoundEdit(this._keys.get(0));
    }

    public synchronized void endCompoundEdit(int key) {
        if (this._keys.size() > 0) {
            if (this._keys.get(0) == key) {
                CompoundEdit compoundEdit = this._compoundEdits.remove(0);
                compoundEdit.end();
                if (compoundEdit.canUndo()) {
                    if (!this._compoundEditInProgress()) {
                        super.addEdit(compoundEdit);
                        this._notifyUndoHappened();
                    } else {
                        this._compoundEdits.get(0).addEdit(compoundEdit);
                    }
                }
                this._keys.remove(0);
            } else {
                throw new IllegalStateException("Improperly nested compound edits.");
            }
        }
    }

    public synchronized CompoundEdit getLastCompoundEdit() {
        return this._compoundEdits.get(0);
    }

    public UndoableEdit getNextUndo() {
        return this.editToBeUndone();
    }

    public UndoableEdit getNextRedo() {
        return this.editToBeRedone();
    }

    public synchronized boolean addEdit(UndoableEdit e) {
        if (this._compoundEditInProgress()) {
            return this._compoundEdits.get(0).addEdit(e);
        }
        boolean result = super.addEdit(e);
        this._notifyUndoHappened();
        return result;
    }

    public boolean _compoundEditInProgress() {
        return !this._compoundEdits.isEmpty();
    }

    public boolean canUndo() {
        return this._compoundEditInProgress() || super.canUndo();
    }

    public String getUndoPresentationName() {
        if (this._compoundEditInProgress()) {
            return "Undo Previous Command";
        }
        return super.getUndoPresentationName();
    }

    public void undo() {
        this.endCompoundEdit();
        super.undo();
    }

    public synchronized void undo(int key) {
        if (this._keys.get(0) != key) {
            throw new IllegalArgumentException("Bad undo key " + key + "!");
        }
        CompoundEdit compoundEdit = this._compoundEdits.get(0);
        this._compoundEdits.remove(0);
        this._keys.remove(0);
        compoundEdit.end();
        compoundEdit.undo();
        compoundEdit.die();
    }

    public void redo() {
        this.endCompoundEdit();
        super.redo();
    }

    private void _notifyUndoHappened() {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                CompoundUndoManager.access$000(CompoundUndoManager.this).undoableEditHappened();
            }
        });
    }

    private synchronized void endCompoundEdit() {
        if (this._compoundEditInProgress()) {
            while (this._keys.size() > 0) {
                this.endCompoundEdit(this._keys.get(0));
            }
        }
    }

    public void documentSaved() {
        this.endCompoundEdit();
        this._savePoint = this.editToBeUndone();
    }

    public boolean isModified() {
        return this.editToBeUndone() != this._savePoint;
    }

    public String toString() {
        return "(CompoundUndoManager: " + this.id + ")";
    }

    static GlobalEventNotifier access$000(CompoundUndoManager x0) {
        return x0._notifier;
    }
}

