/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DirectorySelector;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.IGetDocuments;
import edu.rice.cs.drjava.model.JavadocEventNotifier;
import edu.rice.cs.drjava.model.JavadocListener;
import edu.rice.cs.drjava.model.JavadocModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.platform.PlatformSupport;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.newjvm.ExecJVM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavadocModel
implements JavadocModel {
    private IGetDocuments _model;
    private final JavadocEventNotifier _notifier = new JavadocEventNotifier();
    private CompilerErrorModel _javadocErrorModel;

    public DefaultJavadocModel(IGetDocuments model) {
        this._model = model;
        this._javadocErrorModel = new CompilerErrorModel();
    }

    @Override
    public void addListener(JavadocListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(JavadocListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public CompilerErrorModel getJavadocErrorModel() {
        return this._javadocErrorModel;
    }

    @Override
    public void resetJavadocErrors() {
        this._javadocErrorModel = new CompilerErrorModel();
    }

    @Override
    public void javadocAll(DirectorySelector select, final FileSaveSelector saver, final String classpath) throws IOException {
        if (this._model.hasModifiedDocuments() || this._model.hasUntitledDocuments()) {
            return;
        }
        FileConfiguration config = DrJava.getConfig();
        File destDir = config.getSetting(OptionConstants.JAVADOC_DESTINATION);
        try {
            destDir = destDir.equals(FileOption.NULL_FILE) ? select.getDirectory(null) : select.getDirectory(destDir);
            while (!(destDir.exists() && destDir.isDirectory() && destDir.canWrite())) {
                if (!destDir.getPath().equals("") && !destDir.exists()) {
                    boolean create = select.askUser(new StringBuffer().append("The directory you chose does not exist:\\n'").append(destDir).append("'\nWould you like to create it?").toString(), "Create Directory?");
                    if (create) {
                        boolean dirMade = destDir.mkdirs();
                        if (dirMade) continue;
                        throw new IOException(new StringBuffer().append("Could not create directory: ").append(destDir).toString());
                    }
                    return;
                }
                if (!destDir.isDirectory() || destDir.getPath().equals("")) {
                    select.warnUser(new StringBuffer().append("The file you chose is not a directory:\n'").append(destDir).append("'\n").append("Please choose another.").toString(), "Not a Directory!");
                    destDir = select.getDirectory(null);
                    continue;
                }
                select.warnUser(new StringBuffer().append("The directory you chose is not writable:\n'").append(destDir).append("'\n").append("Please choose another directory.").toString(), "Cannot Write to Destination!");
                destDir = select.getDirectory(null);
            }
        }
        catch (OperationCanceledException oce) {
            return;
        }
        final File destDirF = destDir;
        new Thread("DrJava Javadoc Thread"){

            public void run() {
                DefaultJavadocModel.access$000(DefaultJavadocModel.this, destDirF, saver, classpath);
            }
        }.start();
    }

    private void _javadocAllWorker(File destDirFile, FileSaveSelector saver, String classpath) {
        if (!this._ensureValidToolsJar()) {
            return;
        }
        String destDir = destDirFile.getAbsolutePath();
        HashSet<String> docUnits = new HashSet<String>();
        HashSet<File> sourceRootSet = new HashSet<File>();
        HashSet<File> defaultRoots = new HashSet<File>();
        HashSet<String> topLevelPacks = new HashSet<String>();
        boolean docAll = DrJava.getConfig().getSetting(OptionConstants.JAVADOC_FROM_ROOTS);
        List<OpenDefinitionsDocument> docs = this._model.getOpenDefinitionsDocuments();
        for (OpenDefinitionsDocument doc : docs) {
            File file = null;
            try {
                File searchRoot;
                String topLevelPack;
                file = this._getFileFromDocument(doc, saver);
                if (file == null) {
                    throw new IllegalStateException("No file for this document.");
                }
                File sourceRoot = doc.getSourceRoot();
                String pack = doc.getPackageName();
                if (pack.equals("")) {
                    File[] javaFiles;
                    if (defaultRoots.contains(sourceRoot)) continue;
                    defaultRoots.add(sourceRoot);
                    for (File f : javaFiles = sourceRoot.listFiles(FileOps.JAVA_FILE_FILTER)) {
                        docUnits.add(f.getAbsolutePath());
                    }
                    continue;
                }
                int index = pack.indexOf(46);
                if (docAll && index != -1) {
                    topLevelPack = pack.substring(0, index);
                    searchRoot = new File(sourceRoot, topLevelPack);
                } else {
                    topLevelPack = pack;
                    searchRoot = new File(sourceRoot, pack.replace('.', File.separatorChar));
                }
                if (topLevelPacks.contains(topLevelPack) && sourceRootSet.contains(sourceRoot)) continue;
                topLevelPacks.add(topLevelPack);
                sourceRootSet.add(sourceRoot);
                docUnits.addAll(FileOps.packageExplore(topLevelPack, searchRoot));
            }
            catch (IllegalStateException ise) {
            }
            catch (IOException ioe) {
                this._notifier.javadocStarted();
                this._showCompilerError(ioe.getMessage(), file);
                return;
            }
            catch (InvalidPackageException ipe) {
                this._notifier.javadocStarted();
                this._showCompilerError(ipe.getMessage(), file);
                return;
            }
        }
        if (docUnits.size() == 0) {
            return;
        }
        StringBuffer sourcePath = new StringBuffer();
        String separator = System.getProperty("path.separator");
        sourceRootSet.addAll(defaultRoots);
        File[] sourceRoots = sourceRootSet.toArray(new File[sourceRootSet.size()]);
        for (int a = 0; a < sourceRoots.length; ++a) {
            if (a != 0) {
                sourcePath.append(separator);
            }
            sourcePath.append(sourceRoots[a].getAbsolutePath());
        }
        ArrayList<String> args = this._buildCommandLineArgs(docUnits, destDir, sourcePath.toString(), classpath);
        this._runJavadoc(args, classpath, destDirFile, true);
    }

    @Override
    public void javadocDocument(OpenDefinitionsDocument doc, FileSaveSelector saver, final String classpath) throws IOException {
        if (doc.isUntitled() || doc.isModifiedSinceSave()) {
            this._notifier.saveBeforeJavadoc();
        }
        if (doc.isUntitled() || doc.isModifiedSinceSave()) {
            return;
        }
        final File file = this._getFileFromDocument(doc, saver);
        final File destDir = FileOps.createTempDirectory("DrJava-javadoc");
        new Thread("DrJava Javadoc Thread"){

            public void run() {
                DefaultJavadocModel.access$100(DefaultJavadocModel.this, destDir, file, classpath);
            }
        }.start();
    }

    private void _javadocDocumentWorker(File destDirFile, File docFile, String classpath) {
        if (!this._ensureValidToolsJar()) {
            return;
        }
        String destDir = destDirFile.getAbsolutePath();
        ArrayList<String> args = this._buildCommandLineArgs(docFile, destDir, classpath);
        this._runJavadoc(args, classpath, destDirFile, false);
    }

    @Override
    public File suggestJavadocDestination(OpenDefinitionsDocument doc) {
        this._attemptSaveAllDocuments();
        try {
            File sourceRoot = doc.getSourceRoot();
            return new File(sourceRoot, "doc");
        }
        catch (InvalidPackageException ipe) {
            return null;
        }
    }

    private void _attemptSaveAllDocuments() {
        if (this._model.hasModifiedDocuments() || this._model.hasUntitledDocuments()) {
            this._notifier.saveBeforeJavadoc();
        }
    }

    private boolean _ensureValidToolsJar() {
        PlatformSupport platform = PlatformFactory.ONLY;
        String version = platform.getJavaSpecVersion();
        if (!"1.3".equals(version) && platform.has13ToolsJar()) {
            String msg = new StringBuffer().append("There is an incompatible version of tools.jar on your\nclasspath, so Javadoc cannot run.\n(tools.jar is version 1.3, JDK is version ").append(version).append(")").toString();
            this._notifier.javadocStarted();
            this._showCompilerError(msg, null);
            return false;
        }
        return true;
    }

    private void _showCompilerError(String msg, File f) {
        CompilerError[] errors = new CompilerError[]{new CompilerError(f, -1, -1, msg, false)};
        this._javadocErrorModel = new CompilerErrorModel(errors, this._model);
        this._notifier.javadocEnded(false, null, false);
    }

    private void _runJavadoc(ArrayList<String> args, String classpath, File destDirFile, boolean allDocs) {
        try {
            this._notifier.javadocStarted();
            boolean result = this._javadoc(args.toArray(new String[args.size()]), classpath);
            if (result && !allDocs) {
                FileOps.deleteDirectoryOnExit(destDirFile);
            }
            this._notifier.javadocEnded(result, destDirFile, allDocs);
        }
        catch (Throwable e) {
            this._showCompilerError(e.getMessage(), null);
        }
    }

    private boolean _javadoc(String[] args, String classpath) throws IOException {
        String JAVADOC_CLASS = "com.sun.tools.javadoc.Main";
        String jsr14path = DrJava.getConfig().getSetting(OptionConstants.JSR14_LOCATION).toString();
        double version = Double.valueOf(System.getProperty("java.specification.version"));
        String[] jvmArgs = new String[]{};
        if (version < 1.5 && jsr14path != null && !jsr14path.equals("")) {
            jvmArgs = new String[]{new StringBuffer().append("-Xbootclasspath/p:").append(jsr14path).toString()};
        }
        Process javadocProcess = ExecJVM.runJVM("com.sun.tools.javadoc.Main", args, new String[]{classpath}, jvmArgs);
        LinkedList<String> outLines = new LinkedList<String>();
        LinkedList<String> errLines = new LinkedList<String>();
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(500L);
                javadocProcess.exitValue();
                done = true;
            }
            catch (InterruptedException e) {
            }
            catch (IllegalThreadStateException e) {
                ExecJVM.ventBuffers(javadocProcess, outLines, errLines);
            }
        }
        ExecJVM.ventBuffers(javadocProcess, outLines, errLines);
        ArrayList<CompilerError> errors = this._extractErrors(outLines);
        errors.addAll(this._extractErrors(errLines));
        this._javadocErrorModel = new CompilerErrorModel(errors.toArray(new CompilerError[errors.size()]), this._model);
        return this._javadocErrorModel.hasOnlyWarnings();
    }

    private ArrayList<CompilerError> _extractErrors(LinkedList lines) {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>(100);
        String ERROR_INDICATOR = "Error: ";
        String EXCEPTION_INDICATOR = "Exception: ";
        String BAD_FLAG_INDICATOR = "invalid flag:";
        while (lines.size() > 0) {
            String output = (String)lines.removeFirst();
            int errStart = output.indexOf("Error: ");
            if (errStart == -1) {
                errStart = output.indexOf("Exception: ");
            }
            if (errStart == -1) {
                errStart = output.indexOf("invalid flag:");
            }
            if (errStart != -1) {
                StringBuffer buf = new StringBuffer(60 * lines.size());
                buf.append(output);
                while (lines.size() > 0) {
                    output = (String)lines.removeFirst();
                    buf.append('\n');
                    buf.append(output);
                }
                errors.add(new CompilerError(buf.toString(), false));
                continue;
            }
            CompilerError error = this._parseJavadocErrorLine(output);
            if (error == null) continue;
            errors.add(error);
        }
        return errors;
    }

    private CompilerError _parseJavadocErrorLine(String line) {
        if (line == null) {
            return null;
        }
        String JAVA_INDICATOR = ".java:";
        String GJ_INDICATOR = ".gj:";
        CompilerError error = null;
        int errStart = line.indexOf(".java:");
        if (errStart == -1) {
            errStart = line.indexOf(".gj:");
        }
        if (errStart != -1) {
            String filename = line.substring(0, errStart + 5);
            int lineno = -1;
            StringBuffer linenoString = new StringBuffer();
            int pos = errStart + 6;
            while (line.charAt(pos) >= '0' && line.charAt(pos) <= '9') {
                linenoString.append(line.charAt(pos));
                ++pos;
            }
            if (line.charAt(pos) == ':') {
                try {
                    lineno = Integer.valueOf(linenoString.toString()) - 1;
                }
                catch (NumberFormatException e) {}
            } else {
                pos = errStart;
            }
            String errMessage = line.substring(pos + 2);
            boolean isWarning = false;
            if (errMessage.substring(0, 7).equalsIgnoreCase("warning")) {
                isWarning = true;
            }
            error = lineno >= 0 ? new CompilerError(new File(filename), lineno, 0, errMessage, false) : new CompilerError(new File(filename), errMessage, false);
        }
        return error;
    }

    private File _getFileFromDocument(OpenDefinitionsDocument doc, FileSaveSelector saver) throws IOException {
        try {
            return doc.getFile();
        }
        catch (FileMovedException fme) {
            if (saver.shouldSaveAfterFileMoved(doc, fme.getFile())) {
                try {
                    doc.saveFileAs(saver);
                    return doc.getFile();
                }
                catch (FileMovedException fme2) {
                    fme2.printStackTrace();
                    throw new IOException(new StringBuffer().append("Could not find file: ").append(fme2).toString());
                }
            }
            throw new IllegalStateException("No file exists for this document.");
        }
    }

    protected ArrayList<String> _buildCommandLineArgs(Collection<String> docUnits, String destDir, String sourcePath, String classpath) {
        ArrayList<String> args = new ArrayList<String>();
        this._addBasicArguments(args, destDir, sourcePath, classpath);
        this._addOnlineLinkArguments(args);
        args.addAll(docUnits);
        return args;
    }

    protected ArrayList<String> _buildCommandLineArgs(File file, String destDir, String classpath) {
        ArrayList<String> args = new ArrayList<String>();
        this._addBasicArguments(args, destDir, "", classpath);
        this._addSingleDocArguments(args);
        args.add(file.getAbsolutePath());
        return args;
    }

    private void _addBasicArguments(ArrayList<String> args, String destDir, String sourcePath, String classpath) {
        FileConfiguration config = DrJava.getConfig();
        String accLevel = config.getSetting(OptionConstants.JAVADOC_ACCESS_LEVEL);
        StringBuffer accArg = new StringBuffer(10);
        accArg.append('-');
        accArg.append(accLevel);
        args.add(accArg.toString());
        if (!sourcePath.equals("")) {
            args.add("-sourcepath");
            args.add(sourcePath);
        }
        args.add("-d");
        args.add(destDir);
        args.add("-classpath");
        args.add(classpath);
        String custom = config.getSetting(OptionConstants.JAVADOC_CUSTOM_PARAMS);
        args.addAll(ArgumentTokenizer.tokenize(custom));
    }

    private void _addOnlineLinkArguments(ArrayList<String> args) {
        FileConfiguration config = DrJava.getConfig();
        String linkVersion = config.getSetting(OptionConstants.JAVADOC_LINK_VERSION);
        if (linkVersion.equals("1.3")) {
            args.add("-link");
            args.add(config.getSetting(OptionConstants.JAVADOC_1_3_LINK));
        } else if (linkVersion.equals("1.4")) {
            args.add("-link");
            args.add(config.getSetting(OptionConstants.JAVADOC_1_4_LINK));
        } else if (linkVersion.equals("1.5")) {
            args.add("-link");
            args.add(config.getSetting(OptionConstants.JAVADOC_1_5_LINK));
        }
    }

    private void _addSingleDocArguments(ArrayList<String> args) {
        args.add("-noindex");
        args.add("-notree");
        args.add("-nohelp");
        args.add("-nonavbar");
    }

    static void access$000(DefaultJavadocModel x0, File x1, FileSaveSelector x2, String x3) {
        x0._javadocAllWorker(x1, x2, x3);
    }

    static void access$100(DefaultJavadocModel x0, File x1, File x2, String x3) {
        x0._javadocDocumentWorker(x1, x2, x3);
    }
}

