/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Table;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.util.StringUtil;

public class RemoteTest
extends Thread {
    public static void open() {
        try {
            if (Midlet.getPlatform() == 10) {
                RemoteTest remoteTest = (RemoteTest)Class.forName("net.yura.android.AndroidRemoteTest").newInstance();
                remoteTest.start();
            } else {
                new RemoteTest().start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RemoteTest() {
        super("RemoteTest");
    }

    public void run() {
        while (true) {
            ServerSocketConnection ssc = null;
            try {
                Thread.sleep(5000L);
                System.out.println("Remote Test starting...");
                ssc = (ServerSocketConnection)Connector.open((String)"socket://:1234");
                System.out.println("Remote Test " + ssc.getLocalAddress() + " " + ssc.getLocalPort());
                StreamConnection sc = ssc.acceptAndOpen();
                InputStream is = sc.openInputStream();
                OutputStream out = sc.openOutputStream();
                UTF8InputStreamReader reader = new UTF8InputStreamReader(is);
                OutputStreamWriter writer = new OutputStreamWriter(out);
                while (true) {
                    String command = RemoteTest.readLine(reader);
                    System.out.println("COMMAND: " + command);
                    this.process(command, writer);
                }
            }
            catch (Throwable ex) {
                System.out.println("failed to start RemoteTest " + ex);
                try {
                    ssc.close();
                }
                catch (Throwable throwable) {
                }
                continue;
            }
            break;
        }
    }

    protected void process(String command, Writer writer) throws IOException {
        try {
            if (command.startsWith("click ")) {
                String text = command.substring("click ".length());
                text = this.replaceEscapeSequences(text);
                boolean result = this.onClickText(text);
                System.out.println("result: " + result);
                writer.write(result ? "OK\n" : "FAIL\n");
            } else if (command.startsWith("clickFocusable ")) {
                String text = command.substring("clickFocusable ".length());
                String[] idxs = StringUtil.split(text, ' ');
                int n1 = Integer.parseInt(idxs[0]);
                int n2 = idxs.length <= 1 ? 0 : Integer.parseInt(idxs[1]);
                boolean result = this.onClickFocusable(n1 - 1, n2 - 1);
                writer.write(result ? "OK\n" : "FAIL\n");
            } else if (command.equalsIgnoreCase("setCursorInvisible")) {
                this.onSetCursorInvisible();
                writer.write("OK\n");
            } else if (command.startsWith("command ")) {
                String cmd = command.substring("command ".length());
                boolean result = this.onCommand(cmd);
                writer.write(result ? "OK\n" : "FAIL\n");
            } else {
                System.out.println("Unknown command: " + command);
                writer.write("UNKNOWN\n");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            writer.write("EXCEPTION: " + e + "\n");
        }
        writer.flush();
    }

    protected boolean onClickText(String text) {
        System.out.println("CLICK on >" + text + "<");
        Window window = DesktopPane.getDesktopPane().getSelectedFrame();
        boolean result = RemoteTest.clickText(text, window.getCommands());
        if (!result) {
            result = RemoteTest.clickText(text, window.getComponents());
        }
        return result;
    }

    protected boolean onClickFocusable(int n1, int n2) {
        boolean isValidComponent;
        System.out.println("CLICK Focusable " + n1 + "@" + n2);
        Window window = DesktopPane.getDesktopPane().getSelectedFrame();
        Vector focusComps = new Vector();
        this.getFocusableItems(window, focusComps);
        boolean bl = isValidComponent = n1 >= 0 && n1 < focusComps.size();
        if (isValidComponent) {
            Component comp = (Component)focusComps.elementAt(n1);
            comp.makeVisible();
            comp.requestFocusInWindow();
            if (comp instanceof Button) {
                ((Button)comp).fireActionPerformed();
            } else if (n2 >= 0) {
                if (comp instanceof List) {
                    List list = (List)comp;
                    list.setSelectedIndex(n2);
                    list.fireActionPerformed();
                } else if (comp instanceof Table) {
                    Table table = (Table)comp;
                    int numCols = table.getColumnCount();
                    int row = n2 / numCols;
                    int col = n2 % numCols;
                    if (row >= 0 && col >= 0) {
                        table.editCellAt(row, col);
                        Component editorComp = (Component)table.getComponents().elementAt(0);
                        editorComp.makeVisible();
                        if (editorComp instanceof Button) {
                            ((Button)editorComp).fireActionPerformed();
                        }
                    }
                }
            }
        }
        return isValidComponent;
    }

    protected boolean onCommand(String cmd) {
        return false;
    }

    private void getFocusableItems(Component comp, Vector focusList) {
        if (comp.isVisible()) {
            if (comp.isFocusable()) {
                focusList.addElement(comp);
            } else if (comp instanceof Panel) {
                Vector comps = ((Panel)comp).getComponents();
                for (int i = 0; i < comps.size(); ++i) {
                    this.getFocusableItems((Component)comps.elementAt(i), focusList);
                }
            }
        }
    }

    protected void onSetCursorInvisible() {
    }

    static boolean clickText(String text, Vector components) {
        for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (comp instanceof Button && ((Button)comp).getText().equalsIgnoreCase(text)) {
                comp.requestFocusInWindow();
                ((Button)comp).fireActionPerformed();
                return true;
            }
            if (comp instanceof Panel) {
                if (!RemoteTest.clickText(text, ((Panel)comp).getComponents())) continue;
                return true;
            }
            if (comp instanceof MenuBar) {
                if (!RemoteTest.clickText(text, ((MenuBar)comp).getItems())) continue;
                return true;
            }
            if (comp instanceof List) {
                List list = (List)comp;
                int size = list.getSize();
                for (int i = 0; i < size; ++i) {
                    Object o = list.getElementAt(i);
                    if (!text.equalsIgnoreCase(String.valueOf(o))) continue;
                    list.setSelectedIndex(i);
                    list.fireActionPerformed();
                    return true;
                }
                continue;
            }
            if (!(comp instanceof TextPane) || !((TextPane)comp).pressLink(text)) continue;
            return true;
        }
        return false;
    }

    static String readLine(Reader in) throws IOException {
        int ch = 0;
        StringBuffer sb = new StringBuffer();
        while ((ch = in.read()) != -1 && (ch != 10 || sb.length() <= 0)) {
            if (ch == 13) continue;
            sb.append((char)ch);
        }
        if (ch == -1 && sb.length() == 0) {
            throw new IOException();
        }
        return sb.toString();
    }

    private String replaceEscapeSequences(String txt) {
        txt = StringUtil.replaceAll(txt, "\\n", "\n");
        return txt;
    }
}

