/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.gen;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Message;
import net.yura.lobby.model.Player;
import net.yura.lobby.model.PlayerInfo;
import net.yura.mobile.io.ProtoUtil;
import net.yura.mobile.io.proto.CodedInputStream;
import net.yura.mobile.io.proto.CodedOutputStream;
import net.yura.mobile.io.proto.WireFormat;

public class ProtoLobby
extends ProtoUtil {
    public static final String COMMAND_ADD_OR_UPDATE_GAME = "COMMAND_ADD_OR_UPDATE_GAME";
    public static final String COMMAND_ALL_GAMETYPES = "COMMAND_ALL_GAMETYPES";
    public static final String COMMAND_ANDROID_REGISTER_DONE = "COMMAND_ANDROID_REGISTER_DONE";
    public static final String COMMAND_ANDROID_UNREGISTER_DONE = "COMMAND_ANDROID_UNREGISTER_DONE";
    public static final String COMMAND_CHAT_MESSAGE = "COMMAND_CHAT_MESSAGE";
    public static final String COMMAND_GAME_MESSAGE = "COMMAND_GAME_MESSAGE";
    public static final String COMMAND_KEY = "COMMAND_KEY";
    public static final String COMMAND_LOGIN_ERROR = "COMMAND_LOGIN_ERROR";
    public static final String COMMAND_LOGIN_OK = "COMMAND_LOGIN_OK";
    public static final String COMMAND_LOGOUT_OK = "COMMAND_LOGOUT_OK";
    public static final String COMMAND_PLAYER_ADDED = "COMMAND_PLAYER_ADDED";
    public static final String COMMAND_PLAYER_REMOVE = "COMMAND_PLAYER_REMOVE";
    public static final String COMMAND_REMOVE_GAME = "COMMAND_REMOVE_GAME";
    public static final String COMMAND_RENAME_PLAYER = "COMMAND_RENAME_PLAYER";
    public static final String COMMAND_SERVER_ERROR = "COMMAND_SERVER_ERROR";
    public static final String PING = "PING";
    public static final String PLAYER_ADMIN = "PLAYER_ADMIN";
    public static final String PLAYER_GOD = "PLAYER_GOD";
    public static final String PLAYER_GUEST = "PLAYER_GUEST";
    public static final String PLAYER_MODERATOR = "PLAYER_MODERATOR";
    public static final String PLAYER_NORMAL = "PLAYER_NORMAL";
    public static final String PLAYER_SUBSCRIBER = "PLAYER_SUBSCRIBER";
    public static final String REQUEST_ALL_GAMETYPES = "REQUEST_ALL_GAMETYPES";
    public static final String REQUEST_ANDROID_REGISTER = "REQUEST_ANDROID_REGISTER";
    public static final String REQUEST_ANDROID_UNREGISTER = "REQUEST_ANDROID_UNREGISTER";
    public static final String REQUEST_CLOSE_GAME = "REQUEST_CLOSE_GAME";
    public static final String REQUEST_CREATE_NEW_GAME = "REQUEST_CREATE_NEW_GAME";
    public static final String REQUEST_GAME_MESSAGE = "REQUEST_GAME_MESSAGE";
    public static final String REQUEST_GET_GAMES = "REQUEST_GET_GAMES";
    public static final String REQUEST_HELLO = "REQUEST_HELLO";
    public static final String REQUEST_JOIN_GAME = "REQUEST_JOIN_GAME";
    public static final String REQUEST_LEAVE_GAME = "REQUEST_LEAVE_GAME";
    public static final String REQUEST_LOGIN = "REQUEST_LOGIN";
    public static final String REQUEST_LOGOUT = "REQUEST_LOGOUT";
    public static final String REQUEST_PLAY_GAME = "REQUEST_PLAY_GAME";
    public static final String REQUEST_REGISTER = "REQUEST_REGISTER";
    public static final String REQUEST_SET_NICK = "REQUEST_SET_NICK";
    public static final int TYPE_GAME = 21;
    public static final int TYPE_GAME_TYPE = 22;
    public static final int TYPE_PLAYER = 23;
    public static final int TYPE_PLAYER_INFO = 24;
    public static final int TYPE_MESSAGE = 25;
    static /* synthetic */ Class class$net$yura$lobby$model$GameType;

    public static int getPlayerTypeEnum(String enu) {
        if (PLAYER_GUEST.equals(enu)) {
            return 0;
        }
        if (PLAYER_ADMIN.equals(enu)) {
            return 4;
        }
        if (PLAYER_SUBSCRIBER.equals(enu)) {
            return 2;
        }
        if (PLAYER_NORMAL.equals(enu)) {
            return 1;
        }
        if (PLAYER_GOD.equals(enu)) {
            return 5;
        }
        if (PLAYER_MODERATOR.equals(enu)) {
            return 3;
        }
        return -1;
    }

    public static String getPlayerTypeString(int i) {
        switch (i) {
            case 0: {
                return PLAYER_GUEST;
            }
            case 4: {
                return PLAYER_ADMIN;
            }
            case 2: {
                return PLAYER_SUBSCRIBER;
            }
            case 1: {
                return PLAYER_NORMAL;
            }
            case 5: {
                return PLAYER_GOD;
            }
            case 3: {
                return PLAYER_MODERATOR;
            }
        }
        return "unknown " + i;
    }

    public static int getMessageTypeEnum(String enu) {
        if (COMMAND_CHAT_MESSAGE.equals(enu)) {
            return 30;
        }
        if (COMMAND_LOGIN_ERROR.equals(enu)) {
            return 9;
        }
        if (REQUEST_GET_GAMES.equals(enu)) {
            return 15;
        }
        if (REQUEST_GAME_MESSAGE.equals(enu)) {
            return 24;
        }
        if (REQUEST_REGISTER.equals(enu)) {
            return 4;
        }
        if (REQUEST_JOIN_GAME.equals(enu)) {
            return 19;
        }
        if (COMMAND_SERVER_ERROR.equals(enu)) {
            return 100;
        }
        if (REQUEST_ALL_GAMETYPES.equals(enu)) {
            return 11;
        }
        if (REQUEST_ANDROID_UNREGISTER.equals(enu)) {
            return 42;
        }
        if (REQUEST_CLOSE_GAME.equals(enu)) {
            return 22;
        }
        if (REQUEST_LEAVE_GAME.equals(enu)) {
            return 20;
        }
        if (PING.equals(enu)) {
            return 0;
        }
        if (COMMAND_RENAME_PLAYER.equals(enu)) {
            return 10;
        }
        if (COMMAND_ANDROID_UNREGISTER_DONE.equals(enu)) {
            return 44;
        }
        if (REQUEST_HELLO.equals(enu)) {
            return 1;
        }
        if (COMMAND_KEY.equals(enu)) {
            return 2;
        }
        if (REQUEST_SET_NICK.equals(enu)) {
            return 5;
        }
        if (COMMAND_PLAYER_ADDED.equals(enu)) {
            return 25;
        }
        if (COMMAND_ANDROID_REGISTER_DONE.equals(enu)) {
            return 43;
        }
        if (REQUEST_LOGIN.equals(enu)) {
            return 3;
        }
        if (COMMAND_GAME_MESSAGE.equals(enu)) {
            return 23;
        }
        if (COMMAND_LOGOUT_OK.equals(enu)) {
            return 8;
        }
        if (REQUEST_CREATE_NEW_GAME.equals(enu)) {
            return 18;
        }
        if (REQUEST_LOGOUT.equals(enu)) {
            return 6;
        }
        if (COMMAND_LOGIN_OK.equals(enu)) {
            return 7;
        }
        if (COMMAND_ALL_GAMETYPES.equals(enu)) {
            return 12;
        }
        if (COMMAND_REMOVE_GAME.equals(enu)) {
            return 17;
        }
        if (REQUEST_ANDROID_REGISTER.equals(enu)) {
            return 41;
        }
        if (REQUEST_PLAY_GAME.equals(enu)) {
            return 21;
        }
        if (COMMAND_ADD_OR_UPDATE_GAME.equals(enu)) {
            return 16;
        }
        if (COMMAND_PLAYER_REMOVE.equals(enu)) {
            return 26;
        }
        return -1;
    }

    public static String getMessageTypeString(int i) {
        switch (i) {
            case 30: {
                return COMMAND_CHAT_MESSAGE;
            }
            case 9: {
                return COMMAND_LOGIN_ERROR;
            }
            case 15: {
                return REQUEST_GET_GAMES;
            }
            case 24: {
                return REQUEST_GAME_MESSAGE;
            }
            case 4: {
                return REQUEST_REGISTER;
            }
            case 19: {
                return REQUEST_JOIN_GAME;
            }
            case 100: {
                return COMMAND_SERVER_ERROR;
            }
            case 11: {
                return REQUEST_ALL_GAMETYPES;
            }
            case 42: {
                return REQUEST_ANDROID_UNREGISTER;
            }
            case 22: {
                return REQUEST_CLOSE_GAME;
            }
            case 20: {
                return REQUEST_LEAVE_GAME;
            }
            case 0: {
                return PING;
            }
            case 10: {
                return COMMAND_RENAME_PLAYER;
            }
            case 44: {
                return COMMAND_ANDROID_UNREGISTER_DONE;
            }
            case 1: {
                return REQUEST_HELLO;
            }
            case 2: {
                return COMMAND_KEY;
            }
            case 5: {
                return REQUEST_SET_NICK;
            }
            case 25: {
                return COMMAND_PLAYER_ADDED;
            }
            case 43: {
                return COMMAND_ANDROID_REGISTER_DONE;
            }
            case 3: {
                return REQUEST_LOGIN;
            }
            case 23: {
                return COMMAND_GAME_MESSAGE;
            }
            case 8: {
                return COMMAND_LOGOUT_OK;
            }
            case 18: {
                return REQUEST_CREATE_NEW_GAME;
            }
            case 6: {
                return REQUEST_LOGOUT;
            }
            case 7: {
                return COMMAND_LOGIN_OK;
            }
            case 12: {
                return COMMAND_ALL_GAMETYPES;
            }
            case 17: {
                return COMMAND_REMOVE_GAME;
            }
            case 41: {
                return REQUEST_ANDROID_REGISTER;
            }
            case 21: {
                return REQUEST_PLAY_GAME;
            }
            case 16: {
                return COMMAND_ADD_OR_UPDATE_GAME;
            }
            case 26: {
                return COMMAND_PLAYER_REMOVE;
            }
        }
        return "unknown " + i;
    }

    protected int getObjectTypeEnum(Object obj) {
        if (obj instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)obj;
        }
        if (obj instanceof Game) {
            return 21;
        }
        if (obj instanceof GameType) {
            return 22;
        }
        if (obj instanceof Message) {
            return 25;
        }
        if (obj instanceof Player) {
            return 23;
        }
        if (obj instanceof PlayerInfo) {
            return 24;
        }
        return super.getObjectTypeEnum(obj);
    }

    protected Object decodeObject(CodedInputStream in2, int type) throws IOException {
        switch (type) {
            case 21: {
                return this.decodeGame(in2);
            }
            case 22: {
                return this.decodeGameType(in2);
            }
            case 23: {
                return this.decodePlayer(in2);
            }
            case 24: {
                return this.decodePlayerInfo(in2);
            }
            case 25: {
                return this.decodeMessage(in2);
            }
        }
        return super.decodeObject(in2, type);
    }

    protected int computeObjectSize(Object obj, int type) {
        switch (type) {
            case 21: {
                return this.computeGameSize((Game)obj);
            }
            case 22: {
                return this.computeGameTypeSize((GameType)obj);
            }
            case 23: {
                return this.computePlayerSize((Player)obj);
            }
            case 24: {
                return this.computePlayerInfoSize((PlayerInfo)obj);
            }
            case 25: {
                return this.computeMessageSize((Message)obj);
            }
        }
        return super.computeObjectSize(obj, type);
    }

    protected void encodeObject(CodedOutputStream out, Object obj, int type) throws IOException {
        switch (type) {
            case 21: {
                this.encodeGame(out, (Game)obj);
                break;
            }
            case 22: {
                this.encodeGameType(out, (GameType)obj);
                break;
            }
            case 23: {
                this.encodePlayer(out, (Player)obj);
                break;
            }
            case 24: {
                this.encodePlayerInfo(out, (PlayerInfo)obj);
                break;
            }
            case 25: {
                this.encodeMessage(out, (Message)obj);
                break;
            }
            default: {
                super.encodeObject(out, obj, type);
            }
        }
    }

    private int computeGameSize(Game object) {
        Set playersVector;
        int size = 0;
        int idValue = object.getId();
        size += CodedOutputStream.computeInt32Size((int)1, (int)idValue);
        GameType typeValue = object.getType();
        int typeValueId = (Integer)this.getObjectId(typeValue);
        size += CodedOutputStream.computeInt32Size((int)2, (int)typeValueId);
        String nameValue = object.getName();
        size += CodedOutputStream.computeStringSize((int)3, (String)nameValue);
        int max_playersValue = object.getMaxPlayers();
        size += CodedOutputStream.computeInt32Size((int)4, (int)max_playersValue);
        String optionsValue = object.getOptions();
        if (optionsValue != null) {
            size += CodedOutputStream.computeStringSize((int)5, (String)optionsValue);
        }
        if ((playersVector = object.getPlayers()) != null) {
            Iterator it = playersVector.iterator();
            while (it.hasNext()) {
                Player playersValue = (Player)it.next();
                size += CodedOutputStream.computeBytesSize((int)6, (int)this.computePlayerSize(playersValue));
            }
        }
        int timeoutValue = object.getTimeout();
        size += CodedOutputStream.computeInt32Size((int)8, (int)timeoutValue);
        String whos_turnValue = object.getWhosTurn();
        if (whos_turnValue != null) {
            size += CodedOutputStream.computeStringSize((int)7, (String)whos_turnValue);
        }
        int in_gameValue = object.getInGame();
        return size += CodedOutputStream.computeInt32Size((int)9, (int)in_gameValue);
    }

    private int computeGameTypeSize(GameType object) {
        String optionsValue;
        String classNameValue;
        int size = 0;
        int idValue = object.getId();
        size += CodedOutputStream.computeInt32Size((int)1, (int)idValue);
        int parent_idValue = object.getParentId();
        size += CodedOutputStream.computeInt32Size((int)2, (int)parent_idValue);
        String nameValue = object.getName();
        size += CodedOutputStream.computeStringSize((int)3, (String)nameValue);
        String[] jarNamesArray = object.getJarNames();
        if (jarNamesArray != null) {
            for (int c = 0; c < jarNamesArray.length; ++c) {
                String jarNamesValue = jarNamesArray[c];
                size += CodedOutputStream.computeStringSize((int)4, (String)jarNamesValue);
            }
        }
        if ((classNameValue = object.getClassName()) != null) {
            size += CodedOutputStream.computeStringSize((int)5, (String)classNameValue);
        }
        if ((optionsValue = object.getOptions()) != null) {
            size += CodedOutputStream.computeStringSize((int)6, (String)optionsValue);
        }
        return size;
    }

    private int computeMessageSize(Message object) {
        int size = 0;
        String commandValue = object.getCommand();
        size += CodedOutputStream.computeInt32Size((int)1, (int)ProtoLobby.getMessageTypeEnum(commandValue));
        Object paramValue = object.getParam();
        if (paramValue != null) {
            size += CodedOutputStream.computeBytesSize((int)2, (int)this.computeAnonymousObjectSize(paramValue));
        }
        return size;
    }

    private int computePlayerSize(Player object) {
        int size = 0;
        String nameValue = object.getName();
        size += CodedOutputStream.computeStringSize((int)1, (String)nameValue);
        int typeValue = object.getType();
        return size += CodedOutputStream.computeInt32Size((int)2, (int)typeValue);
    }

    private int computePlayerInfoSize(PlayerInfo object) {
        int size = 0;
        String labelValue = object.getLabel();
        size += CodedOutputStream.computeStringSize((int)1, (String)labelValue);
        String infoValue = object.getInfo();
        if (infoValue != null) {
            size += CodedOutputStream.computeStringSize((int)2, (String)infoValue);
        }
        boolean can_editValue = object.getCanEdit();
        return size += CodedOutputStream.computeBoolSize((int)3, (boolean)can_editValue);
    }

    private void encodeGame(CodedOutputStream out, Game object) throws IOException {
        Set playersVector;
        int idValue = object.getId();
        out.writeInt32(1, idValue);
        GameType typeValue = object.getType();
        int typeValueId = (Integer)this.getObjectId(typeValue);
        out.writeInt32(2, typeValueId);
        String nameValue = object.getName();
        out.writeString(3, nameValue);
        int max_playersValue = object.getMaxPlayers();
        out.writeInt32(4, max_playersValue);
        String optionsValue = object.getOptions();
        if (optionsValue != null) {
            out.writeString(5, optionsValue);
        }
        if ((playersVector = object.getPlayers()) != null) {
            Iterator it = playersVector.iterator();
            while (it.hasNext()) {
                Player playersValue = (Player)it.next();
                out.writeBytes(6, this.computePlayerSize(playersValue));
                this.encodePlayer(out, playersValue);
            }
        }
        int timeoutValue = object.getTimeout();
        out.writeInt32(8, timeoutValue);
        String whos_turnValue = object.getWhosTurn();
        if (whos_turnValue != null) {
            out.writeString(7, whos_turnValue);
        }
        int in_gameValue = object.getInGame();
        out.writeInt32(9, in_gameValue);
    }

    private void encodeGameType(CodedOutputStream out, GameType object) throws IOException {
        String optionsValue;
        String classNameValue;
        int idValue = object.getId();
        out.writeInt32(1, idValue);
        int parent_idValue = object.getParentId();
        out.writeInt32(2, parent_idValue);
        String nameValue = object.getName();
        out.writeString(3, nameValue);
        String[] jarNamesArray = object.getJarNames();
        if (jarNamesArray != null) {
            for (int c = 0; c < jarNamesArray.length; ++c) {
                String jarNamesValue = jarNamesArray[c];
                out.writeString(4, jarNamesValue);
            }
        }
        if ((classNameValue = object.getClassName()) != null) {
            out.writeString(5, classNameValue);
        }
        if ((optionsValue = object.getOptions()) != null) {
            out.writeString(6, optionsValue);
        }
    }

    private void encodeMessage(CodedOutputStream out, Message object) throws IOException {
        String commandValue = object.getCommand();
        out.writeInt32(1, ProtoLobby.getMessageTypeEnum(commandValue));
        Object paramValue = object.getParam();
        if (paramValue != null) {
            out.writeBytes(2, this.computeAnonymousObjectSize(paramValue));
            this.encodeAnonymousObject(out, paramValue);
        }
    }

    private void encodePlayer(CodedOutputStream out, Player object) throws IOException {
        String nameValue = object.getName();
        out.writeString(1, nameValue);
        int typeValue = object.getType();
        out.writeInt32(2, typeValue);
    }

    private void encodePlayerInfo(CodedOutputStream out, PlayerInfo object) throws IOException {
        String labelValue = object.getLabel();
        out.writeString(1, labelValue);
        String infoValue = object.getInfo();
        if (infoValue != null) {
            out.writeString(2, infoValue);
        }
        boolean can_editValue = object.getCanEdit();
        out.writeBool(3, can_editValue);
    }

    protected Game decodeGame(CodedInputStream in2) throws IOException {
        Game object = new Game();
        HashSet<Player> playersVector = new HashSet<Player>();
        block11: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber((int)tag);
            switch (fieldNo) {
                case 1: {
                    int value = in2.readInt32();
                    object.setId(value);
                    continue block11;
                }
                case 2: {
                    GameType value = (GameType)this.getObjetById(new Integer(in2.readInt32()), class$net$yura$lobby$model$GameType == null ? ProtoLobby.class$("net.yura.lobby.model.GameType") : class$net$yura$lobby$model$GameType);
                    object.setType(value);
                    continue block11;
                }
                case 3: {
                    String value = in2.readString();
                    object.setName(value);
                    continue block11;
                }
                case 4: {
                    int value = in2.readInt32();
                    object.setMaxPlayers(value);
                    continue block11;
                }
                case 5: {
                    String value = in2.readString();
                    object.setOptions(value);
                    continue block11;
                }
                case 6: {
                    int size = in2.readBytesSize();
                    int lim = in2.pushLimit(size);
                    Player value = this.decodePlayer(in2);
                    in2.popLimit(lim);
                    playersVector.add(value);
                    continue block11;
                }
                case 8: {
                    int value = in2.readInt32();
                    object.setTimeout(value);
                    continue block11;
                }
                case 7: {
                    String value = in2.readString();
                    object.setWhosTurn(value);
                    continue block11;
                }
                case 9: {
                    int value = in2.readInt32();
                    object.setInGame(value);
                    continue block11;
                }
            }
            in2.skipField(tag);
        }
        object.setPlayers(playersVector);
        return object;
    }

    protected GameType decodeGameType(CodedInputStream in2) throws IOException {
        GameType object = new GameType();
        Vector<String> jarNamesVector = new Vector<String>();
        block8: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber((int)tag);
            switch (fieldNo) {
                case 1: {
                    int value = in2.readInt32();
                    object.setId(value);
                    continue block8;
                }
                case 2: {
                    int value = in2.readInt32();
                    object.setParentId(value);
                    continue block8;
                }
                case 3: {
                    String value = in2.readString();
                    object.setName(value);
                    continue block8;
                }
                case 4: {
                    String value = in2.readString();
                    jarNamesVector.addElement(value);
                    continue block8;
                }
                case 5: {
                    String value = in2.readString();
                    object.setClassName(value);
                    continue block8;
                }
                case 6: {
                    String value = in2.readString();
                    object.setOptions(value);
                    continue block8;
                }
            }
            in2.skipField(tag);
        }
        Object[] jarNamesArray = new String[jarNamesVector.size()];
        jarNamesVector.copyInto(jarNamesArray);
        object.setJarNames((String[])jarNamesArray);
        return object;
    }

    protected Message decodeMessage(CodedInputStream in2) throws IOException {
        Message object = new Message();
        block4: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber((int)tag);
            switch (fieldNo) {
                case 1: {
                    String value = ProtoLobby.getMessageTypeString(in2.readInt32());
                    object.setCommand(value);
                    continue block4;
                }
                case 2: {
                    int size = in2.readBytesSize();
                    int lim = in2.pushLimit(size);
                    Object value = this.decodeAnonymousObject(in2);
                    in2.popLimit(lim);
                    object.setParam(value);
                    continue block4;
                }
            }
            in2.skipField(tag);
        }
        return object;
    }

    protected Player decodePlayer(CodedInputStream in2) throws IOException {
        Player object = new Player();
        block4: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber((int)tag);
            switch (fieldNo) {
                case 1: {
                    String value = in2.readString();
                    object.setName(value);
                    continue block4;
                }
                case 2: {
                    int value = in2.readInt32();
                    object.setType(value);
                    continue block4;
                }
            }
            in2.skipField(tag);
        }
        return object;
    }

    protected PlayerInfo decodePlayerInfo(CodedInputStream in2) throws IOException {
        PlayerInfo object = new PlayerInfo();
        block5: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber((int)tag);
            switch (fieldNo) {
                case 1: {
                    String value = in2.readString();
                    object.setLabel(value);
                    continue block5;
                }
                case 2: {
                    String value = in2.readString();
                    object.setInfo(value);
                    continue block5;
                }
                case 3: {
                    boolean value = in2.readBool();
                    object.setCanEdit(value);
                    continue block5;
                }
            }
            in2.skipField(tag);
        }
        return object;
    }
}

