/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.BugSubmitter;
import net.yura.grasshopper.BugSystemInfo;
import net.yura.grasshopper.LogFile;

public class SimpleBug
extends StringWriter {
    static SimpleBug instance;

    public SimpleBug() {
        if (instance != null) {
            return;
        }
        BugManager.interceptAndAlert(this, new BugManager(){

            protected void action(String cause) {
                SimpleBug.this.doSubmit(cause);
            }
        });
        instance = this;
    }

    private void doSubmit(String cause) {
        BugSubmitter.submitBug(this.toString(), cause);
    }

    public static void initSimple(String appname, String version, String locale) {
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
        if (instance == null) {
            new SimpleBug();
        }
    }

    public static void initLogFile(String appname, String version, String locale) {
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
        try {
            File file = new File("grasshopper.log");
            if (!SimpleBug.canWrite(file)) {
                file = new File(System.getProperty("java.io.tmpdir"), file.getName());
            }
            FileWriter fileWriter = new FileWriter(file);
            final File logfile = file;
            BugManager.interceptAndAlert(fileWriter, new BugManager(){
                boolean sent;

                protected void action(String cause) {
                    if (!this.sent) {
                        this.sent = true;
                        BugSubmitter.submitBug(new LogFile(logfile), cause);
                    }
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean canWrite(File file) {
        try {
            if (file.exists() && file.delete()) {
                return true;
            }
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

