/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.guishared.StatsPanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.FlashBorder;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.NewGameFrame;

public class StatsDialog
extends JDialog
implements ActionListener {
    private BufferedImage Back;
    private Risk myrisk;
    private StatsPanel graph;
    private ResourceBundle resb;
    private ButtonGroup group;

    public StatsDialog(Frame parent, boolean modal, Risk r) {
        super(parent, modal);
        this.myrisk = r;
        this.Back = RiskUIUtil.getUIImage(this.getClass(), "graph.jpg");
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setTitle(this.resb.getString("swing.tab.statistics"));
        JPanel thisgraph = new JPanel();
        thisgraph.setBorder(new FlashBorder(this.Back.getSubimage(100, 0, 740, 50), this.Back.getSubimage(0, 0, 50, 400), this.Back.getSubimage(100, 182, 740, 150), this.Back.getSubimage(50, 0, 50, 400)));
        Dimension d = new Dimension(740, 600);
        thisgraph.setPreferredSize(d);
        thisgraph.setMinimumSize(d);
        thisgraph.setMaximumSize(d);
        thisgraph.setLayout(null);
        this.group = new ButtonGroup();
        int x = 49;
        int y = 483;
        int w = 107;
        int h = 33;
        int s = 1;
        AbstractButton button1 = this.makeButton("countries", x, y, w, h, s);
        button1.setSelected(true);
        thisgraph.add(button1);
        thisgraph.add(this.makeButton("armies", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("kills", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("casualties", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("reinforcements", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("continents", x += w, y, w, h, ++s));
        x = 49;
        thisgraph.add(this.makeButton("empire", x, y += h, w, h, ++s));
        thisgraph.add(this.makeButton("attacks", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("retreats", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("victories", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("defeats", x += w, y, w, h, ++s));
        thisgraph.add(this.makeButton("attacked", x += w, y, w, h, ++s));
        this.graph = new StatsPanel(this.myrisk);
        this.graph.setBounds(50, 50, 640, 400);
        thisgraph.add(this.graph);
        this.getContentPane().add(thisgraph);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StatsDialog.this.exitForm();
            }
        });
    }

    public void actionPerformed(ActionEvent a) {
        this.showGraph(Integer.parseInt(a.getActionCommand()));
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.showGraph(Integer.parseInt(this.group.getSelection().getActionCommand()));
        }
    }

    public void showGraph(int type) {
        this.graph.repaintStats(type);
        this.graph.repaint();
    }

    private void exitForm() {
        ((GameFrame)this.getParent()).displayGraph();
    }

    private AbstractButton makeButton(String a, int x, int y, int w, int h, int s) {
        JToggleButton statbutton = new JToggleButton(this.resb.getString("swing.toolbar." + a));
        statbutton.setActionCommand(s + "");
        statbutton.addActionListener(this);
        statbutton.setBounds(x, y, w, h);
        this.group.add(statbutton);
        NewGameFrame.sortOutButton(statbutton, this.Back.getSubimage(x + 100, y - 433 + 165, w, h), this.Back.getSubimage(x + 100, y - 433, w, h), this.Back.getSubimage(x + 100, y - 433 + 66, w, h));
        return statbutton;
    }
}

