/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.NewGameFrame;

public class MoveDialog
extends JDialog {
    private GameFrame gui;
    private boolean tacmove;
    private BufferedImage Move;
    private BufferedImage MoveBack;
    private BufferedImage c1img;
    private BufferedImage c2img;
    private Country country1;
    private Country country2;
    private int move;
    private int csrc;
    private int cdes;
    private Color color;
    private JSlider slider;
    private ResourceBundle resb;
    private JButton cancel;
    private static final Polygon arrow;
    private movePanel movepanel;

    public MoveDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.gui = (GameFrame)parent;
        this.Move = RiskUIUtil.getUIImage(this.getClass(), "move.jpg");
        this.MoveBack = this.Move.getSubimage(0, 0, 480, 330);
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setDefaultCloseOperation(0);
        Dimension d = new Dimension(480, 330);
        this.movepanel = new movePanel();
        this.movepanel.setPreferredSize(d);
        this.movepanel.setMinimumSize(d);
        this.movepanel.setMaximumSize(d);
        this.movepanel.setLayout(null);
        this.slider = new JSlider();
        this.movepanel.add(this.slider);
        int w = 88;
        int h = 31;
        this.cancel = new JButton(this.resb.getString("move.cancel"));
        NewGameFrame.sortOutButton(this.cancel, this.Move.getSubimage(484, 5, w, h), this.Move.getSubimage(480, 72, w, h), this.Move.getSubimage(480, 41, w, h));
        this.cancel.setBounds(50, 250, w, h);
        this.cancel.setActionCommand("cancel");
        JButton moveall = new JButton(this.resb.getString("move.moveall"));
        NewGameFrame.sortOutButton(moveall, this.Move.getSubimage(196, 250, w, h), this.Move.getSubimage(480, 134, w, h), this.Move.getSubimage(480, 103, w, h));
        moveall.setBounds(196, 250, w, h);
        moveall.setActionCommand("all");
        JButton button = new JButton(this.resb.getString("move.move"));
        NewGameFrame.sortOutButton(button, this.Move.getSubimage(342, 250, w, h), this.Move.getSubimage(480, 196, w, h), this.Move.getSubimage(480, 165, w, h));
        button.setBounds(343, 250, w, h);
        button.setActionCommand("move");
        w = 35;
        h = 25;
        JButton b1 = new JButton(this.resb.getString("move.min"));
        NewGameFrame.sortOutButton(b1, this.Move.getSubimage(25, 192, w, h), this.Move.getSubimage(480, 252, w, h), this.Move.getSubimage(515, 252, w, h));
        b1.setBounds(25, 192, w, h);
        b1.setActionCommand("b1");
        JButton b4 = new JButton(this.resb.getString("move.max"));
        NewGameFrame.sortOutButton(b4, this.Move.getSubimage(25, 192, w, h), this.Move.getSubimage(480, 252, w, h), this.Move.getSubimage(515, 252, w, h));
        b4.setBounds(420, 192, w, h);
        b4.setActionCommand("b4");
        w = 25;
        h = 25;
        JButton b2 = new JButton(this.resb.getString("move.minus"));
        NewGameFrame.sortOutButton(b2, this.Move.getSubimage(60, 192, w, h), this.Move.getSubimage(480, 227, w, h), this.Move.getSubimage(505, 227, w, h));
        b2.setBounds(60, 192, w, h);
        b2.setActionCommand("b2");
        JButton b3 = new JButton(this.resb.getString("move.plus"));
        NewGameFrame.sortOutButton(b3, this.Move.getSubimage(60, 192, w, h), this.Move.getSubimage(480, 227, w, h), this.Move.getSubimage(505, 227, w, h));
        b3.setBounds(395, 192, w, h);
        b3.setActionCommand("b3");
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("cancel")) {
                    MoveDialog.this.exitForm();
                } else if (e.getActionCommand().equals("all")) {
                    if (MoveDialog.this.tacmove) {
                        MoveDialog.this.gui.go("movearmies " + MoveDialog.this.country1.getColor() + " " + MoveDialog.this.country2.getColor() + " " + (MoveDialog.this.csrc - 1));
                    } else {
                        MoveDialog.this.gui.go("move " + (MoveDialog.this.csrc - 1));
                    }
                } else if (e.getActionCommand().equals("move")) {
                    if (MoveDialog.this.tacmove) {
                        MoveDialog.this.gui.go("movearmies " + MoveDialog.this.country1.getColor() + " " + MoveDialog.this.country2.getColor() + " " + MoveDialog.this.move);
                    } else {
                        MoveDialog.this.gui.go("move " + MoveDialog.this.move);
                    }
                } else if (e.getActionCommand().equals("b1")) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.slider.getMinimum());
                } else if (e.getActionCommand().equals("b2")) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.move - 1);
                } else if (e.getActionCommand().equals("b3")) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.move + 1);
                } else if (e.getActionCommand().equals("b4")) {
                    MoveDialog.this.slider.setValue(MoveDialog.this.slider.getMaximum());
                }
            }
        };
        this.cancel.addActionListener(al);
        moveall.addActionListener(al);
        button.addActionListener(al);
        b1.addActionListener(al);
        b2.addActionListener(al);
        b3.addActionListener(al);
        b4.addActionListener(al);
        this.movepanel.add(b1);
        this.movepanel.add(b2);
        this.movepanel.add(b3);
        this.movepanel.add(b4);
        this.movepanel.add(this.cancel);
        this.movepanel.add(moveall);
        this.movepanel.add(button);
        this.getContentPane().add(this.movepanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (MoveDialog.this.tacmove) {
                    MoveDialog.this.exitForm();
                }
            }
        });
    }

    public void setup(boolean tm, int m, int a, int b, BufferedImage ai, BufferedImage bi, Country country1, Country country2, Color c) {
        this.tacmove = tm;
        this.c1img = ai;
        this.c2img = bi;
        this.country1 = country1;
        this.country2 = country2;
        this.move = m;
        this.csrc = a;
        this.cdes = b;
        this.color = c;
        if (this.tacmove) {
            this.setTitle(this.resb.getString("move.title.tactical"));
            this.cancel.setVisible(true);
        } else {
            this.setTitle(this.resb.getString("move.title.captured"));
            this.cancel.setVisible(false);
        }
        this.movepanel.remove(this.slider);
        this.slider = new JSlider(this.move, this.csrc - 1, this.move);
        int spacig = Math.round((float)(this.csrc - 1) / 10.0f);
        if (spacig == 0) {
            this.slider.setMajorTickSpacing(1);
        } else {
            this.slider.setMajorTickSpacing(spacig);
            this.slider.setMinorTickSpacing(1);
        }
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MoveDialog.this.move = MoveDialog.this.slider.getValue();
                MoveDialog.this.movepanel.repaint();
            }
        });
        this.slider.setBounds(90, 180, 300, 50);
        this.movepanel.add(this.slider);
    }

    public void exitForm() {
        this.setVisible(false);
    }

    static void paintMove(Graphics g, BufferedImage c1img, BufferedImage c2img, Color color1, Color color2, String name1, String name2, int noa1i, int noa2i) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MoveDialog.drawCountry(g2, c1img, 130, 100);
        MoveDialog.drawCountry(g2, c2img, 350, 100);
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = g2.getFont();
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout(name1, font, frc);
        tl.draw(g2, (float)(130.0 - tl.getBounds().getWidth() / 2.0), 40.0f);
        tl = new TextLayout(name2, font, frc);
        tl.draw(g2, (float)(350.0 - tl.getBounds().getWidth() / 2.0), 40.0f);
        g2.setColor(color1);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ((RectangularShape)ellipse).setFrame(120.0, 90.0, 20.0, 20.0);
        g2.fill(ellipse);
        g2.setColor(color2);
        ellipse = new Ellipse2D.Double();
        ((RectangularShape)ellipse).setFrame(340.0, 90.0, 20.0, 20.0);
        g2.fill(ellipse);
        g2.setColor(new Color(color1.getRed(), color1.getGreen(), color1.getBlue(), 150));
        g2.fillPolygon(arrow);
        g2.setColor(RiskUIUtil.getTextColorFor(color1));
        if (noa1i < 10) {
            g2.drawString(String.valueOf(noa1i), 126, 105);
        } else if (noa1i < 100) {
            g2.drawString(String.valueOf(noa1i), 123, 105);
        } else {
            g2.drawString(String.valueOf(noa1i), 120, 105);
        }
        g2.setColor(RiskUIUtil.getTextColorFor(color2));
        if (noa2i < 10) {
            g2.drawString(String.valueOf(noa2i), 346, 105);
        } else if (noa2i < 100) {
            g2.drawString(String.valueOf(noa2i), 343, 105);
        } else {
            g2.drawString(String.valueOf(noa2i), 340, 105);
        }
    }

    static void drawCountry(Graphics2D g, BufferedImage img, int x, int y) {
        int maxW = 200;
        int maxH = 140;
        int w = img.getWidth();
        int h = img.getHeight();
        if (w > maxW || h > maxH) {
            double scale = Math.min((double)maxW / (double)w, (double)maxH / (double)h);
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
        }
        g.drawImage(img, x - w / 2, y - h / 2, x + w / 2, y + h / 2, 0, 0, img.getWidth(), img.getHeight(), null);
    }

    static {
        int x = 110;
        int y = 40;
        int[] xCoords = new int[]{x + 60, x + 130, x + 130, x + 200, x + 130, x + 130, x + 60};
        int[] yCoords = new int[]{y + 40, y + 40, y + 20, y + 60, y + 100, y + 80, y + 80};
        arrow = new Polygon(xCoords, yCoords, xCoords.length);
    }

    class movePanel
    extends JPanel {
        movePanel() {
        }

        public void paintComponent(Graphics g) {
            g.drawImage(MoveDialog.this.MoveBack, 0, 0, this);
            if (MoveDialog.this.tacmove) {
                g.drawImage(MoveDialog.this.Move.getSubimage(480, 0, 98, 41), 46, 245, this);
            }
            MoveDialog.paintMove(g, MoveDialog.this.c1img, MoveDialog.this.c2img, MoveDialog.this.color, MoveDialog.this.color, MoveDialog.this.country1.getName(), MoveDialog.this.country2.getName(), MoveDialog.this.csrc - MoveDialog.this.move, MoveDialog.this.cdes + MoveDialog.this.move);
            g.setColor(RiskUIUtil.getTextColorFor(MoveDialog.this.color));
            g.drawString(Integer.toString(MoveDialog.this.move), 240, 104);
        }
    }
}

