/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.util.List;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;

public class GetMap
implements MapServerListener {
    MapServerClient client;
    Risk myrisk;
    String filename;
    Exception problem;

    public static void getMap(String filename, Risk risk, Exception ex) {
        GetMap get = new GetMap();
        get.filename = filename;
        get.myrisk = risk;
        get.problem = ex;
        get.client = new MapServerClient(get);
        get.client.start();
        get.client.makeRequestXML(MapChooser.MAP_PAGE, "mapfile", filename);
    }

    private void onError(String exception) {
        this.myrisk.getMapError(exception);
        this.client.kill();
    }

    public void gotResultXML(String url, String method, Object param) {
        java.util.Map map = (java.util.Map)param;
        List maps = (List)map.get("maps");
        if (maps.size() == 1) {
            Map themap = (Map)maps.get(0);
            this.client.downloadMap(MapChooser.getURL(MapChooser.getContext(url), themap.mapUrl));
        } else {
            System.err.println("wrong number of maps on server: " + maps.size() + " for map: " + this.filename);
            RiskUtil.printStackTrace(this.problem);
            this.onError(this.problem.toString());
        }
    }

    public void downloadFinished(String mapUID) {
        try {
            this.myrisk.setMap(mapUID);
            this.client.kill();
        }
        catch (Exception ex) {
            RiskUtil.printStackTrace(ex);
            this.onError(ex.toString());
        }
    }

    public void onXMLError(String string) {
        this.onError(string);
    }

    public void onDownloadError(String string) {
        this.onError(string);
    }

    public void publishImg(Object param) {
    }
}

