/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import java.util.Vector;
import net.yura.domination.engine.ai.AISubmissive;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

public class AITest
extends AISubmissive {
    public int getType() {
        return 5;
    }

    public String getCommand() {
        return "test";
    }

    public String getPlaceArmies() {
        if (!this.game.NoEmptyCountries()) {
            return "autoplace";
        }
        Vector t = this.player.getTerritoriesOwned();
        String name = null;
        name = this.findAttackableTerritory(this.player);
        if (name == null) {
            return "placearmies " + ((Country)t.elementAt(0)).getColor() + " " + this.player.getExtraArmies();
        }
        if (this.game.getSetup()) {
            return "placearmies " + name + " " + this.player.getExtraArmies();
        }
        return "placearmies " + name + " 1";
    }

    public String getAttack() {
        Vector outputs = new Vector();
        outputs = this.findAttackableNeighbors(this.player.getTerritoriesOwned(), 0.0);
        if (outputs.size() > 0) {
            Attack move = (Attack)outputs.elementAt((int)Math.round(Math.random() * (double)(outputs.size() - 1)));
            return move.toString();
        }
        return "endattack";
    }

    public String getRoll() {
        int n = this.game.getAttacker().getArmies() - 1;
        if (n > 3) {
            return "roll 3";
        }
        return "roll " + n;
    }

    public String findAttackableTerritory(Player p) {
        Vector countries = p.getTerritoriesOwned();
        for (int i = 0; i < countries.size(); ++i) {
            Vector neighbors = ((Country)countries.elementAt(i)).getNeighbours();
            for (int j = 0; j < neighbors.size(); ++j) {
                if (((Country)neighbors.elementAt(j)).getOwner() == p || (p.getCapital() == null || ((Country)countries.elementAt(i)).getColor() == p.getCapital().getColor()) && p.getCapital() != null) continue;
                return ((Country)countries.elementAt(i)).getColor() + "";
            }
        }
        return null;
    }

    public Vector findAttackableNeighbors(Vector t, double ratio) {
        Vector<Attack> output = new Vector<Attack>();
        Vector n = new Vector();
        if (ratio < 0.0) {
            ratio = 0.0;
        }
        for (int a = 0; a < t.size(); ++a) {
            Country source = (Country)t.elementAt(a);
            if (source.getOwner() != this.player || source.getArmies() <= 1) continue;
            n = source.getNeighbours();
            for (int b = 0; b < n.size(); ++b) {
                Country target = (Country)n.elementAt(b);
                if (target.getOwner() == this.player || !((double)(source.getArmies() / target.getArmies()) > ratio)) continue;
                output.add(new Attack(source, target));
            }
        }
        return output;
    }

    protected class Attack {
        public final Country source;
        public final Country destination;

        public Attack(Country s, Country d) {
            this.source = s;
            this.destination = d;
        }

        public String toString() {
            if (this.source == null || this.destination == null) {
                return "";
            }
            return "attack " + this.source.getColor() + " " + this.destination.getColor();
        }
    }
}

