/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.MapTranslator;

public class RiskUtil {
    public static final String RISK_VERSION_URL;
    public static final String RISK_LOBBY_URL;
    public static final String GAME_NAME;
    public static RiskIO streamOpener;
    private static final Properties settings;

    public static InputStream openMapStream(String a) throws IOException {
        return streamOpener.openMapStream(a);
    }

    public static InputStream openStream(String a) throws IOException {
        return streamOpener.openStream(a);
    }

    public static ResourceBundle getResourceBundle(Class c, String n, Locale l) {
        return streamOpener.getResourceBundle(c, n, l);
    }

    public static void openURL(URL url) throws Exception {
        streamOpener.openURL(url);
    }

    public static void openDocs(String docs) throws Exception {
        streamOpener.openDocs(docs);
    }

    public static void saveFile(String file, RiskGame aThis) throws Exception {
        streamOpener.saveGameFile(file, aThis);
    }

    public static InputStream getLoadFileInputStream(String file) throws Exception {
        return streamOpener.loadGameFile(file);
    }

    public static String createGameString(int crapAI, int normalAI, int goodAI, int gameMode, int cardsMode, boolean AutoPlaceAll, boolean recycle, String mapFile) {
        String players = crapAI + "\n" + normalAI + "\n" + goodAI + "\n";
        String type = "";
        switch (gameMode) {
            case 0: {
                type = "domination";
                break;
            }
            case 2: {
                type = "capital";
                break;
            }
            case 3: {
                type = "mission";
            }
        }
        switch (cardsMode) {
            case 0: {
                type = type + " increasing";
                break;
            }
            case 1: {
                type = type + " fixed";
                break;
            }
            case 2: {
                type = type + " italianlike";
            }
        }
        if (AutoPlaceAll) {
            type = type + " autoplaceall";
        }
        if (recycle) {
            type = type + " recycle";
        }
        return players + "choosemap " + mapFile + "\nstartgame " + type;
    }

    public static String getMapNameFromLobbyStartGameOption(String options) {
        String[] lines = options.split(RiskUtil.quote("\n"));
        String choosemap = lines[3];
        return choosemap.substring("choosemap ".length());
    }

    public static String getGameDescriptionFromLobbyStartGameOption(String options) {
        String[] lines = options.split(RiskUtil.quote("\n"));
        int ai = 0;
        for (int c = 0; c < 3; ++c) {
            ai += Integer.parseInt(lines[c]);
        }
        return "AI:" + ai + " " + lines[4].substring("startgame ".length());
    }

    public static void printStackTrace(Throwable ex) {
        Logger.getLogger(RiskUtil.class.getName()).log(Level.WARNING, null, ex);
    }

    public static void donate() throws Exception {
        RiskUtil.openURL(new URL("http://domination.sourceforge.net/donate.shtml"));
    }

    public static void donatePayPal() throws Exception {
        RiskUtil.openURL(new URL("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=yura%40yura%2enet&item_name=" + GAME_NAME + "%20Donation&no_shipping=0&no_note=1&tax=0&currency_code=GBP&lc=GB&bn=PP%2dDonationsBF&charset=UTF%2d8"));
    }

    public static Properties getPlayerSettings(final Risk risk, Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable th) {
            // empty catch block
        }
        final Preferences theprefs = prefs;
        return new Properties(){

            public String getProperty(String key) {
                String value = risk.getRiskConfig(key);
                if (theprefs != null) {
                    value = theprefs.get(key, value);
                }
                return value;
            }
        };
    }

    public static void loadPlayers(Risk risk, Class uiclass) {
        Properties playerSettings = RiskUtil.getPlayerSettings(risk, uiclass);
        for (int cc = 1; cc <= 6; ++cc) {
            String name = playerSettings.getProperty("default.player" + cc + ".name");
            String color = playerSettings.getProperty("default.player" + cc + ".color");
            String type = playerSettings.getProperty("default.player" + cc + ".type");
            if ("".equals(name) || "".equals(color) || "".equals(type)) continue;
            risk.parser("newplayer " + type + " " + color + " " + name);
        }
    }

    public static void savePlayers(Risk risk, Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (prefs != null) {
            Vector players = risk.getGame().getPlayers();
            for (int cc = 1; cc <= 6; ++cc) {
                Player player;
                String nameKey = "default.player" + cc + ".name";
                String colorKey = "default.player" + cc + ".color";
                String typeKey = "default.player" + cc + ".type";
                String name = "";
                String color = "";
                String type = "";
                Player player2 = player = cc <= players.size() ? (Player)players.get(cc - 1) : null;
                if (player != null) {
                    name = player.getName();
                    color = ColorUtil.getStringForColor(player.getColor());
                    type = risk.getType(player.getType());
                }
                prefs.put(nameKey, name);
                prefs.put(colorKey, color);
                prefs.put(typeKey, type);
            }
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
            }
        }
    }

    public static void savePlayers(List players, Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (prefs != null) {
            for (int cc = 1; cc <= 6; ++cc) {
                String[] player;
                String nameKey = "default.player" + cc + ".name";
                String colorKey = "default.player" + cc + ".color";
                String typeKey = "default.player" + cc + ".type";
                String name = "";
                String color = "";
                String type = "";
                String[] stringArray = player = cc <= players.size() ? (String[])players.get(cc - 1) : null;
                if (player != null) {
                    name = player[0];
                    color = player[1];
                    type = player[2];
                }
                prefs.put(nameKey, name);
                prefs.put(colorKey, color);
                prefs.put(typeKey, type);
            }
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
            }
        }
    }

    public static BufferedReader readMap(InputStream in) throws IOException {
        PushbackInputStream pushback = new PushbackInputStream(in, 3);
        int first = pushback.read();
        if (first == 239) {
            int second = pushback.read();
            if (second == 187) {
                int third = pushback.read();
                if (third == 191) {
                    return new BufferedReader(new InputStreamReader((InputStream)pushback, "UTF-8"));
                }
                pushback.unread(third);
            }
            pushback.unread(second);
        }
        pushback.unread(first);
        return new BufferedReader(new InputStreamReader((InputStream)pushback, "ISO-8859-1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadInfo(String fileName, boolean cards) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        int c = 0;
        while (true) {
            BufferedReader bufferin = null;
            try {
                bufferin = RiskUtil.readMap(RiskUtil.openMapStream(fileName));
                Vector<String> misss = null;
                if (cards) {
                    MapTranslator.setCards(fileName);
                    misss = new Vector<String>();
                }
                String input = bufferin.readLine();
                String mode = null;
                while (input != null) {
                    if (!input.equals("")) {
                        if (input.charAt(0) == ';') {
                            String comment = (String)info.get("comment");
                            String com = input.substring(1).trim();
                            comment = comment == null ? com : comment + "\n" + com;
                            info.put("comment", comment);
                        } else {
                            if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                                mode = "newsection";
                            }
                            if ("files".equals(mode)) {
                                int space = input.indexOf(32);
                                String fm = input.substring(0, space);
                                String val = input.substring(space + 1);
                                info.put(fm, val);
                            } else {
                                if ("continents".equals(mode)) break;
                                if ("missions".equals(mode)) {
                                    StringTokenizer st = new StringTokenizer(input);
                                    String description = MapTranslator.getTranslatedMissionName(st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken());
                                    if (description == null) {
                                        StringBuffer d = new StringBuffer();
                                        while (st.hasMoreElements()) {
                                            d.append(st.nextToken());
                                            d.append(" ");
                                        }
                                        description = d.toString();
                                    }
                                    misss.add(description);
                                } else if ("newsection".equals(mode)) {
                                    mode = input.substring(1, input.length() - 1);
                                } else if (mode == null && input.indexOf(32) > 0) {
                                    info.put(input.substring(0, input.indexOf(32)), input.substring(input.indexOf(32) + 1));
                                }
                            }
                        }
                    }
                    input = bufferin.readLine();
                }
                if (!cards) break;
                info.put("missions", misss.toArray(new String[misss.size()]));
                misss = null;
                break;
            }
            catch (IOException ex) {
                System.err.println("Error trying to load: " + fileName);
                RiskUtil.printStackTrace(ex);
                if (c >= 5) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex2) {}
            }
            finally {
                if (bufferin != null) {
                    try {
                        bufferin.close();
                    }
                    catch (Exception ex2) {}
                }
            }
            ++c;
        }
        return info;
    }

    public static OutputStream getOutputStream(File dir, String fileName) throws Exception {
        File outFile = new File(dir, fileName);
        File parent = outFile.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new RuntimeException("can not create dir " + parent);
        }
        return new FileOutputStream(outFile);
    }

    public static void rename(File oldFile, File newFile) {
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("can not del dest file: " + newFile);
        }
        if (!oldFile.renameTo(newFile)) {
            try {
                RiskUtil.copy(oldFile, newFile);
                if (!oldFile.delete()) {
                    System.err.println("can not del source file: " + oldFile);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("rename failed: from: " + oldFile + " to: " + newFile, ex);
            }
        }
    }

    public static Vector asVector(List list) {
        return list instanceof Vector ? (Vector)list : new Vector(list);
    }

    public static String replaceAll(String string, String notregex, String replacement) {
        return string.replaceAll(RiskUtil.quote(notregex), RiskUtil.quoteReplacement(replacement));
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
                System.out.println("Directory copied from " + src + "  to " + dest);
            }
            String[] files = src.list();
            for (int c = 0; c < files.length; ++c) {
                File srcFile = new File(src, files[c]);
                File destFile = new File(dest, files[c]);
                RiskUtil.copy(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied from " + src + " to " + dest);
        }
    }

    static {
        settings = new Properties();
        try {
            settings.load(RiskUtil.class.getResourceAsStream("settings.ini"));
        }
        catch (Exception ex) {
            throw new RuntimeException("can not find settings.ini file!", ex);
        }
        RISK_VERSION_URL = settings.getProperty("VERSION_URL");
        RISK_LOBBY_URL = settings.getProperty("LOBBY_URL");
        GAME_NAME = settings.getProperty("name");
        Risk.RISK_VERSION = settings.getProperty("version");
        String dmap = settings.getProperty("defaultmap");
        String dcards = settings.getProperty("defaultcards");
        RiskGame.setDefaultMapAndCards(dmap, dcards);
    }
}

