/*
 * Decompiled with CFR 0.152.
 */
package collisionphysics;

import collisionphysics.CollisionResponse;

public class CollisionPhysics {
    private static CollisionResponse tempResponse = new CollisionResponse();
    private static float[] pointLineResult = new float[2];
    private static double[] rotateResult = new double[2];

    public static void pointIntersectsRectangleOuter(float pointX, float pointY, float speedX, float speedY, float radius, float rectX1, float rectY1, float rectX2, float rectY2, float timeLimit, CollisionResponse response) {
        assert (rectX1 < rectX2 && rectY1 < rectY2) : "Malformed rectangle!";
        assert (pointX >= rectX1 + radius && pointX <= rectX2 - radius && pointY >= rectY1 + radius && pointY <= rectY2 - radius) : "Point (with radius) is outside the rectangular container!";
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        CollisionPhysics.pointIntersectsLineVertical(pointX, pointY, speedX, speedY, radius, rectX2, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
        CollisionPhysics.pointIntersectsLineVertical(pointX, pointY, speedX, speedY, radius, rectX1, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
        CollisionPhysics.pointIntersectsLineHorizontal(pointX, pointY, speedX, speedY, radius, rectY1, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
        CollisionPhysics.pointIntersectsLineHorizontal(pointX, pointY, speedX, speedY, radius, rectY2, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
    }

    public static void pointIntersectsLineVertical(float pointX, float pointY, float speedX, float speedY, float radius, float lineX, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        if (speedX == 0.0f) {
            return;
        }
        float distance = lineX > pointX ? lineX - pointX - radius : lineX - pointX + radius;
        float t = distance / speedX;
        if (t > 0.0f && t <= timeLimit) {
            response.t = t;
            response.newSpeedX = -speedX;
            response.newSpeedY = speedY;
        }
    }

    public static void pointIntersectsLineHorizontal(float pointX, float pointY, float speedX, float speedY, float radius, float lineY, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        if (speedY == 0.0f) {
            return;
        }
        float distance = lineY > pointY ? lineY - pointY - radius : lineY - pointY + radius;
        float t = distance / speedY;
        if (t > 0.0f && t <= timeLimit) {
            response.t = t;
            response.newSpeedY = -speedY;
            response.newSpeedX = speedX;
        }
    }

    public static void pointIntersectsCircleOuter(float pointX, float pointY, float speedX, float speedY, float radius, float outerCenterX, float outerCenterY, float outerRadius, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f && outerRadius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        float t = CollisionPhysics.pointIntersectsCircleOuterDetection(pointX, pointY, speedX, speedY, radius, outerCenterX, outerCenterY, outerRadius);
        if (t > 0.0f && t <= timeLimit) {
            float impactX = pointX + speedX * t;
            float impactY = pointY + speedY * t;
            CollisionPhysics.pointIntersectsLineNormalResponse(pointX, pointY, speedX, speedY, outerCenterX, outerCenterY, impactX, impactY, response, t);
        }
    }

    private static float pointIntersectsCircleOuterDetection(float pointX, float pointY, float speedX, float speedY, float radius, float outerCenterX, float outerCenterY, float outerRadius) {
        double offsetPointX = pointX - outerCenterX;
        double offsetPointY = pointY - outerCenterY;
        double termB = 2.0 * ((double)speedX * offsetPointX + (double)speedY * offsetPointY);
        double sqSpeedX = speedX * speedX;
        double sqSpeedY = speedY * speedY;
        double termA = sqSpeedX + sqSpeedY;
        double sqOffsetPointX = offsetPointX * offsetPointX;
        double sqOffsetPointY = offsetPointY * offsetPointY;
        double effectiveRadius = outerRadius - radius;
        double sqEffectiveRadius = effectiveRadius * effectiveRadius;
        double termC = sqOffsetPointX + sqOffsetPointY - sqEffectiveRadius;
        double b2minus4ac = termB * termB - 4.0 * termA * termC;
        if (b2minus4ac < 0.0) {
            return Float.MAX_VALUE;
        }
        double rootB2minus4ac = Math.sqrt(b2minus4ac);
        double sol1 = (-termB + rootB2minus4ac) / (2.0 * termA);
        double sol2 = (-termB - rootB2minus4ac) / (2.0 * termA);
        if (sol1 > 0.0 && sol2 > 0.0) {
            return (float)Math.min(sol1, sol2);
        }
        if (sol1 > 0.0) {
            return (float)sol1;
        }
        if (sol2 > 0.0) {
            return (float)sol2;
        }
        return Float.MAX_VALUE;
    }

    private static void pointIntersectsLineNormalResponse(float pointX, float pointY, float speedX, float speedY, float lineNormalX1, float lineNormalY1, float lineNormalX2, float lineNormalY2, CollisionResponse response, float t) {
        response.t = t;
        double lineAngle = Math.atan2(lineNormalY2 - lineNormalY1, lineNormalX2 - lineNormalX1);
        double[] result = CollisionPhysics.rotate(speedX, speedY, lineAngle);
        double speedN = result[0];
        double speedP = result[1];
        double speedNAfter = -speedN;
        double speedPAfter = speedP;
        result = CollisionPhysics.rotate(speedNAfter, speedPAfter, -lineAngle);
        response.newSpeedX = (float)result[0];
        response.newSpeedY = (float)result[1];
    }

    public static void pointIntersectsPolygon(float pointX, float pointY, float speedX, float speedY, float radius, int[] polygonXs, int[] polygonYs, int numPoints, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        for (int segment = 0; segment < numPoints; ++segment) {
            int lineX1 = polygonXs[segment];
            int lineY1 = polygonYs[segment];
            int lineX2 = polygonXs[(segment + 1) % numPoints];
            int lineY2 = polygonYs[(segment + 1) % numPoints];
            CollisionPhysics.pointIntersectsLineSegmentNoEndPoints(pointX, pointY, speedX, speedY, radius, lineX1, lineY1, lineX2, lineY2, timeLimit, tempResponse);
            if (!(CollisionPhysics.tempResponse.t < response.t)) continue;
            response.copy(tempResponse);
        }
        for (int i = 0; i < numPoints; ++i) {
            CollisionPhysics.pointIntersectsPoint(pointX, pointY, speedX, speedY, radius, polygonXs[i], polygonYs[i], 0.0f, timeLimit, tempResponse);
            if (!(CollisionPhysics.tempResponse.t < response.t)) continue;
            response.copy(tempResponse);
        }
    }

    public static void pointIntersectsLine(float pointX, float pointY, float speedX, float speedY, float radius, float lineX1, float lineY1, float lineX2, float lineY2, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        if (lineX1 == lineX2) {
            CollisionPhysics.pointIntersectsLineVertical(pointX, pointY, speedX, speedY, radius, lineX1, timeLimit, response);
            return;
        }
        if (lineY1 == lineY2) {
            CollisionPhysics.pointIntersectsLineHorizontal(pointX, pointY, speedX, speedY, radius, lineY1, timeLimit, response);
            return;
        }
        response.reset();
        float t = CollisionPhysics.pointIntersectsLineDetection(pointX, pointY, speedX, speedY, radius, lineX1, lineY1, lineX2, lineY2)[0];
        if (t > 0.0f && t <= timeLimit) {
            CollisionPhysics.pointIntersectsLineResponse(pointX, pointY, speedX, speedY, lineX1, lineY1, lineX2, lineY2, response, t);
        }
    }

    private static float[] pointIntersectsLineDetection(float pointX, float pointY, float speedX, float speedY, float radius, float lineX1, float lineY1, float lineX2, float lineY2) {
        double t;
        double det;
        double rotatedY;
        double lineVectorX = lineX2 - lineX1;
        double lineVectorY = lineY2 - lineY1;
        double lineX1Offset = lineX1;
        double lineY1Offset = lineY1;
        if (radius > 0.0f) {
            double lineAngle = Math.atan2(lineVectorY, lineVectorX);
            rotatedY = CollisionPhysics.rotate(pointX - lineX1, pointY - lineY1, lineAngle)[1];
            if (rotatedY > 0.0) {
                lineX1Offset -= (double)radius * Math.sin(lineAngle);
                lineY1Offset += (double)radius * Math.cos(lineAngle);
            } else {
                lineX1Offset += (double)radius * Math.sin(lineAngle);
                lineY1Offset -= (double)radius * Math.cos(lineAngle);
            }
        }
        if ((det = (double)(-speedX) * lineVectorY + (double)speedY * lineVectorX) == 0.0) {
            t = Double.MAX_VALUE;
            rotatedY = Double.MAX_VALUE;
        }
        double xDiff = lineX1Offset - (double)pointX;
        double yDiff = lineY1Offset - (double)pointY;
        t = (-lineVectorY * xDiff + lineVectorX * yDiff) / det;
        double lambda = ((double)(-speedY) * xDiff + (double)speedX * yDiff) / det;
        CollisionPhysics.pointLineResult[0] = (float)t;
        CollisionPhysics.pointLineResult[1] = (float)lambda;
        return pointLineResult;
    }

    private static void pointIntersectsLineResponse(float pointX, float pointY, float speedX, float speedY, float lineX1, float lineY1, float lineX2, float lineY2, CollisionResponse response, float t) {
        response.t = t;
        double lineAngle = Math.atan2(lineY2 - lineY1, lineX2 - lineX1);
        double[] result = CollisionPhysics.rotate(speedX, speedY, lineAngle);
        double speedP = result[0];
        double speedN = result[1];
        double speedPAfter = speedP;
        double speedQAfter = -speedN;
        result = CollisionPhysics.rotate(speedPAfter, speedQAfter, -lineAngle);
        response.newSpeedX = (float)result[0];
        response.newSpeedY = (float)result[1];
    }

    public static void pointIntersectsLineSegmentNoEndPoints(float pointX, float pointY, float speedX, float speedY, float radius, float lineX1, float lineY1, float lineX2, float lineY2, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        if (lineX1 == lineX2) {
            CollisionPhysics.pointIntersectsLineVertical(pointX, pointY, speedX, speedY, radius, lineX1, timeLimit, response);
            double impactY = response.getImpactY(pointY, speedY);
            if (!(impactY >= (double)lineY1 && impactY <= (double)lineY2 || impactY >= (double)lineY2 && impactY <= (double)lineY1)) {
                response.reset();
            }
            return;
        }
        if (lineY1 == lineY2) {
            CollisionPhysics.pointIntersectsLineHorizontal(pointX, pointY, speedX, speedY, radius, lineY1, timeLimit, response);
            double impactX = response.getImpactX(pointX, speedX);
            if (!(impactX >= (double)lineX1 && impactX <= (double)lineX2 || impactX >= (double)lineX2 && impactX <= (double)lineX1)) {
                response.reset();
            }
            return;
        }
        response.reset();
        float[] result = CollisionPhysics.pointIntersectsLineDetection(pointX, pointY, speedX, speedY, radius, lineX1, lineY1, lineX2, lineY2);
        float t = result[0];
        float lambda = result[1];
        if (t > 0.0f && t <= timeLimit && lambda >= 0.0f && lambda <= 1.0f) {
            CollisionPhysics.pointIntersectsLineResponse(pointX, pointY, speedX, speedY, lineX1, lineY1, lineX2, lineY2, response, t);
        }
    }

    public static void pointIntersectsLineSegment(float pointX, float pointY, float speedX, float speedY, float radius, float lineX1, float lineY1, float lineX2, float lineY2, float timeLimit, CollisionResponse response) {
        assert (radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        response.reset();
        CollisionPhysics.pointIntersectsLineSegmentNoEndPoints(pointX, pointY, speedX, speedY, radius, lineX1, lineY1, lineX2, lineY2, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
        CollisionPhysics.pointIntersectsPoint(pointX, pointY, speedX, speedY, radius, lineX1, lineY1, 0.0f, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
        CollisionPhysics.pointIntersectsPoint(pointX, pointY, speedX, speedY, radius, lineX2, lineY2, 0.0f, timeLimit, tempResponse);
        if (CollisionPhysics.tempResponse.t < response.t) {
            response.copy(tempResponse);
        }
    }

    public static void pointIntersectsMovingPoint(float p1X, float p1Y, float p1SpeedX, float p1SpeedY, float p1Radius, float p2X, float p2Y, float p2SpeedX, float p2SpeedY, float p2Radius, float timeLimit, CollisionResponse p1Response, CollisionResponse p2Response) {
        assert (p1Radius >= 0.0f && p2Radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time!";
        p1Response.reset();
        p2Response.reset();
        float t = CollisionPhysics.pointIntersectsMovingPointDetection(p1X, p1Y, p1SpeedX, p1SpeedY, p1Radius, p2X, p2Y, p2SpeedX, p2SpeedY, p2Radius);
        if (t > 0.0f && t <= timeLimit) {
            CollisionPhysics.pointIntersectsMovingPointResponse(p1X, p1Y, p1SpeedX, p1SpeedY, p1Radius, p2X, p2Y, p2SpeedX, p2SpeedY, p2Radius, p1Response, p2Response, t);
        }
    }

    private static float pointIntersectsMovingPointDetection(float p1X, float p1Y, float p1SpeedX, float p1SpeedY, float p1Radius, float p2X, float p2Y, float p2SpeedX, float p2SpeedY, float p2Radius) {
        double radius = p1Radius + p2Radius;
        double radiusSq = radius * radius;
        double speedX = p1SpeedX - p2SpeedX;
        double speedXSq = speedX * speedX;
        double speedY = p1SpeedY - p2SpeedY;
        double speedYSq = speedY * speedY;
        double speedSq = speedXSq + speedYSq;
        double centerX = p1X - p2X;
        double centerY = p1Y - p2Y;
        double termB2minus4ac = radiusSq * speedSq - (centerX * speedY - centerY * speedX) * (centerX * speedY - centerY * speedX);
        if (termB2minus4ac < 0.0) {
            return Float.MAX_VALUE;
        }
        double termMinusB = -speedX * centerX - speedY * centerY;
        double term2a = speedSq;
        double rootB2minus4ac = Math.sqrt(termB2minus4ac);
        double sol1 = (termMinusB + rootB2minus4ac) / term2a;
        double sol2 = (termMinusB - rootB2minus4ac) / term2a;
        if (sol1 > 0.0 && sol2 > 0.0) {
            return (float)Math.min(sol1, sol2);
        }
        if (sol1 > 0.0) {
            return (float)sol1;
        }
        if (sol2 > 0.0) {
            return (float)sol2;
        }
        return Float.MAX_VALUE;
    }

    private static void pointIntersectsMovingPointResponse(float p1X, float p1Y, float p1SpeedX, float p1SpeedY, float p1Radius, float p2X, float p2Y, float p2SpeedX, float p2SpeedY, float p2Radius, CollisionResponse p1Response, CollisionResponse p2Response, float t) {
        p1Response.t = t;
        p2Response.t = t;
        double p1ImpactX = p1Response.getImpactX(p1X, p1SpeedX);
        double p1ImpactY = p1Response.getImpactY(p1Y, p1SpeedY);
        double p2ImpactX = p2Response.getImpactX(p2X, p2SpeedX);
        double p2ImpactY = p2Response.getImpactY(p2Y, p2SpeedY);
        double lineAngle = Math.atan2(p2ImpactY - p1ImpactY, p2ImpactX - p1ImpactX);
        double[] result = CollisionPhysics.rotate(p1SpeedX, p1SpeedY, lineAngle);
        double p1SpeedP = result[0];
        double p1SpeedN = result[1];
        result = CollisionPhysics.rotate(p2SpeedX, p2SpeedY, lineAngle);
        double p2SpeedP = result[0];
        double p2SpeedN = result[1];
        if (p1SpeedP - p2SpeedP <= 0.0) {
            p1Response.reset();
            p2Response.reset();
            return;
        }
        double p1Mass = p1Radius * p1Radius * p1Radius;
        double p2Mass = p2Radius * p2Radius * p2Radius;
        double diffMass = p1Mass - p2Mass;
        double sumMass = p1Mass + p2Mass;
        double p1SpeedPAfter = (diffMass * p1SpeedP + 2.0 * p2Mass * p2SpeedP) / sumMass;
        double p2SpeedPAfter = (2.0 * p1Mass * p1SpeedP - diffMass * p2SpeedP) / sumMass;
        double p1SpeedNAfter = p1SpeedN;
        double p2SpeedNAfter = p2SpeedN;
        result = CollisionPhysics.rotate(p1SpeedPAfter, p1SpeedNAfter, -lineAngle);
        p1Response.newSpeedX = (float)result[0];
        p1Response.newSpeedY = (float)result[1];
        result = CollisionPhysics.rotate(p2SpeedPAfter, p2SpeedNAfter, -lineAngle);
        p2Response.newSpeedX = (float)result[0];
        p2Response.newSpeedY = (float)result[1];
    }

    public static void pointIntersectsPoint(float p1X, float p1Y, float p1SpeedX, float p1SpeedY, float p1Radius, float p2X, float p2Y, float p2Radius, float timeLimit, CollisionResponse p1Response) {
        assert (p1Radius >= 0.0f) : "Negative radius!";
        assert (timeLimit > 0.0f) : "Non-positive time";
        p1Response.reset();
        float t = CollisionPhysics.pointIntersectsMovingPointDetection(p1X, p1Y, p1SpeedX, p1SpeedY, p1Radius, p2X, p2Y, 0.0f, 0.0f, p2Radius);
        if (t > 0.0f && t <= timeLimit) {
            CollisionPhysics.pointIntersectsPointResponse(p1X, p1Y, p1SpeedX, p1SpeedY, p2X, p2Y, p1Response, t);
        }
    }

    private static void pointIntersectsPointResponse(float p1X, float p1Y, float p1SpeedX, float p1SpeedY, float p2X, float p2Y, CollisionResponse p1Response, float t) {
        p1Response.t = t;
        double p1ImpactX = p1Response.getImpactX(p1X, p1SpeedX);
        double p1ImpactY = p1Response.getImpactY(p1Y, p1SpeedY);
        double lineAngle = Math.atan2((double)p2Y - p1ImpactY, (double)p2X - p1ImpactX);
        double[] result = CollisionPhysics.rotate(p1SpeedX, p1SpeedY, lineAngle);
        double p1SpeedP = result[0];
        double p1SpeedN = result[1];
        if (p1SpeedP <= 0.0) {
            p1Response.reset();
            return;
        }
        double p1SpeedPAfter = -p1SpeedP;
        double p1SpeedNAfter = p1SpeedN;
        result = CollisionPhysics.rotate(p1SpeedPAfter, p1SpeedNAfter, -lineAngle);
        p1Response.newSpeedX = (float)result[0];
        p1Response.newSpeedY = (float)result[1];
    }

    private static double[] rotate(double x, double y, double theta) {
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        CollisionPhysics.rotateResult[0] = x * cosTheta + y * sinTheta;
        CollisionPhysics.rotateResult[1] = -x * sinTheta + y * cosTheta;
        return rotateResult;
    }

    private static double getSpeed(double speedX, double speedY) {
        return Math.sqrt(speedX * speedX + speedY * speedY);
    }
}

