package net.yura.translation.plugins.xcode;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import net.yura.mobile.util.SystemUtil;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.plugins.NetComm;

/**
 * @author Yura
 */
public class XcodeNet extends NetComm implements XcodeCommXtra {

    private String auth;
    
    public XcodeNet() {
    }
    public XcodeNet(String auth) {
        this.auth = auth;
    }
    public boolean load() throws Exception {
        if (auth!=null) {
            load(auth);
            return true;
        }
        else {
            return super.load();
        }
    }
    
    @Override
    public Class getRemoteClass() {
            return XcodeComm.class;
    }
    @Override
    public void saveAuth(String auth) {
        XcodeComm.setDir(auth, getClass(),"auth" );
    }
    @Override
    public String getAuth(String defaultAuth) {
        return XcodeComm.getDir(defaultAuth, getClass(),"auth" );
    }
    
    JCheckBox spellingOnly;
    public void setSpellingOnlyChackbox(JCheckBox ch) {
        spellingOnly = ch;
    }
    
    @Override
    public void saveMessage(MyNode node, PartnerNode partner, Locale l, String message) throws Exception {
        
		Object[] messages = new Object[5];
		messages[0] = node.getName();
		messages[1] = partner;
		messages[2] = l;
		messages[3] = message;
                messages[4] = spellingOnly.isSelected();

		callMethod("saveMessage",messages);
    }

    public ImageIcon getScreenImage(String screenUID) throws Exception {
            Object[] messages = new Object[1];
            messages[0] = screenUID;
            byte[] bytearray = (byte[])callMethod("getScreenImageBytes",messages);
            InputStream in = new ByteArrayInputStream(bytearray);
            BufferedImage image = ImageIO.read(in);
            return new ImageIcon(image);
    }

    public void addScreen(File file) throws Exception {
        
        Object[] messages1 = new Object[1];
        messages1[0] = file.getName();

        Boolean fileExists = (Boolean)callMethod("fileExists",messages1);

        if (!fileExists) {
        
            FileInputStream filein = new FileInputStream(file);
            byte[] bytearray = SystemUtil.getData(filein, (int)file.length());

            Object[] messages = new Object[2];
            messages[0] = file.getName();
            messages[1] = bytearray;

            callMethod("addScreen",messages);
        }
        else {
            System.out.println("SKIP "+file.getName() );
        }
    }
    
}
