package net.yura.translation.plugins.xcode;

import javax.swing.JFileChooser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.yura.mobile.util.SystemUtil;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;
import net.yura.translation.plugins.NetComm;
import net.yura.util.StringsProperties;

public class XcodeComm implements Mtcomm, XcodeCommXtra {

    public static final Locale SCREEN_LOCALE = new Locale("screens");
    public static final Locale DESCRIPTION_LOCALE = new Locale("description");
    
    private Project project;

    public Project getProject() {
        return project;
    }

    
    
    public static String getDir(String dir,Class clas,String setting) {
            Preferences prefs=null;
            try {
                 prefs = Preferences.userNodeForPackage( clas );
            }
            catch(Throwable th) { } // security
            if (prefs!=null) {
                return prefs.get(setting,dir);
            }
            return dir;
    }
    public static void setDir(String dir,Class clas,String setting) {
            Preferences prefs=null;
            try {
                 prefs = Preferences.userNodeForPackage( clas );
            }
            catch(Throwable th) { } // security
            if (prefs!=null) {
                prefs.put(setting, dir);
                try {
                    prefs.flush();
                }
                catch(Exception ex) {
                    ex.printStackTrace();
                }
            }
    }
    
    
    public boolean load() throws Exception {

        File start = new File( getDir("I:/6_Yura/Work/java/badoo/repo/iPhone", getClass() ,"dir") );

        JFileChooser fc = new JFileChooser(start);

        setupFilter(fc);

        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

        int returnVal = fc.showDialog(null, "Select");

        // if a file is selected instead of a dir, the return value is the same as if you cancel

        if (returnVal == JFileChooser.APPROVE_OPTION) {

            File selectedFile = fc.getSelectedFile();

            setDir( selectedFile.getParent(), getClass(),"dir" );
            
            // do some checks to make sure this is indeed a xcode project
            if (!selectedFile.getName().toLowerCase().endsWith(".xcodeproj")) {
                JOptionPane.showMessageDialog(null, "Please Select a Folder that ends with \".xcodeproj\"");
                return false;
            }
            File pbxproj = new File(selectedFile, "project.pbxproj");
            if (!pbxproj.exists()) {
                JOptionPane.showMessageDialog(null, "Please Select a Folder that has a project.pbxproj in it");
                return false;
            }

            //TODO: Badoo.xcodeproj specific
            File file = new File(selectedFile.getParentFile(), "en.lproj"); // default to english
            //default to english if possible
            if (file.exists()) {
                load(selectedFile, file);
                return true;
            }
            final File[] files = selectedFile.getParentFile().listFiles(new FilenameFilter() {
                public boolean accept(File dir, String name) {
                    return name.endsWith(".lproj");
                }
            });

            if (files.length == 0) {
                JOptionPane.showMessageDialog(null, "This project does not contain any .lproj folder that could be used as the default locale (e.g. en.lprog)");
                return false;
            }

            String[] names = new String[files.length];
            for (int i = 0; i < files.length; i++) {
                names[i] = files[i].getName().substring(0, files[i].getName().indexOf('.'));
            }
            JComboBox chooser = new JComboBox(names);
            int result = JOptionPane.showOptionDialog(null, chooser, "Select default locale", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, null, null);

            if (result == JOptionPane.OK_OPTION) {

                load(selectedFile, (File) files[chooser.getSelectedIndex()]);
                return true;
            }

        }
        return false;

    }
    
    public void load(File xcodeproj, File lproj) throws Exception {
        project = new Project(xcodeproj,lproj);
    }

    public void setupFilter(JFileChooser fc) {
        FileFilter ff = new FileFilter() {

            public boolean accept(File f) {
                return (f.isDirectory() || (f.getName().toLowerCase().endsWith(".xcodeproj")));
            }

            public String getDescription() {
                return "Xcode Project File (*.xcodeproj)";
            }
        };
        fc.addChoosableFileFilter(ff);
        fc.setFileFilter(ff);
    }

    public void addChildren(MyNode node) {
        Vector result = getChildren(node.getName());
        for (int c=0;c<result.size();c++) {
            NetComm.TheNode newNode = (NetComm.TheNode)result.elementAt(c);
            node.add(new MyNode(newNode.name, newNode.hasmessage, newNode.haschildren));
        }
    }
    
    public Vector getChildren(String name) {

        Vector result = new Vector();
        
        if (name.length() > 0) {
            name = name + ".";
        }

        Enumeration en = project.propertyNames();

        while (en.hasMoreElements()) {

            String s = en.nextElement().toString();			// swing.setup.title	swing.mainbox

            if (s.startsWith(name)) {

                // cut off name and first dot
                s = s.substring(name.length(), s.length());	// setup.title		mainbox

                boolean children = false;
                boolean message = false;

                // cut off everything after dot, if there is any

                if (s.indexOf('.') != -1) {			// setup		mainbox

                    children = true;				// ########## it has children!!!!
                    s = s.substring(0, s.indexOf('.'));

                }
                else {
                    message = true;				// ########## it has a message!!!!
                }


                NetComm.TheNode newnode = new NetComm.TheNode();
                newnode.name = s;
                newnode.hasmessage = message;
                newnode.haschildren = children;

                result.add(newnode);
            }

        }
        
        return result;
    }

    public String getMessage(MyNode node, PartnerNode partner, Locale l) {
        return getMessage(node.getName(), partner, l);
    }
    public String getMessage(String node, PartnerNode partner, Locale l) {
        return project.getProperty(node, l);
    }

    public String toString() {
        return ".xcodeproj plugin";
    }

    JCheckBox spellingOnly;
    public void setSpellingOnlyChackbox(JCheckBox ch) {
        spellingOnly = ch;
    }

    public void saveMessage(MyNode node, PartnerNode part, Locale l, String message) throws Exception {
        saveMessage(node.getName(),part, l, message, spellingOnly.isSelected() );
    }

    public void saveMessage(String node, PartnerNode part, Locale l, String message, boolean spellingOnly) throws Exception {
        project.setProperty(node, l, message, spellingOnly );
    }

    public Locale[] getLocales() {
        return project.getLocales();
    }

    public Result[] search(String s) throws Exception {

        Vector results = new Vector();
        project.findString(s==null?null:s.toLowerCase(), results);
        return (Result[]) results.toArray(new Result[results.size()]);

    }

    public void setupMissingTranslation(MyNode node, Locale l) {
        node.setWorkNeeded( getMissingTranslation(node.getName(), l) );
    }
    
    public boolean getMissingTranslation(final String realname,Locale l) {
        
        String name = realname;
        if (name.length() > 0) {
            name = name + ".";
        }

        StringsProperties whatWasTranslated = SCREEN_LOCALE.equals(l)?null:project.getLocalization(l).getTranslations();

        Enumeration en = project.propertyNames();
        while (en.hasMoreElements()) {
            String s = en.nextElement().toString();
            if ( (s.equals( realname ) || s.startsWith(name)) && (
                    // if we are in screens mode, check that the value is not null
                    ( SCREEN_LOCALE.equals(l) && project.getProperty(s, SCREEN_LOCALE)==null) ||
                    // if we are in a language mode, check we dont have a none-matching translation
                    (!SCREEN_LOCALE.equals(l) && !project.getProperty(s, null).equals(whatWasTranslated.getProperty(s)))
            ) ) {

                return true;
            }
        }
        return false;
        
    }

    public PartnerNode[] getPartners() throws Exception {
        return new PartnerNode[]{new PartnerNode(0, "DEFAULT", null)};
    }

    public ImageIcon getScreenImage(String screenUID) {
        return new ImageIcon( project.getScreenFile(screenUID).getAbsolutePath() );
    }
    
    public byte[] getScreenImageBytes(String uid) throws Exception {
        File file = project.getScreenFile(uid);
        return SystemUtil.getData(new FileInputStream(file), -1);
    }

    public void addScreen(File file) throws Exception {
        project.addScreen(file);
    }


    public boolean fileExists(String name) throws Exception {
        return project.fileExists(name);
    }
    public void addScreen(String name,byte[] bytes) throws Exception {
        project.addScreen(name,bytes);
    }
    
}
