/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.translation.plugins.xcode;

import java.io.*;
import java.util.*;
import net.yura.util.StringsProperties;

/**
 *
 * @author user30
 */
class Nib {

    private final Nib copy;
    private final File xib, string;
    private final StringsProperties strings = new StringsProperties();

    //contructor for default locale
    public Nib(File file, Localization localization) throws IOException {
        this.xib = file;
        //TODO: Badoo.xcodeproj specific
        this.string = new File(file.getParentFile().getParentFile().getParent() + "/translation/" + file.getParentFile().getName(), file.getName().substring(0, file.getName().indexOf('.')) + ".strings");
        this.string.getParentFile().mkdirs();
        this.copy = this;
        runTool(new String[]{"ibtool", "--generate-strings-file", string.getAbsolutePath(), file.getAbsolutePath()});
        strings.loadFromStrings(new FileInputStream(string));
        //notify localization of nib string keys
        for (Iterator<Map.Entry<Object, Object>> i = strings.entrySet().iterator(); i.hasNext();) {
            Map.Entry<Object, Object> e = i.next();
            localization.addPropertyForNib(e.getKey().toString(), e.getValue().toString(), this, file.getName());
        }
    }

    //contructor for non-default locale
    public Nib(Nib copy, Locale locale, Localization localization) throws IOException {
        this.xib = new File(copy.xib.getParentFile().getParent() + "/" + Project.toString(locale) + ".lproj", copy.xib.getName());
        this.string = new File(copy.xib.getParentFile().getParentFile().getParent() + "/translation/" + Project.toString(locale) + ".lproj", xib.getName().substring(0, xib.getName().indexOf('.')) + ".strings");
        this.string.getParentFile().mkdirs();
        this.copy = copy;
        //copy deafault locales nib strings
        for (Iterator<Map.Entry<Object, Object>> i = copy.strings.entrySet().iterator(); i.hasNext();) {
            Map.Entry<Object, Object> e = i.next();
            localization.addPropertyForNib(e.getKey().toString(), e.getValue().toString(), this, xib.getName());
        }
        if (xib.exists()) {
            if (!string.exists() || string.lastModified() < xib.lastModified()) {
                runTool(new String[]{"ibtool", "--generate-strings-file", string.getAbsolutePath(), xib.getAbsolutePath()});
            }
            StringsProperties s = new StringsProperties();
            s.loadFromStrings(new FileInputStream(string));
            //add only translated properties that havent changed in the deafault localization
            for (Iterator<Map.Entry<Object, Object>> i = copy.strings.entrySet().iterator(); i.hasNext();) {
                Map.Entry<Object, Object> e = i.next();
                if (e.getValue().equals(localization.getTranslations().getProperty(xib.getName() + "." + e.getKey().toString()))) {
                    strings.setProperty(e.getKey().toString(), s.getProperty(e.getKey().toString()));
                }
            }
        }
    }

    public String getName() {
        return xib.getName();
    }

    private void runTool(String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        while (true) {
            try {
                process.waitFor();
                break;
            }
            catch (InterruptedException e) {
            }
        }
    }

    public String getProperty(String key) {
        return strings.getProperty(key);
    }

    public void setProperty(String key, String value, StringsProperties translations, Project project) throws IOException {
        if (value != null) {
            strings.setProperty(key, value);
            if (translations!=null) {
                translations.setProperty(xib.getName() + "." + key, copy.strings.getProperty(key));
            }
        }
        else {
            strings.remove(key);
            if (translations!=null) {
                translations.remove(key);
            }
        }
        //save strings file and build nib
        strings.storeToStrings(new FileOutputStream(string), null);
        if (!xib.exists()) {
            xib.getParentFile().mkdirs();
            project.nibAdded(xib);
        }
        Runtime.getRuntime().exec(new String[]{"ibtool", "--strings-file", string.getAbsolutePath(), "--write", xib.getAbsolutePath(), copy.xib.getAbsolutePath()});
      }
    }
