package net.yura.translation.plugins;

import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;


public class TestComm implements Mtcomm {

	private PartnerNode partner;

	public PartnerNode[] getPartners() {

		PartnerNode[] partners = new PartnerNode[5];
		partners[0] = new PartnerNode(0,"ga",null);
		partners[1] = new PartnerNode(0,"bob",null);
		partners[2] = new PartnerNode(0,"fred",null);
		partners[3] = new PartnerNode(0,"lala",null);
		partners[4] = new PartnerNode(0,"ted",null);

		partners[0].add(partners[1]);
		partners[0].add(partners[2]);
		partners[0].add(partners[3]);
		partners[1].add(partners[4]);

		partner = partners[0];

		return partners;

	}

	public void addChildren(MyNode node) {

		System.out.println("[TestComm] fetch children: "+node.getName());

		DefaultMutableTreeNode n1 = new MyNode("home",true,true);
		DefaultMutableTreeNode n2 = new MyNode("games",false,true);
		DefaultMutableTreeNode n3 = new MyNode("title",true,false);
		DefaultMutableTreeNode n4 = new MyNode("empty",false,false);

		node.add(n1);
		node.add(n2);
		node.add(n3);
		node.add(n4);

	}

	public String getMessage(MyNode node, PartnerNode partner, Locale l) {

		if (partner.equals("lala")) { return null; }

		System.out.println("[TestComm] fetch message: "+node.getName()+" partner="+partner+" locale="+l);

		return "test message\n"+node.getName()+"\nin "+l+" ("+partner+")";

	}

	public String toString() {

		return "Test Plugin";

	}

	public void saveMessage(MyNode node, PartnerNode partner, Locale l, String message) throws Exception {

		System.out.println("[TestComm] save message: "+node.getName()+" partner="+partner+" locale="+l);

	}

	public Locale[] getLocales() {

		return new Locale[] { new Locale("ru"), new Locale("L337"), new Locale("happy!!!!"),new Locale("ar") };

	}

	public Result[] search(String s) throws Exception {

		Result r1 = new Result();
		r1.node = "home.games.title";
		r1.locale = new Locale("ru");
		r1.partner = partner;

		Result r2 = new Result();
		r2.node = "games.home.title";
		r2.locale = new Locale("ru");
		r2.partner = partner;

		return new Result[] { r1,r2 };

	}

	public void close() throws Exception { }

    public boolean load() throws Exception {
        return true;
    }

    public void setupMissingTranslation(MyNode node, Locale l) throws Exception {

    }

}
