package net.yura.translation;

import net.yura.swing.Service;
import net.yura.swing.CollapsiblePanel;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Arrays;
import java.util.List;
import java.util.Comparator;
import java.util.Vector;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JMenu;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.ListSelectionModel;
import net.yura.swing.TCPopupEventQueue;
import net.yura.swing.TreeCombo;

//import risk.ui.SwingGUI.SwingGUITab;
public class MessageTool extends JPanel implements ActionListener, TreeSelectionListener, TreeWillExpandListener, ListSelectionListener { // TreeExpansionListener

    private JTree tree;
    protected Mtcomm mycomm;
    private MyPanel box;
    private JTextField status;
    private JComboBox address;
    private JComboBox local;
    private TreeCombo part;
    private JButton find;
    private Vector partners;
    private MyNode message;
    private JCheckBox wrap;
    private JTextField searchbox;
    private JList results;
    private Locale currentlocale;
    private PartnerNode currentpartner;
    private JComboBox filter1;
    private JCheckBox filter3;
    private JToolBar toolbar;
    public static final String appName = "yura.net CUNNING LINGUIST Translation Tool";
    public static final String version = "2.7";
    public static final String WEBSITE = "http://cunninglinguist.sf.net/";
    private Map partmap;
    public static final Comparator CASE_POSTERIORITY_ORDER = new Comparator() {
        public int compare(Object o1, Object o2) {
            int a = o1.toString().compareToIgnoreCase(o2.toString());
            return a==0?o1.toString().compareTo(o2.toString()):a;
        }
    };

    public MessageTool() {

        try {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TCPopupEventQueue());
        }
        catch (Throwable th) {
            System.err.println("TCPopupEventQueue error: " + th.toString());
        }

        setName(appName+" "+version);

        setOpaque(false);

        setLayout(new BorderLayout());


        JButton load = new JButton("Load", new ImageIcon(MessageTool.class.getResource("openFile.png")));
        load.setActionCommand("load");
        load.addActionListener(this);


        wrap = new JCheckBox("Word Wrap");
        wrap.setActionCommand("wrap");
        wrap.addActionListener(this);


        toolbar = new JToolBar();

        toolbar.setFloatable(false);

        address = new JComboBox();

        address.setEditable(true);

        //address.setActionCommand("go");
        //address.addActionListener(this);

        address.getEditor().getEditorComponent().addKeyListener(
                new KeyAdapter() {

                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == KeyEvent.VK_ENTER) {

                            actionPerformed(new ActionEvent(e, e.getKeyCode(), "go"));

                        }
                    }
                });


        JButton go = new JButton("Go");
        go.setActionCommand("go");
        go.addActionListener(this);

        JPanel addressbar = new JPanel(new BorderLayout());
        addressbar.add(new JLabel("   Address: "), BorderLayout.WEST);
        addressbar.add(address);
        addressbar.add(go, BorderLayout.EAST);

        addressbar.setOpaque(false);

        JButton add = new JButton("add Message", new ImageIcon(MessageTool.class.getResource("New16.gif")));
        add.setActionCommand("add");
        add.addActionListener(this);


        Action refresh = new AbstractAction( "refresh tree", new ImageIcon(MessageTool.class.getResource("Refresh16.gif")) ) {
            public void actionPerformed(ActionEvent e) {
                MessageTool.this.actionPerformed( new ActionEvent(e.getSource(), e.getID(), "refresh") );
            }
        };
        // this does the global mapping for F5 to fire the action
 	getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("F5"), "refresh_tree");
 	getActionMap().put("refresh_tree", refresh);


        JButton save = new JButton("save Message", new ImageIcon(MessageTool.class.getResource("Save16.gif")));
        save.setActionCommand("save message");
        save.addActionListener(this);

        JButton revert = new JButton("revert Message", new ImageIcon(MessageTool.class.getResource("Undo16.gif")));
        revert.setActionCommand("revert");
        revert.addActionListener(this);

        toolbar.add(load);
        toolbar.addSeparator();

        toolbar.add(add);
        toolbar.add( new JButton( refresh ) ); // says this is how you should add actions
        toolbar.addSeparator();
        toolbar.add(save);
        toolbar.add(revert);

        local = new JComboBox();
        //local.setSelectedItem( Locale.getDefault() );

        local.setActionCommand("locale");
        local.addActionListener(this);

        Dimension size = new Dimension(80, 25);

        local.setMaximumSize(size);
        local.setMinimumSize(size);
        local.setPreferredSize(size);


        part = new TreeCombo();

        part.setActionCommand("partner");
        part.addActionListener(this);

        size = new Dimension(150, 20);

        part.setMaximumSize(size);
        part.setMinimumSize(size);
        part.setPreferredSize(size);


        toolbar.add(Box.createHorizontalGlue());

        toolbar.add(new JLabel("  Locale: "));
        toolbar.add(local);
        toolbar.add(new JLabel("  Partner: "));
        toolbar.add(part);

        toolbar.setRollover(true);

        //DefaultMutableTreeNode top = new DefaultMutableTreeNode("root");

        //mycomm = new TestComm(top);

        tree = new JTree((TreeNode) null);
        tree.addTreeSelectionListener(this);
        //tree.addTreeExpansionListener(this);
        tree.addTreeWillExpandListener(this);

        //tree.setRootVisible(false);

        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);

        tree.setCellRenderer(new MyRenderer());

        JSplitPane splitPane = new JSplitPane();

        box = new MyPanel();

        JScrollPane scrollPane = new JScrollPane(box, JScrollPane.VERTICAL_SCROLLBAR_NEVER, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

        // bar = scrollPane.getHorizontalScrollBar();

        find = new JButton("find");
        find.setActionCommand("find");
        find.addActionListener(this);

        searchbox = new JTextField();
        searchbox.setActionCommand("find");
        searchbox.addActionListener(this);

        JPanel search = new JPanel(new BorderLayout());
        search.setOpaque(false);

        JPanel stop = new JPanel(new BorderLayout());
        stop.setOpaque(false);
        stop.add(searchbox);
        stop.add(find, BorderLayout.EAST);

        results = new JList();
        results.addListSelectionListener(this);
        results.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);


        filter1 = new JComboBox();
        filter1.setActionCommand("filter");
        filter1.addActionListener(this);

        filter3 = new JCheckBox();
        filter3.setActionCommand("missing");
        filter3.addActionListener(this);
        filter3.setOpaque(false);

        JPanel advanced = new JPanel(new java.awt.GridBagLayout());
        advanced.setOpaque(false);

        java.awt.GridBagConstraints c = new java.awt.GridBagConstraints();
        c.insets = new java.awt.Insets(3, 3, 3, 3);
        c.fill = java.awt.GridBagConstraints.BOTH;
        
        c.gridwidth = 1; // width
        c.gridheight = 1; // height

        c.weightx = 0;
        c.gridx = 0; // col
        c.gridy = 0; // row
        advanced.add(new JLabel("Locale: "), c);

        c.weightx = 1;
        c.gridx = 1; // col
        c.gridy = 0; // row
        advanced.add(filter1,c);

        c.weightx = 0;
        c.gridx = 0; // col
        c.gridy = 1; // row
        advanced.add(new JLabel("Partner: "), c);

        c.weightx = 1;
        c.gridx = 1; // col
        c.gridy = 1; // row
        advanced.add(new JComboBox(),c); // TODO

        c.weightx = 0;
        c.gridx = 0; // col
        c.gridy = 2; // row
        advanced.add(new JLabel("Missing: "), c);

        c.weightx = 1;
        c.gridx = 1; // col
        c.gridy = 2; // row
        advanced.add(filter3,c);

        JPanel more = new JPanel(new BorderLayout());
        more.setOpaque(false);

        CollapsiblePanel advanced1 = new CollapsiblePanel(advanced, "Advanced Filters");
        advanced1.setOpaque(false);

        more.add(advanced1, BorderLayout.NORTH);
        more.add(new JScrollPane(results));

        search.add(stop, BorderLayout.NORTH);
        search.add(more);

        JTabbedPane tabs = new JTabbedPane();
        tabs.add("tree", new JScrollPane(tree));
        tabs.add("search", search);

        //doublePanel = new DoublePanel(tree);
        //doublePanel.setVisible(false);

        //JPanel rightPanel = new JPanel( new BorderLayout() );
        //rightPanel.add(doublePanel);

        splitPane.setLeftComponent(tabs);
        splitPane.setRightComponent(scrollPane);

        splitPane.setDividerLocation(200);
        splitPane.setContinuousLayout(true);

        //toolbarPanel.add(toolbar, BorderLayout.NORTH);
        //toolbarPanel.add(splitPane);


        status = new JTextField("plugin not loaded");

        status.setEnabled(false);
        status.setDisabledTextColor(getForeground());
        status.setOpaque(false);
        wrap.setOpaque(false);

        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setOpaque(false);

        bottom.add(status);
        bottom.add(wrap, BorderLayout.EAST);

        add(addressbar, BorderLayout.NORTH);
        add(splitPane);
        add(bottom, BorderLayout.SOUTH);

        partners = new Vector();
    }

    public Locale getCurrentLocale() {
        return currentlocale;
    }

    public Mtcomm getPlugin() {
        return mycomm;
    }

    public JToolBar getToolBar() {
        return toolbar;
    }

    public JMenu getMenu() {
        return null;
    }
    private boolean actioncancelled;

    public void valueChanged(TreeSelectionEvent e) {

        MyNode node = (MyNode) tree.getLastSelectedPathComponent();

        if (node == null) {
            return;
        }

        if (actioncancelled) {
            actioncancelled = false;
            return;
        }

        if (node.hasMessage() && checkChange()) {

            //tree.setSelectionPath( new TreePath(message.getPath()) ); // rest highleghted message

            actioncancelled = true;

            tree.setSelectionPath(e.getOldLeadSelectionPath());

            return;

        }


        String name = node.getName();

        address.removeItem(name);

        address.insertItemAt(name, 0);
        address.setSelectedIndex(0);

        if (!node.hasMessage()) {
            return;
        }

        message = node;

        redoMessage();

    }

    public boolean checkChange() {


        boolean needsave = false;

        Component[] nowpartners = box.getComponents();

        for (int c = 0; c < nowpartners.length; c++) {

            DoublePanel p = (DoublePanel) nowpartners[c];

            if (p.checkChange()) {
                needsave = true;
                break;
            }

        }

        if (needsave) {

            int result = JOptionPane.showConfirmDialog(this, "do you want to save changes to: " + message.getName(), "save?", JOptionPane.YES_NO_CANCEL_OPTION);

            if (result == JOptionPane.CANCEL_OPTION) {

                return true;

            }

            if (result == JOptionPane.YES_OPTION) {

                saveChanges();

            }

        }


        return false;

    }

    public void redoMessage() {

        if (message == null) {
            return;
        }

        PartnerNode[] partnersh = (PartnerNode[]) partmap.get(currentpartner);

        if (partnersh == null) {

            try {

                partnersh = getPartnerHierarchy(currentpartner);

                if (partnersh == null || partnersh.length == 0) {

                    throw new Exception("nothing returned");

                }

            }
            catch (Exception e) {
                e.printStackTrace();
                showError("unable to load partners hierarchy: " + e.getMessage());

            }

            partmap.put(currentpartner, partnersh);

        }

        boolean dowrap = wrap.isSelected();

        while (partners.size() < partnersh.length) {

            DoublePanel p = new DoublePanel(tree);

            partners.add(p);

            p.setWrap(dowrap);

        }

        box.removeAll();

        for (int c = 0; c < partnersh.length; c++) {

            DoublePanel p = (DoublePanel) partners.elementAt(c);

            try {

                p.reuse(
                        message,
                        partnersh[c],
                        null,
                        currentlocale,
                        mycomm);

                box.add(p);

            }
            catch (Exception e) {
                e.printStackTrace();
                showError("unable to load message: " + e.getMessage());
                e.printStackTrace();

            }



        }

        box.validate();
        box.repaint();

    }

    public static PartnerNode[] getPartnerHierarchy(PartnerNode p) throws Exception {

        TreeNode[] path = p.getPath();

        PartnerNode[] paths = new PartnerNode[path.length];

        for (int c = 0; c < path.length; c++) {

            paths[c] = (PartnerNode) path[(path.length - 1) - c];

        }

        return paths;
    }

    /*
    public void redoMessage() {

    if (message==null) { return; }

    try {

    doublePanel.reuse(

    message,
    null,
    currentlocale,
    mycomm
    );

    doublePanel.setVisible(true);
    }
    catch(Exception e) {
    e.printStackTrace();
    showError("unable to load message: "+e.getMessage() );
    e.printStackTrace();

    }


    }
     */
    public void saveChanges() {
        Component[] nowpartners = box.getComponents();
        try {
            for (int c = 0; c < nowpartners.length; c++) {
                DoublePanel p = (DoublePanel) nowpartners[c];
                p.saveChanges();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            showError("unable to save: " + e.getMessage());
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {

        // go though all children of the node about to be expanded, and add there children to them
        //System.out.println(e.getPath());

        MyNode node = (MyNode) e.getPath().getLastPathComponent();

        try {

            node.loadChildren(mycomm, currentlocale);

        }
        catch (Exception ex) {

            showError("unable to load children: " + ex.getMessage());
            throw new ExpandVetoException(e);

        }

        //setupChildren( (DefaultMutableTreeNode)e.getPath().getLastPathComponent() );

    }

    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        //System.out.println(e);
    }

    
    public static String getNewPlugin(Component parent, String[] files) {

            //File file = new File("plugins");
            //String[] files = file.list();
            if (files.length == 1) {
                return files[0];
            }
            else {
                JComboBox box = new JComboBox();
                //String path = files[0].substring(0, files[0].lastIndexOf('.') + 1);
                for (int c = 0; c < files.length; c++) {
                    box.addItem(files[c].substring(files[c].lastIndexOf('.') + 1, files[c].length()));
                }
                Object[] message = new Object[2];
                message[0] = "Select Plugin:";
                message[1] = box;

                String[] options = {
                    "OK",
                    "cancel"
                };

                int result = JOptionPane.showOptionDialog(
                        parent, // the parent that the dialog blocks
                        message, // the dialog message array
                        "select plugin", // the title of the dialog window
                        JOptionPane.OK_CANCEL_OPTION, // option type
                        JOptionPane.QUESTION_MESSAGE, // message type
                        null, // optional icon, use null to use the default icon
                        options, // options string array, will be made into buttons
                        options[0] // option that should be made into a default button
                        );

                if (result == JOptionPane.OK_OPTION) {
                    //load( "plugins."+((JComboBox)message[1]).getSelectedItem().toString() );
                    return files[ ((JComboBox) message[1]).getSelectedIndex() ];
                }
            }
        
            return null;
    }
    
    
    public static String[] getPlugins() {
        //Iterator<Class> providers = (Iterator<Class>) Service.providerClasses( MessageTool.class );
        //List<String> list = new ArrayList<String>();

        Iterator providers = (Iterator) Service.providerClasses(MessageTool.class);
        List list = new ArrayList();

        while (providers.hasNext()) {
            String name = ((Class) providers.next()).getName();
            if (!list.contains(name)) {
                list.add(name);
            }
        }
        return (String[]) list.toArray(new String[list.size()]);
    }
    private boolean searching;
    private Result[] fullResults;

    public void actionPerformed(ActionEvent ae) {

        if (ae.getActionCommand().equals("load")) {

            if (checkChange()) {
                return;
            }

            load();

        }
        else if (ae.getActionCommand().equals("add")) {

            TreePath path = tree.getSelectionPath();

            if (path != null) {

                MyNode node = (MyNode) path.getLastPathComponent();

                String name = JOptionPane.showInputDialog(this, "Select name:", node.getName());

                if (name != null) {

                    MyNode newnode = addNode(name);

                    if (newnode!=null) {
                        TreePath treepath = new TreePath(newnode.getPath());
                        tree.setSelectionPath(treepath);
                        tree.scrollPathToVisible(treepath);
                    }
                }

            }

        }
        else if (ae.getActionCommand().equals("refresh")) {

            TreePath path = tree.getSelectionPath();

            if (path != null) {

                MyNode node = (MyNode) path.getLastPathComponent();

                node.removeAllChildren();

                try {

                    node.loadChildren(mycomm, currentlocale);

                }
                catch (Exception e) {

                    showError("unable to load children: " + e.getMessage());

                }

                ((DefaultTreeModel) tree.getModel()).reload(node);
            }

        }
        else if (ae.getActionCommand().equals("find")) {

            if (mycomm != null && !searching) {

                searching = true;
                find.setEnabled(false);

                status.setText("Searching...");

                new Thread() {

                    public void run() {

                        try {

                            fullResults = mycomm.search(filter3.isSelected()?null:searchbox.getText());

                            doFilter();

                        }
                        catch (Throwable e) {

                            showError("unable to search: " + e.getMessage());

                            e.printStackTrace();

                            status.setText("Ready");

                        }

                        find.setEnabled(true);
                        searching = false;
                    }
                }.start();


            }

        }
        else if (ae.getActionCommand().equals("go")) {

            String name = ((JTextComponent) address.getEditor().getEditorComponent()).getText(); //address.getSelectedItem().toString();

            if (name == "" || mycomm == null) {
                return;
            }

            MyNode node = getNode(name);

            if (node != null) {
                TreePath treepath = new TreePath(node.getPath());
                tree.setSelectionPath(treepath);
                tree.scrollPathToVisible(treepath);
            }

        }
        else if (ae.getActionCommand().equals("locale")) {

            if (checkChange()) {

                local.setSelectedItem(currentlocale);
                return;

            }

            final Thread old = setLocale;

            // this needs to be in a thread other then the UI thread as it does lots of network calls
            // as it updates the "is missing" state of every node in the tree, and this can take time
            setLocale = new Thread() {
                public void run() {
                    try {
                        
                        // prevent 2 from running at the same time,
                        // as both threads propagate through the tree, they will override each others changes with potential wrong values
                        if (old!=null) {
                            //old.interrupt(); because we mix UI and plugin(network) code, strange things happen like: 
                            //java.lang.Error: Interrupted attempt to aquire write lock
                            //    at javax.swing.text.AbstractDocument.writeLock(AbstractDocument.java:1334)
                            //    at javax.swing.text.AbstractDocument.replace(AbstractDocument.java:644)
                            //    at javax.swing.text.JTextComponent.setText(JTextComponent.java:1693)
                            //    at net.yura.swing.YuraTextEditor.setText(YuraTextEditor.java:599)
                            //    at net.yura.translation.DoublePanel.resetLocale(DoublePanel.java:113)
                            //    at net.yura.translation.MessageTool.setCurrentLocale(MessageTool.java:905)
                            //    at net.yura.translation.MessageTool$5.run(MessageTool.java:829)
                            old.join();
                        }

                        setCurrentLocale((Locale) local.getSelectedItem());
                    }
                    catch (InterruptedException in) {
                        // someone didnt want us to finish!! ah well..
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        showError("unable to setup locale: " +e);
                    }
                }
            };

            setLocale.start();


        }
        else if (ae.getActionCommand().equals("partner")) {

            if (checkChange()) {

                part.setSelectedItem(currentpartner);
                return;

            }

            currentpartner = (PartnerNode) part.getSelectedItem();

            redoMessage();

        }
        else if (ae.getActionCommand().equals("wrap")) {

            boolean dowrap = wrap.isSelected();
            for (int c = 0; c < partners.size(); c++) {
                DoublePanel p = (DoublePanel) partners.elementAt(c);
                p.setWrap(dowrap);
            }

        }
        else if (ae.getActionCommand().equals("save message")) {

            saveChanges();

        }
        else if (ae.getActionCommand().equals("revert")) {

            Component[] nowpartners = box.getComponents();
            for (int c = 0; c < nowpartners.length; c++) {
                ((DoublePanel) nowpartners[c]).revert();
            }

        }
        else if (ae.getActionCommand().equals("filter")) {

            doFilter();
        }
        else if (ae.getActionCommand().equals("missing")) {

            searchbox.setEnabled( !filter3.isSelected() );
            searchbox.setOpaque( !filter3.isSelected() );
        }
        else {

            System.out.println("unknown command: " + ae.getActionCommand());

        }

    }

    Thread setLocale;
    /**
     * internal method called when the locale ComboBox selection changes
     */
    private void setCurrentLocale(Locale l) throws Exception {
        if (l!=currentlocale) {
            currentlocale = l;

            for (int c = 0; c < partners.size(); c++) {
                DoublePanel p = (DoublePanel) partners.elementAt(c);
                p.resetLocale(currentlocale);
            }
            ((MyNode) tree.getModel().getRoot()).nodeWorkRefresh(mycomm, currentlocale);
            tree.repaint();

            if (filter1.getSelectedItem()==FILTER_DEFAULT_CURRENT) {
                doFilter();
            }
        }
    }

    private void doFilter() {
        if (fullResults != null) {
            Result[] res = filter(fullResults);
            Arrays.sort(res, CASE_POSTERIORITY_ORDER);
            results.setListData(res);
            status.setText("Found " + res.length + " results");
        }
    }

    private Result[] filter(Result[] res) {
        Vector v = new Vector();
        Object selected = filter1.getSelectedItem();
        Object current = local.getSelectedItem();
        for (int c = 0; c < res.length; c++) {
            if (
                    (selected == FILTER_ALL) ||
                    (selected == FILTER_DEFAULT && res[c].locale==null) ||
                    (selected == FILTER_DEFAULT_CURRENT && (res[c].locale==null || current.equals(res[c].locale) )) ||
                    (selected.equals(res[c].locale) )
                    ) {
                v.add(res[c]);
            }
        }
        return (Result[]) v.toArray(new Result[v.size()]);
    }

    public void valueChanged(ListSelectionEvent lse) {

        if (!lse.getValueIsAdjusting()) {

            Result r = (Result) results.getSelectedValue();

            if (r != null) {

                MyNode node = getNode(r.node);

                if (node!=null) {
                    TreePath treepath = new TreePath(node.getPath());
                    tree.setSelectionPath(treepath);
                    tree.scrollPathToVisible(treepath);
                }

                if (r.locale != null) {
                    local.setSelectedItem(r.locale);
                }

            }

        }

    }

    public void exit() { // yura@todo: this needs to be called

        if (!checkChange()) {

            System.exit(0);

        }

    }

    public void showError(String s) {

        JOptionPane.showMessageDialog(this, s, "Error", JOptionPane.ERROR_MESSAGE);

    }

    /**
     * method will return null if it can not add the node
     */
    public MyNode addNode(String name) {
        
        if (name.equals("") || name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.' || name.indexOf("..") != -1) {
            showError("unable to create message\nbad name: " + name);
            return null;
        }
        
        try {
             return addNode(name, (MyNode) tree.getModel().getRoot());
        }
        catch (Exception ex) { // the main error here that can happen is "node already exists"
//System.err.println("Error in addNode "+name);
//ex.printStackTrace();
            showError("unable to create node: " + ex.getMessage());
            return null;
        }

    }
    
    public MyNode addNode(String s, MyNode n) throws Exception {

        n.loadChildren(mycomm, currentlocale);

        if (s.indexOf('.') == -1) {

            Enumeration en = n.children();

            MyNode exists = null;

            while (en.hasMoreElements()) {

                MyNode node = (MyNode) en.nextElement();

                if (node.getUserObject().equals(s)) {

                    if (node.hasMessage()) {

                        throw new Exception("node already exists");

                    }
                    else {

                        exists = node;
                        node.setHasMessage(true);

                    }

                }

            }

            if (exists == null) {

                MyNode node = new MyNode(s, true);

                n.add(node);

                //((DefaultTreeModel)tree.getModel()).insertNodeInto(node,n,0);

                exists = node;
            }

            ((DefaultTreeModel) tree.getModel()).reload(n);

            return exists;

        }
        else {

            // split the name up
            String name = s.substring(0, s.indexOf('.'));			// things b4 first dot
            String name2 = s.substring(s.indexOf('.') + 1, s.length());	// things after first dot

            Enumeration en = n.children();

            while (en.hasMoreElements()) {

                MyNode node = (MyNode) en.nextElement();

                if (node.getUserObject().equals(name)) {

                    node.setHasChildren(true);

                    return addNode(name2, node);

                }

            }


            MyNode node = new MyNode(name, false);

            n.add(node);
            ((DefaultTreeModel) tree.getModel()).reload(n);


            //((DefaultTreeModel)tree.getModel()).insertNodeInto(node,n,0);

            return addNode(name2, node);


        }

    }

    public MyNode getNode(String name) {

        String[] names = name.split("\\.");

        MyNode node = (MyNode) tree.getModel().getRoot();

        for (int c = 0; c < names.length; c++) {

            // this should not happen, something is wrong!
            if ("".equals(names[c])) {
                node = null;
                break;
            }

            try {
                node.loadChildren(mycomm, currentlocale);
            }
            catch (Exception e) {
System.err.println("Error with loadChildren "+node);
e.printStackTrace();
                showError("Error loading children node: "+node);
                return null;
            }
            
            node = node.getChild(names[c]);

            if (node == null) {
                break;
            }

        }
        
        // if we have not managed to find this node, maybe the user wants to add it?
        if (node == null) {
            int result = JOptionPane.showConfirmDialog(this, "do you want to add: " + name, "confirm add", JOptionPane.YES_NO_OPTION);
            if (result == JOptionPane.YES_OPTION) {
                node = addNode( name );
            }
        }
        
        return node;

    }

    public void load() {

        try {

            String plugin = getNewPlugin(this, getPlugins() );
            if (plugin!=null) {
                load(plugin,null);
            }
            
        }
        catch (Throwable e) {
            e.printStackTrace();
            StackTraceElement[] st = e.getStackTrace();
            String info = "";
            for (int i = 0; i < st.length; i++) {
                info = info + "      at " + st[i] + "\n";
            }
            JOptionPane.showMessageDialog(this, "Error Loading plugin: " + e.getMessage() + "\n\n" + e.toString() + "\n" + info, "Load error!", JOptionPane.ERROR_MESSAGE);
        }
    }

    public void load(String plugin, Object auth) throws Exception {

        //Class myclass = pluginLoader.loadClass( plugin );

        Class myclass = Class.forName(plugin);

        final Mtcomm mycomm1;

        if (auth == null) {
            mycomm1 = (Mtcomm) myclass.newInstance(); // this will throw UserCancelledException if the user cancells during load
        }
        else {
            // TODO this is prob not the best way of doing this, would be better in the load method
            mycomm1 = (Mtcomm) myclass.getConstructor(new Class[]{auth.getClass()}).newInstance(new Object[]{auth});
        }
        Runnable runner = new Runnable() {
            public void run() {
                try {
                    if (mycomm1.load()) {
                        load(mycomm1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        // YURA not sure what to use here??
        new Thread(runner,"Mtcomm-Load-Thread").start();
        //javax.swing.SwingUtilities.invokeLater(runner);
    }

    private static Object FILTER_DEFAULT_CURRENT = "Default&Current";
    private static Object FILTER_ALL = "All";
    private static Object FILTER_DEFAULT = "Default";
    
    public void load(Mtcomm mycomm1) {

        try {

            Locale[] locales = mycomm1.getLocales();
            PartnerNode[] parts = mycomm1.getPartners();
            Locale systemDefault = Locale.getDefault();
            
            Locale defaultLocale;
            if (Arrays.asList(locales).contains(systemDefault) ) {
                defaultLocale = systemDefault;
            }
            else {
                defaultLocale = locales[0];
            }

            if (locales == null || locales.length == 0) {
                throw new Exception("unable to get info from plugin");
            }

            fullResults = null;

            MyNode root = new MyNode("ROOT", false, true);

            root.loadChildren(mycomm1, defaultLocale);

            ((DefaultTreeModel) tree.getModel()).setRoot(root);

            address.removeAllItems();

            box.removeAll();
            box.validate();
            box.repaint();

            message = null;

            local.setModel(new DefaultComboBoxModel(locales));

            //Arrays.sort(parts,YuraUtils.CASE_INSENSITIVE_ORDER);
            part.setModel(new DefaultComboBoxModel(parts));
            currentpartner = (PartnerNode) parts[0].getRoot();

            part.setModel(new DefaultTreeModel(currentpartner));

            part.setSelectedItem(currentpartner);


            results.setListData(new Object[]{});

            filter1.setModel(new DefaultComboBoxModel(locales));
            filter1.insertItemAt(FILTER_DEFAULT_CURRENT, 0);
            filter1.insertItemAt(FILTER_ALL, 1);
            filter1.insertItemAt(FILTER_DEFAULT, 2);
            filter1.setSelectedIndex(0);

            partmap = new HashMap();

            mycomm = mycomm1;

            //setLocale(defaultLocale);
            local.setSelectedItem(defaultLocale);
            local.repaint();

            status.setText("Ready");

        }
        catch (Exception ex) {

            ex.printStackTrace();
            showError(ex.toString());
        }


    }

    class MyRenderer extends DefaultTreeCellRenderer {

        ImageIcon fc;
        ImageIcon fcm;
        ImageIcon fo;
        ImageIcon fom;
        ImageIcon m;
        ImageIcon fc_E;
        ImageIcon fcm_E;
        ImageIcon fo_E;
        ImageIcon fom_E;
        ImageIcon m_E;
        ImageIcon w;

        public MyRenderer() {

            fc = new ImageIcon(MessageTool.class.getResource("fc.gif"));
            fcm = new ImageIcon(MessageTool.class.getResource("fcm.gif"));
            fo = new ImageIcon(MessageTool.class.getResource("fo.gif"));
            fom = new ImageIcon(MessageTool.class.getResource("fom.gif"));
            m = new ImageIcon(MessageTool.class.getResource("m.gif"));

            w = new ImageIcon(MessageTool.class.getResource("work.png"));

            fc_E = paintDot(fc);
            fcm_E = paintDot(fcm);
            fo_E = paintDot(fo);
            fom_E = paintDot(fom);
            m_E = paintDot(m);

        }

        private ImageIcon paintDot(ImageIcon a) {

            int s = 5;

            BufferedImage b = new BufferedImage(a.getIconWidth(), a.getIconHeight(), BufferedImage.TYPE_INT_ARGB);

            Graphics g = b.getGraphics();

            g.drawImage(a.getImage(), 0, 0, this);
            //g.setColor(Color.RED);
            //g.fillOval(b.getWidth()-s,b.getHeight()-s,s,s);

            g.drawImage(w.getImage(), 0, 0, this);
            g.dispose();

            return new ImageIcon(b);
        }

        public Component getTreeCellRendererComponent(
                JTree tree,
                Object value,
                boolean sel,
                boolean expanded,
                boolean leaf,
                int row,
                boolean hasFocus) {

            super.getTreeCellRendererComponent(
                    tree, value, sel,
                    expanded, leaf, row,
                    hasFocus);

            MyNode node = (MyNode) value;

            boolean wn = node.workNeeded();

            if (leaf && node.hasMessage()) {
                setIcon(wn ? m_E : m);
            }
            else if (expanded && node.hasMessage()) {
                setIcon(wn ? fom_E : fom);
            }
            else if (!expanded && node.hasMessage()) {
                setIcon(wn ? fcm_E : fcm);
            }
            else if (expanded && !node.hasMessage()) {
                setIcon(wn ? fo_E : fo);
            }
            else { // if (!expanded && !node.hasMessage()) {
                setIcon(wn ? fc_E : fc);
            }

            return this;
        }
    }

    public static void main(String[] args) {

        // bug reporting system
        try {
            net.yura.grasshopper.SimpleBug.initSimple(appName, version, Locale.getDefault().toString());
        }
        catch (Throwable th) { }

        MessageTool mt = new MessageTool();

        JFrame frame = new JFrame( mt.getName() +" "+WEBSITE );

        frame.getContentPane().add(mt.getToolBar(), BorderLayout.NORTH);
        frame.getContentPane().add(mt);

        frame.setSize(700, 500);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        frame.setVisible(true);

        //mt.load("plugin.name", new Auth(username,password));

    }
}

