package net.yura.swing;

import javax.swing.JDialog;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.event.MouseInputListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.FocusEvent;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

class TableSize extends JDialog implements MouseInputListener,WindowFocusListener {

	private Dimension dimension;
	private ActionListener actionlistener;

	public TableSize() {

		//setModal(true);

		setBounds(0,0,100,100);

		setBackground( Color.WHITE );

		addMouseListener(this);
		addMouseMotionListener(this);
		addWindowFocusListener(this);

		setUndecorated(true);

	}


	public void mouseDragged(MouseEvent e) {

		int x = e.getX(); if (x<0) { x=0; }
		int y = e.getY(); if (y<0) { y=0; }

		if (x > getWidth()) { setSize( getWidth()+10,getHeight() ); }

		if (y > getHeight()) { setSize( getWidth(),getHeight()+10 ); }

		Dimension d2 = new Dimension( x/10+1,y/10+1 );

		if (!d2.equals(dimension)) { dimension=d2; repaint(); }

	}

	public void mouseMoved(MouseEvent e) {



	}

	public void paint(Graphics g) {


		g.setColor( Color.WHITE );
		g.fillRect(0,0,getWidth(),getHeight());

		g.setColor( Color.BLUE );
		g.fillRect(0,0,dimension.width*10,dimension.height*10);



		g.setColor( Color.BLACK );
		g.drawRect(0,0,getWidth()-1,getHeight()-1);

		int width = getWidth()/10;
		int height = getHeight()/10;

		for (int x=1; x < width;x++) {

			g.drawLine(x*10,0,x*10,height*10);

		}
		for (int y=1; y < height;y++) {

			g.drawLine(0,y*10,width*10,y*10);
		}

		g.setColor( Color.WHITE );
		g.drawString("("+dimension.width+","+dimension.height+")",dimension.width*5-10,dimension.height*5+5);

	}

	public void showPopup() {

		dimension = new Dimension(3,3);

		setVisible(true);

	}

	public void addActionListener(ActionListener l) {

		actionlistener = l;

	}

	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void windowGainedFocus(WindowEvent e) {}

	public void mouseReleased(MouseEvent e) {

		setVisible(false);

		if (e.getX() > 0 && e.getY() > 0) { actionlistener.actionPerformed( new ActionEvent(this,0,"yuratable") ); }

	}
	public void windowLostFocus(WindowEvent e) {

		setVisible(false);

	}

	public Dimension getTableSize() {

		return dimension;

	}

}
