package net.yura.grasshopper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

/**
 * @author Yura Mamyrin
 */
public class SimpleBug extends StringWriter {

    static SimpleBug instance;

    public SimpleBug() {

        if (instance!=null) return;

        BugManager.interceptAndAlert(this, new BugManager() {
            protected void action(String cause) {
                doSubmit(cause);
            }
        });

        instance = this;
    }


    private void doSubmit(String cause) {
        BugSubmitter.submitBug(toString(), cause);
    }

    
    /**
     * keeps the full log in memory
     */
    public static void initSimple(String appname,String version,String locale) {
        
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
        
        if (instance==null) {
            new SimpleBug();
        }

    }

    /**
     * keeps the full log for this session in a log file grasshopper.log
     */
    public static void initLogFile(String appname,String version,String locale) {
        
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
        
        try {
            File file = new File("grasshopper.log");
            if ( !canWrite(file) ) {
                file = new File( System.getProperty("java.io.tmpdir"), file.getName() );
            }
            FileWriter fileWriter = new FileWriter(file);
            // this is better then FileHandler as i know for sure what file is being used
            // with JUL you can not get the filename in current use
            //Logger.getLogger("").addHandler( new FileHandler() );

            final File logfile = file;
            //logfile.deleteOnExit();
            BugManager.interceptAndAlert(fileWriter, new BugManager() {
                boolean sent;
                protected void action(String cause) {
                    // TODO only sends first error, maybe there is a better way of doing this
                    if (!sent) {
                        sent=true;
                        BugSubmitter.submitBug(logfile, cause);
                    }
                }
            });

        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        
    }
    
    private static boolean canWrite(File file) {
        try {
            if (file.exists() && file.delete()) {
                return true;
            }
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (Exception ex) { }
        return false;
    }
    
}
