/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIPlayer;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.BadgeButton;
import net.yura.domination.engine.guishared.MapMouseListener;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.guishared.RiskFileFilter;
import net.yura.domination.engine.guishared.StatsPanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.tools.mapeditor.MapEditor;
import net.yura.domination.ui.swinggui.BugsPanel;
import net.yura.domination.ui.swinggui.CardsDialog;
import net.yura.domination.ui.swinggui.FX3DPanel;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.domination.ui.swinggui.TestPanel;
import net.yura.domination.ui.swinggui.TranslationToolPanel;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.BugSubmitter;
import net.yura.swingme.core.CoreUtil;

public class SwingGUIPanel
extends JPanel
implements ActionListener {
    public static final String version = "2";
    public static final String product = "Swing GUI for " + RiskUtil.GAME_NAME;
    private ResourceBundle resbundle = TranslationBundle.getBundle();
    private Risk myrisk;
    private int gameState;
    private boolean localGame;
    private JTabbedPane tabbedpane;
    private JToolBar currentToolbar;
    private JMenuBar gMenuBar;
    private GameTab gameTab;
    private ConsoleTab consoleTab;
    private StatisticsTab statisticsTab;
    private DebugTab debugTab;
    private MapEditor editorTab;
    private PicturePanel pp;
    private JLabel attacker;
    private JTextField country1;
    private JTextField country2;
    private JPanel inGameInput;
    private CardLayout inGameCards;
    private JPanel defend;
    private JPanel roll;
    private winnerPanel winner;
    private tradeCardsPanel tradeCards;
    private JSlider slider;
    private JSlider moveNumber;
    private JLabel armies;
    private JButton autoplace;
    private JLabel resultsLabel;
    private SetupPanel guiSetup;
    private JPanel gameOptions;
    private JButton roll1;
    private JButton roll2;
    private JButton roll3;
    private JComboBox mapViewComboBox;
    private JButton showMission;
    private JButton showCards;
    private JButton Undo;
    private JButton lobby;
    private JLabel capitalLabel;

    public SwingGUIPanel(Risk r) {
        this.myrisk = r;
        this.gameState = -1;
        this.pp = new PicturePanel(this.myrisk);
        this.setLayout(new BorderLayout());
        this.gMenuBar = new JMenuBar();
        this.tabbedpane = new JTabbedPane();
        this.gameTab = new GameTab();
        this.consoleTab = new ConsoleTab();
        this.statisticsTab = new StatisticsTab();
        this.editorTab = new MapEditor(this.myrisk, this);
        this.addTab(this.gameTab);
        this.addTab(new FX3DPanel(this.pp));
        this.addTab(this.consoleTab);
        this.addTab(this.statisticsTab);
        try {
            this.debugTab = new DebugTab();
            this.addTab(this.debugTab);
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        this.addTab(new TestPanel(this.myrisk, this.pp));
        this.addTab(this.editorTab);
        try {
            this.addTab(new TranslationToolPanel());
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        this.addTab(new BugsPanel());
        this.add((Component)this.tabbedpane, "Center");
        ChangeListener changeMenu = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingGUITab sgt = (SwingGUITab)((Object)SwingGUIPanel.this.tabbedpane.getSelectedComponent());
                if (SwingGUIPanel.this.currentToolbar != null) {
                    SwingGUIPanel.this.remove(SwingGUIPanel.this.currentToolbar);
                }
                SwingGUIPanel.this.currentToolbar = sgt.getToolBar();
                SwingGUIPanel.this.currentToolbar.setOrientation(0);
                SwingGUIPanel.this.add((Component)SwingGUIPanel.this.currentToolbar, "North");
                SwingGUIPanel.this.revalidate();
                SwingGUIPanel.this.repaint();
            }
        };
        this.tabbedpane.addChangeListener(changeMenu);
        changeMenu.stateChanged(null);
        JMenu gHelp = new JMenu(this.resbundle.getString("swing.menu.help"));
        gHelp.setMnemonic('H');
        JMenuItem gmManual = new JMenuItem(this.resbundle.getString("swing.menu.manual"));
        gmManual.setMnemonic('M');
        gmManual.setActionCommand("manual");
        gmManual.addActionListener(this);
        gHelp.add(gmManual);
        JMenuItem cmCommands = new JMenuItem(this.resbundle.getString("swing.menu.console.commands"));
        cmCommands.setMnemonic('C');
        cmCommands.setActionCommand("commands");
        cmCommands.addActionListener(this);
        gHelp.add(cmCommands);
        JMenuItem gmAbout = new JMenuItem(this.resbundle.getString("swing.menu.about"));
        gmAbout.setMnemonic('A');
        gmAbout.setActionCommand("about");
        gmAbout.addActionListener(this);
        gHelp.add(gmAbout);
        this.gMenuBar.add(gHelp);
        this.myrisk.addRiskListener(new SwingRiskAdapter());
        if (this.debugTab != null) {
            this.debugTab.start();
        }
        AIPlayer.setWait(5);
    }

    public JMenuBar getJMenuBar() {
        return this.gMenuBar;
    }

    public void setupLobbyButton() {
        if (RiskUIUtil.getAddLobby(this.myrisk)) {
            this.lobby.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals("manual")) {
            try {
                RiskUtil.openDocs(this.resbundle.getString("helpfiles.swing"));
            }
            catch (Exception e) {
                this.showError("Unable to open manual: " + e.getMessage());
            }
        } else if (a.getActionCommand().equals("about")) {
            this.openAbout();
        } else if (a.getActionCommand().equals("quit")) {
            System.exit(0);
        } else if (a.getActionCommand().equals("commands")) {
            this.Commands();
        } else {
            System.out.print("command \"" + a.getActionCommand() + "\" is not implemented yet\n");
        }
    }

    public void addTab(SwingGUITab a) {
        this.tabbedpane.add((Component)((Object)a));
        JMenu menu = a.getMenu();
        if (menu != null) {
            this.gMenuBar.add(menu);
        }
    }

    public static void submitBug(Component parent, String text, String from, String subjectIn, String cause) {
        String subject = RiskUtil.GAME_NAME + " " + Risk.RISK_VERSION + " SwingGUI " + TranslationBundle.getBundle().getLocale().toString() + " " + subjectIn;
        try {
            BugSubmitter.submitBug(text, from, subject, cause, RiskUtil.GAME_NAME, Risk.RISK_VERSION + " (save: " + RiskGame.SAVE_VERSION + " network: " + "11" + ")", TranslationBundle.getBundle().getLocale().toString());
            JOptionPane.showMessageDialog(parent, "SENT!");
        }
        catch (Throwable ex) {
            try {
                URL url = new URL("mailto:yura@yura.net?subject=" + URLEncoder.encode(subject, "UTF-8").replace('+', ' ') + "&body=" + URLEncoder.encode(text, "UTF-8").replace('+', ' '));
                RiskUtil.openURL(url);
            }
            catch (Throwable th) {
                JOptionPane.showMessageDialog(parent, "ERROR: " + ex + " " + th);
            }
        }
    }

    public void saveLog(JTextArea textArea) {
        JFileChooser fc = new JFileChooser();
        RiskFileFilter filter = new RiskFileFilter("log");
        fc.setFileFilter(filter);
        int returnVal = fc.showSaveDialog(RiskUIUtil.findParentFrame(this));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith(".log")) {
                fileName = fileName + "." + "log";
            }
            try {
                FileWriter fileout = new FileWriter(fileName);
                BufferedWriter buffer = new BufferedWriter(fileout);
                PrintWriter printer = new PrintWriter(buffer);
                printer.write(textArea.getText());
                printer.close();
            }
            catch (Exception error) {
                this.showError(error.getMessage());
            }
        }
    }

    public void go(String input) {
        this.pp.setHighLight(255);
        if (this.gameState != 2 || !this.myrisk.getGame().getSetup()) {
            this.blockInput();
        }
        this.myrisk.parser(input);
    }

    public void blockInput() {
        this.gameState = -1;
        this.inGameCards.show(this.inGameInput, "nothing");
        this.gameTab.blockInput();
        this.consoleTab.blockInput();
    }

    public void Commands() {
        String commands = "";
        try {
            BufferedReader bufferin = new BufferedReader(new InputStreamReader(RiskUtil.openStream("commands.txt")));
            String input = bufferin.readLine();
            while (input != null) {
                commands = commands.equals("") ? input : commands + "\n" + input;
                input = bufferin.readLine();
            }
            bufferin.close();
            JOptionPane.showMessageDialog(RiskUIUtil.findParentFrame(this), commands, this.resbundle.getString("swing.message.commands"), -1);
        }
        catch (Exception e) {
            this.showError("error with commands.txt file: " + e.getMessage());
        }
    }

    public void openAbout() {
        RiskUIUtil.openAbout(RiskUIUtil.findParentFrame(this), product, version);
    }

    public void openCards() {
        Frame frame = RiskUIUtil.findParentFrame(this);
        CardsDialog cardsDialog = new CardsDialog(frame, this.pp, true, this.myrisk, this.gameState == 1);
        Dimension frameSize = frame.getSize();
        Dimension aboutSize = cardsDialog.getPreferredSize();
        int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        cardsDialog.setLocation(x, y);
        cardsDialog.populate(this.myrisk.getCurrentCards());
        cardsDialog.setVisible(true);
    }

    public void showQuestion(int n) {
        this.moveNumber.setMaximum(n);
        this.moveNumber.setMinimum(1);
        this.moveNumber.setValue(1);
        Object[] options = new String[]{this.resbundle.getString("swing.move.move"), this.resbundle.getString("swing.move.moveall"), this.resbundle.getString("swing.move.cancel")};
        int a = JOptionPane.showOptionDialog(RiskUIUtil.findParentFrame(this), this.moveNumber, this.resbundle.getString("swing.move.title"), -1, 3, null, options, options[0]);
        if (a == 0) {
            this.go("movearmies " + this.pp.getC1() + " " + this.pp.getC2() + " " + this.moveNumber.getValue());
        }
        if (a == 1) {
            this.go("movearmies " + this.pp.getC1() + " " + this.pp.getC2() + " " + n);
        }
    }

    public void showError(String error) {
        JOptionPane.showMessageDialog(this, this.resbundle.getString("swing.message.error") + " " + error, this.resbundle.getString("swing.title.error"), 0);
    }

    public void showMission(String mission) {
        JOptionPane.showMessageDialog(this, this.resbundle.getString("swing.message.mission") + " " + mission, this.resbundle.getString("swing.title.mission"), 1);
    }

    public void pprepaintCountries() {
        String tmp = (String)this.mapViewComboBox.getSelectedItem();
        int newview = -1;
        if (tmp.equals(this.resbundle.getString("game.tabs.continents"))) {
            newview = 0;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.ownership"))) {
            newview = 1;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.borderthreat"))) {
            newview = 2;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.cardownership"))) {
            newview = 3;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.troopstrength"))) {
            newview = 4;
        } else if (tmp.equals(this.resbundle.getString("game.tabs.connectedempire"))) {
            newview = 5;
        }
        this.pp.repaintCountries(newview);
    }

    public void showMapImage(Icon p) {
        this.guiSetup.showMapImage(p);
    }

    public JPanel makeGameOptionsPanel() {
        JPanel gameOptionsPanel = new JPanel();
        gameOptionsPanel.setLayout(new FlowLayout(1, 10, 0));
        gameOptionsPanel.setOpaque(false);
        JLabel mapLookLabel = new JLabel(this.resbundle.getString("game.tabs.mapview") + ":");
        this.mapViewComboBox = new JComboBox();
        Dimension mapViewSize = new Dimension(120, 20);
        this.mapViewComboBox.setPreferredSize(mapViewSize);
        this.mapViewComboBox.setMinimumSize(mapViewSize);
        this.mapViewComboBox.setMaximumSize(mapViewSize);
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.continents"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.ownership"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.borderthreat"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.cardownership"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.troopstrength"));
        this.mapViewComboBox.addItem(this.resbundle.getString("game.tabs.connectedempire"));
        this.mapViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                SwingGUIPanel.this.pprepaintCountries();
                SwingGUIPanel.this.pp.repaint();
            }
        });
        JLabel playersLabel = new JLabel(this.resbundle.getString("newgame.label.players"));
        Dimension playerPanelSize = new Dimension(120, 20);
        playersPanel players = new playersPanel();
        players.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1));
        players.setPreferredSize(playerPanelSize);
        players.setMinimumSize(playerPanelSize);
        players.setMaximumSize(playerPanelSize);
        gameOptionsPanel.add(mapLookLabel);
        gameOptionsPanel.add(this.mapViewComboBox);
        gameOptionsPanel.add(playersLabel);
        gameOptionsPanel.add(players);
        gameOptionsPanel.add(this.showMission);
        gameOptionsPanel.add(this.showCards);
        gameOptionsPanel.add(this.Undo);
        return gameOptionsPanel;
    }

    class winnerPanel
    extends JPanel {
        JButton continueButton;

        public winnerPanel() {
            this.continueButton = new JButton(SwingGUIPanel.this.resbundle.getString("game.button.go.continue"));
            this.continueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("continue");
                }
            });
            this.add(new JLabel(SwingGUIPanel.this.resbundle.getString("game.over")));
            this.add(this.continueButton);
        }
    }

    class movePanel
    extends JPanel {
        public movePanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            SwingGUIPanel.this.slider.setMinimumSize(new Dimension(300, 50));
            SwingGUIPanel.this.slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            SwingGUIPanel.this.slider.setPaintTicks(true);
            SwingGUIPanel.this.slider.setMajorTickSpacing(1);
            SwingGUIPanel.this.slider.setPaintLabels(true);
            SwingGUIPanel.this.slider.setSnapToTicks(true);
            SwingGUIPanel.this.slider.getLabelTable().put(new Integer(11), new JLabel(new Integer(11).toString(), 0));
            SwingGUIPanel.this.slider.setLabelTable(SwingGUIPanel.this.slider.getLabelTable());
            SwingGUIPanel.this.slider.getAccessibleContext().setAccessibleName("slider");
            SwingGUIPanel.this.slider.getAccessibleContext().setAccessibleDescription("move armies slider");
            SwingGUIPanel.this.slider.setOpaque(false);
            JLabel label = new JLabel(SwingGUIPanel.this.resbundle.getString("move.numberofarmies"));
            JButton move1 = new JButton(SwingGUIPanel.this.resbundle.getString("move.move"));
            move1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("move " + SwingGUIPanel.this.slider.getValue());
                }
            });
            JButton moveall = new JButton(SwingGUIPanel.this.resbundle.getString("move.moveall"));
            moveall.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("move all");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)label, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.slider, c);
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)move1, c);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)moveall, c);
        }
    }

    class defendPanel
    extends JPanel {
        public defendPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
        }
    }

    class rollPanel
    extends JPanel {
        public rollPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton retreat = new JButton(SwingGUIPanel.this.resbundle.getString("battle.retreat"));
            retreat.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("retreat");
                }
            });
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)retreat, c);
        }
    }

    class tacMovePanel
    extends JPanel {
        public tacMovePanel() {
            this.setLayout(new GridBagLayout());
            Dimension size = new Dimension(200, 40);
            SwingGUIPanel.this.country1 = new JTextField("");
            SwingGUIPanel.this.country1.setEditable(false);
            SwingGUIPanel.this.country1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Source", 4, 2, new Font("SansSerif", 0, 11), new Color(60, 60, 60)));
            SwingGUIPanel.this.country1.setPreferredSize(size);
            SwingGUIPanel.this.country1.setMinimumSize(size);
            SwingGUIPanel.this.country1.setMaximumSize(size);
            SwingGUIPanel.this.country2 = new JTextField("");
            SwingGUIPanel.this.country2.setEditable(false);
            SwingGUIPanel.this.country2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Target", 4, 2, new Font("SansSerif", 0, 11), new Color(60, 60, 60)));
            SwingGUIPanel.this.country2.setPreferredSize(size);
            SwingGUIPanel.this.country2.setMinimumSize(size);
            SwingGUIPanel.this.country2.setMaximumSize(size);
            SwingGUIPanel.this.country1.setOpaque(false);
            SwingGUIPanel.this.country2.setOpaque(false);
            SwingGUIPanel.this.moveNumber.setMinimumSize(new Dimension(300, 50));
            SwingGUIPanel.this.moveNumber.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            SwingGUIPanel.this.moveNumber.setPaintTicks(true);
            SwingGUIPanel.this.moveNumber.setMajorTickSpacing(1);
            SwingGUIPanel.this.moveNumber.setPaintLabels(true);
            SwingGUIPanel.this.moveNumber.setSnapToTicks(true);
            SwingGUIPanel.this.moveNumber.getLabelTable().put(new Integer(11), new JLabel(new Integer(11).toString(), 0));
            SwingGUIPanel.this.moveNumber.setLabelTable(SwingGUIPanel.this.slider.getLabelTable());
            SwingGUIPanel.this.moveNumber.getAccessibleContext().setAccessibleName("slider");
            SwingGUIPanel.this.moveNumber.getAccessibleContext().setAccessibleDescription("move armies slider");
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.anchor = 15;
            JButton moveButton = new JButton(SwingGUIPanel.this.resbundle.getString("move.move"));
            moveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (!SwingGUIPanel.this.country1.getText().equals("") && !SwingGUIPanel.this.country2.getText().equals("")) {
                        int nCountryId = SwingGUIPanel.this.myrisk.getGame().getCountryInt(SwingGUIPanel.this.pp.getC1()).getColor();
                        SwingGUIPanel.this.showQuestion(SwingGUIPanel.this.myrisk.hasArmiesInt(nCountryId) - 1);
                        SwingGUIPanel.this.country1.setText("");
                        SwingGUIPanel.this.country2.setText("");
                        SwingGUIPanel.this.pp.setC1(255);
                        SwingGUIPanel.this.pp.setC2(255);
                        SwingGUIPanel.this.pp.repaint();
                    }
                }
            });
            JButton noMoveButton = new JButton(SwingGUIPanel.this.resbundle.getString("game.button.go.nomove"));
            noMoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("nomove");
                    SwingGUIPanel.this.country1.setText("");
                    SwingGUIPanel.this.country2.setText("");
                    SwingGUIPanel.this.pp.setC1(255);
                    SwingGUIPanel.this.pp.setC2(255);
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.country1, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.country2, c);
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)moveButton, c);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)noMoveButton, c);
        }
    }

    class attackPanel
    extends JPanel {
        public attackPanel() {
            this.setLayout(new GridBagLayout());
            Dimension size = new Dimension(300, 20);
            SwingGUIPanel.this.attacker = new JLabel(SwingGUIPanel.this.resbundle.getString("game.note.selectattacker"));
            SwingGUIPanel.this.attacker.setPreferredSize(size);
            SwingGUIPanel.this.attacker.setMinimumSize(size);
            SwingGUIPanel.this.attacker.setMaximumSize(size);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endAttackButton = new JButton(SwingGUIPanel.this.resbundle.getString("game.button.go.endattack"));
            endAttackButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("endattack");
                    SwingGUIPanel.this.attacker.setText(SwingGUIPanel.this.resbundle.getString("game.note.selectattacker"));
                    SwingGUIPanel.this.pp.setC1(255);
                    SwingGUIPanel.this.pp.setC2(255);
                    SwingGUIPanel.this.pp.repaint();
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.attacker, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endAttackButton, c);
        }
    }

    class placeArmiesPanel
    extends JPanel {
        public placeArmiesPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            SwingGUIPanel.this.autoplace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("autoplace");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.armies, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.autoplace, c);
        }
    }

    class endgoPanel
    extends JPanel {
        public endgoPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endturn = new JButton("End Go");
            endturn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("endgo");
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endturn, c);
        }
    }

    class tradeCardsPanel
    extends JPanel {
        JButton endtrade;

        public tradeCardsPanel() {
            this.endtrade = new JButton(SwingGUIPanel.this.resbundle.getString("game.button.go.endtrade"));
            this.endtrade.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("endtrade");
                }
            });
            this.add(new JLabel(SwingGUIPanel.this.resbundle.getString("cards.totradeclick")));
            this.add(this.endtrade);
        }
    }

    class capitalPanel
    extends JPanel {
        public capitalPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JButton endtrade = new JButton(SwingGUIPanel.this.resbundle.getString("about.okbutton"));
            endtrade.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    int c1Id = SwingGUIPanel.this.pp.getC1();
                    SwingGUIPanel.this.pp.setC1(255);
                    SwingGUIPanel.this.go("capital " + c1Id);
                }
            });
            SwingGUIPanel.this.capitalLabel = new JLabel(SwingGUIPanel.this.resbundle.getString("core.help.selectcapital"));
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)SwingGUIPanel.this.capitalLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)endtrade, c);
        }
    }

    class SetupPanel
    extends JPanel
    implements ActionListener {
        private JRadioButton domination;
        private JRadioButton capital;
        private JRadioButton mission;
        private JCheckBox AutoPlaceAll;
        private JCheckBox recycle;
        private JLabel mapPic;
        private JTextField cardsFile;
        private ButtonGroup CardTypeButtonGroup;
        private ButtonGroup GameTypeButtonGroup;
        private JTable players;
        private TableModel dataModel;
        private JButton defaultPlayers;
        private Object[][] data;
        private NamedColor[] namedColors;

        private void showCardsFile(String c, boolean m) {
            this.cardsFile.setText(c);
            if (!m && this.mission.isSelected()) {
                this.domination.setSelected(true);
                this.AutoPlaceAll.setEnabled(true);
            }
            this.mission.setEnabled(m);
        }

        public void showMapImage(Icon p) {
            this.mapPic.setIcon(p);
            SwingGUIPanel.this.setCursor(null);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.mission) {
                this.AutoPlaceAll.setEnabled(false);
            } else if (e.getSource() == this.domination) {
                this.AutoPlaceAll.setEnabled(true);
            } else if (e.getSource() == this.capital) {
                this.AutoPlaceAll.setEnabled(true);
            }
        }

        public SetupPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            JPanel playerOptions = new JPanel();
            playerOptions.setLayout(new GridBagLayout());
            playerOptions.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.players")));
            this.namedColors = new NamedColor[]{new NamedColor(Color.black, "black", SwingGUIPanel.this.resbundle.getString("color.black")), new NamedColor(Color.blue, "blue", SwingGUIPanel.this.resbundle.getString("color.blue")), new NamedColor(Color.cyan, "cyan", SwingGUIPanel.this.resbundle.getString("color.cyan")), new NamedColor(Color.darkGray, "darkgray", SwingGUIPanel.this.resbundle.getString("color.darkgray")), new NamedColor(Color.green, "green", SwingGUIPanel.this.resbundle.getString("color.green")), new NamedColor(Color.lightGray, "lightgray", SwingGUIPanel.this.resbundle.getString("color.lightgray")), new NamedColor(Color.magenta, "magenta", SwingGUIPanel.this.resbundle.getString("color.magenta")), new NamedColor(Color.orange, "orange", SwingGUIPanel.this.resbundle.getString("color.orange")), new NamedColor(Color.pink, "pink", SwingGUIPanel.this.resbundle.getString("color.pink")), new NamedColor(Color.red, "red", SwingGUIPanel.this.resbundle.getString("color.red")), new NamedColor(Color.white, "white", SwingGUIPanel.this.resbundle.getString("color.white")), new NamedColor(Color.yellow, "yellow", SwingGUIPanel.this.resbundle.getString("color.yellow"))};
            Object[] names = new String[]{SwingGUIPanel.this.resbundle.getString("newgame.label.name"), SwingGUIPanel.this.resbundle.getString("newgame.label.color"), SwingGUIPanel.this.resbundle.getString("newgame.label.type")};
            this.data = new Object[6][3];
            for (int cc = 1; cc <= 6; ++cc) {
                this.data[cc - 1][0] = SwingGUIPanel.this.myrisk.getRiskConfig("default.player" + cc + ".name");
                this.data[cc - 1][1] = this.findColor(RiskUtil.getColor(SwingGUIPanel.this.myrisk.getRiskConfig("default.player" + cc + ".color")));
                this.data[cc - 1][2] = this.findType(Risk.getType(SwingGUIPanel.this.myrisk.getRiskConfig("default.player" + cc + ".type")));
            }
            this.dataModel = new DefaultTableModel(this.data, names, (String[])names){
                private final /* synthetic */ String[] val$names;
                {
                    this.val$names = stringArray;
                    super(x0, x1);
                }

                public String getColumnName(int column) {
                    return this.val$names[column];
                }

                public Class getColumnClass(int c) {
                    return this.getValueAt(0, c).getClass();
                }

                public boolean isCellEditable(int row, int col) {
                    return SwingGUIPanel.this.localGame;
                }

                public void setValueAt(Object aValue, int row, int column) {
                    if (column == 0 && ((String)(aValue = ((String)aValue).replace('$', 'S'))).length() > 15) {
                        aValue = ((String)aValue).substring(0, 15);
                    }
                    super.setValueAt(aValue, row, column);
                }
            };
            this.players = new JTable(this.dataModel);
            this.players.setSelectionMode(0);
            this.players.getTableHeader().setReorderingAllowed(false);
            DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer(){

                public void setValue(Object value) {
                    if (value instanceof NamedColor) {
                        NamedColor c = (NamedColor)value;
                        this.setBackground(c);
                        this.setForeground(RiskUIUtil.getTextColorFor(c));
                        this.setText(c.toString());
                    } else {
                        super.setValue(value);
                    }
                }
            };
            final JComboBox<NamedColor> colorComboBox = new JComboBox<NamedColor>(this.namedColors);
            final JComboBox<String> typeComboBox = new JComboBox<String>();
            typeComboBox.addItem(SwingGUIPanel.this.resbundle.getString("newgame.player.type.human"));
            typeComboBox.addItem(SwingGUIPanel.this.resbundle.getString("newgame.player.type.crapai"));
            typeComboBox.addItem(SwingGUIPanel.this.resbundle.getString("newgame.player.type.easyai"));
            typeComboBox.addItem(SwingGUIPanel.this.resbundle.getString("newgame.player.type.hardai"));
            TableColumn colorColumn = this.players.getColumn(SwingGUIPanel.this.resbundle.getString("newgame.label.color"));
            colorColumn.setCellEditor(new DefaultCellEditor(colorComboBox));
            colorRenderer.setHorizontalAlignment(0);
            colorColumn.setCellRenderer(colorRenderer);
            TableColumn typeColumn = this.players.getColumn(SwingGUIPanel.this.resbundle.getString("newgame.label.type"));
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            JScrollPane scrollpane = new JScrollPane(this.players);
            Dimension psize = new Dimension(200, 140);
            scrollpane.setPreferredSize(psize);
            scrollpane.setMinimumSize(psize);
            scrollpane.setMaximumSize(psize);
            colorComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    Color c = (Color)colorComboBox.getSelectedItem();
                    colorComboBox.setBackground(c);
                    colorComboBox.setForeground(RiskUIUtil.getTextColorFor(c));
                }
            });
            JButton newPlayer = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.newplayer"));
            newPlayer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (SwingGUIPanel.this.localGame) {
                        ((DefaultTableModel)SetupPanel.this.dataModel).addRow(new Object[]{SwingGUIPanel.this.resbundle.getString("newgame.newplayername"), SetupPanel.this.namedColors[0], SwingGUIPanel.this.resbundle.getString("newgame.player.type.human")});
                    } else {
                        colorComboBox.setSelectedIndex(0);
                        typeComboBox.setSelectedIndex(0);
                        Object[] message = new Object[]{SwingGUIPanel.this.resbundle.getString("newgame.label.name"), new JTextField(SwingGUIPanel.this.resbundle.getString("newgame.newplayername")), SwingGUIPanel.this.resbundle.getString("newgame.label.color"), colorComboBox, SwingGUIPanel.this.resbundle.getString("newgame.label.type"), typeComboBox};
                        Object[] options = new String[]{"OK", "Cancel"};
                        int result = JOptionPane.showOptionDialog(RiskUIUtil.findParentFrame(SwingGUIPanel.this), message, "create new player", 2, 3, null, options, options[0]);
                        if (result == 0) {
                            String type = null;
                            int types = typeComboBox.getSelectedIndex();
                            switch (types) {
                                case 0: {
                                    type = "human";
                                    break;
                                }
                                case 1: {
                                    type = "ai crap";
                                    break;
                                }
                                case 2: {
                                    type = "ai easy";
                                    break;
                                }
                                case 3: {
                                    type = "ai hard";
                                }
                            }
                            SwingGUIPanel.this.go("newplayer " + type + " " + ((NamedColor)colorComboBox.getSelectedItem()).getRealName() + " " + ((JTextField)message[1]).getText());
                        }
                    }
                }
            });
            JButton delPlayer = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.removeplayer"));
            delPlayer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    if (SetupPanel.this.players.getSelectedRow() == -1) {
                        return;
                    }
                    if (SwingGUIPanel.this.localGame) {
                        SetupPanel.this.players.removeEditor();
                        ((DefaultTableModel)SetupPanel.this.dataModel).removeRow(SetupPanel.this.players.getSelectedRow());
                    } else {
                        SwingGUIPanel.this.go("delplayer " + SetupPanel.this.players.getValueAt(SetupPanel.this.players.getSelectedRow(), 0));
                    }
                }
            });
            this.defaultPlayers = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.resetplayers"));
            this.defaultPlayers.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SetupPanel.this.players.removeEditor();
                    SetupPanel.this.resetPlayers();
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.gridheight = 1;
            playerOptions.add((Component)scrollpane, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)newPlayer, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)delPlayer, c);
            c.gridx = 2;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            playerOptions.add((Component)this.defaultPlayers, c);
            JPanel mapOptions = new JPanel();
            mapOptions.setLayout(new GridBagLayout());
            mapOptions.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.map")));
            BadgeButton chooseMap = new BadgeButton(SwingGUIPanel.this.resbundle.getString("newgame.choosemap"));
            chooseMap.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String name = RiskUIUtil.getNewMap(RiskUIUtil.findParentFrame(SwingGUIPanel.this));
                    if (name != null) {
                        SwingGUIPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        SwingGUIPanel.this.go("choosemap " + name);
                    }
                }
            });
            JButton defaultMap = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.defaultmap"));
            defaultMap.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("choosemap " + RiskGame.getDefaultMap());
                }
            });
            this.mapPic = new JLabel();
            this.mapPic.setBorder(BorderFactory.createLoweredBevelBorder());
            Dimension size = new Dimension(203, 127);
            this.mapPic.setPreferredSize(size);
            this.mapPic.setMinimumSize(size);
            this.mapPic.setMaximumSize(size);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            mapOptions.add((Component)this.mapPic, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            mapOptions.add((Component)chooseMap, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            mapOptions.add((Component)defaultMap, c);
            JPanel cardOptions = new JPanel();
            cardOptions.setLayout(new GridBagLayout());
            cardOptions.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.cards")));
            this.cardsFile = new JTextField("");
            this.cardsFile.setEditable(false);
            this.cardsFile.setBackground(mapOptions.getBackground());
            size = new Dimension(200, 20);
            this.cardsFile.setPreferredSize(size);
            this.cardsFile.setMinimumSize(size);
            this.cardsFile.setMaximumSize(size);
            JButton chooseCards = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.choosecards"));
            chooseCards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String name = RiskUIUtil.getNewFile(RiskUIUtil.findParentFrame(SwingGUIPanel.this), "cards");
                    if (name != null) {
                        SwingGUIPanel.this.go("choosecards " + name);
                    }
                }
            });
            JButton defaultCards = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.defaultcards"));
            defaultCards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    SwingGUIPanel.this.go("choosecards " + RiskGame.getDefaultCards());
                }
            });
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            cardOptions.add((Component)this.cardsFile, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            cardOptions.add((Component)chooseCards, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            cardOptions.add((Component)defaultCards, c);
            JPanel GameTypeButtons = new JPanel();
            GameTypeButtons.setLayout(new BoxLayout(GameTypeButtons, 1));
            GameTypeButtons.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.gametype")));
            JPanel cardsOptions = new JPanel();
            cardsOptions.setLayout(new BoxLayout(cardsOptions, 1));
            cardsOptions.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.cardsoptions")));
            this.GameTypeButtonGroup = new ButtonGroup();
            this.CardTypeButtonGroup = new ButtonGroup();
            this.domination = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.mode.domination"), true);
            this.capital = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.mode.capital"));
            this.mission = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.mode.mission"));
            this.domination.setOpaque(false);
            this.capital.setOpaque(false);
            this.mission.setOpaque(false);
            this.domination.addActionListener(this);
            this.capital.addActionListener(this);
            this.mission.addActionListener(this);
            final JRadioButton increasing = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.cardmode.increasing"), true);
            final JRadioButton fixed = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.cardmode.fixed"));
            JRadioButton italian = new JRadioButton(SwingGUIPanel.this.resbundle.getString("newgame.cardmode.italianlike"));
            increasing.setOpaque(false);
            fixed.setOpaque(false);
            italian.setOpaque(false);
            this.GameTypeButtonGroup.add(this.domination);
            this.GameTypeButtonGroup.add(this.capital);
            this.GameTypeButtonGroup.add(this.mission);
            this.CardTypeButtonGroup.add(increasing);
            this.CardTypeButtonGroup.add(fixed);
            this.CardTypeButtonGroup.add(italian);
            GameTypeButtons.add(this.domination);
            GameTypeButtons.add(this.capital);
            GameTypeButtons.add(this.mission);
            cardsOptions.add(increasing);
            cardsOptions.add(fixed);
            cardsOptions.add(italian);
            JPanel GameOptionsButtons = new JPanel();
            GameOptionsButtons.setLayout(new FlowLayout(0));
            GameOptionsButtons.setBorder(BorderFactory.createTitledBorder(SwingGUIPanel.this.resbundle.getString("newgame.label.startgameoptions")));
            this.AutoPlaceAll = new JCheckBox(SwingGUIPanel.this.resbundle.getString("newgame.autoplace"));
            GameOptionsButtons.add(this.AutoPlaceAll);
            this.AutoPlaceAll.setOpaque(false);
            this.recycle = new JCheckBox(SwingGUIPanel.this.resbundle.getString("newgame.recycle"));
            GameOptionsButtons.add(this.recycle);
            this.recycle.setOpaque(false);
            JButton startGame = new JButton(SwingGUIPanel.this.resbundle.getString("newgame.startgame"));
            startGame.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    int c;
                    boolean setupOK = true;
                    String error = "";
                    if (SetupPanel.this.players.getRowCount() >= 2 && SetupPanel.this.players.getRowCount() <= 6) {
                        for (c = 0; c < SetupPanel.this.players.getRowCount(); ++c) {
                            for (int b = c + 1; b < SetupPanel.this.players.getRowCount(); ++b) {
                                if (((String)SetupPanel.this.players.getValueAt(c, 0)).equals(SetupPanel.this.players.getValueAt(b, 0))) {
                                    setupOK = false;
                                    error = SwingGUIPanel.this.resbundle.getString("newgame.error.samename");
                                }
                                if (SetupPanel.this.players.getValueAt(c, 1) != SetupPanel.this.players.getValueAt(b, 1)) continue;
                                setupOK = false;
                                error = SwingGUIPanel.this.resbundle.getString("newgame.error.samecolor");
                            }
                        }
                    } else {
                        setupOK = false;
                        error = SwingGUIPanel.this.resbundle.getString("newgame.error.2to6players");
                    }
                    if (setupOK) {
                        if (SwingGUIPanel.this.localGame) {
                            for (c = 0; c < SetupPanel.this.players.getRowCount(); ++c) {
                                String Ptype = "";
                                if (SetupPanel.this.players.getValueAt(c, 2).equals(SwingGUIPanel.this.resbundle.getString("newgame.player.type.human"))) {
                                    Ptype = "human";
                                } else if (SetupPanel.this.players.getValueAt(c, 2).equals(SwingGUIPanel.this.resbundle.getString("newgame.player.type.crapai"))) {
                                    Ptype = "ai crap";
                                } else if (SetupPanel.this.players.getValueAt(c, 2).equals(SwingGUIPanel.this.resbundle.getString("newgame.player.type.easyai"))) {
                                    Ptype = "ai easy";
                                } else if (SetupPanel.this.players.getValueAt(c, 2).equals(SwingGUIPanel.this.resbundle.getString("newgame.player.type.hardai"))) {
                                    Ptype = "ai hard";
                                }
                                SwingGUIPanel.this.go("newplayer " + Ptype + " " + ((NamedColor)SetupPanel.this.players.getValueAt(c, 1)).getRealName() + " " + SetupPanel.this.players.getValueAt(c, 0));
                            }
                        }
                        String type = "";
                        if (SetupPanel.this.domination.isSelected()) {
                            type = "domination";
                        } else if (SetupPanel.this.capital.isSelected()) {
                            type = "capital";
                        } else if (SetupPanel.this.mission.isSelected()) {
                            type = "mission";
                        }
                        type = increasing.isSelected() ? type + " increasing" : (fixed.isSelected() ? type + " fixed" : type + " italianlike");
                        SwingGUIPanel.this.go("startgame " + type + (SetupPanel.this.AutoPlaceAll.isSelected() ? " autoplaceall" : "") + (SetupPanel.this.recycle.isSelected() ? " recycle" : ""));
                    } else {
                        SwingGUIPanel.this.showError(error);
                    }
                }
            });
            this.setLayout(new GridBagLayout());
            playerOptions.setOpaque(false);
            GameTypeButtons.setOpaque(false);
            mapOptions.setOpaque(false);
            cardOptions.setOpaque(false);
            GameOptionsButtons.setOpaque(false);
            cardsOptions.setOpaque(false);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)playerOptions, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 2;
            this.add((Component)GameTypeButtons, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)mapOptions, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)cardsOptions, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)cardOptions, c);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)GameOptionsButtons, c);
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)startGame, c);
        }

        public void resetPlayers() {
            while (this.players.getRowCount() != 0) {
                ((DefaultTableModel)this.dataModel).removeRow(0);
            }
            for (int c = 0; c < this.data.length; ++c) {
                ((DefaultTableModel)this.dataModel).addRow(this.data[c]);
            }
        }

        public void setupGame() {
            this.players.removeEditor();
            if (SwingGUIPanel.this.localGame) {
                this.resetPlayers();
                this.defaultPlayers.setEnabled(true);
            } else {
                while (this.players.getRowCount() != 0) {
                    ((DefaultTableModel)this.dataModel).removeRow(0);
                }
                this.defaultPlayers.setEnabled(false);
            }
        }

        public void addPlayer(int t, String name, int color, String ip) {
            if (!SwingGUIPanel.this.localGame) {
                NamedColor c = this.findColor(color);
                String type = this.findType(t);
                ((DefaultTableModel)this.dataModel).addRow(new Object[]{name, c, type});
            }
        }

        public NamedColor findColor(int color) {
            for (int a = 0; a < this.namedColors.length; ++a) {
                if (this.namedColors[a].getRGB() != color) continue;
                return this.namedColors[a];
            }
            return null;
        }

        public String findType(int t) {
            if (t == 0) {
                return SwingGUIPanel.this.resbundle.getString("newgame.player.type.human");
            }
            if (t == 3) {
                return SwingGUIPanel.this.resbundle.getString("newgame.player.type.crapai");
            }
            if (t == 1) {
                return SwingGUIPanel.this.resbundle.getString("newgame.player.type.easyai");
            }
            if (t == 2) {
                return SwingGUIPanel.this.resbundle.getString("newgame.player.type.hardai");
            }
            return null;
        }

        public void delPlayer(String name) {
            if (!SwingGUIPanel.this.localGame) {
                for (int c = 0; c < this.players.getRowCount(); ++c) {
                    if (!this.players.getValueAt(c, 0).equals(name)) continue;
                    ((DefaultTableModel)this.dataModel).removeRow(c);
                    break;
                }
            }
        }

        class NamedColor
        extends Color {
            private String name;
            private String realname;

            public NamedColor(Color color, String rn, String n) {
                super(color.getRGB());
                this.realname = rn;
                this.name = n;
            }

            public String toString() {
                return this.name;
            }

            public String getRealName() {
                return this.realname;
            }
        }
    }

    class GamePanel
    extends JPanel {
        public GamePanel() {
            SwingGUIPanel.this.resultsLabel = new JLabel("RESULTS");
            Dimension mapSize = new Dimension(677, 425);
            SwingGUIPanel.this.pp.setPreferredSize(mapSize);
            SwingGUIPanel.this.pp.setMinimumSize(mapSize);
            SwingGUIPanel.this.pp.setMaximumSize(mapSize);
            final MapMouseListener mml = new MapMouseListener(SwingGUIPanel.this.myrisk, SwingGUIPanel.this.pp);
            MouseInputAdapter mapListener = new MouseInputAdapter(){

                public void mouseExited(MouseEvent e) {
                    mml.mouseExited();
                }

                public void mouseReleased(MouseEvent e) {
                    int[] click = mml.mouseReleased(e.getX(), e.getY(), SwingGUIPanel.this.gameState);
                    if (click != null) {
                        GamePanel.this.mapClick(click, e);
                    }
                }

                public void mouseMoved(MouseEvent e) {
                    mml.mouseMoved(e.getX(), e.getY(), SwingGUIPanel.this.gameState);
                }
            };
            SwingGUIPanel.this.pp.addMouseListener(mapListener);
            SwingGUIPanel.this.pp.addMouseMotionListener(mapListener);
            Dimension d = new Dimension(677, 50);
            SwingGUIPanel.this.inGameCards = new CardLayout();
            SwingGUIPanel.this.inGameInput = new JPanel();
            SwingGUIPanel.this.inGameInput.setLayout(SwingGUIPanel.this.inGameCards);
            SwingGUIPanel.this.inGameInput.setPreferredSize(d);
            SwingGUIPanel.this.inGameInput.setMinimumSize(d);
            SwingGUIPanel.this.inGameInput.setMaximumSize(d);
            JPanel nothing = new JPanel();
            nothing.setPreferredSize(d);
            nothing.setMinimumSize(d);
            nothing.setMaximumSize(d);
            nothing.add(new JLabel(SwingGUIPanel.this.resbundle.getString("game.pleasewaitnetwork")));
            JPanel results = new JPanel();
            results.setPreferredSize(d);
            results.setMinimumSize(d);
            results.setMaximumSize(d);
            results.add(SwingGUIPanel.this.resultsLabel);
            placeArmiesPanel placeArmies = new placeArmiesPanel();
            placeArmies.setPreferredSize(d);
            placeArmies.setMinimumSize(d);
            placeArmies.setMaximumSize(d);
            SwingGUIPanel.this.roll = new rollPanel();
            SwingGUIPanel.this.roll.setPreferredSize(d);
            SwingGUIPanel.this.roll.setMinimumSize(d);
            SwingGUIPanel.this.roll.setMaximumSize(d);
            movePanel move = new movePanel();
            move.setPreferredSize(d);
            move.setMinimumSize(d);
            move.setMaximumSize(d);
            attackPanel attack = new attackPanel();
            attack.setPreferredSize(d);
            attack.setMinimumSize(d);
            attack.setMaximumSize(d);
            SwingGUIPanel.this.defend = new defendPanel();
            SwingGUIPanel.this.defend.setPreferredSize(d);
            SwingGUIPanel.this.defend.setMinimumSize(d);
            SwingGUIPanel.this.defend.setMaximumSize(d);
            tacMovePanel tacMove = new tacMovePanel();
            tacMove.setPreferredSize(d);
            tacMove.setMinimumSize(d);
            tacMove.setMaximumSize(d);
            capitalPanel capital = new capitalPanel();
            capital.setPreferredSize(d);
            capital.setMinimumSize(d);
            capital.setMaximumSize(d);
            SwingGUIPanel.this.tradeCards = new tradeCardsPanel();
            SwingGUIPanel.this.tradeCards.setPreferredSize(d);
            SwingGUIPanel.this.tradeCards.setMinimumSize(d);
            SwingGUIPanel.this.tradeCards.setMaximumSize(d);
            SwingGUIPanel.this.winner = new winnerPanel();
            SwingGUIPanel.this.winner.setPreferredSize(d);
            SwingGUIPanel.this.winner.setMinimumSize(d);
            SwingGUIPanel.this.winner.setMaximumSize(d);
            endgoPanel endgo = new endgoPanel();
            endgo.setPreferredSize(d);
            endgo.setMinimumSize(d);
            endgo.setMaximumSize(d);
            SwingGUIPanel.this.inGameInput.setOpaque(false);
            nothing.setOpaque(false);
            placeArmies.setOpaque(false);
            SwingGUIPanel.this.roll.setOpaque(false);
            move.setOpaque(false);
            attack.setOpaque(false);
            SwingGUIPanel.this.defend.setOpaque(false);
            tacMove.setOpaque(false);
            capital.setOpaque(false);
            SwingGUIPanel.this.tradeCards.setOpaque(false);
            SwingGUIPanel.this.winner.setOpaque(false);
            endgo.setOpaque(false);
            results.setOpaque(false);
            SwingGUIPanel.this.inGameInput.add((Component)nothing, "nothing");
            SwingGUIPanel.this.inGameInput.add((Component)placeArmies, "placeArmies");
            SwingGUIPanel.this.inGameInput.add((Component)SwingGUIPanel.this.roll, "roll");
            SwingGUIPanel.this.inGameInput.add((Component)move, "move");
            SwingGUIPanel.this.inGameInput.add((Component)attack, "attack");
            SwingGUIPanel.this.inGameInput.add((Component)SwingGUIPanel.this.defend, "defend");
            SwingGUIPanel.this.inGameInput.add((Component)tacMove, "tacMove");
            SwingGUIPanel.this.inGameInput.add((Component)capital, "capital");
            SwingGUIPanel.this.inGameInput.add((Component)SwingGUIPanel.this.tradeCards, "tradeCards");
            SwingGUIPanel.this.inGameInput.add((Component)SwingGUIPanel.this.winner, "winner");
            SwingGUIPanel.this.inGameInput.add((Component)endgo, "endgo");
            SwingGUIPanel.this.inGameInput.add((Component)results, "results");
            JPanel ppBorder = new JPanel(new BorderLayout());
            ppBorder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), BorderFactory.createLineBorder(Color.BLACK, 1)));
            ppBorder.setOpaque(false);
            ppBorder.add(SwingGUIPanel.this.pp);
            this.setLayout(new BorderLayout());
            this.add((Component)SwingGUIPanel.this.gameOptions, "North");
            this.add(ppBorder);
            this.add((Component)SwingGUIPanel.this.inGameInput, "South");
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        }

        public void mapClick(int[] countries, MouseEvent e) {
            if (SwingGUIPanel.this.gameState == 2) {
                if (countries.length == 1) {
                    if (e.getModifiers() == 16) {
                        SwingGUIPanel.this.go("placearmies " + countries[0] + " 1");
                    } else {
                        SwingGUIPanel.this.go("placearmies " + countries[0] + " 10");
                    }
                }
            } else if (SwingGUIPanel.this.gameState == 3) {
                if (countries.length == 0) {
                    SwingGUIPanel.this.attacker.setText(SwingGUIPanel.this.resbundle.getString("game.note.selectattacker"));
                } else if (countries.length == 1) {
                    SwingGUIPanel.this.attacker.setText(SwingGUIPanel.this.resbundle.getString("game.note.attackerisseldefender").replaceAll("\\{0\\}", SwingGUIPanel.this.myrisk.getCountryName(countries[0])));
                } else {
                    SwingGUIPanel.this.go("attack " + countries[0] + " " + countries[1]);
                }
            } else if (SwingGUIPanel.this.gameState == 6) {
                if (countries.length == 0) {
                    SwingGUIPanel.this.country1.setText("");
                } else if (countries.length == 1) {
                    SwingGUIPanel.this.country1.setText(SwingGUIPanel.this.myrisk.getCountryName(countries[0]));
                    SwingGUIPanel.this.country2.setText("");
                } else if (countries.length == 2) {
                    SwingGUIPanel.this.country2.setText(SwingGUIPanel.this.myrisk.getCountryName(countries[1]));
                }
            } else if (SwingGUIPanel.this.gameState == 9) {
                if (countries.length == 0) {
                    SwingGUIPanel.this.capitalLabel.setText(SwingGUIPanel.this.resbundle.getString("core.help.selectcapital"));
                } else if (countries.length == 1) {
                    SwingGUIPanel.this.capitalLabel.setText(SwingGUIPanel.this.resbundle.getString("core.help.selectcapital") + ": " + SwingGUIPanel.this.myrisk.getCountryName(countries[0]));
                }
            }
        }
    }

    class playersPanel
    extends JPanel {
        playersPanel() {
        }

        public void paintComponent(Graphics g) {
            int[] colors = SwingGUIPanel.this.myrisk.getPlayerColors();
            for (int c = 0; c < colors.length; ++c) {
                g.setColor(new Color(colors[c]));
                g.fillRect(120 / colors.length * c, 0, 120 / colors.length, 20);
            }
            g.setColor(new Color(RiskUtil.getTextColorFor(colors[0])));
            g.drawRect(2, 2, 120 / colors.length - 5, 15);
            g.setColor(Color.black);
            g.drawLine(120 / colors.length - 1, 0, 120 / colors.length - 1, 19);
        }
    }

    class SwingRiskAdapter
    extends RiskAdapter {
        SwingRiskAdapter() {
        }

        public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
            SwingGUIPanel.this.consoleTab.addOutput(output);
            if (redrawNeeded) {
                SwingGUIPanel.this.pprepaintCountries();
            }
            if (repaintNeeded) {
                SwingGUIPanel.this.repaint();
            }
        }

        public void sendDebug(String a) {
            if (SwingGUIPanel.this.debugTab != null) {
                SwingGUIPanel.this.debugTab.sendDebug(a);
            }
        }

        public void showMessageDialog(String a) {
            SwingGUIPanel.this.showError(a);
        }

        public void noInput() {
            SwingGUIPanel.this.blockInput();
        }

        public void needInput(int s) {
            SwingGUIPanel.this.gameState = s;
            if (SwingGUIPanel.this.gameState != -1 && SwingGUIPanel.this.gameState != 0 && SwingGUIPanel.this.gameState != 10 && SwingGUIPanel.this.gameState != 4) {
                SwingGUIPanel.this.gameTab.getInput();
            }
            if (SwingGUIPanel.this.gameState == 0) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "nothing");
            } else if (SwingGUIPanel.this.gameState == 1) {
                SwingGUIPanel.this.pp.setC1(255);
                SwingGUIPanel.this.pp.setC2(255);
                ((SwingGUIPanel)SwingGUIPanel.this).tradeCards.endtrade.setVisible(SwingGUIPanel.this.myrisk.getGame().canEndTrade());
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "tradeCards");
            } else if (SwingGUIPanel.this.gameState == 2) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "placeArmies");
            } else if (SwingGUIPanel.this.gameState == 3) {
                SwingGUIPanel.this.pp.setC1(255);
                SwingGUIPanel.this.pp.setC2(255);
                SwingGUIPanel.this.attacker.setText(SwingGUIPanel.this.resbundle.getString("game.note.selectattacker"));
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "attack");
            } else if (SwingGUIPanel.this.gameState == 4) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "roll");
            } else if (SwingGUIPanel.this.gameState == 5) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "move");
            } else if (SwingGUIPanel.this.gameState == 6) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "tacMove");
            } else if (SwingGUIPanel.this.gameState == 7) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "endgo");
            } else if (SwingGUIPanel.this.gameState == 8) {
                ((SwingGUIPanel)SwingGUIPanel.this).winner.continueButton.setVisible(SwingGUIPanel.this.myrisk.getGame().canContinue());
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "winner");
            } else if (SwingGUIPanel.this.gameState == 9) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "capital");
            } else if (SwingGUIPanel.this.gameState == 10) {
                SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "defend");
            }
            SwingGUIPanel.this.consoleTab.getInput();
            SwingGUIPanel.this.repaint();
        }

        public void setGameStatus(String state) {
            SwingGUIPanel.this.gameTab.setGameStatus(state);
        }

        public void showMapPic(RiskGame p) {
            ImageIcon i = null;
            try {
                i = new ImageIcon(PicturePanel.getImage(p));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SwingGUIPanel.this.guiSetup.showMapImage(i);
        }

        public void showCardsFile(String c, boolean m) {
            SwingGUIPanel.this.guiSetup.showCardsFile(c, m);
        }

        public void newGame(boolean t) {
            SwingGUIPanel.this.localGame = t;
            SwingGUIPanel.this.gameTab.newGame();
        }

        public void startGame(boolean s) {
            SwingGUIPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            SwingGUIPanel.this.localGame = s;
            if (SwingGUIPanel.this.myrisk.getGame().getMapFile() == null && SwingGUIPanel.this.myrisk.getGame().getCardsFile() == null) {
                SwingGUIPanel.this.pp.memoryLoad(SwingGUIPanel.this.editorTab.getImageMap(), SwingGUIPanel.this.editorTab.getImagePic());
            } else {
                try {
                    SwingGUIPanel.this.pp.load();
                }
                catch (IOException e) {
                    RiskUtil.printStackTrace(e);
                }
            }
            SwingGUIPanel.this.pprepaintCountries();
            SwingGUIPanel.this.gameTab.startGame();
            SwingGUIPanel.this.statisticsTab.startGame();
            SwingGUIPanel.this.setCursor(null);
        }

        public void closeGame() {
            SwingGUIPanel.this.gameTab.closeGame();
            SwingGUIPanel.this.statisticsTab.closeGame();
            System.gc();
        }

        public void setSlider(int min, int c1num, int c2num) {
            int max = SwingGUIPanel.this.myrisk.hasArmiesInt(c1num) - 1;
            SwingGUIPanel.this.slider.setMaximum(max);
            SwingGUIPanel.this.slider.setMinimum(min);
            SwingGUIPanel.this.slider.setValue(min);
        }

        public void armiesLeft(int l, boolean s) {
            SwingGUIPanel.this.armies.setText(SwingGUIPanel.this.resbundle.getString("core.input.armiesleft").replaceAll("\\{0\\}", "" + l));
            if (s) {
                SwingGUIPanel.this.autoplace.setVisible(false);
            } else {
                SwingGUIPanel.this.autoplace.setVisible(true);
            }
        }

        public void showDice(int n, boolean w) {
            JPanel p = w ? SwingGUIPanel.this.roll : SwingGUIPanel.this.defend;
            p.remove(SwingGUIPanel.this.roll1);
            p.remove(SwingGUIPanel.this.roll2);
            p.remove(SwingGUIPanel.this.roll3);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            if (n > 0) {
                c.gridx = 0;
                c.gridy = 0;
                c.gridwidth = 1;
                c.gridheight = 1;
                p.add((Component)SwingGUIPanel.this.roll1, c);
                if (n > 1) {
                    c.gridx = 1;
                    c.gridy = 0;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    p.add((Component)SwingGUIPanel.this.roll2, c);
                    if (n > 2) {
                        c.gridx = 2;
                        c.gridy = 0;
                        c.gridwidth = 1;
                        c.gridheight = 1;
                        p.add((Component)SwingGUIPanel.this.roll3, c);
                    }
                }
            }
        }

        public void showDiceResults(int[] att, int[] def) {
            int c;
            String output = SwingGUIPanel.this.resbundle.getString("core.dice.results");
            output = output + " " + SwingGUIPanel.this.resbundle.getString("core.dice.attacker");
            for (c = 0; c < att.length; ++c) {
                output = output + " " + (att[c] + 1);
            }
            output = output + " " + SwingGUIPanel.this.resbundle.getString("core.dice.defender");
            for (c = 0; c < def.length; ++c) {
                output = output + " " + (def[c] + 1);
            }
            SwingGUIPanel.this.resultsLabel.setText(output);
            SwingGUIPanel.this.inGameCards.show(SwingGUIPanel.this.inGameInput, "results");
        }

        public void closeBattle() {
            SwingGUIPanel.this.blockInput();
        }

        public void serverState(boolean s) {
            SwingGUIPanel.this.gameTab.serverState(s);
        }

        public void addPlayer(int t, String name, int color, String ip) {
            SwingGUIPanel.this.guiSetup.addPlayer(t, name, color, ip);
        }

        public void delPlayer(String name) {
            SwingGUIPanel.this.guiSetup.delPlayer(name);
        }
    }

    class StatisticsTab
    extends JPanel
    implements SwingGUITab,
    ActionListener {
        private JToolBar toolbarStat;
        private JMenu sStatistics;
        private StatsPanel graph;
        private AbstractButton[] statbuttons;

        public JToolBar getToolBar() {
            return this.toolbarStat;
        }

        public JMenu getMenu() {
            return this.sStatistics;
        }

        public void actionPerformed(ActionEvent a) {
            this.graph.repaintStats(Integer.parseInt(a.getActionCommand()));
            this.graph.repaint();
        }

        public StatisticsTab() {
            int a;
            this.setName(SwingGUIPanel.this.resbundle.getString("swing.tab.statistics"));
            this.toolbarStat = new JToolBar();
            this.toolbarStat.setRollover(true);
            this.toolbarStat.setFloatable(false);
            this.graph = new StatsPanel(SwingGUIPanel.this.myrisk);
            this.graph.setBorder(BorderFactory.createLoweredBevelBorder());
            this.statbuttons = new AbstractButton[24];
            this.statbuttons[0] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.countries"));
            this.statbuttons[1] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.armies"));
            this.statbuttons[2] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.kills"));
            this.statbuttons[3] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.casualties"));
            this.statbuttons[4] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.reinforcements"));
            this.statbuttons[5] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.continents"));
            this.statbuttons[6] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.empire"));
            this.statbuttons[7] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.attacks"));
            this.statbuttons[8] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.retreats"));
            this.statbuttons[9] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.victories"));
            this.statbuttons[10] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.defeats"));
            this.statbuttons[11] = new JButton(SwingGUIPanel.this.resbundle.getString("swing.toolbar.attacked"));
            for (a = 0; a < 12; ++a) {
                this.statbuttons[a].setActionCommand(a + 1 + "");
                this.statbuttons[a].addActionListener(this);
                this.toolbarStat.add(this.statbuttons[a]);
                this.statbuttons[a].setEnabled(false);
            }
            this.sStatistics = new JMenu(SwingGUIPanel.this.resbundle.getString("swing.tab.statistics"));
            this.sStatistics.setMnemonic('S');
            this.statbuttons[12] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.countries"));
            this.statbuttons[13] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.armies"));
            this.statbuttons[14] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.kills"));
            this.statbuttons[15] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.casualties"));
            this.statbuttons[16] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.reinforcements"));
            this.statbuttons[17] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.continents"));
            this.statbuttons[18] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.empire"));
            this.statbuttons[19] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.attacks"));
            this.statbuttons[20] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.retreats"));
            this.statbuttons[21] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.victories"));
            this.statbuttons[22] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.defeats"));
            this.statbuttons[23] = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.toolbar.attacked"));
            for (a = 12; a < this.statbuttons.length; ++a) {
                this.statbuttons[a].setActionCommand(a - 11 + "");
                this.statbuttons[a].addActionListener(this);
                this.sStatistics.add(this.statbuttons[a]);
                this.statbuttons[a].setEnabled(false);
            }
            this.setLayout(new BorderLayout());
            this.add(this.graph);
        }

        public void startGame() {
            for (int a = 0; a < this.statbuttons.length; ++a) {
                this.statbuttons[a].setEnabled(true);
            }
        }

        public void closeGame() {
            for (int a = 0; a < this.statbuttons.length; ++a) {
                this.statbuttons[a].setEnabled(false);
            }
        }
    }

    class DebugTab
    extends JSplitPane
    implements SwingGUITab,
    ActionListener {
        private JTextArea debugText;
        private JTextArea errText;
        private JToolBar toolbarDebug;
        private JMenu mDebug;
        String cause;

        public JToolBar getToolBar() {
            return this.toolbarDebug;
        }

        public JMenu getMenu() {
            return this.mDebug;
        }

        public void sendDebug(String a) {
            this.debugText.append(a + System.getProperty("line.separator"));
            this.debugText.setCaretPosition(this.debugText.getDocument().getLength());
        }

        public DebugTab() {
            super(1);
            this.setName("Debug");
            this.toolbarDebug = new JToolBar();
            this.toolbarDebug.setRollover(true);
            JButton tdSaveDebug = new JButton("Save Debug Log");
            JButton tdPlayDebug = new JButton("Play Debug Log");
            JButton tdClearDebug = new JButton("Clear Debug Log");
            JButton tdSaveError = new JButton("Save Error Log");
            JButton sendError = new JButton("Send Error Log");
            tdSaveDebug.setActionCommand("save debug");
            tdPlayDebug.setActionCommand("play debug");
            tdClearDebug.setActionCommand("clear debug");
            tdSaveError.setActionCommand("save error");
            sendError.setActionCommand("send error");
            tdSaveDebug.addActionListener(this);
            tdPlayDebug.addActionListener(this);
            tdClearDebug.addActionListener(this);
            tdSaveError.addActionListener(this);
            sendError.addActionListener(this);
            JButton cr = new JButton("Clear Error");
            cr.setActionCommand("clear error");
            cr.addActionListener(this);
            JButton gc = new JButton("GC");
            gc.setActionCommand("gc");
            gc.addActionListener(this);
            this.toolbarDebug.add(tdSaveDebug);
            this.toolbarDebug.add(tdPlayDebug);
            this.toolbarDebug.add(tdClearDebug);
            this.toolbarDebug.addSeparator();
            this.toolbarDebug.add(tdSaveError);
            this.toolbarDebug.add(sendError);
            this.toolbarDebug.add(cr);
            this.toolbarDebug.addSeparator();
            this.toolbarDebug.add(gc);
            this.toolbarDebug.setFloatable(false);
            this.mDebug = new JMenu("Debug");
            this.mDebug.setMnemonic('D');
            JMenuItem dSave = new JMenuItem("Save Debug Log");
            dSave.setMnemonic('S');
            dSave.setActionCommand("save debug");
            dSave.addActionListener(this);
            this.mDebug.add(dSave);
            JMenuItem dPlay = new JMenuItem("Play Debug Log");
            dPlay.setMnemonic('P');
            dPlay.setActionCommand("play debug");
            dPlay.addActionListener(this);
            this.mDebug.add(dPlay);
            JMenuItem dClear = new JMenuItem("Clear Debug Log");
            dClear.setMnemonic('C');
            dClear.setActionCommand("clear debug");
            dClear.addActionListener(this);
            this.mDebug.add(dClear);
            this.mDebug.addSeparator();
            JMenuItem dSaveErr = new JMenuItem("Save Error Log");
            dSaveErr.setMnemonic('E');
            dSaveErr.setActionCommand("save error");
            dSaveErr.addActionListener(this);
            this.mDebug.add(dSaveErr);
            JMenuItem send = new JMenuItem("Send Error Log");
            send.setMnemonic('S');
            send.setActionCommand("send error");
            send.addActionListener(this);
            this.mDebug.add(send);
            this.debugText = new JTextArea();
            this.debugText.setEditable(false);
            JScrollPane debugScroll = new JScrollPane(this.debugText);
            debugScroll.setVerticalScrollBarPolicy(22);
            JPanel debugPanel = new JPanel(new BorderLayout());
            debugPanel.add((Component)new JLabel("  Debug Log"), "North");
            debugPanel.add(debugScroll);
            this.errText = new JTextArea();
            this.errText.setEditable(false);
            JScrollPane errScroll = new JScrollPane(this.errText);
            JPanel errPanel = new JPanel(new BorderLayout());
            errPanel.add((Component)new JLabel("  Error Log"), "North");
            errPanel.add(errScroll);
            debugPanel.setOpaque(false);
            errPanel.setOpaque(false);
            this.setLeftComponent(debugPanel);
            this.setRightComponent(errPanel);
            this.setContinuousLayout(true);
            this.setOneTouchExpandable(true);
            this.setDividerLocation(400);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
        }

        public void start() {
            int size = 16;
            BufferedImage img = new BufferedImage(size, size, 2);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(Color.RED);
            g.fillOval(0, 0, size, size);
            g.dispose();
            final ImageIcon icon = new ImageIcon(img);
            if (RiskUIUtil.checkForNoSandbox()) {
                try {
                    Preferences.userRoot();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                BugManager.interceptAndAlert(new Writer(){

                    public void write(char[] cbuf, int off, int len) {
                        DebugTab.this.errText.append(String.valueOf(cbuf, off, len));
                    }

                    public void flush() {
                    }

                    public void close() {
                    }
                }, new BugManager(){

                    public void action(String thecause) {
                        DebugTab.this.cause = thecause;
                        int nom = SwingGUIPanel.this.tabbedpane.indexOfComponent(DebugTab.this);
                        if (SwingGUIPanel.this.tabbedpane.getIconAt(nom) == null) {
                            SwingGUIPanel.this.tabbedpane.setIconAt(nom, icon);
                        }
                    }
                });
                try {
                    CoreUtil.setupLogging();
                }
                catch (Throwable th) {
                    RiskUtil.printStackTrace(th);
                }
            }
        }

        public void actionPerformed(ActionEvent a) {
            if (a.getActionCommand().equals("play debug")) {
                JFileChooser fc = new JFileChooser();
                RiskFileFilter filter = new RiskFileFilter("log");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(RiskUIUtil.findParentFrame(this));
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    SwingGUIPanel.this.go("newgame");
                    SwingGUIPanel.this.go("play " + fileName);
                }
            } else if (a.getActionCommand().equals("save debug")) {
                SwingGUIPanel.this.saveLog(this.debugText);
            } else if (a.getActionCommand().equals("clear debug")) {
                this.debugText.setText("");
            } else if (a.getActionCommand().equals("save error")) {
                SwingGUIPanel.this.saveLog(this.errText);
            } else if (a.getActionCommand().equals("send error")) {
                String email = JOptionPane.showInputDialog(this, (Object)"tell me your e-mail please");
                if (email == null) {
                    email = "none";
                }
                SwingGUIPanel.submitBug(this, this.debugText.getText() + this.errText.getText(), email, "Bug", this.cause);
            } else if (a.getActionCommand().equals("clear error")) {
                this.errText.setText("");
                SwingGUIPanel.this.tabbedpane.setIconAt(SwingGUIPanel.this.tabbedpane.indexOfComponent(this), null);
            } else if (a.getActionCommand().equals("gc")) {
                System.gc();
            } else {
                throw new RuntimeException("command \"" + a.getActionCommand() + "\" is not implemented yet\n");
            }
        }
    }

    class GameTab
    extends JPanel
    implements SwingGUITab,
    ActionListener {
        private JPanel Pix;
        private JPanel guiGame;
        private JLabel gameStatus;
        private JMenu gGame;
        private JToolBar toolbarGUI;
        private boolean serverOn;
        private JButton gNewGame;
        private JButton gLoadGame;
        private JButton gSaveGame;
        private JButton gCloseGame;
        private JButton gJoinGame;
        private JButton gStartServer;
        private JButton gOptions;
        private JMenuItem gmOptions;
        private JMenuItem gmReplay;
        private JMenuItem gmStartServer;
        private JMenuItem gmJoinGame;
        private JMenuItem gmNewGame;
        private JMenuItem gmLoadGame;
        private JMenuItem gmSaveGame;
        private JMenuItem gmCloseGame;

        public JMenu getMenu() {
            return this.gGame;
        }

        public JToolBar getToolBar() {
            return this.toolbarGUI;
        }

        public GameTab() {
            this.setName(SwingGUIPanel.this.resbundle.getString("swing.tab.game"));
            this.serverOn = false;
            this.gameStatus = new JLabel("");
            this.Pix = new JPanel(new BorderLayout());
            this.Pix.setOpaque(false);
            SwingGUIPanel.this.lobby = new JButton(SwingGUIPanel.this.resbundle.getString("lobby.run"));
            SwingGUIPanel.this.lobby.setActionCommand("lobby");
            SwingGUIPanel.this.lobby.addActionListener(this);
            SwingGUIPanel.this.lobby.setBackground(Color.RED);
            SwingGUIPanel.this.lobby.setVisible(false);
            JLabel pixlogo = new JLabel("yura.net " + product + ", " + RiskUtil.GAME_NAME + " IDE", new ImageIcon(this.getClass().getResource("about.jpg")), 0);
            pixlogo.setHorizontalTextPosition(0);
            pixlogo.setVerticalTextPosition(1);
            this.Pix.add((Component)SwingGUIPanel.this.lobby, "North");
            this.Pix.add(pixlogo);
            JButton donate = new JButton();
            donate.addActionListener(this);
            donate.setActionCommand("donate");
            donate.setCursor(Cursor.getPredefinedCursor(12));
            URL donateNow = this.getClass().getResource("donateNow.gif");
            if (donateNow != null) {
                donate.setIcon(new ImageIcon(donateNow));
            } else {
                donate.setText("Donate");
            }
            this.Pix.add((Component)donate, "South");
            this.setLayout(new BorderLayout());
            this.add((Component)this.Pix, "Center");
            this.add((Component)this.gameStatus, "South");
            this.gameStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            Insets margin = new Insets(2, 2, 2, 2);
            SwingGUIPanel.this.showMission = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.mission"));
            SwingGUIPanel.this.showMission.setToolTipText(SwingGUIPanel.this.resbundle.getString("game.button.mission"));
            SwingGUIPanel.this.showMission.addActionListener(this);
            SwingGUIPanel.this.showMission.setActionCommand("showmission");
            SwingGUIPanel.this.showMission.setMargin(margin);
            SwingGUIPanel.this.showCards = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.cards"));
            SwingGUIPanel.this.showCards.setToolTipText(SwingGUIPanel.this.resbundle.getString("game.button.cards"));
            SwingGUIPanel.this.showCards.addActionListener(this);
            SwingGUIPanel.this.showCards.setActionCommand("showcards");
            SwingGUIPanel.this.showCards.setMargin(margin);
            SwingGUIPanel.this.Undo = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.undo"));
            SwingGUIPanel.this.Undo.setToolTipText(SwingGUIPanel.this.resbundle.getString("game.button.undo"));
            SwingGUIPanel.this.Undo.addActionListener(this);
            SwingGUIPanel.this.Undo.setActionCommand("undo");
            SwingGUIPanel.this.Undo.setMargin(margin);
            JButton viewContinents = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.continents"));
            viewContinents.addActionListener(this);
            viewContinents.setActionCommand("continents");
            viewContinents.setMargin(margin);
            SwingGUIPanel.this.moveNumber = new JSlider();
            SwingGUIPanel.this.slider = new JSlider();
            SwingGUIPanel.this.armies = new JLabel();
            this.toolbarGUI = new JToolBar();
            this.toolbarGUI.setRollover(true);
            SwingGUIPanel.this.autoplace = new JButton(SwingGUIPanel.this.resbundle.getString("game.button.go.autoplace"));
            Dimension gameOptionsSize = new Dimension(677, 25);
            SwingGUIPanel.this.gameOptions = SwingGUIPanel.this.makeGameOptionsPanel();
            SwingGUIPanel.this.gameOptions.setPreferredSize(gameOptionsSize);
            SwingGUIPanel.this.gameOptions.setMinimumSize(gameOptionsSize);
            SwingGUIPanel.this.gameOptions.setMaximumSize(gameOptionsSize);
            SwingGUIPanel.this.gameOptions.add(viewContinents);
            SwingGUIPanel.this.guiSetup = new SetupPanel();
            this.guiGame = new GamePanel();
            SwingGUIPanel.this.guiSetup.setOpaque(false);
            this.guiGame.setOpaque(false);
            this.gNewGame = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.new"));
            this.gLoadGame = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.load"));
            this.gSaveGame = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.save"));
            this.gCloseGame = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.close"));
            this.gOptions = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.options"));
            this.gJoinGame = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.joingame"));
            this.gStartServer = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.startserver"));
            JButton gManual = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.manual"));
            JButton gAbout = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.about"));
            JButton gQuit = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.quit"));
            this.gNewGame.setActionCommand("new game");
            this.gNewGame.addActionListener(this);
            this.gLoadGame.setActionCommand("load game");
            this.gLoadGame.addActionListener(this);
            this.gSaveGame.setActionCommand("save game");
            this.gSaveGame.addActionListener(this);
            this.gCloseGame.setActionCommand("close game");
            this.gCloseGame.addActionListener(this);
            this.gOptions.setActionCommand("options");
            this.gOptions.addActionListener(this);
            gManual.setActionCommand("manual");
            gManual.addActionListener(this);
            gAbout.setActionCommand("about");
            gAbout.addActionListener(this);
            gQuit.setActionCommand("quit");
            gQuit.addActionListener(this);
            this.gStartServer.setActionCommand("start server");
            this.gStartServer.addActionListener(this);
            this.gJoinGame.setActionCommand("join game");
            this.gJoinGame.addActionListener(this);
            this.toolbarGUI.add(this.gNewGame);
            this.toolbarGUI.add(this.gLoadGame);
            this.toolbarGUI.add(this.gSaveGame);
            this.toolbarGUI.add(this.gCloseGame);
            this.toolbarGUI.addSeparator();
            this.toolbarGUI.add(this.gJoinGame);
            this.toolbarGUI.add(this.gStartServer);
            this.toolbarGUI.addSeparator();
            this.toolbarGUI.add(this.gOptions);
            this.toolbarGUI.add(gManual);
            this.toolbarGUI.add(gAbout);
            if (RiskUIUtil.checkForNoSandbox()) {
                this.toolbarGUI.add(gQuit);
            }
            this.toolbarGUI.setFloatable(false);
            this.gGame = new JMenu(SwingGUIPanel.this.resbundle.getString("swing.menu.game"));
            this.gGame.setMnemonic('G');
            this.gmNewGame = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.new"));
            this.gmNewGame.setMnemonic('N');
            this.gmNewGame.setActionCommand("new game");
            this.gmNewGame.addActionListener(this);
            this.gGame.add(this.gmNewGame);
            this.gmLoadGame = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.load"));
            this.gmLoadGame.setMnemonic('L');
            this.gmLoadGame.setActionCommand("load game");
            this.gmLoadGame.addActionListener(this);
            this.gGame.add(this.gmLoadGame);
            this.gmSaveGame = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.save"));
            this.gmSaveGame.setMnemonic('S');
            this.gmSaveGame.setActionCommand("save game");
            this.gmSaveGame.addActionListener(this);
            this.gGame.add(this.gmSaveGame);
            this.gmCloseGame = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.close"));
            this.gmCloseGame.setMnemonic('C');
            this.gmCloseGame.setActionCommand("close game");
            this.gmCloseGame.addActionListener(this);
            this.gGame.add(this.gmCloseGame);
            this.gGame.addSeparator();
            this.gmJoinGame = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.joingame"));
            this.gmJoinGame.setMnemonic('J');
            this.gmJoinGame.setActionCommand("join game");
            this.gmJoinGame.addActionListener(this);
            this.gGame.add(this.gmJoinGame);
            this.gmStartServer = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.startserver"));
            this.gmStartServer.setMnemonic('V');
            this.gmStartServer.setActionCommand("start server");
            this.gmStartServer.addActionListener(this);
            this.gGame.add(this.gmStartServer);
            this.gGame.addSeparator();
            this.gmOptions = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.options"));
            this.gmOptions.setMnemonic('O');
            this.gmOptions.setActionCommand("options");
            this.gmOptions.addActionListener(this);
            this.gGame.add(this.gmOptions);
            this.gmReplay = new JMenuItem("Replay");
            this.gmReplay.setMnemonic('R');
            this.gmReplay.setActionCommand("replay");
            this.gmReplay.addActionListener(this);
            this.gGame.add(this.gmReplay);
            if (RiskUIUtil.checkForNoSandbox()) {
                this.gGame.addSeparator();
                JMenuItem gmQuit = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.quit"));
                gmQuit.setMnemonic('Q');
                gmQuit.setActionCommand("quit");
                gmQuit.addActionListener(this);
                this.gGame.add(gmQuit);
            }
            SwingGUIPanel.this.roll1 = new JButton(SwingGUIPanel.this.resbundle.getString("swing.dice.roll1"));
            SwingGUIPanel.this.roll2 = new JButton(SwingGUIPanel.this.resbundle.getString("swing.dice.roll2"));
            SwingGUIPanel.this.roll3 = new JButton(SwingGUIPanel.this.resbundle.getString("swing.dice.roll3"));
            SwingGUIPanel.this.roll1.setActionCommand("roll 1");
            SwingGUIPanel.this.roll2.setActionCommand("roll 2");
            SwingGUIPanel.this.roll3.setActionCommand("roll 3");
            SwingGUIPanel.this.roll1.addActionListener(this);
            SwingGUIPanel.this.roll2.addActionListener(this);
            SwingGUIPanel.this.roll3.addActionListener(this);
            this.gOptions.setEnabled(false);
            this.gmOptions.setEnabled(false);
            this.gmReplay.setEnabled(false);
            this.gSaveGame.setEnabled(false);
            this.gCloseGame.setEnabled(false);
            this.gmSaveGame.setEnabled(false);
            this.gmCloseGame.setEnabled(false);
            this.setOpaque(false);
        }

        public void actionPerformed(ActionEvent a) {
            String actionCommand = a.getActionCommand();
            if ("showmission".equals(actionCommand)) {
                SwingGUIPanel.this.showMission(SwingGUIPanel.this.myrisk.getCurrentMission());
            } else if ("showcards".equals(actionCommand)) {
                SwingGUIPanel.this.openCards();
            } else if ("undo".equals(actionCommand)) {
                SwingGUIPanel.this.pp.setC1(255);
                SwingGUIPanel.this.pp.setC2(255);
                SwingGUIPanel.this.go("undo");
            } else if ("continents".equals(actionCommand)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<html><table>");
                Continent[] continents = SwingGUIPanel.this.myrisk.getGame().getContinents();
                for (int c = 0; c < continents.length; ++c) {
                    Continent continent = continents[c];
                    buffer.append("<tr style=\"background-color: ");
                    buffer.append(RiskUtil.getHexForColor(continent.getColor()));
                    buffer.append("; color:");
                    buffer.append(RiskUtil.getHexForColor(RiskUtil.getTextColorFor(continent.getColor())));
                    buffer.append("\"><td>");
                    buffer.append(continent.getName());
                    buffer.append("</td><td> - </td><td>");
                    buffer.append(continent.getArmyValue());
                    buffer.append("</td></tr>");
                }
                buffer.append("</table></html>");
                JOptionPane.showMessageDialog(this, buffer.toString(), SwingGUIPanel.this.resbundle.getString("swing.button.continents"), -1);
            } else if ("roll 1".equals(actionCommand)) {
                SwingGUIPanel.this.go("roll 1");
            } else if ("roll 2".equals(actionCommand)) {
                SwingGUIPanel.this.go("roll 2");
            } else if ("roll 3".equals(actionCommand)) {
                SwingGUIPanel.this.go("roll 3");
            } else if ("join game".equals(actionCommand)) {
                String result = JOptionPane.showInputDialog(RiskUIUtil.findParentFrame(this), "type the server name", SwingGUIPanel.this.myrisk.getRiskConfig("default.host"));
                if (result != null) {
                    SwingGUIPanel.this.go("join " + result);
                }
            } else if ("new game".equals(actionCommand)) {
                SwingGUIPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                SwingGUIPanel.this.go("newgame");
            } else if ("load game".equals(actionCommand)) {
                String name = RiskUIUtil.getLoadFileName(RiskUIUtil.findParentFrame(this));
                if (name != null) {
                    SwingGUIPanel.this.go("loadgame " + name);
                }
            } else if ("save game".equals(actionCommand)) {
                String name = RiskUIUtil.getSaveFileName(RiskUIUtil.findParentFrame(this));
                if (name != null) {
                    SwingGUIPanel.this.go("savegame " + name);
                }
            } else if ("close game".equals(actionCommand)) {
                SwingGUIPanel.this.go("closegame");
            } else if ("options".equals(actionCommand)) {
                Object[] message = new Object[]{new JCheckBox("Auto End Go"), new JCheckBox("Auto Defend")};
                ((JCheckBox)message[0]).setSelected(SwingGUIPanel.this.myrisk.getAutoEndGo());
                ((JCheckBox)message[1]).setSelected(SwingGUIPanel.this.myrisk.getAutoDefend());
                Object[] options = new String[]{"OK", "cancel"};
                int result = JOptionPane.showOptionDialog(this, message, "Options", 2, -1, null, options, options[0]);
                if (result == 0) {
                    SwingGUIPanel.this.myrisk.parser("autodefend " + (((JCheckBox)message[1]).isSelected() ? "on" : "off"));
                    SwingGUIPanel.this.myrisk.parser("autoendgo " + (((JCheckBox)message[0]).isSelected() ? "on" : "off"));
                }
            } else if ("replay".equals(actionCommand)) {
                SwingGUIPanel.this.go("replay");
            } else if ("start server".equals(actionCommand)) {
                if (this.serverOn) {
                    SwingGUIPanel.this.go("killserver");
                } else {
                    SwingGUIPanel.this.go("startserver");
                }
            } else if ("lobby".equals(actionCommand)) {
                RiskUIUtil.runLobby(SwingGUIPanel.this.myrisk);
            } else if ("donate".equals(actionCommand)) {
                RiskUIUtil.donate(this);
            } else {
                SwingGUIPanel.this.actionPerformed(a);
            }
        }

        public void blockInput() {
            this.gSaveGame.setEnabled(false);
            this.gmSaveGame.setEnabled(false);
            SwingGUIPanel.this.showMission.setEnabled(false);
            SwingGUIPanel.this.showCards.setEnabled(false);
            SwingGUIPanel.this.Undo.setEnabled(false);
            this.gOptions.setEnabled(false);
            this.gmOptions.setEnabled(false);
            this.gmReplay.setEnabled(false);
            SwingGUIPanel.this.mapViewComboBox.grabFocus();
        }

        public void getInput() {
            if (SwingGUIPanel.this.localGame) {
                this.gSaveGame.setEnabled(true);
                this.gmSaveGame.setEnabled(true);
                SwingGUIPanel.this.Undo.setEnabled(true);
                this.gmReplay.setEnabled(true);
            }
            SwingGUIPanel.this.showMission.setEnabled(true);
            SwingGUIPanel.this.showCards.setEnabled(true);
            this.gOptions.setEnabled(true);
            this.gmOptions.setEnabled(true);
        }

        public void newGame() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GameTab.this.gNewGame.setEnabled(false);
                    GameTab.this.gLoadGame.setEnabled(false);
                    GameTab.this.gCloseGame.setEnabled(true);
                    GameTab.this.gmNewGame.setEnabled(false);
                    GameTab.this.gmLoadGame.setEnabled(false);
                    GameTab.this.gmStartServer.setEnabled(false);
                    GameTab.this.gmJoinGame.setEnabled(false);
                    GameTab.this.gStartServer.setEnabled(false);
                    GameTab.this.gJoinGame.setEnabled(false);
                    GameTab.this.gmCloseGame.setEnabled(true);
                    GameTab.this.remove(GameTab.this.Pix);
                    GameTab.this.remove(GameTab.this.guiGame);
                    SwingGUIPanel.this.guiSetup.setupGame();
                    GameTab.this.add((Component)SwingGUIPanel.this.guiSetup, "Center");
                    SwingGUIPanel.this.setCursor(null);
                }
            });
        }

        public void closeGame() {
            this.gNewGame.setEnabled(true);
            this.gLoadGame.setEnabled(true);
            this.gSaveGame.setEnabled(false);
            this.gCloseGame.setEnabled(false);
            this.gmNewGame.setEnabled(true);
            this.gmLoadGame.setEnabled(true);
            this.gmStartServer.setEnabled(true);
            this.gmJoinGame.setEnabled(true);
            this.gStartServer.setEnabled(true);
            this.gJoinGame.setEnabled(true);
            this.gmSaveGame.setEnabled(false);
            this.gmCloseGame.setEnabled(false);
            this.gOptions.setEnabled(false);
            this.gmOptions.setEnabled(false);
            this.gmReplay.setEnabled(false);
            this.remove(this.guiGame);
            this.remove(SwingGUIPanel.this.guiSetup);
            this.add((Component)this.Pix, "Center");
            SwingGUIPanel.this.pp.stopAni();
        }

        public void startGame() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GameTab.this.gNewGame.setEnabled(false);
                    GameTab.this.gLoadGame.setEnabled(false);
                    GameTab.this.gCloseGame.setEnabled(true);
                    GameTab.this.gmNewGame.setEnabled(false);
                    GameTab.this.gmLoadGame.setEnabled(false);
                    GameTab.this.gmStartServer.setEnabled(false);
                    GameTab.this.gmJoinGame.setEnabled(false);
                    GameTab.this.gStartServer.setEnabled(false);
                    GameTab.this.gJoinGame.setEnabled(false);
                    GameTab.this.gmCloseGame.setEnabled(true);
                    GameTab.this.remove(GameTab.this.Pix);
                    GameTab.this.remove(SwingGUIPanel.this.guiSetup);
                    GameTab.this.add((Component)GameTab.this.guiGame, "Center");
                    SwingGUIPanel.this.mapViewComboBox.grabFocus();
                }
            });
        }

        public void serverState(boolean s) {
            this.serverOn = s;
            if (this.serverOn) {
                this.gmStartServer.setText(SwingGUIPanel.this.resbundle.getString("swing.menu.stopserver"));
                this.gStartServer.setText(SwingGUIPanel.this.resbundle.getString("swing.menu.stopserver"));
            } else {
                this.gmStartServer.setText(SwingGUIPanel.this.resbundle.getString("swing.menu.startserver"));
                this.gStartServer.setText(SwingGUIPanel.this.resbundle.getString("swing.menu.startserver"));
            }
        }

        public void setGameStatus(String state) {
            this.gameStatus.setText(" " + state);
        }
    }

    class ConsoleTab
    extends JPanel
    implements SwingGUITab,
    ActionListener {
        private String temptext;
        private Vector history;
        private int pointer;
        JMenu cConsole;
        JToolBar toolbarCon;
        private JTextArea Console;
        private JTextField Command;
        private JButton Submit;
        private JLabel statusBar;
        private JScrollPane Con;

        public ConsoleTab() {
            this.setName(SwingGUIPanel.this.resbundle.getString("swing.tab.console"));
            this.history = new Vector();
            this.pointer = -1;
            this.statusBar = new JLabel(SwingGUIPanel.this.resbundle.getString("swing.status.loading"));
            this.Console = new JTextArea();
            this.Con = new JScrollPane(this.Console);
            Dimension conSize = new Dimension(677, 485);
            this.Con.setVerticalScrollBarPolicy(22);
            this.Con.setPreferredSize(conSize);
            this.Con.setMinimumSize(conSize);
            this.Console.setEditable(false);
            this.Command = new JTextField("");
            Dimension CommandSize = new Dimension(627, 20);
            this.Command.setPreferredSize(CommandSize);
            this.Command.setMinimumSize(CommandSize);
            this.Command.setMaximumSize(CommandSize);
            this.Submit = new JButton(SwingGUIPanel.this.resbundle.getString("swing.button.submit"));
            this.Submit.setActionCommand("read command");
            this.Submit.addActionListener(this);
            this.Command.setActionCommand("read command");
            this.Command.addActionListener(this);
            this.toolbarCon = new JToolBar();
            this.toolbarCon.setRollover(true);
            this.toolbarCon.setFloatable(false);
            JButton cRunScript = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.runscript"));
            JButton cSaveConsole = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.save"));
            JButton cClearConsole = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.clear"));
            JButton cClearHistory = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.histclear"));
            JButton cCommands = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.console.commands"));
            JButton cManual = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.manual"));
            JButton cAbout = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.about"));
            JButton cQuit = new JButton(SwingGUIPanel.this.resbundle.getString("swing.menu.quit"));
            cRunScript.setActionCommand("run script");
            cRunScript.addActionListener(this);
            cSaveConsole.setActionCommand("save console");
            cSaveConsole.addActionListener(this);
            cClearConsole.setActionCommand("clear console");
            cClearConsole.addActionListener(this);
            cClearHistory.setActionCommand("clear history");
            cClearHistory.addActionListener(this);
            cCommands.setActionCommand("commands");
            cCommands.addActionListener(this);
            cManual.setActionCommand("manual");
            cManual.addActionListener(this);
            cAbout.setActionCommand("about");
            cAbout.addActionListener(this);
            cQuit.setActionCommand("quit");
            cQuit.addActionListener(this);
            this.toolbarCon.add(cRunScript);
            this.toolbarCon.add(cSaveConsole);
            this.toolbarCon.add(cClearConsole);
            this.toolbarCon.add(cClearHistory);
            this.toolbarCon.addSeparator();
            this.toolbarCon.add(cCommands);
            this.toolbarCon.add(cManual);
            this.toolbarCon.add(cAbout);
            if (RiskUIUtil.checkForNoSandbox()) {
                this.toolbarCon.add(cQuit);
            }
            this.cConsole = new JMenu(SwingGUIPanel.this.resbundle.getString("swing.menu.console"));
            this.cConsole.setMnemonic('C');
            JMenuItem cmRunScript = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.runscript"));
            cmRunScript.setMnemonic('R');
            cmRunScript.setActionCommand("run script");
            cmRunScript.addActionListener(this);
            this.cConsole.add(cmRunScript);
            JMenuItem cmSaveConsole = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.save"));
            cmSaveConsole.setMnemonic('S');
            cmSaveConsole.setActionCommand("save console");
            cmSaveConsole.addActionListener(this);
            this.cConsole.add(cmSaveConsole);
            JMenuItem cmClearConsole = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.clear"));
            cmClearConsole.setMnemonic('C');
            cmClearConsole.setActionCommand("clear console");
            cmClearConsole.addActionListener(this);
            this.cConsole.add(cmClearConsole);
            JMenuItem cmClearHistory = new JMenuItem(SwingGUIPanel.this.resbundle.getString("swing.menu.console.histclear"));
            cmClearHistory.setMnemonic('H');
            cmClearHistory.setActionCommand("clear history");
            cmClearHistory.addActionListener(this);
            this.cConsole.add(cmClearHistory);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.fill = 1;
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            this.add((Component)this.Con, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)this.Command, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            this.add((Component)this.Submit, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.gridheight = 1;
            this.add((Component)this.statusBar, c);
            this.Command.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent key) {
                    if (key.getKeyCode() == 38) {
                        if (ConsoleTab.this.pointer < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            if (ConsoleTab.this.pointer == ConsoleTab.this.history.size() - 1) {
                                ConsoleTab.this.temptext = ConsoleTab.this.Command.getText();
                            }
                            ConsoleTab.this.Command.setText((String)ConsoleTab.this.history.elementAt(ConsoleTab.this.pointer));
                            ConsoleTab.this.pointer--;
                        }
                    } else if (key.getKeyCode() == 40) {
                        if (ConsoleTab.this.pointer > ConsoleTab.this.history.size() - 2) {
                            Toolkit.getDefaultToolkit().beep();
                        } else if (ConsoleTab.this.pointer == ConsoleTab.this.history.size() - 2) {
                            ConsoleTab.this.Command.setText(ConsoleTab.this.temptext);
                            ConsoleTab.this.pointer++;
                        } else {
                            ConsoleTab.this.pointer = ConsoleTab.this.pointer + 2;
                            ConsoleTab.this.Command.setText((String)ConsoleTab.this.history.elementAt(ConsoleTab.this.pointer));
                            ConsoleTab.this.pointer--;
                        }
                    } else {
                        ConsoleTab.this.pointer = ConsoleTab.this.history.size() - 1;
                    }
                }
            });
            this.setOpaque(false);
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.ready"));
        }

        private void cgo(String input) {
            if (input.equals("exit")) {
                System.exit(0);
            } else if (input.equals("help")) {
                SwingGUIPanel.this.Commands();
            } else if (input.equals("about")) {
                SwingGUIPanel.this.openAbout();
            } else if (input.equals("clear")) {
                this.Console.setText("");
            } else if (input.equals("manual")) {
                try {
                    RiskUtil.openDocs(SwingGUIPanel.this.resbundle.getString("helpfiles.swing"));
                }
                catch (Exception e) {
                    this.addOutput("Unable to open manual: " + e.getMessage());
                }
            } else {
                SwingGUIPanel.this.go(input);
            }
        }

        public void addOutput(String output) {
            this.Console.append(output + System.getProperty("line.separator"));
            this.Console.setCaretPosition(this.Console.getDocument().getLength());
        }

        public void blockInput() {
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.working"));
            this.Submit.setEnabled(false);
            this.Command.setEnabled(false);
        }

        public void getInput() {
            this.Submit.setEnabled(true);
            this.Command.setEnabled(true);
            this.Command.requestFocus();
            this.statusBar.setText(SwingGUIPanel.this.resbundle.getString("swing.status.doneready"));
        }

        public void setVisible(boolean v) {
            super.setVisible(v);
            this.Command.requestFocus();
        }

        public JToolBar getToolBar() {
            return this.toolbarCon;
        }

        public JMenu getMenu() {
            return this.cConsole;
        }

        public void actionPerformed(ActionEvent a) {
            if (a.getActionCommand().equals("read command")) {
                String input = this.Command.getText();
                this.Command.setText("");
                this.history.add(input);
                this.pointer = this.history.size() - 1;
                this.cgo(input);
            } else if (a.getActionCommand().equals("run script")) {
                JFileChooser fc = new JFileChooser();
                RiskFileFilter filter = new RiskFileFilter("risk");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(RiskUIUtil.findParentFrame(this));
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        FileReader filein = new FileReader(file);
                        BufferedReader bufferin = new BufferedReader(filein);
                        String input = bufferin.readLine();
                        while (input != null) {
                            SwingGUIPanel.this.go(input);
                            input = bufferin.readLine();
                        }
                        bufferin.close();
                    }
                    catch (Exception error) {}
                }
            } else if (a.getActionCommand().equals("save console")) {
                SwingGUIPanel.this.saveLog(this.Console);
            } else if (a.getActionCommand().equals("clear console")) {
                this.Console.setText("");
            } else if (a.getActionCommand().equals("clear history")) {
                this.history.clear();
                this.pointer = -1;
            } else {
                SwingGUIPanel.this.actionPerformed(a);
            }
        }
    }
}

