/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.increment1gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.ui.increment1gui.PrintDialog;

public class Increment1Frame
extends JFrame {
    private static final String version = "1.1.1.1";
    private static final String product = "Increment1 GUI for RISK";
    private BorderLayout layout;
    private JTextArea Console;
    private JTextArea Testing;
    private JTextField Command;
    private JButton Submit;
    private JLabel Pix;
    private JLabel statusBar;
    private JScrollPane Con;
    private JScrollPane Log;
    private JLabel logLabel;
    private Risk risk;
    private Vector history;
    private int pointer;
    private String temptext;

    public Increment1Frame(Risk r) {
        this.risk = r;
        this.risk.addRiskListener(new Increment1RiskAdapter());
        this.history = new Vector();
        this.pointer = -1;
        this.Console = new JTextArea();
        this.Testing = new JTextArea();
        this.Command = new JTextField();
        this.Submit = new JButton();
        this.Pix = new JLabel(new ImageIcon(this.getClass().getResource("map.png")));
        this.statusBar = new JLabel("Loading...");
        this.Con = new JScrollPane(this.Console);
        this.Log = new JScrollPane(this.Testing);
        this.logLabel = new JLabel("Test Log");
        this.initGUI();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AboutDialog.class.getResource("icon.gif")));
        this.setResizable(false);
        this.Testing.append("creating GUI...\n");
        this.pack();
        this.Testing.append("Program loaded\n");
        this.statusBar.setText("Ready");
    }

    private void initGUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setTitle(product);
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 1;
        this.Console.setText("");
        this.Console.setEditable(false);
        this.Testing.setEditable(false);
        this.Log.setHorizontalScrollBarPolicy(32);
        this.Log.setVerticalScrollBarPolicy(22);
        this.Log.setPreferredSize(new Dimension(200, 550));
        this.Log.setMinimumSize(new Dimension(200, 550));
        this.Con.setVerticalScrollBarPolicy(22);
        this.Con.setPreferredSize(new Dimension(677, 150));
        this.Con.setMinimumSize(new Dimension(677, 150));
        this.Command.setPreferredSize(new Dimension(600, 20));
        this.Command.setMinimumSize(new Dimension(600, 20));
        this.Command.setMaximumSize(new Dimension(600, 20));
        this.Submit.setText(" Submit ");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        this.getContentPane().add((Component)this.Pix, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Submit, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.logLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Con, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.Command, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 3;
        this.getContentPane().add((Component)this.Log, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.statusBar, c);
        ActionListener readCommand = new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                String input = Increment1Frame.this.Command.getText();
                Increment1Frame.this.Command.setText("");
                Increment1Frame.this.history.add(input);
                Increment1Frame.this.pointer = Increment1Frame.this.history.size() - 1;
                Increment1Frame.this.go(input);
                Increment1Frame.this.Command.requestFocus();
            }
        };
        this.Submit.addActionListener(readCommand);
        this.Command.addActionListener(readCommand);
        class CommandKeyAdapter
        extends KeyAdapter {
            Increment1Frame adaptee;

            CommandKeyAdapter(Increment1Frame adaptee) {
                this.adaptee = adaptee;
            }

            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 38) {
                    Increment1Frame.this.Testing.append("up key (history)\n");
                    if (Increment1Frame.this.pointer < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        if (Increment1Frame.this.pointer == Increment1Frame.this.history.size() - 1) {
                            Increment1Frame.this.temptext = Increment1Frame.this.Command.getText();
                        }
                        Increment1Frame.this.Command.setText((String)Increment1Frame.this.history.elementAt(Increment1Frame.this.pointer));
                        Increment1Frame.this.pointer--;
                    }
                } else if (key.getKeyCode() == 40) {
                    Increment1Frame.this.Testing.append("down key (history)\n");
                    if (Increment1Frame.this.pointer > Increment1Frame.this.history.size() - 2) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (Increment1Frame.this.pointer == Increment1Frame.this.history.size() - 2) {
                        Increment1Frame.this.Command.setText(Increment1Frame.this.temptext);
                        Increment1Frame.this.pointer++;
                    } else {
                        Increment1Frame.this.pointer = Increment1Frame.this.pointer + 2;
                        Increment1Frame.this.Command.setText((String)Increment1Frame.this.history.elementAt(Increment1Frame.this.pointer));
                        Increment1Frame.this.pointer--;
                    }
                } else {
                    Increment1Frame.this.pointer = Increment1Frame.this.history.size() - 1;
                }
            }
        }
        this.Command.addKeyListener(new CommandKeyAdapter(this));
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic('F');
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic('H');
        JMenuItem Commands = new JMenuItem("Commands");
        Commands.setMnemonic('C');
        Commands.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.Commands();
            }
        });
        menuHelp.add(Commands);
        JMenuItem helpMan = new JMenuItem("Manual");
        helpMan.setMnemonic('M');
        helpMan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.go("manual");
            }
        });
        menuHelp.add(helpMan);
        JMenuItem helpAbout = new JMenuItem("About");
        helpAbout.setMnemonic('A');
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.openAbout();
            }
        });
        menuHelp.add(helpAbout);
        JMenu menuClear = new JMenu("Clear");
        menuClear.setMnemonic('C');
        JMenuItem ClearConsole = new JMenuItem("Clear Console");
        ClearConsole.setMnemonic('s');
        ClearConsole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.Testing.append("Console cleared\n");
                Increment1Frame.this.Console.setText("");
            }
        });
        menuClear.add(ClearConsole);
        JMenuItem ClearTestLog = new JMenuItem("Clear TestLog");
        ClearTestLog.setMnemonic('T');
        ClearTestLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.Testing.append("TestLog cleared\n");
                Increment1Frame.this.Testing.setText("");
            }
        });
        menuClear.add(ClearTestLog);
        JMenuItem ClearHistory = new JMenuItem("Clear History");
        ClearHistory.setMnemonic('H');
        ClearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Increment1Frame.this.history.clear();
                Increment1Frame.this.pointer = -1;
                Increment1Frame.this.Testing.append("History cleared\n");
            }
        });
        menuClear.add(ClearHistory);
        final JFileChooser fc = new JFileChooser();
        JMenuItem openFile = new JMenuItem("Run Script");
        openFile.setMnemonic('R');
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(Increment1Frame.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        Increment1Frame.this.Testing.append("Opening file: " + file.getPath() + "\n");
                        Increment1Frame.this.Testing.append("Running Script...\n");
                        FileReader filein = new FileReader(file);
                        BufferedReader bufferin = new BufferedReader(filein);
                        String input = bufferin.readLine();
                        while (input != null) {
                            Increment1Frame.this.go(input);
                            input = bufferin.readLine();
                        }
                        bufferin.close();
                        Increment1Frame.this.Testing.append("Script end\n");
                    }
                    catch (Exception error) {
                        Increment1Frame.this.Testing.append("Error: " + error.getMessage() + "\n");
                    }
                }
            }
        });
        menuFile.add(openFile);
        JMenuItem saveFile = new JMenuItem("Save Console");
        saveFile.setMnemonic('S');
        saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(Increment1Frame.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        Increment1Frame.this.Testing.append("Creating file: " + file.getPath() + "\n");
                        Increment1Frame.this.Testing.append("Writing to file...\n");
                        FileWriter fileout = new FileWriter(file);
                        BufferedWriter buffer = new BufferedWriter(fileout);
                        PrintWriter printer = new PrintWriter(buffer);
                        printer.write(Increment1Frame.this.Console.getText());
                        printer.close();
                        Increment1Frame.this.Testing.append("File Saved\n");
                    }
                    catch (Exception error) {
                        Increment1Frame.this.Testing.append("Error: " + error.getMessage() + "\n");
                    }
                }
            }
        });
        menuFile.add(saveFile);
        JMenuItem print = new JMenuItem("Print");
        print.setMnemonic('P');
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintDialog.print();
            }
        });
        menuFile.add(print);
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('E');
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menuFile.add(fileExit);
        menuBar.add(menuFile);
        menuBar.add(menuClear);
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        this.setBounds(new Rectangle(0, 0, 905, 629));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Increment1Frame.this.exitForm(evt);
            }
        });
    }

    private void exitForm(WindowEvent evt) {
        this.Testing.append("Exit\n");
        System.exit(0);
    }

    public void go(String input) {
        this.Testing.append("Submitted: \"" + input + "\"\n");
        if (input.equals("exit")) {
            System.exit(0);
        } else if (input.equals("help")) {
            this.Commands();
        } else if (input.equals("about")) {
            this.openAbout();
        } else if (input.equals("clear")) {
            this.Console.setText("");
            this.Testing.append("Console cleared\n");
        } else if (input.equals("manual")) {
            try {
                RiskUtil.openDocs("help/index_commands.htm");
                this.Testing.append("Manual Opened\n");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Unable to open manual: " + e.getMessage(), "Error", 0);
            }
        } else {
            this.risk.parser(input);
        }
    }

    public void Commands() {
        String commands = "";
        try {
            FileReader filein = new FileReader("commands.txt");
            BufferedReader bufferin = new BufferedReader(filein);
            String input = bufferin.readLine();
            while (input != null) {
                commands = commands.equals("") ? input : commands + "\n" + input;
                input = bufferin.readLine();
            }
            bufferin.close();
            this.Testing.append("Commands Box opened\n");
            JOptionPane.showMessageDialog(this, commands, "Commands:", -1);
        }
        catch (FileNotFoundException e) {
            this.Testing.append("Unable to find file commands.txt\n");
        }
        catch (IOException e) {
            this.Testing.append("Unable to read file commands.txt\n");
        }
    }

    public void openAbout() {
        RiskUIUtil.openAbout(this, product, version);
        this.Testing.append("About Box opened\n");
    }

    public static void main(String[] argv) {
        RiskUIUtil.parseArgs(argv);
        Increment1Frame gui = new Increment1Frame(new Risk("sersom.map", "risk.cards"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = gui.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        gui.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        gui.setVisible(true);
    }

    class Increment1RiskAdapter
    extends RiskAdapter {
        Increment1RiskAdapter() {
        }

        public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
            Increment1Frame.this.Testing.append("Returned: \"" + output + "\"\n");
            Increment1Frame.this.Console.append(output + System.getProperty("line.separator"));
            Increment1Frame.this.Console.setCaretPosition(Increment1Frame.this.Console.getDocument().getLength());
        }

        public void needInput(int s) {
            Increment1Frame.this.Submit.setEnabled(true);
            Increment1Frame.this.Command.setEnabled(true);
            Increment1Frame.this.Command.requestFocus();
            Increment1Frame.this.statusBar.setText("Done... Ready");
        }

        public void noInput() {
            Increment1Frame.this.statusBar.setText("Working...");
            Increment1Frame.this.Submit.setEnabled(false);
            Increment1Frame.this.Command.setEnabled(false);
            Increment1Frame.this.Testing.append("Input Blocked\n");
        }
    }
}

