/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.gen.XMLMapAccess;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.io.UTF8InputStreamReader;
import org.apache.http.Header;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class MapsTools {
    public static final String MAPS_XML_FILE = "maps.xml";
    public static final String PREVIEW = "preview";

    public static Vector loadMaps() {
        try {
            File mapsDir = RiskUIUtil.getSaveMapDir();
            File xml = new File(mapsDir, MAPS_XML_FILE);
            if (xml.exists()) {
                XMLMapAccess access = new XMLMapAccess();
                ServiceLink.Task task = (ServiceLink.Task)access.load(new InputStreamReader((InputStream)new FileInputStream(xml), "UTF-8"));
                Vector maps = (Vector)task.getObject();
                return maps;
            }
            return new Vector();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void saveMaps(Vector maps) {
        try {
            ServiceLink.Task task = new ServiceLink.Task("categories", (Object)maps);
            File mapsDir = RiskUIUtil.getSaveMapDir();
            File xml = new File(mapsDir, MAPS_XML_FILE);
            XMLMapAccess access = new XMLMapAccess();
            access.save(new FileOutputStream(xml), task);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void saveMapsHTML(Vector maps) {
        String a = "<div class='thumbnail'><a href=\"maps/haiti.zip\"><img src=\"images/maps/haiti.jpg\" border=\"1\" width=\"150\" height=\"94\"><br>29. Haiti Map</a><br> by Louis-Pierre Charbonneau </div>";
    }

    public static Map findMap(Vector maps, String fileName) {
        for (int c = 0; c < maps.size(); ++c) {
            Map map = (Map)maps.elementAt(c);
            if (!fileName.equals(map.getMapUrl())) continue;
            return map;
        }
        return null;
    }

    public static String getSafeMapID(String file) {
        int i;
        if (file.toLowerCase().endsWith(".map")) {
            file = file.substring(0, file.length() - 4);
        }
        while ((i = file.indexOf(32)) >= 0) {
            file = file.substring(0, i) + (i < file.length() - 1 ? Character.toUpperCase(file.charAt(i + 1)) + file.substring(i + 2) : "");
        }
        return file;
    }

    public static String makePreview(String mapUID, BufferedImage prvimg, File previewDir, String format) throws Exception {
        String prv = MapsTools.getSafeMapID(mapUID) + "." + format;
        boolean done = ImageIO.write((RenderedImage)prvimg, format, new File(previewDir, prv));
        if (!done) {
            throw new Exception("not done " + format);
        }
        return "preview/" + prv;
    }

    static String publish(Map map, String[] myCategoriesIds) {
        try {
            String preview;
            File mapsDir = RiskUIUtil.getSaveMapDir();
            File zipFile = new File(mapsDir, MapsTools.getSafeMapID(map.getMapUrl()) + ".zip");
            if (zipFile.exists() && !zipFile.delete()) {
                throw new RuntimeException("can not del " + zipFile);
            }
            Hashtable info = RiskUtil.loadInfo(map.getMapUrl(), false);
            Vector<String> files = new Vector<String>();
            files.add(map.getMapUrl());
            files.add((String)info.get("pic"));
            files.add((String)info.get("map"));
            String cardsFile = (String)info.get("crd");
            if (!"risk.cards".equals(cardsFile) && !"nomission.cards".equals(cardsFile)) {
                files.add(cardsFile);
            }
            if ((preview = (String)info.get("prv")) != null) {
                files.add("preview/" + preview);
            }
            MapsTools.makeZipFile(zipFile, mapsDir, files.toArray(new String[files.size()]));
            MultipartEntity requestContent = new MultipartEntity();
            requestContent.addPart("first_name", (ContentBody)MapsTools.makeStringBody(map.getAuthorName()));
            requestContent.addPart("email", (ContentBody)MapsTools.makeStringBody(map.getAuthorId()));
            requestContent.addPart("name", (ContentBody)MapsTools.makeStringBody(map.getName()));
            requestContent.addPart("description", (ContentBody)MapsTools.makeStringBody(map.getDescription()));
            for (int c = 0; c < myCategoriesIds.length; ++c) {
                requestContent.addPart("categories", (ContentBody)MapsTools.makeStringBody(myCategoriesIds[c]));
            }
            requestContent.addPart("mapZipFile", (ContentBody)new FileBody(zipFile));
            return MapsTools.doPost("http://maps.yura.net/upload-unauthorised", requestContent);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static StringBody makeStringBody(String string) {
        try {
            return new StringBody(string, Charset.forName("UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void makeZipFile(File zipFile, File root, String[] files) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            for (int i = 0; i < files.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(new File(root, files[i]));
                out.putNextEntry(new ZipEntry(files[i]));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String doPost(String url, MultipartEntity requestContent) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        Header contentType = requestContent.getContentType();
        conn.setRequestProperty(contentType.getName(), contentType.getValue());
        conn.setRequestProperty("Content-Length", String.valueOf(requestContent.getContentLength()));
        OutputStream out = conn.getOutputStream();
        requestContent.writeTo(out);
        out.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        rd.close();
        return buffer.toString();
    }

    public static Vector getCategories() {
        try {
            URLConnection conn = new URL(MapChooser.CATEGORIES_PAGE).openConnection();
            XMLMapAccess access = new XMLMapAccess();
            InputStream in = conn.getInputStream();
            ServiceLink.Task result = (ServiceLink.Task)access.load((Reader)new UTF8InputStreamReader(in));
            in.close();
            return (Vector)result.getObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

