/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.tools.mapeditor.MapEditorPanel;

public class MapEditorViews
extends JDialog
implements ActionListener,
ListSelectionListener {
    private MapEditorPanel editPanel;
    private RiskGame map;
    private JList countriesList;
    private JList continentsList;
    private JList cardsList;
    private JList missionsList;
    private JTabbedPane tabs;
    private String[] cardTypes;
    private JButton add;
    private JButton remove;
    private JButton edit;

    public MapEditorViews(Frame parent, MapEditorPanel ep) {
        super(parent, "Map Editor Views", false);
        this.editPanel = ep;
        JToolBar optionspanel = new JToolBar();
        this.add = new JButton("Add");
        this.add.setActionCommand("add");
        this.add.addActionListener(this);
        optionspanel.add(this.add);
        this.remove = new JButton("Remove");
        this.remove.setActionCommand("remove");
        this.remove.addActionListener(this);
        optionspanel.add(this.remove);
        this.edit = new JButton("Edit");
        this.edit.setActionCommand("edit");
        this.edit.addActionListener(this);
        optionspanel.add(this.edit);
        this.add.setEnabled(false);
        this.remove.setEnabled(false);
        this.edit.setEnabled(false);
        this.tabs = new JTabbedPane();
        this.countriesList = new JList(new CountriesListModel());
        this.continentsList = new JList(new ContinentsListModel());
        this.cardsList = new JList(new CardsListModel());
        this.missionsList = new JList(new MissionsListModel());
        MouseAdapter clicky = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MapEditorViews.this.edit.doClick();
                }
            }
        };
        this.countriesList.addMouseListener(clicky);
        this.continentsList.addMouseListener(clicky);
        this.cardsList.addMouseListener(clicky);
        this.missionsList.addMouseListener(clicky);
        this.tabs.addTab("Countries", new JScrollPane(this.countriesList));
        this.tabs.addTab("Continents", new JScrollPane(this.continentsList));
        this.tabs.addTab("Cards", new JScrollPane(this.cardsList));
        this.tabs.addTab("Missions", new JScrollPane(this.missionsList));
        this.getContentPane().add((Component)optionspanel, "South");
        this.getContentPane().add(this.tabs);
        this.cardTypes = new String[4];
        this.cardTypes[0] = "Cavalry";
        this.cardTypes[1] = "Infantry";
        this.cardTypes[2] = "Cannon";
        this.cardTypes[3] = "wildcard";
        this.countriesList.addListSelectionListener(this);
        this.continentsList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Continent con = (Continent)value;
                final Color color = new Color(con.getColor());
                this.setIcon(new Icon(){

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setColor(color);
                        g.fillOval(x, y, this.getIconWidth(), this.getIconHeight());
                    }

                    public int getIconWidth() {
                        return 10;
                    }

                    public int getIconHeight() {
                        return 10;
                    }
                });
                return c;
            }
        });
    }

    public void valueChanged(ListSelectionEvent e) {
        this.editPanel.setCountry((Country)this.countriesList.getSelectedValue());
    }

    public void setMap(RiskGame m) {
        this.map = m;
        ((ViewTab)((Object)this.countriesList.getModel())).changed();
        ((ViewTab)((Object)this.continentsList.getModel())).changed();
        ((ViewTab)((Object)this.cardsList.getModel())).changed();
        ((ViewTab)((Object)this.missionsList.getModel())).changed();
        this.add.setEnabled(true);
        this.remove.setEnabled(true);
        this.edit.setEnabled(true);
    }

    public void actionPerformed(ActionEvent a) {
        ViewTab current = (ViewTab)((Object)((JList)((JScrollPane)this.tabs.getSelectedComponent()).getViewport().getView()).getModel());
        if (a.getActionCommand().equals("add")) {
            current.add();
        } else if (a.getActionCommand().equals("remove")) {
            current.remove();
        } else if (a.getActionCommand().equals("edit")) {
            current.edit();
        } else {
            throw new RuntimeException(a.getActionCommand());
        }
    }

    public int openOptionDialog(Object[] message, String title) {
        Object[] options = new String[]{"OK", "cancel"};
        int result = JOptionPane.showOptionDialog(this, message, title, 2, -1, null, options, options[0]);
        return result;
    }

    public void removeCountries(Object[] a) {
        if (a.length > 0) {
            int c;
            Vector<Country> countries = new Vector<Country>(Arrays.asList(this.map.getCountries()));
            List<Object> removeList = Arrays.asList(a);
            countries.removeAll(removeList);
            Country[] newCountries = countries.toArray(new Country[countries.size()]);
            HashMap<Integer, Integer> updateMap = new HashMap<Integer, Integer>();
            updateMap.put(new Integer(255), new Integer(255));
            for (c = 0; c < a.length; ++c) {
                updateMap.put(new Integer(((Country)a[c]).getColor()), new Integer(255));
            }
            for (c = 0; c < newCountries.length; ++c) {
                updateMap.put(new Integer(newCountries[c].getColor()), new Integer(c + 1));
                newCountries[c].setColor(c + 1);
                newCountries[c].getNeighbours().removeAll(removeList);
            }
            Vector cards = this.map.getCards();
            for (int c2 = 0; c2 < cards.size(); ++c2) {
                Card card = (Card)cards.elementAt(c2);
                if (!removeList.contains(card.getCountry())) continue;
                cards.remove(c2);
                --c2;
            }
            Continent[] continents = this.map.getContinents();
            for (int c3 = 0; c3 < continents.length; ++c3) {
                continents[c3].getTerritoriesContained().removeAll(removeList);
            }
            this.map.setCountries(newCountries);
            this.editPanel.update(updateMap);
            ((ViewTab)((Object)this.countriesList.getModel())).changed();
            ((ViewTab)((Object)this.cardsList.getModel())).changed();
        }
    }

    static class OptionPaneTextArea
    extends JScrollPane {
        private JTextArea textarea;

        public OptionPaneTextArea(String a) {
            this.textarea = new JTextArea(a, 5, 20);
            this.textarea.setWrapStyleWord(true);
            this.textarea.setLineWrap(true);
            this.setViewportView(this.textarea);
        }

        public String getText() {
            return this.textarea.getText();
        }

        public String getLineText() {
            return this.getText().replace('\n', ' ');
        }

        public String[] getLines() {
            String[] strings = this.getText().split("\\n");
            Vector<String> goodStrings = new Vector<String>();
            for (int c = 0; c < strings.length; ++c) {
                if ("".equals(strings[c])) continue;
                goodStrings.add(strings[c]);
            }
            return goodStrings.toArray(new String[goodStrings.size()]);
        }
    }

    class MissionsListModel
    extends AbstractListModel
    implements ViewTab {
        MissionsListModel() {
        }

        public void changed() {
            super.fireContentsChanged(this, 0, MapEditorViews.this.map.getNoMissions() - 1);
            MapEditorViews.this.missionsList.clearSelection();
        }

        public Object getElementAt(int index) {
            if (MapEditorViews.this.map == null) {
                return null;
            }
            return MapEditorViews.this.map.getMissions().elementAt(index);
        }

        public int getSize() {
            if (MapEditorViews.this.map == null) {
                return 0;
            }
            return MapEditorViews.this.map.getNoMissions();
        }

        private JComboBox makeContinentsJComboBox() {
            JComboBox<Continent> a = new JComboBox<Continent>(MapEditorViews.this.map.getContinents());
            a.insertItemAt(RiskGame.ANY_CONTINENT, 0);
            a.insertItemAt(null, 0);
            return a;
        }

        private Object[] newBox(int a, int b, String text, Player p, Continent c1, Continent c2, Continent c3) {
            Object[] message = new Object[14];
            message[0] = new JLabel("Player:");
            message[1] = new JComboBox<Object>(MapEditorViews.this.map.getPlayers().toArray());
            ((JComboBox)message[1]).insertItemAt(null, 0);
            message[2] = new JLabel("Number of countries:");
            message[3] = new JSpinner(new SpinnerNumberModel(a, 0, 100, 1));
            message[4] = new JLabel("Number of armies:");
            message[5] = new JSpinner(new SpinnerNumberModel(b, 0, 100, 1));
            message[6] = new JLabel("Continent 1:");
            message[7] = this.makeContinentsJComboBox();
            message[8] = new JLabel("Continent 2:");
            message[9] = this.makeContinentsJComboBox();
            message[10] = new JLabel("Continent 3:");
            message[11] = this.makeContinentsJComboBox();
            message[12] = new JLabel("Discription:");
            message[13] = new OptionPaneTextArea(text);
            ((JComboBox)message[1]).setSelectedItem(p);
            ((JComboBox)message[7]).setSelectedItem(c1);
            ((JComboBox)message[9]).setSelectedItem(c2);
            ((JComboBox)message[11]).setSelectedItem(c3);
            return message;
        }

        public void edit() {
            Mission mission;
            Object[] message;
            int result;
            int sel = MapEditorViews.this.missionsList.getSelectedIndex();
            if (sel != -1 && (result = MapEditorViews.this.openOptionDialog(message = this.newBox((mission = (Mission)this.getElementAt(sel)).getNoofcountries(), mission.getNoofarmies(), mission.getDiscription(), mission.getPlayer(), mission.getContinent1(), mission.getContinent2(), mission.getContinent3()), "Edit mission")) == 0) {
                mission.setPlayer((Player)((JComboBox)message[1]).getSelectedItem());
                mission.setNoofcountries((Integer)((JSpinner)message[3]).getValue());
                mission.setNoofarmies((Integer)((JSpinner)message[5]).getValue());
                mission.setContinent1((Continent)((JComboBox)message[7]).getSelectedItem());
                mission.setContinent2((Continent)((JComboBox)message[9]).getSelectedItem());
                mission.setContinent3((Continent)((JComboBox)message[11]).getSelectedItem());
                mission.setDiscription(((OptionPaneTextArea)message[13]).getLineText());
                this.fireContentsChanged(this, sel, sel);
            }
        }

        public void remove() {
            Object[] m = MapEditorViews.this.missionsList.getSelectedValues();
            if (m.length != 0) {
                String missionsString = "";
                for (int c = 0; c < m.length; ++c) {
                    missionsString = missionsString + "\n" + m[c];
                }
                int result = JOptionPane.showConfirmDialog(MapEditorViews.this, "Are you sure you want to remove:" + missionsString, "Remove?", 0);
                if (result == 0) {
                    Vector missions = MapEditorViews.this.map.getMissions();
                    missions.removeAll(Arrays.asList(m));
                    this.fireContentsChanged(this, 0, missions.size() - 1);
                    MapEditorViews.this.missionsList.clearSelection();
                }
            }
        }

        public void add() {
            Object[] message = this.newBox(0, 0, "", null, null, null, null);
            int result = MapEditorViews.this.openOptionDialog(message, "New mission");
            if (result == 0) {
                Mission mission = new Mission((Player)((JComboBox)message[1]).getSelectedItem(), (Integer)((JSpinner)message[3]).getValue(), (Integer)((JSpinner)message[5]).getValue(), (Continent)((JComboBox)message[7]).getSelectedItem(), (Continent)((JComboBox)message[9]).getSelectedItem(), (Continent)((JComboBox)message[11]).getSelectedItem(), ((OptionPaneTextArea)message[13]).getLineText());
                Vector missions = MapEditorViews.this.map.getMissions();
                missions.add(mission);
                this.fireContentsChanged(this, missions.size() - 1, missions.size() - 1);
            }
        }
    }

    class CardsListModel
    extends AbstractListModel
    implements ViewTab {
        CardsListModel() {
        }

        public void changed() {
            super.fireContentsChanged(this, 0, MapEditorViews.this.map.getNoCards() - 1);
            MapEditorViews.this.cardsList.clearSelection();
        }

        public Object getElementAt(int index) {
            if (MapEditorViews.this.map == null) {
                return null;
            }
            return MapEditorViews.this.map.getCards().elementAt(index);
        }

        public int getSize() {
            if (MapEditorViews.this.map == null) {
                return 0;
            }
            return MapEditorViews.this.map.getNoCards();
        }

        public void edit() {
            int sel = MapEditorViews.this.cardsList.getSelectedIndex();
            if (sel != -1) {
                Card card = (Card)this.getElementAt(sel);
                Country country = MapEditorViews.this.map.getCountryInt(sel + 1);
                Object[] message = new Object[]{new JLabel("Type:"), country == null || sel > 0 && ((Card)this.getElementAt(sel - 1)).getName().equals("wildcard") ? new JComboBox<String>(new String[]{"wildcard"}) : (!(this.getSize() != sel + 1 && !((Card)this.getElementAt(sel + 1)).getName().equals("wildcard") || sel != 0 && ((Card)this.getElementAt(sel - 1)).getName().equals("wildcard")) ? new JComboBox<String>(MapEditorViews.this.cardTypes) : new JComboBox<String>(new String[]{"Cavalry", "Infantry", "Cannon"}))};
                ((JComboBox)message[1]).setSelectedItem(card.getName());
                int result = MapEditorViews.this.openOptionDialog(message, "Edit card");
                if (result == 0) {
                    String newtype = (String)((JComboBox)message[1]).getSelectedItem();
                    card.setName(newtype);
                    if ("wildcard".equals(newtype)) {
                        card.setCountry(null);
                    } else {
                        card.setCountry(country);
                    }
                    this.fireContentsChanged(this, sel, sel);
                }
            }
        }

        public void remove() {
            Object[] a = MapEditorViews.this.cardsList.getSelectedValues();
            if (a.length != 0) {
                String cardsString = "";
                for (int c = 0; c < a.length; ++c) {
                    cardsString = cardsString + "\n" + ((Card)a[c]).getName();
                }
                int result = JOptionPane.showConfirmDialog(MapEditorViews.this, "Are you sure you want to remove:" + cardsString, "Remove?", 0);
                if (result == 0) {
                    Vector cards = MapEditorViews.this.map.getCards();
                    cards.removeAll(Arrays.asList(a));
                    for (int c = 0; c < cards.size(); ++c) {
                        Card card = (Card)cards.elementAt(c);
                        if (card.getName().equals("wildcard")) continue;
                        card.setCountry(MapEditorViews.this.map.getCountryInt(c + 1));
                    }
                    this.fireContentsChanged(this, 0, this.getSize() - 1);
                    MapEditorViews.this.cardsList.clearSelection();
                }
            }
        }

        public void add() {
            Object[] message = new Object[]{new JLabel("Amount of new cards:"), new JSpinner(new SpinnerNumberModel(20, 0, 500, 1))};
            int result = MapEditorViews.this.openOptionDialog(message, "New Cards");
            if (result == 0) {
                int c;
                int number;
                int n = number = ((Integer)((JSpinner)message[1]).getValue()).intValue();
                Vector cards = MapEditorViews.this.map.getCards();
                Vector wilds = new Vector();
                for (int c2 = 0; c2 < cards.size(); ++c2) {
                    if (!((Card)cards.elementAt(c2)).getName().equals("wildcard")) continue;
                    wilds.add(cards.remove(c2));
                    --c2;
                }
                Country[] countries = MapEditorViews.this.map.getCountries();
                for (c = cards.size(); c < countries.length && number > 0; --number, ++c) {
                    cards.add(new Card(c % 3 == 0 ? "Cavalry" : (c % 3 == 1 ? "Infantry" : "Cannon"), countries[c]));
                }
                for (c = 0; c < number; ++c) {
                    cards.add(new Card("wildcard", null));
                }
                cards.addAll(wilds);
                this.fireContentsChanged(this, cards.size() - n, cards.size() - 1);
            }
        }
    }

    class ContinentsListModel
    extends AbstractListModel
    implements ViewTab {
        private Color editcolor;

        ContinentsListModel() {
        }

        public void changed() {
            super.fireContentsChanged(this, 0, MapEditorViews.this.map.getNoContinents() - 1);
            MapEditorViews.this.continentsList.clearSelection();
        }

        public Object getElementAt(int index) {
            if (MapEditorViews.this.map == null) {
                return null;
            }
            return MapEditorViews.this.map.getContinents()[index];
        }

        public int getSize() {
            if (MapEditorViews.this.map == null) {
                return 0;
            }
            return MapEditorViews.this.map.getNoContinents();
        }

        public void edit() {
            int sel = MapEditorViews.this.continentsList.getSelectedIndex();
            if (sel != -1) {
                String name;
                Continent continent = (Continent)this.getElementAt(sel);
                final Object[] message = new Object[]{new JLabel("Name:"), new JTextField(continent.getIdString().replace('_', ' ')), new JLabel("Army Value:"), new JSpinner(new SpinnerNumberModel(continent.getArmyValue(), 0, 100, 1)), new JLabel("Color:"), new JButton("change")};
                this.editcolor = new Color(continent.getColor());
                ((JButton)message[5]).setBackground(this.editcolor);
                ((JButton)message[5]).setForeground(RiskUIUtil.getTextColorFor(this.editcolor));
                ((JButton)message[5]).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent a) {
                        Color newcolor = JColorChooser.showDialog(MapEditorViews.this, "select color", ContinentsListModel.this.editcolor);
                        if (newcolor != null) {
                            ContinentsListModel.this.editcolor = newcolor;
                            ((JButton)message[5]).setBackground(ContinentsListModel.this.editcolor);
                            ((JButton)message[5]).setForeground(RiskUIUtil.getTextColorFor(ContinentsListModel.this.editcolor));
                        }
                    }
                });
                int result = MapEditorViews.this.openOptionDialog(message, "Edit continent");
                if (result == 0 && !"".equals(name = ((JTextField)message[1]).getText())) {
                    continent.setIdString(name.replace(' ', '_'));
                    continent.setName(name);
                    continent.setArmyValue((Integer)((JSpinner)message[3]).getValue());
                    continent.setColor(this.editcolor.getRGB());
                    this.fireContentsChanged(this, sel, sel);
                    MapEditorViews.this.editPanel.repaint();
                }
            }
        }

        public void remove() {
            Object[] a = MapEditorViews.this.continentsList.getSelectedValues();
            if (a.length != 0) {
                String continentsString = "";
                for (int c = 0; c < a.length; ++c) {
                    continentsString = continentsString + "\n" + a[c];
                }
                int result = JOptionPane.showConfirmDialog(MapEditorViews.this, "Are you sure you want to remove:" + continentsString, "Remove?", 0);
                if (result == 0) {
                    Vector<Continent> continents = new Vector<Continent>(Arrays.asList(MapEditorViews.this.map.getContinents()));
                    List<Object> removeList = Arrays.asList(a);
                    Vector removeCountreis = new Vector();
                    for (int c = 0; c < a.length; ++c) {
                        removeCountreis.addAll(((Continent)a[c]).getTerritoriesContained());
                    }
                    MapEditorViews.this.removeCountries(removeCountreis.toArray());
                    continents.removeAll(removeList);
                    MapEditorViews.this.map.setContinents(continents.toArray(new Continent[continents.size()]));
                    this.fireContentsChanged(this, 0, this.getSize() - 1);
                    MapEditorViews.this.continentsList.clearSelection();
                    Vector missions = MapEditorViews.this.map.getMissions();
                    for (int c = 0; c < missions.size(); ++c) {
                        Mission mission = (Mission)missions.elementAt(c);
                        if (removeList.contains(mission.getContinent1())) {
                            mission.setContinent1(null);
                        }
                        if (removeList.contains(mission.getContinent2())) {
                            mission.setContinent2(null);
                        }
                        if (!removeList.contains(mission.getContinent3())) continue;
                        mission.setContinent3(null);
                    }
                }
            }
        }

        public void add() {
            Object[] message = new Object[]{new JLabel("Names: (each line will be made into a new continent)"), new OptionPaneTextArea(""), new JLabel("Initial army value:"), new JSpinner(new SpinnerNumberModel(5, 0, 100, 1))};
            int result = MapEditorViews.this.openOptionDialog(message, "New continents");
            if (result == 0) {
                int armies = (Integer)((JSpinner)message[3]).getValue();
                String[] names = ((OptionPaneTextArea)message[1]).getLines();
                Continent[] oldContinents = MapEditorViews.this.map.getContinents();
                Vector<Continent> newContinents = new Vector<Continent>(Arrays.asList(oldContinents));
                for (int c = 0; c < names.length; ++c) {
                    Continent continent = new Continent(names[c].replace(' ', '_'), names[c], armies, RiskGame.getRandomColor());
                    newContinents.add(continent);
                }
                MapEditorViews.this.map.setContinents(newContinents.toArray(new Continent[newContinents.size()]));
                this.fireContentsChanged(this, oldContinents.length, oldContinents.length + names.length - 1);
                MapEditorViews.this.editPanel.repaint();
            }
        }
    }

    class CountriesListModel
    extends AbstractListModel
    implements ViewTab {
        CountriesListModel() {
        }

        public void changed() {
            this.fireContentsChanged(this, 0, MapEditorViews.this.map.getNoCountries() - 1);
            MapEditorViews.this.countriesList.clearSelection();
        }

        public Object getElementAt(int index) {
            if (MapEditorViews.this.map == null) {
                return null;
            }
            return MapEditorViews.this.map.getCountries()[index];
        }

        public int getSize() {
            if (MapEditorViews.this.map == null) {
                return 0;
            }
            return MapEditorViews.this.map.getNoCountries();
        }

        public void edit() {
            int sel = MapEditorViews.this.countriesList.getSelectedIndex();
            if (sel != -1) {
                String name;
                Country country = (Country)this.getElementAt(sel);
                Continent oldContinent = country.getContinent();
                Object[] message = new Object[]{new JLabel("Name:"), new JTextField(country.getIdString().replace('_', ' ')), new JLabel("Continent:"), new JComboBox<Continent>(MapEditorViews.this.map.getContinents())};
                ((JComboBox)message[3]).setSelectedItem(oldContinent);
                int result = MapEditorViews.this.openOptionDialog(message, "Edit country");
                if (result == 0 && !"".equals(name = ((JTextField)message[1]).getText())) {
                    Continent newContinent = (Continent)((JComboBox)message[3]).getSelectedItem();
                    country.setIdString(name.replace(' ', '_'));
                    country.setName(name);
                    country.setContinent(newContinent);
                    oldContinent.getTerritoriesContained().remove(country);
                    newContinent.addTerritoriesContained(country);
                    this.fireContentsChanged(this, sel, sel);
                    MapEditorViews.this.editPanel.repaint();
                }
            }
        }

        public void remove() {
            Object[] a = MapEditorViews.this.countriesList.getSelectedValues();
            if (a.length != 0) {
                String countriesString = "";
                for (int c = 0; c < a.length; ++c) {
                    countriesString = countriesString + "\n" + a[c];
                }
                int result = JOptionPane.showConfirmDialog(MapEditorViews.this, "Are you sure you want to remove:" + countriesString, "Remove?", 0);
                if (result == 0) {
                    MapEditorViews.this.removeCountries(a);
                }
            }
        }

        public void add() {
            if (MapEditorViews.this.map.getContinents().length == 0) {
                JOptionPane.showMessageDialog(MapEditorViews.this, "Need to add a continent first");
                return;
            }
            Object[] message = new Object[]{new JLabel("Names: (each line will be made into a new country)"), new OptionPaneTextArea(""), new JLabel("Select continent:"), new JComboBox<Continent>(MapEditorViews.this.map.getContinents())};
            int result = MapEditorViews.this.openOptionDialog(message, "New countries");
            if (result == 0) {
                String[] names = ((OptionPaneTextArea)message[1]).getLines();
                Country[] oldCountries = MapEditorViews.this.map.getCountries();
                if (oldCountries.length + names.length > 254) {
                    JOptionPane.showMessageDialog(MapEditorViews.this, "Too many countries. 254 is the max number.");
                    return;
                }
                Vector<Country> newCountries = new Vector<Country>(Arrays.asList(oldCountries));
                Continent continent = (Continent)((JComboBox)message[3]).getSelectedItem();
                for (int c = 0; c < names.length; ++c) {
                    Country country = new Country(oldCountries.length + c + 1, names[c].replace(' ', '_'), names[c], continent, 20 * (c + 1), 20);
                    newCountries.add(country);
                    continent.addTerritoriesContained(country);
                }
                MapEditorViews.this.map.setCountries(newCountries.toArray(new Country[newCountries.size()]));
                this.fireContentsChanged(this, oldCountries.length, oldCountries.length + names.length - 1);
                MapEditorViews.this.editPanel.repaint();
            }
        }
    }

    static interface ViewTab {
        public void edit();

        public void remove();

        public void add();

        public void changed();
    }
}

