/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.mapstore.gen.XMLMapAccess;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.io.HTTPClient;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.SystemUtil;

public class MapServerClient
extends HTTPClient {
    public static final Object XML_REQUEST_ID = "XML_REQUEST";
    public static final Object MAP_REQUEST_ID = "MAP_REQUEST";
    MapServerListener chooser;
    Vector downloads = new Vector();

    public MapServerClient(MapServerListener aThis) {
        this.chooser = aThis;
    }

    public void kill() {
        this.chooser = null;
        if (this.downloads.isEmpty()) {
            super.kill();
        }
    }

    protected void onError(HTTPClient.Request request, int responseCode, Hashtable headers, Exception ex) {
        MapServerListener ch = this.chooser;
        if (request.id == MAP_REQUEST_ID && this.getMapDownload(request.url).ignoreErrorInDownload(request.url)) {
            return;
        }
        Logger.warn((String)("error: " + responseCode + " " + ex + " " + request + "\n" + headers));
        if (ex != null) {
            Logger.warn((Throwable)ex);
        } else {
            Logger.dumpStack();
        }
        if (ch != null) {
            String error = "error:" + (responseCode != 0 ? " " + responseCode : "") + (ex != null ? " " + ex : "");
            if (request.id == XML_REQUEST_ID) {
                ch.onXMLError(error);
            } else if (request.id == MAP_REQUEST_ID) {
                ch.onDownloadError(error);
            }
        }
    }

    protected void onResult(HTTPClient.Request request, int responseCode, Hashtable headers, InputStream is, long length) throws Exception {
        MapServerListener ch = this.chooser;
        if (request.id == XML_REQUEST_ID) {
            XMLMapAccess access = new XMLMapAccess();
            ServiceLink.Task task = (ServiceLink.Task)access.load((Reader)new UTF8InputStreamReader(is));
            if (Midlet.getPlatform() == 10) {
                is.read();
            }
            if (ch != null) {
                ch.gotResultXML(request.url, task);
            }
        } else if (request.id == MAP_REQUEST_ID) {
            this.getMapDownload(request.url).gotRes(request.url, is);
        } else if (ch != null) {
            ch.gotImgFromServer(request.id, request.url, SystemUtil.getData((InputStream)is, (int)((int)length)));
        }
    }

    void makeRequestXML(String string, String a, String b) {
        Hashtable<String, String> params = null;
        if (a != null && b != null) {
            params = new Hashtable<String, String>();
            params.put(a, b);
        }
        this.makeRequest(string, params, XML_REQUEST_ID);
    }

    void makeRequest(String url, Hashtable params, Object type) {
        HTTPClient.Request request = new HTTPClient.Request();
        request.url = url;
        request.params = params;
        request.id = type;
        Logger.info((String)("Make Request: " + request));
        this.makeRequest(request);
    }

    public void downloadMap(String fullMapUrl) {
        MapDownload download = new MapDownload(fullMapUrl);
        this.downloads.addElement(download);
    }

    public boolean isDownloading(String mapUID) {
        for (int c = 0; c < this.downloads.size(); ++c) {
            MapDownload download = (MapDownload)this.downloads.elementAt(c);
            if (!download.mapUID.equals(mapUID)) continue;
            return true;
        }
        return false;
    }

    MapDownload getMapDownload(String url) {
        for (int c = 0; c < this.downloads.size(); ++c) {
            MapDownload download = (MapDownload)this.downloads.elementAt(c);
            if (!download.hasUrl(url)) continue;
            return download;
        }
        throw new IllegalArgumentException("no download for url " + url);
    }

    private static void saveFile(InputStream is, OutputStream out) throws IOException {
        int COPY_BLOCK_SIZE = 1024;
        byte[] data = new byte[COPY_BLOCK_SIZE];
        int i = 0;
        while ((i = is.read(data, 0, COPY_BLOCK_SIZE)) != -1) {
            out.write(data, 0, i);
        }
    }

    public static String getURL(String context, String path) {
        try {
            return new URI(context).resolve(new URI(null, null, path, null)).toASCIIString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getPath(String context, String url) {
        try {
            return new URI(context).relativize(new URI(url)).getPath();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    class MapDownload {
        String mapUID;
        String mapContext;
        Vector urls = new Vector();
        Vector fileNames = new Vector();
        boolean error = false;

        MapDownload(String url) {
            this.mapUID = MapChooser.getFileUID(url);
            this.mapContext = url.substring(0, url.length() - this.mapUID.length());
            this.downloadFile(this.mapUID);
        }

        public String toString() {
            return this.mapUID;
        }

        final void downloadFile(String fileName) {
            this.fileNames.add(fileName);
            String url = MapServerClient.getURL(this.mapContext, fileName);
            this.urls.addElement(url);
            MapServerClient.this.makeRequest(url, null, MAP_REQUEST_ID);
        }

        boolean hasUrl(String url) {
            return this.urls.contains(url);
        }

        private void gotResponse(String url) {
            this.urls.removeElement(url);
            if (this.urls.isEmpty()) {
                MapServerClient.this.downloads.removeElement(this);
                try {
                    if (!this.error) {
                        for (int c = this.fileNames.size() - 1; c >= 0; --c) {
                            String fileName = (String)this.fileNames.get(c);
                            RiskUtil.streamOpener.renameMapFile(fileName + ".part", fileName);
                        }
                        MapUpdateService.getInstance().downloadFinished(this.mapUID);
                        MapServerListener ch = MapServerClient.this.chooser;
                        if (ch != null) {
                            ch.downloadFinished(this.mapUID);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (MapServerClient.this.chooser == null) {
                    MapServerClient.this.kill();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gotRes(String url, InputStream is) {
            String fileName = MapServerClient.getPath(this.mapContext, url);
            String saveToDiskName = fileName + ".part";
            OutputStream out = null;
            try {
                out = RiskUtil.streamOpener.saveMapFile(saveToDiskName);
                MapServerClient.saveFile(is, out);
                if (fileName.endsWith(".map")) {
                    Hashtable info = RiskUtil.loadInfo(saveToDiskName, false);
                    String pic = (String)info.get("pic");
                    String crd = (String)info.get("crd");
                    String map = (String)info.get("map");
                    String prv = (String)info.get("prv");
                    if (pic == null || crd == null || map == null || "".equals(pic) || "".equals(crd) || "".equals(map)) {
                        throw new RuntimeException("info not found for map: " + this.mapUID + " in file: " + saveToDiskName + " info=" + info);
                    }
                    this.downloadFile(pic);
                    this.downloadFile(crd);
                    this.downloadFile(map);
                    if (prv != null) {
                        this.downloadFile("preview/" + prv);
                    }
                }
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
                this.error = true;
            }
            finally {
                FileUtil.close((Object)is);
                FileUtil.close((Object)out);
                this.gotResponse(url);
            }
        }

        private boolean ignoreErrorInDownload(String url) {
            String fileName = MapServerClient.getPath(this.mapContext, url);
            boolean fileExists = MapChooser.fileExists(fileName);
            if (fileExists) {
                this.fileNames.remove(fileName);
            } else {
                this.error = true;
            }
            this.gotResponse(url);
            return fileExists;
        }
    }
}

