/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.yura.cache.Cache;
import net.yura.domination.ImageManager;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.BadgeButton;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapRenderer;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.RadioButton;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.ImageUtil;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.Url;
import net.yura.swingme.core.CoreUtil;

public class MapChooser
implements ActionListener,
MapServerListener {
    public Properties resBundle = CoreUtil.wrap(TranslationBundle.getBundle());
    XULLoader loader;
    ActionListener al;
    static Cache repo;
    MapServerClient client;
    private Vector mapfiles;
    List list;
    public static final String SERVER_URL = "http://maps.yura.net/";
    public static final String MAP_PAGE;
    public static final String CATEGORIES_PAGE;
    private String selectedMap;

    public static void loadThemeExtension() {
        try {
            LookAndFeel laf = DesktopPane.getDesktopPane().getLookAndFeel();
            if (laf instanceof SynthLookAndFeel) {
                ((SynthLookAndFeel)laf).load(Midlet.getResourceAsStream((String)"/ms_tabbar.xml"));
            } else {
                System.err.println("LookAndFeel not SynthLookAndFeel " + laf);
            }
        }
        catch (Exception ex) {
            RiskUtil.printStackTrace(ex);
        }
    }

    public MapChooser(ActionListener al, Vector mapfiles) {
        this.al = al;
        this.mapfiles = mapfiles;
        try {
            this.loader = XULLoader.load((InputStream)Midlet.getResourceAsStream((String)"/ms_maps.xml"), (ActionListener)this, (Properties)this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Panel TabBar = (Panel)this.loader.find("TabBar");
        if (TabBar != null) {
            Icon off;
            Icon on;
            Vector buttons = TabBar.getComponents();
            try {
                on = new Icon("/ms_bar_on.png");
                off = new Icon("/ms_bar_off.png");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            int w = off.getIconWidth() / buttons.size();
            for (int c = 0; c < buttons.size(); ++c) {
                RadioButton b = (RadioButton)buttons.elementAt(c);
                Icon oni = on.getSubimage(c * w, 0, w, off.getIconHeight());
                Icon offi = off.getSubimage(c * w, 0, w, off.getIconHeight());
                b.setIcon(offi);
                b.setSelectedIcon(oni);
                b.setRolloverIcon(offi);
                b.setRolloverSelectedIcon(oni);
                b.setToolTipText(b.getText());
                b.setText("");
                b.setMargin(0);
            }
        }
        this.list = (List)this.loader.find("ResultList");
        if (Midlet.getPlatform() == 8) {
            this.list.setDoubleClick(true);
        }
        this.list.setCellRenderer((ListCellRenderer)new MapRenderer(this));
        this.list.setFixedCellHeight(XULLoader.adjustSizeToDensity((int)75));
        this.list.setFixedCellWidth(10);
        this.client = new MapServerClient(this);
        this.client.start();
        this.activateGroup("MapView");
        MapUpdateService.getInstance().addObserver((BadgeButton)this.loader.find("updateButton"));
    }

    public void destroy() {
        MapUpdateService.getInstance().deleteObserver((BadgeButton)this.loader.find("updateButton"));
        this.client.kill();
        this.client = null;
    }

    public Icon getIcon(Object key, String context, String iconUrl, int w, int h) {
        ImageManager.LazyIcon aicon = ImageManager.get(key);
        if (aicon == null) {
            aicon = ImageManager.newIcon(key, w, h);
            this.loadImg(key, MapChooser.getURL(context, iconUrl));
        }
        return aicon;
    }

    public void loadImg(Object obj, String url) {
        if (url.indexOf(58) > 0) {
            InputStream in;
            InputStream inputStream = in = repo != null ? repo.get(url) : null;
            if (in != null) {
                this.publishImg(obj, in);
            } else {
                MapServerClient c = this.client;
                if (c != null) {
                    c.makeRequest(url, null, obj);
                }
            }
        } else {
            InputStream in = MapChooser.getLocalePreviewImg(url);
            if (in != null) {
                this.publishImg(obj, in);
            }
        }
    }

    public void gotImgFromServer(Object obj, String url, byte[] data) {
        try {
            this.publishImg(obj, new ByteArrayInputStream(data));
        }
        catch (RuntimeException ex) {
            System.out.println("error in publishImg with img: " + url);
            throw ex;
        }
        MapChooser.cache(url, data);
    }

    private void publishImg(Object obj, InputStream in) {
        try {
            if (this.client != null) {
                Image img = MapChooser.createImage(in);
                ImageManager.gotImg(obj, img);
                this.list.repaint();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to decode img " + obj, ex);
        }
    }

    public static InputStream getLocalePreviewImg(String url) {
        if (url.startsWith("preview/")) {
            try {
                return RiskUtil.openMapStream(url);
            }
            catch (Exception ex) {
                Logger.warn((Throwable)ex);
            }
        } else {
            InputStream in;
            InputStream inputStream = in = repo != null ? repo.get(url) : null;
            if (in != null) {
                return in;
            }
            try {
                System.out.println("[MapChooser] ### Going to re-encode img: " + url);
                InputStream min = RiskUtil.openMapStream(url);
                Image img = MapChooser.createImage(min);
                img = ImageUtil.scaleImage((Image)img, (int)150, (int)94);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageUtil.saveImage((Image)img, (OutputStream)out);
                img = null;
                byte[] bytes = out.toByteArray();
                out = null;
                MapChooser.cache(url, bytes);
                return new ByteArrayInputStream(bytes);
            }
            catch (Exception ex) {
                Logger.warn((Throwable)ex);
            }
        }
        return null;
    }

    private static void cache(String url, byte[] data) {
        if (repo != null && !repo.containsKey(url)) {
            repo.put(url, data);
        }
    }

    public static Map createMap(String file) {
        Hashtable info = RiskUtil.loadInfo(file, false);
        Map map = new Map();
        map.setMapUrl(file);
        String name = (String)info.get("name");
        if (name == null) {
            name = file.toLowerCase().endsWith(".map") ? file.substring(0, file.length() - 4) : file;
        }
        map.setName(name);
        map.setDescription((String)info.get("comment"));
        String prv = (String)info.get("prv");
        if (prv != null && !MapChooser.fileExists(prv = "preview/" + prv)) {
            prv = null;
        }
        if (prv == null) {
            prv = (String)info.get("pic");
        }
        map.setPreviewUrl(prv);
        map.setVersion((String)info.get("ver"));
        return map;
    }

    public static String getFileUID(String mapUrl) {
        int i = mapUrl.lastIndexOf(47);
        return i >= 0 ? mapUrl.substring(i + 1) : mapUrl;
    }

    void makeRequestForMap(String a, String b) {
        this.client.makeRequestXML(MAP_PAGE, a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(String actionCommand) {
        if ("local".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            Vector<Map> riskmaps = new Vector<Map>(this.mapfiles.size());
            for (int c = 0; c < this.mapfiles.size(); ++c) {
                String file = (String)this.mapfiles.elementAt(c);
                Map map = MapChooser.createMap(file);
                riskmaps.add(map);
            }
            Collections.sort(riskmaps, new Comparator(){

                public int compare(Object t1, Object t2) {
                    Map m1 = (Map)t1;
                    Map m2 = (Map)t2;
                    return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
                }
            });
            this.setListData(null, riskmaps);
        } else if ("catagories".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.client.makeRequestXML(CATEGORIES_PAGE, null, null);
        } else if ("top25".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.activateGroup("Top25View");
        } else if ("search".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.actionPerformed("doMapSearch");
        } else if ("update".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            Vector mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            Component updateAll = this.loader.find("updateAll");
            if (mapsToUpdate.isEmpty()) {
                updateAll.setVisible(false);
                this.show("AllUpToDate");
            } else {
                updateAll.setVisible(true);
                this.setListData(MAP_PAGE, mapsToUpdate);
            }
        } else if ("updateall".equals(actionCommand)) {
            Vector mapsToUpdate;
            Vector updateAll = mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            synchronized (updateAll) {
                for (int c = 0; c < mapsToUpdate.size(); ++c) {
                    this.click((Map)mapsToUpdate.elementAt(c));
                }
            }
        } else if ("TOP_NEW".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_NEW");
        } else if ("TOP_RATINGS".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_RATINGS");
        } else if ("TOP_DOWNLOADS".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_DOWNLOADS");
        } else if ("listSelect".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Category) {
                Category cat = (Category)value;
                this.clearList();
                this.makeRequestForMap("category", cat.getId());
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.click(map);
            }
        } else if ("sameAuthor".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                this.makeRequestForMap("author", map.getAuthorId());
            }
        } else if ("defaultMap".equals(actionCommand)) {
            this.chosenMap(RiskGame.getDefaultMap());
        } else if ("cancel".equals(actionCommand)) {
            this.al.actionPerformed(null);
        } else if ("doMapSearch".equals(actionCommand)) {
            TextComponent.closeNativeEditor();
            String text = ((TextComponent)this.loader.find("mapSearchBox")).getText();
            this.clearList();
            if (text != null && !"".equals(text)) {
                this.makeRequestForMap("search", text);
            } else {
                this.setListData(null, null);
            }
        } else {
            System.out.println("Unknown command " + actionCommand);
        }
    }

    public void click(Map map) {
        String fileUID = MapChooser.getFileUID(map.getMapUrl());
        String context = ((MapRenderer)this.list.getCellRenderer()).getContext();
        if (context != null) {
            if (this.client.isDownloading(fileUID)) {
                OptionPane.showMessageDialog(null, (Object)"already downloading", (String)"message", (int)0);
            } else if (this.mapfiles.contains(fileUID)) {
                Hashtable info = RiskUtil.loadInfo(fileUID, false);
                String ver = (String)info.get("ver");
                if (!(map.getVersion() == null || "".equals(map.getVersion()) || "1".equals(map.getVersion()) || map.getVersion().equals(ver))) {
                    this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                String pic = (String)info.get("pic");
                String crd = (String)info.get("crd");
                String imap = (String)info.get("map");
                String prv = (String)info.get("prv");
                if (!MapChooser.fileExists(pic) || !MapChooser.fileExists(crd) || !MapChooser.fileExists(imap) || prv != null && !MapChooser.fileExists("preview/" + prv)) {
                    this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                this.chosenMap(fileUID);
            } else {
                this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                this.list.repaint();
            }
        } else {
            this.chosenMap(fileUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileExists(String fileUID) {
        InputStream file = null;
        try {
            file = RiskUtil.openMapStream(fileUID);
        }
        catch (Exception exception) {
        }
        finally {
            FileUtil.close((Object)file);
        }
        return file != null;
    }

    private void chosenMap(String mapName) {
        this.selectedMap = mapName;
        this.al.actionPerformed(null);
    }

    public static String getURL(String context, String mapUrl) {
        if (mapUrl.indexOf(58) < 0 && context != null) {
            mapUrl = mapUrl.startsWith("/") ? context.substring(0, context.indexOf(47, "http://.".length())) + mapUrl : context + mapUrl;
        }
        return mapUrl;
    }

    public void mainCatList(String actionCommand) {
        Enumeration group = ((ButtonGroup)this.loader.getGroups().get("MapView")).getElements();
        while (group.hasMoreElements()) {
            Button button = (Button)group.nextElement();
            String action = button.getActionCommand();
            Component panel = this.loader.find(action + "Bar");
            panel.setVisible(action.equals(actionCommand));
        }
        this.clearList();
    }

    void clearList() {
        this.show("Loading");
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public String getSelectedMap() {
        return this.selectedMap;
    }

    public void gotResultXML(String url, ServiceLink.Task task) {
        String method = task.getMethod();
        Object param = task.getObject();
        if ("categories".equals(method)) {
            if (param instanceof Vector) {
                this.setListData(url, (Vector)param);
            }
        } else if ("maps".equals(method) && param instanceof Hashtable) {
            Hashtable map = (Hashtable)param;
            map.get("search");
            map.get("author");
            map.get("category");
            map.get("offset");
            map.get("total");
            this.setListData(url, (Vector)map.get("maps"));
        }
    }

    public void onXMLError(String error) {
        this.show("Error");
    }

    public void onDownloadError(String error) {
        OptionPane.showMessageDialog(null, (Object)error, (String)"Error!", (int)0);
    }

    public void downloadFinished(String download) {
        if (!this.mapfiles.contains(download)) {
            this.mapfiles.addElement(download);
        }
        if (((Button)this.loader.find("updateButton")).isSelected() && MapUpdateService.getInstance().mapsToUpdate.isEmpty()) {
            this.loader.find("updateAll").setVisible(false);
            this.show("AllUpToDate");
        }
    }

    public static String getContext(String url) {
        int i;
        if (url != null && (i = url.lastIndexOf(47)) > "http://.".length()) {
            url = url.substring(0, i + 1);
        }
        return url;
    }

    private void setListData(String url, Vector items) {
        String context = MapChooser.getContext(url);
        ((MapRenderer)this.list.getCellRenderer()).setContext(context);
        this.list.setListData(items == null ? new Vector(0) : items);
        if (this.list.getSize() > 0) {
            this.list.setSelectedIndex(-1);
            this.list.ensureIndexIsVisible(0);
        }
        boolean showNoMatch = items != null && items.isEmpty();
        this.show(showNoMatch ? "NoMatches" : "ResultList");
    }

    private void show(String name) {
        Component loading = this.loader.find("Loading");
        Component noMatches = this.loader.find("NoMatches");
        Component allUpToDate = this.loader.find("AllUpToDate");
        Component error = this.loader.find("Error");
        this.list.setVisible("ResultList".equals(name));
        noMatches.setVisible("NoMatches".equals(name));
        allUpToDate.setVisible("AllUpToDate".equals(name));
        loading.setVisible("Loading".equals(name));
        error.setVisible("Error".equals(name));
        this.getRoot().revalidate();
        this.getRoot().repaint();
    }

    private void activateGroup(String string) {
        String mincat = ((ButtonGroup)this.loader.getGroups().get(string)).getSelection().getActionCommand();
        this.actionPerformed(mincat);
    }

    public boolean willDownload(Map map) {
        String mapUID = MapChooser.getFileUID(map.getMapUrl());
        if (!this.mapfiles.contains(mapUID)) {
            return true;
        }
        return MapUpdateService.getInstance().mapsToUpdate.contains(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createImage(InputStream in) throws IOException {
        try {
            Image img = Image.createImage((InputStream)in);
            if (img == null) {
                throw new IOException("Image.createImage returned null");
            }
            Image image = img;
            return image;
        }
        finally {
            FileUtil.close((Object)in);
        }
    }

    static {
        try {
            repo = new Cache("net.yura.domination");
        }
        catch (Throwable ex) {
            System.err.println("[MapChooser] no cache: " + ex);
        }
        MAP_PAGE = "http://maps.yura.net/maps?format=xml&version=" + Url.encode((String)Risk.RISK_VERSION);
        CATEGORIES_PAGE = "http://maps.yura.net/categories?format=xml&version=" + Url.encode((String)Risk.RISK_VERSION);
    }
}

