/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.guishared;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.translation.TranslationBundle;

public class AboutDialog
extends JDialog {
    private JPanel contentPane = new JPanel();
    private JLabel prodLabel = new JLabel();
    private JLabel verLabel = new JLabel();
    private JLabel authLabel = new JLabel();
    private JLabel copLabel = new JLabel();
    private JTextArea commentField = new JTextArea();
    private JPanel btnPanel = new JPanel();
    private JButton okButton = new JButton();
    private GridBagLayout contentPaneLayout = new GridBagLayout();
    private FlowLayout btnPaneLayout = new FlowLayout();
    private JPanel infoPanel = new JPanel();
    private JTextArea info1 = new JTextArea();
    private JTextArea info2 = new JTextArea();

    public AboutDialog(Frame parent, boolean modal, String product, String v) {
        super(parent, modal);
        ResourceBundle resb = TranslationBundle.getBundle();
        String version = resb.getString("about.version") + " " + v;
        String author = " Yura Mamyrin (yura@yura.net)";
        String title = resb.getString("about.title");
        int year = Calendar.getInstance().get(1);
        String copyright = resb.getString("about.copyright").replaceAll("\\{0\\}", String.valueOf(year));
        String comments = " " + resb.getString("about.comments");
        this.contentPane.setLayout(this.contentPaneLayout);
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        this.prodLabel.setText(product);
        this.contentPane.add((Component)this.prodLabel, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.verLabel.setText(version);
        this.contentPane.add((Component)this.verLabel, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.authLabel.setText(resb.getString("about.author") + author);
        this.contentPane.add((Component)this.authLabel, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.copLabel.setText(copyright);
        this.contentPane.add((Component)this.copLabel, new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.commentField.setBackground(this.copLabel.getBackground());
        this.commentField.setForeground(this.copLabel.getForeground());
        this.commentField.setFont(this.copLabel.getFont());
        this.commentField.setText(comments);
        this.commentField.setEditable(false);
        this.commentField.setOpaque(false);
        JLabel image = new JLabel(new ImageIcon(AboutDialog.class.getResource("logo.png")), 0);
        image.setHorizontalAlignment(0);
        this.btnPanel.setLayout(this.btnPaneLayout);
        this.okButton.setText(" " + resb.getString("about.okbutton") + " ");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.closeDialog();
            }
        });
        this.btnPanel.add(this.okButton);
        this.okButton.setDefaultCapable(true);
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 0));
        this.info1.setText(" " + resb.getString("about.infopanel"));
        this.info2.setText(RiskUIUtil.getSystemInfoText() + " " + resb.getString("about.compiledfor"));
        this.info1.setBackground(this.copLabel.getBackground());
        this.info1.setForeground(this.copLabel.getForeground());
        this.info1.setFont(this.copLabel.getFont());
        this.info1.setEditable(false);
        this.info1.setOpaque(false);
        this.info2.setBackground(this.copLabel.getBackground());
        this.info2.setForeground(this.copLabel.getForeground());
        this.info2.setFont(this.copLabel.getFont());
        this.info2.setEditable(false);
        this.info2.setOpaque(false);
        this.infoPanel.add(this.info1);
        this.infoPanel.add(this.info2);
        this.infoPanel.setOpaque(false);
        JEditorPane editorPane1 = new JEditorPane();
        JEditorPane editorPane2 = new JEditorPane();
        JEditorPane editorPane3 = new JEditorPane();
        editorPane1.setEditable(false);
        editorPane2.setEditable(false);
        editorPane3.setEditable(false);
        JTabbedPane tabbedpane = new JTabbedPane();
        tabbedpane.addTab(resb.getString("about.tab.sysinfo"), this.infoPanel);
        tabbedpane.addTab(resb.getString("about.tab.credits"), new JScrollPane(editorPane1));
        tabbedpane.addTab(resb.getString("about.tab.license"), new JScrollPane(editorPane2));
        tabbedpane.addTab(resb.getString("about.tab.changelog"), new JScrollPane(editorPane3));
        JPanel allcontent = new JPanel();
        allcontent.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        allcontent.add((Component)image, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        allcontent.add((Component)this.contentPane, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        allcontent.add((Component)this.commentField, c);
        this.getContentPane().add((Component)allcontent, "North");
        this.getContentPane().add(tabbedpane);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.setTitle(title);
        this.okButton.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog();
            }
        });
        this.pack();
        Dimension size = this.getPreferredSize();
        try {
            this.setMinimumSize(size);
        }
        catch (NoSuchMethodError ex) {
            this.setResizable(false);
        }
        AboutDialog.addTextToTextBox(editorPane1, "help/game_credits.htm");
        AboutDialog.addTextToTextBox(editorPane2, "gpl.txt");
        AboutDialog.addTextToTextBox(editorPane3, "ChangeLog.txt");
    }

    private static void addTextToTextBox(JEditorPane a, String n) {
        try {
            if (n.endsWith(".htm") || n.endsWith(".html")) {
                a.setContentType("text/html");
            }
            a.read(RiskUtil.openStream(n), (Object)null);
        }
        catch (Exception e) {
            a.setText(e.toString());
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

