/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.Serializable;
import java.util.Vector;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Player;

public class Country
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Vector neighbours;
    private Player owner;
    private int armies;
    private Continent continent;
    private int color;
    private int x;
    private int y;
    private String idString;

    public Country(int p, String id, String n, Continent c, int a, int b) {
        this.idString = id;
        this.color = p;
        this.name = n;
        this.continent = c;
        this.neighbours = new Vector();
        this.owner = null;
        this.armies = 0;
        this.x = a;
        this.y = b;
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String a) {
        this.idString = a;
    }

    public String toString() {
        return this.idString + " (" + this.color + ")";
    }

    public boolean isNeighbours(Country t) {
        return this.neighbours.contains(t);
    }

    public Vector getNeighbours() {
        return this.neighbours;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String a) {
        this.name = a;
    }

    public int getArmies() {
        return this.armies;
    }

    public Continent getContinent() {
        return this.continent;
    }

    public void setContinent(Continent a) {
        this.continent = a;
    }

    public void addNeighbour(Country t) {
        this.neighbours.add(t);
    }

    public void setOwner(Player p) {
        this.owner = p;
    }

    public Player getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        return null;
    }

    public void addArmy() {
        ++this.armies;
    }

    public void addArmies(int n) {
        this.armies += n;
    }

    public void removeArmies(int lessArmies) {
        this.armies -= lessArmies;
    }

    public void looseArmy() {
        --this.armies;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int a) {
        this.color = a;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int a) {
        this.x = a;
    }

    public void setY(int a) {
        this.y = a;
    }
}

