/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.yura.domination.engine.MapChooserSwingWrapper;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.AboutDialog;
import net.yura.domination.engine.guishared.BrowserLauncher;
import net.yura.domination.engine.guishared.RiskFileFilter;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.GetMap;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapUpdateService;

public class RiskUIUtil {
    public static URL mapsdir;
    public static Applet applet;
    private static String webstart;
    private static boolean nosandbox;
    private static Map UIImagesReferences;
    public static final String SAVES_DIR = "saves/";
    private static String lobbyAppletURL;
    private static String lobbyURL;
    private static String maps;
    private static String cards;
    private static HashMap fileio;
    private static File gameDir;
    private static File mapsDir;

    public static boolean checkForNoSandbox() {
        return nosandbox;
    }

    public static BufferedImage getUIImage(Class c, String name) {
        try {
            BufferedImage img;
            String id = c + " - " + name;
            WeakReference wr = (WeakReference)UIImagesReferences.get(id);
            if (wr != null && (img = (BufferedImage)wr.get()) != null) {
                return img;
            }
            img = ImageIO.read(c.getResource(name));
            UIImagesReferences.put(id, new WeakReference<BufferedImage>(img));
            return img;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void riskOpenURL(URL docs) throws Exception {
        if (applet != null) {
            applet.getAppletContext().showDocument(docs, "_blank");
        } else if (webstart != null) {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            boolean good = bs.showDocument(docs);
            if (!good) {
                throw new Exception("unable to open URL: " + docs);
            }
        } else {
            BrowserLauncher.openURL(docs.toString());
        }
    }

    private static URL getRiskFileURL(String a) {
        try {
            if (applet != null) {
                return new URL(applet.getCodeBase(), a);
            }
            if (webstart != null) {
                BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                return new URL(bs.getCodeBase(), a);
            }
            return new File(a).toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupMapsDir(Applet a) {
        applet = a;
        if (mapsdir == null) {
            if (applet == null && (webstart = System.getProperty("javawebstart.version")) == null) {
                nosandbox = true;
                RiskUIUtil.setupLookAndFeel();
            }
            try {
                if (RiskUIUtil.checkForNoSandbox()) {
                    File mapsdir1 = new File("maps");
                    String dmname = RiskGame.getDefaultMap();
                    while (!new File(mapsdir1, dmname).exists()) {
                        JOptionPane.showMessageDialog(null, "Can not find map: " + dmname);
                        JFileChooser fc = new JFileChooser(new File("."));
                        fc.setFileSelectionMode(1);
                        fc.setDialogTitle("Select maps directory");
                        int returnVal = fc.showOpenDialog(null);
                        if (returnVal == 0) {
                            mapsdir1 = fc.getSelectedFile();
                            continue;
                        }
                        System.exit(0);
                    }
                    mapsdir = mapsdir1.toURI().toURL();
                } else {
                    mapsdir = RiskUIUtil.getRiskFileURL("maps/");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Frame findParentFrame(Container c) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
    }

    private static Vector getFileList(final String a) {
        Vector<String> namesvector;
        block11: {
            block10: {
                File file2;
                namesvector = new Vector<String>();
                if (!RiskUIUtil.checkForNoSandbox()) break block10;
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith("." + a);
                    }
                };
                File file = RiskUIUtil.getSaveMapDir();
                File[] mapsList = file.listFiles(filter);
                if (mapsList != null) {
                    for (int c = 0; c < mapsList.length; ++c) {
                        namesvector.addElement(mapsList[c].getName());
                    }
                }
                if (file.equals(file2 = RiskUIUtil.getFile(mapsdir))) break block11;
                mapsList = file2.listFiles(filter);
                for (int c = 0; c < mapsList.length; ++c) {
                    String name = mapsList[c].getName();
                    if (namesvector.contains(name)) continue;
                    namesvector.addElement(name);
                }
                break block11;
            }
            String names = null;
            if (applet != null) {
                names = applet.getParameter(a);
            } else if (webstart != null) {
                if ("map".equals(a)) {
                    names = maps;
                } else if ("cards".equals(a)) {
                    names = cards;
                }
            }
            StringTokenizer tok = new StringTokenizer(names, ",");
            while (tok.hasMoreTokens()) {
                namesvector.add(tok.nextToken());
            }
        }
        return namesvector;
    }

    public static String getNewMap(Frame f) {
        try {
            if (RiskUIUtil.checkForNoSandbox()) {
                Vector mapsList = RiskUIUtil.getFileList("map");
                MapChooserSwingWrapper ch = new MapChooserSwingWrapper(mapsList);
                return ch.getNewMap(f);
            }
        }
        catch (Throwable th) {
            RiskUtil.printStackTrace(th);
        }
        return RiskUIUtil.getNewFile(f, "map");
    }

    public static String getNewFile(Frame f, String a) {
        if (RiskUIUtil.checkForNoSandbox()) {
            return RiskUIUtil.getNewFileNoSandbox(f, a);
        }
        return RiskUIUtil.getNewFileInSandbox(f, a);
    }

    public static String getNewFileNoSandbox(Frame f, String a) {
        File md = RiskUIUtil.getFile(mapsdir);
        JFileChooser fc = new JFileChooser(md);
        RiskFileFilter filter = new RiskFileFilter(a);
        fc.setFileFilter(filter);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (file == null) {
                return null;
            }
            return file.getName();
        }
        return null;
    }

    public static String getNewFileInSandbox(Frame f, String a) {
        Vector namesvector = RiskUIUtil.getFileList(a);
        JComboBox combobox = new JComboBox(namesvector);
        Object[] message = new Object[]{TranslationBundle.getBundle().getString("core.error.applet"), combobox};
        Object[] options = new String[]{"OK", "Cancel"};
        int result = JOptionPane.showOptionDialog(f, message, "select " + a, 2, 3, null, options, options[0]);
        if (result == 0) {
            return combobox.getSelectedItem() + "";
        }
        return null;
    }

    public static String getLoadFileName(Frame frame) {
        if (applet != null) {
            RiskUIUtil.showAppletWarning(frame);
            return null;
        }
        String extension = "save";
        if (webstart != null) {
            try {
                FileOpenService fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
                FileContents fc = fos.openFileDialog(SAVES_DIR, new String[]{extension});
                if (fc != null) {
                    fileio.put(fc.getName(), fc);
                    return fc.getName();
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        File dir = RiskUIUtil.getSaveGameDir();
        JFileChooser fc = new JFileChooser(dir);
        fc.setFileFilter(new RiskFileFilter(extension));
        int returnVal = fc.showDialog(frame, TranslationBundle.getBundle().getString("mainmenu.loadgame.loadbutton"));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    public static InputStream getLoadFileInputStream(String file) throws Exception {
        if (webstart != null) {
            FileContents fc = (FileContents)fileio.remove(file);
            return fc.getInputStream();
        }
        return new java.io.FileInputStream(file);
    }

    public static String getSaveFileName(Frame frame) {
        if (applet != null) {
            RiskUIUtil.showAppletWarning(frame);
            return null;
        }
        String extension = "save";
        if (webstart != null) {
            JOptionPane.showMessageDialog(frame, "Please make sure to select a file name ending with \"." + extension + "\"");
            return "saves/filename." + extension;
        }
        File dir = RiskUIUtil.getSaveGameDir();
        JFileChooser fc = new JFileChooser(dir);
        fc.setFileFilter(new RiskFileFilter(extension));
        int returnVal = fc.showSaveDialog(frame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith("." + extension)) {
                fileName = fileName + "." + extension;
            }
            return fileName;
        }
        return null;
    }

    public static void saveFile(String name, Object obj) throws Exception {
        if (webstart != null) {
            ByteArrayOutputStream stor = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(stor);
            out.writeObject(obj);
            out.flush();
            out.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(stor.toByteArray());
            FileSaveService fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            FileContents fc = fss.saveFileDialog(name.substring(0, name.indexOf(47) + 1), new String[]{name.substring(name.indexOf(46) + 1)}, (InputStream)stream, name.substring(name.indexOf(47) + 1, name.indexOf(46)));
        } else {
            FileOutputStream fileout = new FileOutputStream(name);
            ObjectOutputStream objectout = new ObjectOutputStream(fileout);
            objectout.writeObject(obj);
            objectout.close();
        }
    }

    public static void showAppletWarning(Frame frame) {
        JOptionPane.showMessageDialog(frame, TranslationBundle.getBundle().getString("core.error.applet"));
    }

    public static String getSystemInfoText() {
        String netInfo;
        String info;
        String name;
        String cpu;
        String home;
        ResourceBundle resb = TranslationBundle.getBundle();
        if (RiskUIUtil.checkForNoSandbox()) {
            home = System.getProperty("java.home");
            cpu = System.getProperty("sun.cpu.isalist");
            name = System.getProperty("java.runtime.name") + " (" + System.getProperty("java.runtime.version") + ")";
            info = System.getProperty("java.vm.info");
            try {
                netInfo = InetAddress.getLocalHost().getHostAddress() + " (" + InetAddress.getLocalHost().getHostName() + ")";
            }
            catch (UnknownHostException e) {
                netInfo = resb.getString("about.nonetwork");
            }
        } else {
            home = "?";
            cpu = "?";
            info = "?";
            name = applet != null ? "applet" : (webstart != null ? "web start (" + webstart + ")" : "?");
            netInfo = "?";
        }
        return " " + Risk.RISK_VERSION + " (save: " + RiskGame.SAVE_VERSION + " network: " + "11" + ") \n" + " " + "system:" + Locale.getDefault() + " current:" + resb.getLocale() + "\n" + " " + netInfo + " \n" + " " + RiskUIUtil.getOSString() + " \n" + " " + cpu + " \n" + " " + UIManager.getLookAndFeel() + " \n" + " " + System.getProperty("java.vendor") + " \n" + " " + System.getProperty("java.vendor.url") + " \n" + " " + name + " \n" + " " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + ", " + info + ") \n" + " " + System.getProperty("java.specification.version") + " (" + System.getProperty("java.version") + ") \n" + " " + home + " \n" + " " + System.getProperty("java.class.version");
    }

    public static String getOSString() {
        String patch = RiskUIUtil.checkForNoSandbox() ? System.getProperty("sun.os.patch.level") + " (" + System.getProperty("sun.arch.data.model") + "bit)" : "?";
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + patch + " on " + System.getProperty("os.arch");
    }

    public static void openAbout(Frame frame, String product, String version) {
        AboutDialog aboutDialog = new AboutDialog(frame, true, product, version);
        Dimension frameSize = frame.getSize();
        Dimension aboutSize = aboutDialog.getSize();
        int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
        int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        aboutDialog.setLocation(x, y);
        aboutDialog.setVisible(true);
    }

    public static boolean getAddLobby(Risk risk) {
        boolean canlobby = false;
        if (RiskUIUtil.checkForNoSandbox()) {
            String input;
            Serializable buffer;
            BufferedReader bufferin;
            URL url;
            try {
                url = new URL(RiskUtil.RISK_LOBBY_URL);
                bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
                buffer = new StringBuffer();
                input = bufferin.readLine();
                while (input != null) {
                    ((StringBuffer)buffer).append(input + "\n");
                    input = bufferin.readLine();
                }
                String[] lobbyinfo = ((StringBuffer)buffer).toString().split("\\n");
                if (lobbyinfo.length >= 1 && lobbyinfo[0].equals("LOBBYOK")) {
                    if (lobbyinfo.length >= 2) {
                        lobbyAppletURL = lobbyinfo[1];
                        canlobby = true;
                    }
                    if (lobbyinfo.length >= 3) {
                        lobbyURL = lobbyinfo[2];
                        canlobby = true;
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            try {
                String v;
                url = new URL(RiskUtil.RISK_VERSION_URL);
                bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
                buffer = new Vector();
                input = bufferin.readLine();
                while (input != null) {
                    ((Vector)buffer).add(input);
                    input = bufferin.readLine();
                }
                String[] newversion = ((Vector)buffer).toArray(new String[((Vector)buffer).size()]);
                if (newversion[0].startsWith("RISKOK ") && !(v = newversion[0].substring(7, newversion[0].length())).equals(Risk.RISK_VERSION)) {
                    for (int c = 1; c < newversion.length; ++c) {
                        v = v + "\n" + newversion[c];
                    }
                    ResourceBundle resb = TranslationBundle.getBundle();
                    v = resb.getString("mainmenu.new-version.text").replaceAll("\\{0\\}", RiskUtil.GAME_NAME) + " " + v;
                    String link = RiskUIUtil.getURL(v);
                    if (link != null) {
                        int result = JOptionPane.showConfirmDialog(null, v, resb.getString("mainmenu.new-version.title"), 2);
                        if (result == 0) {
                            RiskUtil.streamOpener.openURL(new URL(link));
                        }
                    } else {
                        risk.showMessageDialog(v);
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                MapUpdateService.getInstance().init(RiskUIUtil.getFileList("map"), MapChooser.MAP_PAGE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return canlobby;
    }

    public static String getURL(String v) {
        int site = v.indexOf("http://");
        if (site >= 0) {
            int end = v.length();
            String chars = " \n\r\t";
            for (int c = 0; c < chars.length(); ++c) {
                int r = v.indexOf(chars.charAt(c), site);
                if (r < 0 || r >= end) continue;
                end = r;
            }
            return v.substring(site, end);
        }
        return null;
    }

    public static void runLobby(Risk risk) {
        try {
            if (lobbyURL != null) {
                URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{new URL("jar:" + lobbyURL + "/LobbyClient.jar!/")});
                Class<?> lobbyclass = ucl.loadClass("org.lobby.client.LobbyClientGUI");
                final JPanel panel = (JPanel)lobbyclass.getConstructor(URL.class).newInstance(new URL(lobbyURL));
                JFrame gui = new JFrame("yura.net Lobby");
                gui.setContentPane(panel);
                gui.setSize(800, 600);
                gui.setVisible(true);
                gui.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent evt) {
                        panel.setVisible(false);
                    }
                });
                panel.setVisible(true);
            } else if (lobbyAppletURL != null) {
                RiskUtil.openURL(new URL(lobbyAppletURL));
            }
        }
        catch (Exception e) {
            risk.showMessageDialog("unable to run the lobby: " + e.toString());
        }
    }

    private static File getFile(URL url) {
        File md;
        String dir = url.toString();
        try {
            md = new File(new URI(dir));
        }
        catch (IllegalArgumentException e) {
            if (dir.startsWith("file://")) {
                md = new File(dir.substring(5, dir.length()).replaceAll("\\%20", " "));
            } else {
                System.err.println("this should never happen! bad file: " + dir);
                md = new File("maps/");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cant create file: " + dir, e);
        }
        return md;
    }

    private static void setupLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            RiskUtil.printStackTrace(e);
        }
        if (RiskUIUtil.checkForNoSandbox()) {
            try {
                new JFileChooser();
            }
            catch (Throwable th) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e) {
                    RiskUtil.printStackTrace(e);
                }
            }
        }
    }

    public static void parseArgs(String[] args) {
        TranslationBundle.parseArgs(args);
        for (int nA = 0; nA < args.length; ++nA) {
            if (args[nA].length() > 5 && args[nA].substring(0, 5).equals("maps=")) {
                maps = args[nA].substring(5);
            }
            if (args[nA].length() <= 6 || !args[nA].substring(0, 6).equals("cards=")) continue;
            cards = args[nA].substring(6);
        }
        RiskUIUtil.setupMapsDir(null);
    }

    public static Color getTextColorFor(Color color) {
        return new Color(RiskUtil.getTextColorFor(color.getRGB()));
    }

    public static void donate(Component parent) {
        try {
            RiskUtil.donate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Unable to open web browser: " + e.getMessage(), "Error", 0);
        }
    }

    public static boolean canWriteTo(File dir) {
        try {
            File tmp = new File(dir, "del.me");
            tmp.createNewFile();
            tmp.deleteOnExit();
            tmp.delete();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static File getSaveGameDir() {
        if (gameDir != null) {
            return gameDir;
        }
        File saveDir = new File(SAVES_DIR);
        if (RiskUIUtil.canWriteTo(saveDir)) {
            gameDir = saveDir;
            return saveDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, RiskUtil.GAME_NAME + " Saves");
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps);
        }
        gameDir = userMaps;
        return userMaps;
    }

    public static File getSaveMapDir() {
        if (mapsDir != null) {
            return mapsDir;
        }
        File saveDir = RiskUIUtil.getFile(mapsdir);
        if (RiskUIUtil.canWriteTo(saveDir)) {
            mapsDir = saveDir;
            return saveDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, RiskUtil.GAME_NAME + " Maps");
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps);
        }
        mapsDir = userMaps;
        return userMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(InputStream in) throws IOException {
        try {
            BufferedImage img = ImageIO.read(in);
            if (img == null) {
                throw new IOException("ImageIO.read returned null");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        if (RiskUtil.streamOpener == null) {
            RiskUtil.streamOpener = new RiskIO(){

                public InputStream openStream(String name) throws IOException {
                    return RiskUIUtil.getRiskFileURL(name).openStream();
                }

                public InputStream openMapStream(String name) throws IOException {
                    try {
                        File mapsDir = RiskUIUtil.getSaveMapDir();
                        return new FileInputStream(new File(mapsDir, name));
                    }
                    catch (Throwable th) {
                        try {
                            return new URL(mapsdir, name).openStream();
                        }
                        catch (Throwable ex) {
                            IOException exception = new IOException(ex.toString());
                            exception.initCause(th);
                            throw exception;
                        }
                    }
                }

                public ResourceBundle getResourceBundle(Class c, String n, Locale l) {
                    return ResourceBundle.getBundle(c.getPackage().getName() + "." + n, l);
                }

                public void openURL(URL url) throws Exception {
                    RiskUIUtil.riskOpenURL(url);
                }

                public void openDocs(String doc) throws Exception {
                    RiskUIUtil.riskOpenURL(RiskUIUtil.getRiskFileURL(doc));
                }

                public void saveGameFile(String name, Object obj) throws Exception {
                    RiskUIUtil.saveFile(name, obj);
                }

                public InputStream loadGameFile(String file) throws Exception {
                    return RiskUIUtil.getLoadFileInputStream(file);
                }

                public OutputStream saveMapFile(String fileName) throws Exception {
                    return RiskUtil.getOutputStream(RiskUIUtil.getSaveMapDir(), fileName);
                }

                public void getMap(String filename, Risk risk, Exception ex) {
                    GetMap.getMap(filename, risk, ex);
                }

                public void renameMapFile(String oldName, String newName) {
                    File oldFile = new File(RiskUIUtil.getSaveMapDir(), oldName);
                    File newFile = new File(RiskUIUtil.getSaveMapDir(), newName);
                    RiskUtil.rename(oldFile, newFile);
                }
            };
        }
        UIImagesReferences = new HashMap();
        fileio = new HashMap();
    }

    public static class FileInputStream
    extends java.io.FileInputStream {
        private final File file;

        private FileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

