/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.yura.grasshopper.BugSubmitterMultipart;
import net.yura.grasshopper.BugSystemInfo;

public class BugSubmitter {
    static void submitBug(Object log, String cause) {
        BugSubmitter.submitBug(log, "no-email", cause);
    }

    static void submitBug(Object log, String email, String cause) {
        BugSubmitter.submitBug(log, email, BugSystemInfo.appName + " " + BugSystemInfo.version + " " + BugSystemInfo.locale + " Bug", cause, BugSystemInfo.appName, BugSystemInfo.version, BugSystemInfo.locale);
    }

    public static void submitBug(Object log, String email, String subject, String cause, String appName, String version, String locale) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("log", log);
        map.put("appName", appName);
        map.put("appVersion", version);
        map.put("appLocale", locale);
        map.put("grasshopperVersion", "2.2");
        map.putAll(BugSystemInfo.addSystemInfo());
        map.put("recipient", "yura@yura.net");
        map.put("subject", "GRASSHOPPER " + subject);
        map.put("email", email);
        map.put("env_report", "REMOTE_HOST,HTTP_USER_AGENT");
        if (cause != null) {
            map.put("cause", cause);
        }
        try {
            BugSubmitterMultipart.send("http://yura.net/cgi-bin/TFmail.cgi", map);
            System.out.println("[grasshopper] send ok");
        }
        catch (Throwable th) {
            try {
                StringWriter error = new StringWriter();
                th.printStackTrace(new PrintWriter(error));
                map.put("grasshopperError", error.toString());
                BugSubmitter.doPost("http://yura.net/cgi-sys/FormMail.cgi", map);
                System.out.println("[grasshopper] send ok ish " + th);
            }
            catch (Throwable th2) {
                System.out.println("[grasshopper] error sending: " + th + " " + th2);
            }
        }
    }

    public static void doPost(OutputStreamWriter getpostb, Map map) throws IOException {
        boolean firstDone = false;
        Iterator enu = map.keySet().iterator();
        while (enu.hasNext()) {
            if (firstDone) {
                getpostb.append("&");
            } else {
                firstDone = true;
            }
            Object key = enu.next();
            getpostb.append(URLEncoder.encode(String.valueOf(key), "UTF-8"));
            getpostb.append("=");
            Object object = map.get(key);
            if (object instanceof File) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader((File)object));
                while ((line = br.readLine()) != null) {
                    getpostb.append(URLEncoder.encode(line + "<br>\n", "UTF-8"));
                }
                continue;
            }
            String value = String.valueOf(object);
            value = value.replaceAll("\\n|\\r\\n", "<br>$0");
            getpostb.append(URLEncoder.encode(value, "UTF-8"));
        }
    }

    public static void doPost(String url, Map map) throws IOException {
        String line;
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        BugSubmitter.doPost(wr, map);
        wr.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
        }
        rd.close();
    }
}

