#include <dk.h>

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dkmem.h>
#include <dklogc.h>
#include <dkapp.h>

static int exval = 1;

static dk_app_t *app = NULL;

static char groupname[] = { "testprog" };

static char tablename[] = { "hello" };

static char **msg = NULL;

static dk_key_value_t kv[] = {
  { "/m/00", "Hello world!" },
  { "/m/01", "Goodbye world!" },
  { "/m/02", "Test debug message." },
  { "/m/03", "Test warning message." },
  { "/m/04", "This error" },
  { "/m/05", " example message" },
  { "/m/06", " consists of multiple parts." }
};
static size_t szkv = sizeof(kv)/sizeof(dk_key_value_t);

int main(int argc, char *argv[])
{
  char *msgptr[3];
  app = dkapp_open_ext1(argc, argv, groupname, DK_SYSCONFDIR, 0, 0);
  if(app) {
    msg = dkapp_find_key_value(app, kv, szkv, tablename);
    if(msg) {
      printf("%s\n", msg[0]);
      msgptr[0] = msg[2];
      dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, msgptr, 1);
      msgptr[0] = msg[3];
      dkapp_log_msg(app, DK_LOG_LEVEL_WARNING, msgptr, 1);
      msgptr[0] = msg[4];
      msgptr[1] = msg[5];
      msgptr[2] = msg[6];
      dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, msgptr, 3);
      printf("%s\n", msg[1]);
      exval = 0;
      dk_delete(msg);
    } else {
      /* ERROR: Failed to obtain strings. */
    }
    dkapp_close(app); app = NULL;
  } else {
    /* ERROR: Failed to open application. */
  }
  exit(exval);
  return exval;
}


