/*
Copyright (c) 2002-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	psonly.c	The psonly program.
*/



#include <dk.h>

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_STRING_H
#include <string.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <dksf.h>



#line 61 "psonly.ctr"



/**	Exit status.
*/
static int exval = 0;



/**	Start of PS contents.
*/
static char ps_header[] = { "%!PS-Adobe" };



/**	Input buffer.
*/
static char inbuffer[4096];



/**	Output buffer.
*/
static char outbuffer[4096];



/**	Number of used bytes in output buffer.
*/
static size_t outbuffer_used;



/**	Flush output buffer.
	@param	out	Output file.
*/
static
void
flush_outbuffer DK_P1(FILE *,out)
{
  if(outbuffer_used) {
    (void)fwrite((void *)outbuffer,1,outbuffer_used,out);
  }
  outbuffer_used = 0;
}



/**	Add one character to output buffer, flush if necessary.
	@param	out	Output file.
	@param	c	Character to add.
*/
static
void
add_out_char DK_P2(FILE *,out, char,c)
{
  outbuffer[outbuffer_used++] = c;
  if(outbuffer_used == sizeof(outbuffer)) {
    flush_outbuffer(out);
  }
}



/**	Run for opened files.
	@param	in	Input file.
	@param	out	Output file.
*/
static
void
run_for_files DK_P2(FILE *,in, FILE *,out)
{
  int can_continue;
  int state;
  size_t header_found, header_sz;
  size_t inbuffer_sz, inbuffer_used;
  char c, *ptr;

  header_sz = strlen(ps_header);
  can_continue = 1; state = 0; header_found = 0;
  outbuffer_used = 0;
  while(can_continue) {
    inbuffer_sz = fread((void *)inbuffer,1,sizeof(inbuffer),in);
    if(inbuffer_sz > 0) {
      ptr = inbuffer; inbuffer_used = 0;
      while(inbuffer_used < inbuffer_sz) {
	c = *ptr;
	switch(state) {
	  case 0: {
	    if(c == ps_header[header_found]) {
	      header_found++;
	      if(header_found == header_sz) {
		state = 1; exval = 1;
		for(header_found = 0; header_found < header_sz; header_found++)
		{
		  add_out_char(out, ps_header[header_found]);
		}
	      }
	    } else {
	      header_found = 0;
	    }
	  } break;
	  case 1: {
	    if(c == 0x1B) {
	      state = 2;
	    } else {
	      add_out_char(out, c);
	    }
	  } break;
	  case 2: {
	    if(c == 0x25) {
	      state = 3;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, c);
	    }
	  } break;
	  case 3: {
	    if(c == 0x2D) {
	      state = 4;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, c);
	    }
	  } break;
	  case 4: {
	    if(c == 0x31) {
	      state = 5;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, c);
	    }
	  } break;
	  case 5: {
	    if(c == 0x32) {
	      state = 6;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, 0x31);
	      add_out_char(out, c);
	    }
	  } break;
	  case 6: {
	    if(c == 0x33) {
	      state = 7;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, 0x31);
	      add_out_char(out, 0x32);
	      add_out_char(out, c);
	    }
	  } break;
	  case 7: {
	    if(c == 0x34) {
	      state = 8;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, 0x31);
	      add_out_char(out, 0x32);
	      add_out_char(out, 0x33);
	      add_out_char(out, c);
	    }
	  } break;
	  case 8: {
	    if(c == 0x35) {
	      state = 9;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, 0x31);
	      add_out_char(out, 0x32);
	      add_out_char(out, 0x33);
	      add_out_char(out, 0x34);
	      add_out_char(out, c);
	    }
	  } break;
	  case 9: {
	    if(c == 0x58) {
	      state = 10;
	    } else {
	      state = 1;
	      add_out_char(out, 0x1B);
	      add_out_char(out, 0x25);
	      add_out_char(out, 0x2D);
	      add_out_char(out, 0x31);
	      add_out_char(out, 0x32);
	      add_out_char(out, 0x33);
	      add_out_char(out, 0x34);
	      add_out_char(out, 0x35);
	      add_out_char(out, c);
	    }
	  } break;
	}
	inbuffer_used++; ptr++;
      }
    } else {
      can_continue = 0;
    }
  }
  flush_outbuffer(out);
}



/**	The main() function of the psonly program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  FILE *in, *out;
  switch(argc) {
    case 1: {
      run_for_files(stdin, stdout);
    } break;
    case 2: {
      in = dksf_fopen(argv[1], "rb");
      if(in) {
	run_for_files(in, stdout);
	fclose(in);
      }
    } break;
    case 3: {
      in = dksf_fopen(argv[1], "rb");
      if(in) {
	out = dksf_fopen(argv[2], "wb");
	if(out) {
	  run_for_files(in, out);
	  fclose(out);
	}
	fclose(in);
      }
    } break;
  }
  exval = (exval ? 0 : 1);
  exit(exval);
  return exval;
}


