/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/** @file prqdlog.c	Prqd log module. */


/**	Inside the prqdlog module. */
#define PRQDLOG_C	1
#include "prqd.h"

#line 46 "prqdlog.ctr"




/** Keywords for message priorities. */
static char *kw_prio[] = {
 "",
 "FATAL: ",
 "ERROR: ",
 "Warning: ",
};



/**	Log timestamp with message (if time has changed since
	previous message).
	@param	pj	Pointer to prqd job structure.
	@param	f	File to print timestamp to.
*/
static
void
log_time DK_P2(PJ *,pj, FILE *,f)
{
  time_t timer;
  struct tm *tm;
  time(&timer);
  if(pj->last_log_time == (time_t)0) {
    fputs("\n\n", f);
  }
  if(timer > pj->last_log_time) {
    tm = localtime(&timer);
    if(tm) {
      pj->last_log_time = timer;
      fprintf(
        f, "# %04d-%02d-%02d %02d:%02d:%02d (%lu)\n",
	(1900 + tm->tm_year),
	(1 + tm->tm_mon),
	tm->tm_mday,
	tm->tm_hour,
	tm->tm_min,
	tm->tm_sec,
	(unsigned long)dksf_getpid()
      );
    }
  }
}



/**	Write a log message.
	The log message is written if the priority in prio is
	important enough.
	@param	pj	Pointer to prqd job structure.
	@param	prio	Message priority.
	@param	format	Message format.
	@return	1 on success, 0 on error.
*/
#if DK_HAVE_PROTOTYPES
int prqdlog(PJ *pj, int prio, char *format, ...)
#else
int prqdlog(pj, prio, format, ...) PJ *pj; int prio; char *format;
#endif
{
  int back = 0;
  int must_syslog = 0;
  FILE *f = NULL;
  va_list arg_list;
  
  if((prio < PRQD_PRIO_DEBUG) || (prqdconf_get_debug(pj))) {
    if(pj->allow_file_logging) {	
      f = dksf_fopen(prqdconf_get_logfile(), "a");
      if(f) {				
        back = 1;
        log_time(pj, f);
        if(prio <= PRQD_PRIO_WARNING) {
          fputs(kw_prio[prio], f);
        }
        va_start(arg_list, format);
        vfprintf(f, format, arg_list);
        va_end(arg_list);
        fputc('\n', f); fflush(f);
        fclose(f); f = NULL;		
      } else {				
        must_syslog = 1;
      }
    } else {
      
    }
  } else {
    
  }
#if DK_HAVE_SYSLOG && DK_HAVE_VSNPRINTF
  if((prio <= PRQD_PRIO_WARNING) || must_syslog) {
    char buffer[1024];
    va_start(arg_list, format);
    vsnprintf(buffer, sizeof(buffer), format, arg_list);
    va_end(arg_list);
    buffer[sizeof(buffer)-1] = '\0';
    syslog(LOG_ERR, "%s", buffer);
  }
#endif
  
  return back;
}


