// Copyright (c) 2010 - Dipl.-Ing. Dirk Krause
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms,
// with or without modification, are permitted provided
// that the following conditions are met:
// 
// * Redistributions of source code must retain the above
//   copyright notice, this list of conditions and the
//   following disclaimer.
// * Redistributions in binary form must reproduce the above 
//   opyright notice, this list of conditions and the following
//   disclaimer in the documentation and/or other materials
//   provided with the distribution.
// * Neither the name of Dirk Krause nor the names of
//   contributors may be used to endorse or promote
//   products derived from this software without specific
//   prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
// CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
// Category for kWinDown
//
//  Values are 32 bit values laid out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_SYSTEM                  0x0


//
// Define the severity codes
//
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: CAT_KWINDOWN
//
// MessageText:
//
// kWinDown
//
#define CAT_KWINDOWN                     ((DWORD)0x00000001L)

// The system was started
//
// MessageId: MSG_KWINDOWN_UP
//
// MessageText:
//
// The kWinDown service was started successfully.
//
#define MSG_KWINDOWN_UP                  ((DWORD)0x00000101L)

// Failed to register the service
//
// MessageId: MSG_ERROR_FAILED_TO_REGISTER_SERVICE
//
// MessageText:
//
// Failed to register the kWinDown service!
//
#define MSG_ERROR_FAILED_TO_REGISTER_SERVICE ((DWORD)0xC0000102L)

// System was shut down
//
// MessageId: MSG_SUCCESS_SHUTDOWN_INITIATED
//
// MessageText:
//
// A system shutdown was initiated.
//
#define MSG_SUCCESS_SHUTDOWN_INITIATED   ((DWORD)0x00000103L)

// Failed to shutdown system
//
// MessageId: MSG_ERROR_FAILED_TO_SHUTDOWN
//
// MessageText:
//
// Failed to initiate system shutdown!
//
#define MSG_ERROR_FAILED_TO_SHUTDOWN     ((DWORD)0xC0000104L)

// Failed to obtain handle for current process
//
// MessageId: MSG_ERROR_FAILED_PROCESS_HANDLE
//
// MessageText:
//
// Failed to obtain process handle!
//
#define MSG_ERROR_FAILED_PROCESS_HANDLE  ((DWORD)0xC0000105L)

// Failed to access process token
//
// MessageId: MSG_ERROR_FAILED_TO_ACCESS_TOKEN
//
// MessageText:
//
// Failed to access process token!
//
#define MSG_ERROR_FAILED_TO_ACCESS_TOKEN ((DWORD)0xC0000106L)

// Failed to obtain shutdown privilege
//
// MessageId: MSG_ERROR_FAILED_TO_OBTAIN_SHUTDOWN_PRIVILEGE
//
// MessageText:
//
// Failed to obtain shutdown privilege!
//
#define MSG_ERROR_FAILED_TO_OBTAIN_SHUTDOWN_PRIVILEGE ((DWORD)0xC0000107L)

// Failed to open parent registry key
//
// MessageId: MSG_ERROR_FAILED_TO_OPEN_PARENT_REGKEY
//
// MessageText:
//
// Failed to open registry key "%1"!
//
#define MSG_ERROR_FAILED_TO_OPEN_PARENT_REGKEY ((DWORD)0xC0000108L)

// Failed to open my registry key
//
// MessageId: MSG_ERROR_FAILED_TO_OPEN_MY_REGKEY
//
// MessageText:
//
// Failed to open registry key "%1"!
//
#define MSG_ERROR_FAILED_TO_OPEN_MY_REGKEY ((DWORD)0xC0000109L)

// Timeout while waiting for background thread to end
//
// MessageId: MSG_ERROR_TIMEOUT_WHILE_WAITING_FOR_BGTHREAD
//
// MessageText:
//
// Timeout while waiting for background thread to finish!
//
#define MSG_ERROR_TIMEOUT_WHILE_WAITING_FOR_BGTHREAD ((DWORD)0xC000010AL)

// Failed to create event
//
// MessageId: MSG_ERROR_FAILED_TO_CREATE_EVENT
//
// MessageText:
//
// Failed to obtain resources for event handling!
//
#define MSG_ERROR_FAILED_TO_CREATE_EVENT ((DWORD)0xC000010BL)

// Failed to start background thread
//
// MessageId: MSG_ERROR_FAILED_TO_START_THREAD
//
// MessageText:
//
// Failed to start background thread!
//
#define MSG_ERROR_FAILED_TO_START_THREAD ((DWORD)0xC000010CL)

// Shutting down service
//
// MessageId: MSG_INFO_MUST_SHUTDOWN
//
// MessageText:
//
// Must initiate shutdown.
//
#define MSG_INFO_MUST_SHUTDOWN           ((DWORD)0x4000010DL)

// Shutting down service
//
// MessageId: MSG_INFO_SERVICE_DOWN
//
// MessageText:
//
// Service going down.
//
#define MSG_INFO_SERVICE_DOWN            ((DWORD)0x4000010EL)

// Parent key is missing
//
// MessageId: MSG_ERROR_REGKEY_MISSING
//
// MessageText:
//
// Failed to open/create registry "HKLM\\%1"!
//
#define MSG_ERROR_REGKEY_MISSING         ((DWORD)0xC000010FL)

// Wrong type or size
//
// MessageId: MSG_ERROR_REGENTRY_WRONG_TYPE
//
// MessageText:
//
// Registry entry has wrong type or size!
//
#define MSG_ERROR_REGENTRY_WRONG_TYPE    ((DWORD)0xC0000110L)

// Wrong type or size
//
// MessageId: MSG_INFO_NO_SHUTDOWN
//
// MessageText:
//
// No shutdown necessary.
//
#define MSG_INFO_NO_SHUTDOWN             ((DWORD)0x40000111L)

// Shutdown time changed
//
// MessageId: MSG_INFO_SHUTDOWN_TIME_CHANGED
//
// MessageText:
//
// Shutdown time changed: %1
//
#define MSG_INFO_SHUTDOWN_TIME_CHANGED   ((DWORD)0x40000112L)

