/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	klpr.c	The klpr program.
*/



#include <dk.h>
#include <dkmem.h>
#include <dkstr.h>
#include <dkapp.h>
#include <dktcpip.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dktypes.h>

#include <yalc.h>
#include <dklic.h>


#line 60 "klpr.ctr"




/**	Application.
*/
dk_app_t *app = NULL;



/**	System configuration directory.
*/
static char sysconfdir[] = { DK_SYSCONFDIR };



/**	Program group name.
*/
static char prg_group_name[] = { "dktools" };



/**	Type definition, needed for sizeof operator.
*/
typedef char *PCHAR;



/**	Help text, printed if help text file is not found.
*/
static char *help_text[] = {
  "",
  "klpr <options> <files>",
  "",
  "Options",
  "-------",
  "-S <server>          connect to the specified server",
  "-P <printer>         print to the specified printer",
  "-U <user>            print as the specified user",
  "-C <class>           class name for banner and priority",
  "-l                   print file literaly (as is, default)",
  "-c                   print cifplot output file",
  "-d                   print dvi file",
  "-g                   print standard plot file",
  "-n                   print device independent troff output file",
  "-p                   use pr to format files",
  "-t                   print troff output file",
  "-r                   print raster file",
  "-e                   enable header page printing (suppressed by default)",
  "-i <width>           indent lines",
  "-J <job_name>        specifiy job name for banner page",
  "-K <number>          number of copies",
  "-m <mailaddress>     send mail to recipient after printing",
  "-Q <queue_name>      note original queue in control file",
  "-R <account>         bill the named account",
  "-T <job_title>       job title for banner page",
  "-V                   verbose",
  "-w <width>           specify line width for pr filter",
  "-o <options>         filter options",
  "",
  NULL,
};



/**	Long options.
*/
static char *long_options[] = {
  /*  0 */	"s$erver",
  /*  1 */	"p$rinter",
  /*  2 */	"u$ser",
  /*  3 */	"cl$ass",
  /*  4 */	"l$iterally",
  /*  5 */	"ci$fplot",
  /*  6 */	"d$vi",
  /*  7 */	"pl$ot",
  /*  8 */	"dvi-t$roff",
  /*  9 */	"pr",
  /* 10 */	"tr$off",
  /* 11 */	"r$aster",
  /* 12 */	"head$er",
  /* 13 */	"i$ndent",
  /* 14 */	"jobn$ame",
  /* 15 */	"c$opies",
  /* 16 */	"m$ail",
  /* 17 */	"ori$ginal-queue",
  /* 18 */	"b$ill",
  /* 19 */	"jobt$itle",
  /* 20 */	"verb$ose",
  /* 21 */	"w$idth",
  /* 22 */	"f$ilter-options",
  /* 23 */	"h$elp",
  /* 24 */	"v$ersion",
  NULL,
};



/**	Run the program, send print job or print help/version.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	1 on success, 0 on error.
*/
static
int
run DK_P2(int, argc, char **, argv)
{
  int back = 0;
  char *pchr, **arguments, **lfdargs, **licptr;
  char *printer_name, *server_name, *user_name;
  char *class_name, *job_name, *job_title;
  char *mail_address, *other_options, *remote_account;
  int    args_used, i, version_wanted, help_wanted, all;
  int   file_type, x, indent_width, suppress_header;
  int   number_of_copies, keep_queue, verbose, width;
  yalc_rq_t *rq;
  rq = yalc_new();
  if(rq) {
    all = help_wanted = version_wanted = 0;
    printer_name = server_name = user_name = NULL;
    class_name = job_name = job_title = NULL;
    mail_address = other_options = remote_account = NULL;
    file_type = YALC_TYPE_UNKNOWN;
    indent_width = keep_queue = 0;
    suppress_header = 1; verbose = 0; width = 0;
    number_of_copies = 1;
    arguments = dk_new(PCHAR,argc);
    if(arguments) {
      for(i = 0; i < argc; i++) {
	arguments[i] = NULL;
      }
      args_used = 0;
      i = 1; lfdargs = argv; lfdargs++;
      while(i < argc) {
	pchr = *lfdargs;
	if(*pchr == '-') {
	  pchr++;
	  switch(*pchr) {
	    case 'h' : {
	      help_wanted = 1; 
	    } break;
	    case 'v' : {
	      version_wanted = 1;
	    } break;
	    case 'P' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  printer_name = pchr;
		}
	      }
	    } break;
	    case 'S' :
	    case 'H' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  server_name = pchr;
		}
	      }
	    } break;
	    case 'U' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  user_name = pchr;
		}
	      }
	    } break;
	    case 'C' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  class_name = pchr;
		}
	      }
	    } break;
	    case 'F' : {
	      pchr++;
	      if(!(*pchr)) {
	        pchr = NULL;
		i++; lfdargs++;
		if(i < argc) { pchr = *lfdargs; }
	      }
	      if(pchr) {
	        if(*pchr) {
		  switch(*pchr) {
	            case 'b' :
	            case 'l' : {
	              file_type = YALC_TYPE_BINARY;
	            } break;
	            case 'c' : {
	              file_type = YALC_TYPE_CIFPLOT;
	            } break;
	            case 'd' : {
	              file_type = YALC_TYPE_DVI;
	            } break;
	            case 'g' : {
	              file_type = YALC_TYPE_PLOT;
	            } break;
	            case 'n' : {
	              file_type = YALC_TYPE_TROFF_N;
	            } break;
	            case 'p' : {
	              file_type = YALC_TYPE_PR;
	            } break;
	            case 't' : {
	              file_type = YALC_TYPE_TROFF_T;
	            } break;
	            case 'r' : {
	              file_type = YALC_TYPE_RASTER;
	            } break;
		  }
		}
	      }
	    } break;
	    case 'b' :
	    case 'l' : {
	      file_type = YALC_TYPE_BINARY;
	    } break;
	    case 'c' : {
	      file_type = YALC_TYPE_CIFPLOT;
	    } break;
	    case 'd' : {
	      file_type = YALC_TYPE_DVI;
	    } break;
	    case 'g' : {
	      file_type = YALC_TYPE_PLOT;
	    } break;
	    case 'n' : {
	      file_type = YALC_TYPE_TROFF_N;
	    } break;
	    case 'p' : {
	      file_type = YALC_TYPE_PR;
	    } break;
	    case 't' : {
	      file_type = YALC_TYPE_TROFF_T;
	    } break;
	    case 'r' : {
	      file_type = YALC_TYPE_RASTER;
	    } break;
	    case 'e' : {
	      suppress_header = 0;
	    } break;
	    case 'i' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  if(sscanf(pchr, "%d", &x) == 1) {
		    indent_width = x;
		  }
		}
	      }
	    } break;
	    case 'J' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  job_name = pchr;
		}
	      }
	    } break;
	    case 'K' :
	    case '#' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  if(sscanf(pchr, "%d", &x) == 1) {
		    number_of_copies = x;
		  }
		}
	      }
	    } break;
	    case 'm' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  mail_address = pchr;
		}
	      }
	    } break;
	    case 'Q' : {
	      keep_queue = 1;
	    } break;
	    case 'R' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  remote_account = pchr;
		}
	      }
	    } break;
	    case 'T' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  job_title = pchr;
		}
	      }
	    } break;
	    case 'V' : {
	      verbose = 1;
	    } break;
	    case 'w' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  if(sscanf(pchr, "%d", &x) == 1) {
		    width = 1;
		  }
		}
	      }
	    } break;
	    case 'o' :
	    case 'Z' : {
	      pchr++;
	      if(!(*pchr)) {
		pchr = NULL;
		i++; lfdargs++;
		if(i < argc) {
		  pchr = *lfdargs;
		}
	      }
	      if(pchr) {
		if(*pchr) {
		  other_options = pchr;
		}
	      }
	    } break;
	    case '-' : {		/* long option */
	      int whichoption; char *valptr;
	      pchr++; valptr = NULL;
	      valptr = dkstr_chr(pchr, '=');
	      if(valptr) { *(valptr++) = (char)0; }
	      whichoption = dkstr_array_abbr(long_options, pchr, '$', 0);
	      switch(whichoption) {
	        case 0: {
		  if(valptr) { server_name = valptr; } 
		} break;
		case 1: {
		  if(valptr) { printer_name = valptr; }
		} break;
		case 2: {
		  if(valptr) { user_name = valptr; }
		} break;
		case 3: {
		  if(valptr) { class_name = valptr; }
		} break;
		case 4: {
		  file_type = YALC_TYPE_BINARY;
		} break;
		case 5: {
		  file_type = YALC_TYPE_CIFPLOT;
		} break;
		case 6: {
		  file_type = YALC_TYPE_DVI;
		} break;
		case 7: {
		  file_type = YALC_TYPE_PLOT;
		} break;
		case 8: {
		  file_type = YALC_TYPE_TROFF_N;
		} break;
		case 9: {
		  file_type = YALC_TYPE_PR;
		} break;
		case 10: {
		  file_type = YALC_TYPE_TROFF_T;
		} break;
		case 11: {
		  file_type = YALC_TYPE_RASTER;
		} break;
		case 12: {
		  if(valptr) {
		    suppress_header = (dkstr_is_on(valptr) ? 0 : 1);
		  } else {
		    suppress_header = 0;
		  }
		} break;
		case 13: {
		  if(valptr) {
		    if(sscanf(valptr, "%d", &x) == 1) {
		      indent_width = x;
		    }
		  }
		} break;
		case 14: {
		  if(valptr) { job_name = valptr; }
		} break;
		case 15: {
		  if(valptr) {
		    if(sscanf(valptr, "%d", &x) == 1) {
		      number_of_copies = x;
		    }
		  }
		} break;
		case 16: {
		  if(valptr) {
		    mail_address = valptr;
		  }
		} break;
		case 17: {
		  if(valptr) {
		    keep_queue = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    keep_queue = 1;
		  }
		} break;
		case 18: {
		  if(valptr) {
		    remote_account = valptr;
		  }
		} break;
		case 19: {
		  if(valptr) {
		    job_title = valptr;
		  }
		} break;
		case 20: {
		  if(valptr) {
		    verbose = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    verbose = 1;
		  }
		} break;
		case 21: {
		  if(valptr) {
		    if(sscanf(valptr, "%d", &x) == 1) {
		      indent_width = x;
		    }
		  }
		} break;
		case 22: {
		  if(valptr) {
		    other_options = valptr;
		  }
		} break;
		case 23: {
		  if(valptr) {
		    help_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    help_wanted = 1;
		  }
		} break;
		case 24: {
		  if(valptr) {
		    version_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    version_wanted = 1;
		  }
		} break;
	      }
	    } break;
	  }
	} else {
	  arguments[args_used] = dkstr_dup(pchr);
	  if(arguments[args_used]) {
	    args_used++;
	  } else {
	    dkapp_err_memory(app,sizeof(char),(1+strlen(pchr)));
	  }
	}
	i++; lfdargs++;
      }
      if(version_wanted || help_wanted) {
        if(version_wanted) {
	  printf("\n");
	  {
	    char **vptr;
	    vptr = yalc_get_version();
	    if(vptr) {
	      while(*vptr) {
	        printf("%s\n", *(vptr++));
	      }
	    }
	  }
	  printf("\nLibraries used:\n\n");
	  licptr = dklic_get();
	  while(*licptr) {
	    printf("%s\n", *(licptr++));
	  }
	  printf("\n");
	}
	if(help_wanted) {
	  dkapp_help(app, "klpr.txt", help_text);
	}
        back = 1;
      } else {
        yalc_set_lpr(rq);
        yalc_set_printer(rq, printer_name);
        yalc_set_server(rq, server_name);
        yalc_set_app(rq, app);
        yalc_set_args(rq, args_used, arguments);
        if(file_type != YALC_TYPE_UNKNOWN) {
	  yalc_set_lpr_filetype(rq, file_type);
        }
        yalc_set_lpr_suppress_header(rq, suppress_header);
        if(indent_width) {
	  yalc_set_lpr_indent_cols(rq, indent_width);
        }
        if(number_of_copies) {
	  yalc_set_lpr_number_of_copies(rq, number_of_copies);
        }
        if(keep_queue) {
	  yalc_set_lpr_keep_spool_queue(rq, keep_queue);
        }
        if(width) {
	  yalc_set_lpr_width(rq, width);
        }
        if(class_name) {
	  yalc_set_lpr_class_name(rq, class_name);
        }
        if(job_name) {
	  yalc_set_lpr_job_name(rq, job_name);
        }
        if(mail_address) {
	  yalc_set_lpr_mail_addr(rq, mail_address);
        }
        if(remote_account) {
	  yalc_set_lpr_remote_account(rq, remote_account);
        }
        if(job_title) {
	  yalc_set_lpr_job_title(rq, job_title);
        }
        if(other_options) {
	  yalc_set_lpr_other_options(rq, other_options);
        }
        back = yalc_run(rq);
      }
      /* ende */
      dk_delete(arguments);
    } else {
      dkapp_err_memory(app, sizeof(PCHAR), argc);
    }
    yalc_delete(rq); rq = NULL;
  } else {
    dkapp_err_memory(app, sizeof(yalc_rq_t), 1);
  }
  return back;
}



/**	The main() function of the klpr program-.
	@param	argc	Number of command line arguments
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  int back = 0;
  int xargc;
  char **xargv;
  
#line 694 "klpr.ctr"

  app = dkapp_open_ext1(argc, argv, prg_group_name, sysconfdir, 0, 0);
  if(app) {
    if(dktcpip_start()) {
      xargc = dkapp_get_argc(app);
      xargv = dkapp_get_argv(app);
      back = run(xargc, xargv);
      dktcpip_end();
    } else {
      dkapp_err_tcpip(app);
    }
    dkapp_close(app); app = NULL;
  } else {
    fprintf(stderr,
      "ERROR: Not enough memory!\n"
    );
  }
  back = (back ? 0 : 1);
  
  
#line 713 "klpr.ctr"

  exit(back); return back;
}


