#! /usr/bin/perl

# Copyright (C) 2010 by Dirk Krause
# All rights reserved.
# 
# Redistribution and use in source and binary forms,
# with or without modification, are permitted provided
# that the following conditions are met:
# 
# * Redistributions of source code must retain the above
#   copyright notice, this list of conditions and the
#   following disclaimer.
# * Redistributions in binary form must reproduce the above 
#   opyright notice, this list of conditions and the following
#   disclaimer in the documentation and/or other materials
#   provided with the distribution.
# * Neither the name of the Dirk Krause nor the names of
#   contributors may be used to endorse or promote
#   products derived from this software without specific
#   prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

my $version = "unknown";
my @lines;
my $nlines = 0;

my $line;
my $i;

if($#ARGV > -1) {
  $version = shift @ARGV;
}

print "corver.pl: Version number $version\n";

if(open(INPUT, "<Doxyfile")) {
  while(<INPUT>) {
    $line = $_;
    chomp($line);
    if($line =~ /^\s*PROJECT_NUMBER\s*=\s*\S+/o) {
      $lines[$nlines++] = "PROJECT_NUMBER\t=\t$version";
    } else {
      $lines[$nlines++] = $line;
    }
  }
  close(INPUT);
  if(open(OUTPUT, ">Doxyfile")) {
    for($i = 0; $i < $nlines; $i++) {
      print OUTPUT ($lines[$i] . "\n");
    }
    close(OUTPUT);
  }
}

# if(open(OUTPUT, ">../dktools-doc/doc-src/wml/src/version.wml")) {
#   print "SUCCESS version.wml opened.\n";
#   print OUTPUT "#use wml::std::tags\n";
#   print OUTPUT "<perl>\n";
#   print OUTPUT "my \$projectversion = \"$version\";\n";
#   print OUTPUT "</perl>\n";
#   close(OUTPUT);
# } else {
#   print "ERROR: Failed to open ../dktools-doc/doc-src/wml/src/version.wml\n";
# }
