/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	b2conv.c
	Conversions.
*/



/** Inside the b2conv.c module. */
#define B2CONV_C	1
#include "bmepsi.h"




#line 52 "b2conv.ctr"




/**	Run a conversion to PDF.
	@param	bj	Bmeps job.
*/
static
void
convert_to_pdf DK_P1(BJ *,bj)
{
  int can_use_dct = 0;	/* Flag: Direct pass-through of DCT encoded data. */
  
  if(bj->it == DKBIF_TYPE_UNKNOWN) {
    if(bj->infname) {
      bj->it = dkbif_get_type(bj->infname);
    }
  }
  if(bj->it == DKBIF_TYPE_JPG) {	
      if(((bj->bo)->enc) & BMEPS_ENCODING_DCT) {	
#if DK_HAVE_JPEGLIB_H
	/* can_use_dct = 1; */
	if(((bj->bif)->d).jpg.jpgana.is_jfif < 2) {
	  can_use_dct = 1;
	  if(!(((bj->bo)->opt) & BMEPS_OPT_FORCE_DCT)) {
	    if((((bj->bif)->d).jpg.jpgana.used_sofs) & (~((bj->bo)->jfif_s))) {
	      can_use_dct = 0;	/* illegal SOFs were used */
	    }
	    if(((bj->bif)->d).jpg.jpgana.n_sofs != 1UL) {
	      can_use_dct = 0;	/* file structure too complicated */
	    }
	    if(((bj->bif)->d).jpg.jpgana.n_images != 1UL) {
	      can_use_dct = 0;	/* file structure too complicated */
	    }
	  }
	} else {
	  if(((bj->bo)->opt) & BMEPS_OPT_FORCE_DCT) {
	    can_use_dct = 1;
	    ((bj->bif)->d).jpg.jpgana.components =
	    dkbif_get_channels(bj->bif);
	  }
	}
	if(can_use_dct) {
	  if(!((bj->bo)->opt & BMEPS_OPT_COLOR_OUTPUT)) {
	    switch(dkbif_get_channels(bj->bif)) {
	      case 3: case 4: {
	        
	        can_use_dct = 0;
	      } break;
	    }
	  }
	}
#endif
      }
  }
  if(((bj->bo)->opt) & BMEPS_OPT_DRAFT) {	
    bmeps_pdf(bj, 2);
  } else {					
    if(dkbif_read_data(bj->bif, bj->inf)) {
      if(can_use_dct) {				
        bmeps_pdf(bj, 1);
      } else {					
        bmeps_pdf(bj, 0);
      }
    } else {
      bmeps_tool_msg_3(bj, DK_LOG_LEVEL_ERROR, 60, 61, bj->infname);
      bj->exval = 1;
    }
  }
  
}



/**	Run conversion to EPS.
	@param	bj	Bmeps job.
*/
static
void
convert_to_eps DK_P1(BJ *,bj)
{
  int can_use_dct = 0;	/* Flag: Can pass-through DCT encoded data. */
  
  if(bj->it == DKBIF_TYPE_UNKNOWN) {
    if(bj->infname) {	
      bj->it = dkbif_get_type(bj->infname);
    }
  }
  
  if(bj->it == DKBIF_TYPE_JPG) {	
    if((bj->bo)->l >= BMEPS_PS_LEVEL_2) {	
      if(((bj->bo)->enc) & BMEPS_ENCODING_DCT) {	
#if DK_HAVE_JPEGLIB_H
	/* can_use_dct = 1; */
	if(((bj->bif)->d).jpg.jpgana.is_jfif < 2) {
	  can_use_dct = 1;
	  if(!(((bj->bo)->opt) & BMEPS_OPT_FORCE_DCT)) {
	    if((((bj->bif)->d).jpg.jpgana.used_sofs) & (~((bj->bo)->jfif_s))) {
	      can_use_dct = 0;	/* illegal SOFs were used */
	    }
	    if(((bj->bif)->d).jpg.jpgana.n_sofs != 1UL) {
	      can_use_dct = 0;	/* file structure too complicated */
	    }
	    if(((bj->bif)->d).jpg.jpgana.n_images != 1UL) {
	      can_use_dct = 0;	/* file structure too complicated */
	    }
	  }
	} else {
	  if(((bj->bo)->opt) & BMEPS_OPT_FORCE_DCT) {
	    can_use_dct = 1;
	    ((bj->bif)->d).jpg.jpgana.components =
	    dkbif_get_channels(bj->bif);
	  }
	}
	if(can_use_dct) {
	  if(!((bj->bo)->opt & BMEPS_OPT_COLOR_OUTPUT)) {
	    switch(dkbif_get_channels(bj->bif)) {
	      case 3: case 4: {
	        
	        can_use_dct = 0;
	      } break;
	    }
	  }
	}
#endif
      }
    }
  }
  if(((bj->bo)->opt) & BMEPS_OPT_DRAFT) {	
    bmeps_eps_draft(bj);
  } else {					
    if(dkbif_read_data(bj->bif, bj->inf)) {
      if(can_use_dct) {				
        bmeps_eps_dct(bj);
      } else {					
        bmeps_eps_conventional(bj);
      }
    } else {
      bmeps_tool_msg_3(bj, DK_LOG_LEVEL_ERROR, 60, 61, bj->infname);
      bj->exval = 1;
    }
  }
  
}



/**	Run a conversion.
	@param	bj	Bmeps job.
*/
void
bmeps_convert DK_P1(BJ *,bj)
{
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  if(bj) {
    bj->bif = dkbif_open();
    if(bj->bif) {
      if((bj->it == BMEPS_OUTPUT_TYPE_BB)
         || ((bj->bo)->opt & BMEPS_OPT_DRAFT))
      {
        dkbif_set_width_height_sufficient(bj->bif, 1);
      }
      if(dkbif_read_header(bj->bif, bj->inf, bj->infname, bj->it, bj->tmp7)) {
        if(!(bj->frame_c)) {
	  bj->frame_s = 0UL;
	  if(dkbif_number_of_frames(bj->bif) > 0L) {
	    
	    bj->frame_e = (long)dkbif_number_of_frames(bj->bif) - 1L;
	  } else {
	    bj->frame_e = 0L;
	    
	  }
          
          
	}
	if(bj->frame_s < 0L) {
	  bj->frame_e = (long)dkbif_number_of_frames(bj->bif) - 1L;
	  bj->frame_s = 0L;
	} else {
	  if(bj->frame_e >= (long)dkbif_number_of_frames(bj->bif)) {
	    bj->frame_e = (long)dkbif_number_of_frames(bj->bif) - 1L;
	  }
	  if(bj->frame_e < 0L) { bj->frame_e = 0L; }
	  if(bj->frame_s > bj->frame_e) bj->frame_s = bj->frame_e;
	}
        bj->os = dkstream_for_file(bj->outf);
	if(bj->os) {
          switch((bj->bo)->ot) {
            case BMEPS_OUTPUT_TYPE_PDF: {
              convert_to_pdf(bj);
            } break;
            case BMEPS_OUTPUT_TYPE_BB: {
              bmeps_eps_bb(bj);
            } break;
            default: {
              convert_to_eps(bj);
            } break;
          }
	  dkstream_close(bj->os); bj->os = NULL;
	} else {	
	  bmeps_tool_msg_1(bj, DK_LOG_LEVEL_ERROR, 59);
	  bj->exval = 1;
	}
      } else {		
	bmeps_tool_msg_3(bj, DK_LOG_LEVEL_ERROR, 57, 58, bj->infname);
	bj->exval = 1;
      }
      dkbif_close(bj->bif); bj->bif = NULL;
    } else {
      bmeps_tool_error_memory(bj); bj->exval = 1;
    }
  }
  
}



