/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include <stdio.h>

#include "dkmem.h"
#include "dkapp.h"
#include "dksto.h"
#include "dklogc.h"

#if DK_HAVE_ALLOC_H
#include <alloc.h>
#endif


#line 49 "apptest.ctr"


static char test_file_name[] = { "test.dat" };

static char test_msg[] = { "Test error message!" };
static char *msgs[] = { test_msg, NULL };

static dk_key_value_t mykv[] = {
  { "/ll/f", "Ein hoechst fataler Fehler" },
  { "/ll/e", "Ein aergerlicher Fehler" },
  { "/ll/w", "Eine unbedeutende Warnung" }
};
static size_t s_mykv = DK_KEY_VALUE_ARRAY_SIZE(mykv);

static char *xmsgs[DK_KEY_VALUE_ARRAY_SIZE(mykv)];

int main(int argc, char *argv[])
{
  dk_app_t *app;
  dk_storage_iterator_t *it;
  dk_preference_t *pptr;
  char testline[2048];
  int i;
  char pattern[] = { "/usr/local/lib/$(app.name)/$(user.uid)" };
  char **msgs;
  
#line 74 "apptest.ctr"

#if DK_HAVE_CORELEFT
  
#endif
#if DK_HAVE_FARCORELEFT
  
#endif
  app = dkapp_open(argc,argv);
  msgs = dkapp_find_key_value(NULL, mykv, s_mykv, "dkapp");
  if(msgs) {
    printf("MSGS (1):\n");
    printf("%s\n", msgs[0]);
    printf("%s\n", msgs[1]);
    printf("%s\n", msgs[2]);
    dk_delete(msgs);
  }
  dkapp_init_key_value(NULL, mykv, s_mykv, "dkapp", xmsgs);
  printf("XMSGS (1):\n");
  printf("%s\n", xmsgs[0]);
  printf("%s\n", xmsgs[1]);
  printf("%s\n", xmsgs[2]);
  if(app) {
    msgs = dkapp_find_key_value(app, mykv, s_mykv, "dkapp");
    if(msgs) {
      printf("MSGS (2):\n");
      printf("%s\n", msgs[0]);
      printf("%s\n", msgs[1]);
      printf("%s\n", msgs[2]);
      dk_delete(msgs);
    }
    dkapp_init_key_value(app, mykv, s_mykv, "dkapp", xmsgs);
    printf("XMSGS (2):\n");
    printf("%s\n", xmsgs[0]);
    printf("%s\n", xmsgs[1]);
    printf("%s\n", xmsgs[2]);
    if((app->p).c) {
      it = dksto_it_open((app->p).c);
      if(it) {
	dksto_it_reset(it);
        while((pptr = (dk_preference_t *)dksto_it_next(it)) != NULL) {
	  printf("%s\t%s\n",
	    pptr->n, pptr->v
	  );
	}
	dksto_it_close(it);
      }
    }
    dkapp_set_source_filename(app, test_file_name);
    dkapp_set_source_lineno(app, 1UL);
    dkapp_log_msg(app,DK_LOG_LEVEL_ERROR,msgs,1);
    if(dkapp_get_pref(app,"/ui/lang",testline,sizeof(testline),0)) {
      printf("%s\n", testline);
    }
    if(dkapp_get_pref(app,"/unsinn",testline,sizeof(testline),0)) {
      printf("%s\n", testline);
    }
    if(dkapp_transform_string(app,testline,sizeof(testline),pattern)) {
      printf("%s\n", testline);
    }
    dkapp_set_pref(app, "/unsinn", "Bloedsinn");
    if(dkapp_find_file(app, "x.txt", testline, sizeof(testline))) {
      printf("File %s\n", testline);
    }
    for(i = 0; i < 2048; i++) {
      if(dkapp_tmpnam(app,testline,sizeof(testline))) {
	printf("tmpfile %s\n", testline);
      }
    }
    dkapp_close(app);
  }
#if DK_HAVE_CORELEFT
  
#endif
#if DK_HAVE_FARCORELEFT
  
#endif
  
#line 150 "apptest.ctr"

  exit(0); return 0;
}


