/*
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include "dkbif.h"
#include "dkbifi.h"
#include "dk.h"
#include "dkstr.h"

#line 42 "jpgreport.ctr"



static char buffer[4096];


static int sof_codes[] = {
  DKBIF_I_SOF0,
  DKBIF_I_SOF1,
  DKBIF_I_SOF2,
  DKBIF_I_SOF3,
  0,
  DKBIF_I_SOF5,
  DKBIF_I_SOF6,
  DKBIF_I_SOF7,
  DKBIF_I_SOF8,
  DKBIF_I_SOF9,
  DKBIF_I_SOF10,
  DKBIF_I_SOF11,
  0,
  DKBIF_I_SOF13,
  DKBIF_I_SOF14,
  DKBIF_I_SOF15,
};
static size_t n_sof_codes = sizeof(sof_codes)/sizeof(int);

static
void
run_for(char *filename)
{
  FILE *f;
  dk_bif_jfif_analyze_t ja;
  size_t i;
  int have_a_sof;
  
  f = dksf_fopen(filename, "rb");
  if(f) {
    /* ja.is_printing = 0; */
    ja.inputfile = f;
    ja.os = NULL;
    ja.a = NULL;
    dkbif_jfif_analyze(&ja);
    
    printf("%s\n", filename);
    switch(ja.is_jfif) {
      case 0: {
        printf("\tJFIF file shows no problems.\n");
      } break;
      case 1: {
        printf("\tJFIF file contains problematic SOF chunk(s).\n");
      } break;
      case 2: {
      	printf("\tNot a JFIF file\n");
      } break;
    }
    switch(ja.is_jfif) {
      case 0: case 1: case 2: {
        printf("\tJFIF version:       %u.%u\n",
	  (unsigned)(ja.vers_major), (unsigned)(ja.vers_minor)
	);
	printf("\tImages in file:     %lu\n", ja.n_images);
	printf("\tSOF entries:        %lu\n", ja.n_sofs);
	printf("\tSOF(s):             ");
	have_a_sof = 0;
	for(i = 0; i < n_sof_codes; i++) {
	  if(dkbif_jfif_get_sof(ja.used_sofs, sof_codes[i])) {
	    if(have_a_sof) {
	      printf(", ");
	    }
	    have_a_sof = 1;
	    printf("%u", (unsigned)i);
	  }
	}
	printf("\n");
	printf("\tWidth:              %u\n", ja.width);
	printf("\tHeight:             %u\n", ja.height);
	printf("\tComponents:         %u\n", (unsigned)(ja.components));
	printf("\tBits per component: %u\n", (unsigned)(ja.bpc));
	printf("\tDpi setting         %u\n", (unsigned)(ja.dpi_setting));
	printf("\tX resolution:       %u\n", ja.xres);
	printf("\tY resolution:       %u\n", ja.yres);
      } break;
    }
    fclose(f); f = NULL;
  } else {
    printf("%s: ERROR: Failed to open file\n", filename);
  }
  
}


int main(int argc, char *argv[])
{
  int i;
  char *p;
  
#line 137 "jpgreport.ctr"

  if(argc > 1) {
    for(i = 1; i < argc; i++) {
      run_for(argv[i]);
    }
  } else {
    while(fgets(buffer, sizeof(buffer), stdin)) {
      p = dkstr_start(buffer, NULL);
      if(p) {
        dkstr_chomp(p, NULL);
	run_for(p);
      }
    }
  }
  
#line 151 "jpgreport.ctr"

}


