
package hostdata;

# new <name>

sub new
{
  my $class = shift;
  my $self  = {};
  $self->{'name'} = undef;
  $self->{'ipaddr'} = undef;
  $self->{'ether'} = undef;
  $self->{'aliases'} = {};
  $self->{'ngmember'} = 0;
  $self->{'ngnumber'} = 0;
  $self->{'ngnum2'} = 0;
  $self->{'domain'} = undef;
  $self->{'yp'} = 0;
  $self->{'netgroups'} = {};
  $self->{'comment'} = undef;
  $self->{'patch'} = undef;
  $self->{'segment'} = undef;
  $self->{'user'} = undef;
  $self->{'sysadm'} = undef;
  $self->{'os'} = undef;
  $self->{'arpwatch_exclude'} = undef;
  $self->{'serial'} = undef;
  $self->{'hostid'} = undef;
  $self->{'arch'} = undef;
  $self->{'typeno'} = undef;
  $self->{'inventory'} = undef;
  $self->{'location'} = undef;
  $self->{'full_name_first'} = 0;
  $self->{'dhcp-class'} = undef;
  $self->{'expires'} = undef;
  bless($self,$class);
  return $self;
}

sub set_dhcp_class
{
  my $self = shift; my $cl = shift;
  $self->{'dhcp-class'} = $cl;
}

sub get_dhcp_class
{
  my $self = shift;
  my $back = undef;
  if(exists($self->{'dhcp-class'})) {
    $back = $self->{'dhcp-class'};
  }
  return $back;
}

sub set_expiration
{
  my $self = shift; my $e = shift;
  $self->{'expires'} = $e;
}

sub get_expiration
{
  my $self = shift;
  my $back = undef;
  if(exists($self->{'expires'})) {
    $back = $self->{'expires'};
  }
  return $back;
}

sub set_name
{
  my $self = shift; my $name = shift;
  $self->{'name'} = $name;
}

sub get_name
{
  my $self = shift;
  my $back = '';
  if(exists($self->{'name'})) {
    $back = $self->{'name'};
  } else {
  }
  return $back;
}

sub set_ipaddr
{
  my $self = shift; my $ipaddr = shift; $self->{'ipaddr'} = $ipaddr;
}

sub get_ipaddr
{
  my $self = shift;
  my $back = '';
  if(exists($self->{'ipaddr'})) { $back = $self->{'ipaddr'}; }
  return $back;
}

sub set_ether
{
  my $self = shift; my $ether = shift; $self->{'ether'} = $ether; 
}

sub get_ether
{
  my $self = shift;
  my $back = '';
  if(exists($self->{'ether'})) { $back = $self->{'ether'}; }
  return $back;
}

sub set_alias
{
  my $self = shift;
  my $name = shift;
  my $al   = $self->{'aliases'};
  if(!(exists($al->{"$name"}))) {
    $al->{"$name"} = 1;
  }
}

sub set_aliases
{
  my $self = shift;
  my $line = shift;
  my $name = "";
  $line =~ s/^\s*//g;
  chomp $line;
  while($line =~ /\S+/o) {
    if($line =~ /(\S+)\s+(\S.*)/o) {
      $name = $1; $line = $2;
      $self->set_alias($name);
    } else {
      $self->set_alias($line);
      $line = "";
    }
  }
}

sub get_aliases
{
  my $self = shift;
  my $back = $self->{'aliases'};
  return $back;
}

sub set_ng_member
{
  my $self = shift;
  my $val = shift;
  $self->{'ngmember'} = $val;
}

sub get_ng_member
{
  my $self = shift;
  my $back = $self->{'ngmember'};
  return $back;
}

sub set_ng_number
{
  my $self = shift; my $num = shift;
  $self->{'ngnumber'} = $num;
}

sub get_ng_number
{
  my $self = shift;
  my $back = $self->{'ngnumber'};
  return $back;
}

sub set_ng_num2
{
  my $self = shift; my $num = shift;
  $self->{'ngnum2'} = $num;
}

sub get_ng_num2
{
  my $self = shift;
  my $back = $self->{'ngnum2'};
  return $back;
}

sub set_domainname
{
  my $self = shift;
  my $name = shift;
  $self->{'domain'} = $name;
}

sub get_domainname
{
  my $self = shift;
  my $back = $self->{'domain'};
  return $back;
}

sub set_yp
{
  my $self = shift; my $val = shift;
  $self->{'yp'} = $val;
}

sub get_yp
{
  my $self = shift;
  my $back = $self->{'yp'};
  return $back;
}

sub set_comment
{
  my $self = shift; my $comm = shift;
  $self->{'comment'} = $comm;
}

sub get_comment
{
  my $self = shift;
  my $back = $self->{'comment'};
  return $back;
}

sub set_patch
{
  my $self = shift; my $comm = shift;
  $self->{'patch'} = $comm;
}

sub get_patch
{
  my $self = shift;
  my $back = $self->{'patch'};
  return $back;
}

sub set_segment
{
  my $self = shift; my $comm = shift;
  $self->{'segment'} = $comm;
}

sub get_segment
{
  my $self = shift;
  my $back = $self->{'segment'};
  return $back;
}

sub set_user
{
  my $self = shift; my $comm = shift;
  $self->{'user'} = $comm;
}

sub get_user
{
  my $self = shift;
  my $back = $self->{'user'};
  return $back;
}

sub set_sysadm
{
  my $self = shift; my $comm = shift;
  $self->{'sysadm'} = $comm;
}

sub get_sysadm
{
  my $self = shift;
  my $back = $self->{'sysadm'};
  return $back;
}

sub set_os
{
  my $self = shift; my $comm = shift;
  $self->{'os'} = $comm;
}

sub get_os
{
  my $self = shift;
  my $back = $self->{'os'};
  return $back;
}

sub set_arpwatch_exclude
{
  my $self = shift; my $comm = shift;
  $self->{'arpwatch_exclude'} = $comm;
}

sub get_arpwatch_exclude
{
  my $self = shift;
  my $back = $self->{'arpwatch_exclude'};
  return $back;
}

sub set_serial
{
  my $self = shift; my $comm = shift;
  $self->{'serial'} = $comm;
}

sub get_serial
{
  my $self = shift;
  my $back = $self->{'serial'};
  return $back;
}

sub set_hostid
{
  my $self = shift; my $comm = shift;
  $self->{'hostid'} = $comm;
}

sub get_hostid
{
  my $self = shift;
  my $back = $self->{'hostid'};
  return $back;
}

sub set_arch
{
  my $self = shift; my $comm = shift;
  $self->{'arch'} = $comm;
}

sub get_arch
{
  my $self = shift;
  my $back = $self->{'arch'};
  return $back;
}

sub set_typeno
{
  my $self = shift; my $comm = shift;
  $self->{'typeno'} = $comm;
}

sub get_typeno
{
  my $self = shift;
  my $back = $self->{'typeno'};
  return $back;
}

sub set_inventory
{
  my $self = shift; my $comm = shift;
  $self->{'inventory'} = $comm;
}

sub get_inventory
{
  my $self = shift;
  my $back = $self->{'inventory'};
  return $back;
}

sub set_ndexclude
{
  my $self = shift; my $comm = shift;
  $self->{'ndexclude'} = $comm;
}

sub set_full_name_first
{
  my $self = shift; my $val = shift;
  $self->{'full_name_first'} = $val;
}

sub get_full_name_first
{
  my $self = shift;
  my $back = 0;
  if(exists($self->{'full_name_first'})) {
   $back = $self->{'full_name_first'};
  }
  return $back;
}

sub get_ndexclude
{
  my $self = shift;
  my $back = $self->{'ndexclude'};
  return $back;
}

sub set_location
{
  my $self = shift; my $comm = shift;
  $self->{'location'} = $comm;
}

sub get_location
{
  my $self = shift;
  my $back = $self->{'location'};
  return $back;
}

sub set_direct_netgroup
{
  my $self = shift;
  my $name = shift;
  $ngref = $self->{'netgroups'};
  $ngref->{"$name"} = 1;
}

sub get_netgroups
{
  my $self = shift;
  my $back = $self->{'netgroups'};
  return $back;
}


1;

