/*
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dksdndbm.c	Simple database API for NDBM databases.
*/



#include "dk.h"

#if DK_HAVE_STRING_H
#include <string.h>
#endif
#if DK_HAVE_FCNTL_H
#include <fcntl.h>
#endif
#if DK_HAVE_IO_H
#include <io.h>
#endif

#include "dkmem.h"
#include "dkstr.h"



/**	Inside the dksdndbm module.
*/
#define DKSDBI_NDBM	1

#include "dksdbi.h"
#include "dksdbii.h"




#line 71 "dksdndbm.ctr"




#if DK_HAVE_NDBM_H
#if !DK_HAVE_GDBM_H

#include <ndbm.h>



int
dksdbi_ndbm_close DK_P1(dk_sdbi_db *,p)
{
  int back = 0;
  DBM *dbm;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    dbm_close(dbm);
    p->dbptr = NULL;
    back = 1;
  }
  
  return back;
}



int
dksdbi_ndbm_open DK_P1(dk_sdbi_db *,p)
{
  int back = 0;
  int openmode = 0, found = 0;
  DBM *dbm = NULL;
  
  if((p->acc) & DK_SDBI_MODE_READ) {
    if((p->acc) & DK_SDBI_MODE_WRITE) {
      openmode = (O_RDWR | O_CREAT); found = 1;
      if((p->acc) & DK_SDBI_MODE_TRUNCATE) {  openmode |= O_TRUNC; }
    } else {
      openmode = (O_RDONLY | O_CREAT); found = 1;
    }
  } else {
    if((p->acc) & DK_SDBI_MODE_WRITE) {
      openmode = (O_WRONLY | O_CREAT); found = 1;
      if((p->acc) & DK_SDBI_MODE_TRUNCATE) { openmode |= O_TRUNC; }
    }
  }
  if(found) {
    dbm = dbm_open(p->fn, openmode, p->tfm);
    if(dbm) {
      p->dbptr = (void *)dbm;
      back = 1;
    }
  }
  
  return back;
}



int
dksdbi_ndbm_store DK_P6(dk_sdbi_db *,p, void *,kp, size_t,kl, void *,vp, size_t,vl, int,insm)
{
  int back = 0;
  DBM *dbm;
  datum k, v; int ret;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    DK_MEMRES(&k,sizeof(datum)) ; DK_MEMRES(&v,sizeof(datum)) ;
    k.dptr = kp; k.dsize = kl; v.dptr = vp; v.dsize = vl;
    ret = dbm_store(dbm, k, v, DBM_INSERT);
    if(ret == 0) {
      back = 1;
    } else {
      if(!(insm & DK_SDBI_INSMOD_NO_REPLACE)) {
        DK_MEMRES(&k,sizeof(datum)) ; DK_MEMRES(&v,sizeof(datum)) ;
	k.dptr = kp; k.dsize = kl; v.dptr = vp; v.dsize = vl;
	ret = dbm_store(dbm, k, v, DBM_REPLACE);
	if(ret == 0) { back = 1; }
      }
    }
  }
  
  return back;
}



int
dksdbi_ndbm_delete DK_P3(dk_sdbi_db *,p, char *,kp, size_t,kl)
{
  int back = 0;
  DBM *dbm;
  datum k;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    DK_MEMRES(&k,sizeof(datum)) ;
    k.dptr = kp; k.dsize = kl;
    if(dbm_delete(dbm, k) == 0) {
      back = 1;
    }
  }
  
  return back;
}



int
dksdbi_ndbm_fetch DK_P5(dk_sdbi_db *,p, void *,kp, size_t,kl, void *,vp, size_t *,vl)
{
  int back = 0;
  DBM *dbm;
  datum k, v; int ret;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    DK_MEMRES(&k,sizeof(datum)) ; DK_MEMRES(&v,sizeof(datum)) ;
    k.dptr = kp; k.dsize = kl;
    v = dbm_fetch(dbm, k);
    if(v.dptr) {
      if(v.dsize) {
        if(v.dsize <= (*vl)) {
	  DK_MEMCPY(vp,v.dptr,v.dsize);
	  *vl = v.dsize;
	  back = 1;
	} else {
	  DK_MEMCPY(vp,v.dptr,(*vl));
	  back = -1;
	}
      } else {
      }
    } else {
    }
  }
  
  return back;
}



int
dksdbi_ndbm_string_fetch  DK_P4(dk_sdbi_db *,p, char *,kp, char *,vp, size_t,s)
{
  int back = 0;
  DBM *dbm;
  datum k, v; int ret;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    DK_MEMRES(&k,sizeof(datum)) ; DK_MEMRES(&v,sizeof(datum)) ;
    k.dptr = kp; k.dsize = (1 + strlen(kp));
    v = dbm_fetch(dbm, k);
    if(v.dptr) {
      if(v.dsize) {
        if(v.dsize < s) {
	  DK_MEMCPY(vp,v.dptr,v.dsize) ;
	  vp[v.dsize] = '\0';
	  back = 1;
	} else {
	  DK_MEMCPY(vp,v.dptr,(s-1)) ;
	  vp[s-1] = '\0';
	  back = -1;
	}
      } else {
      }
    } else {
    }
  }
  
  return back;
}



int
dksdbi_ndbm_traverse DK_P3(dk_sdbi_db *,p, void *,d, dk_sdbi_fct_t *,f)
{
  int back = 0;
  DBM *dbm;
  datum k, v; int ret = 0; int cc = 0; int found = 0;
  
  dbm = (DBM *)(p->dbptr);
  if(dbm) {
    cc = 1; found = 0; back = 1;
    for(
      k = dbm_firstkey(dbm);
      ((k.dptr != NULL) && (cc));
      k = dbm_nextkey(dbm)
    ) {
      if(k.dptr) {
        if(k.dsize) {
	  v = dbm_fetch(dbm, k);
	  if(v.dptr) {
	    if(v.dsize) {
	      found = 1;
	      switch((*f)(d, k.dptr, k.dsize, v.dptr, v.dsize)) {
	        case -1: { cc = 0; back = 0; } break;
	      }
	    } else {
	      cc = 0;
	    }
	  } else {
	    cc = 0;
	  }
	} else {
	  cc = 0;
	}
      } else {
        cc = 0;
      }
    }
    if(!found) { back = 0; }
  }
  
  return back;
}



int
dksdbi_ndbm_sync DK_P1(dk_sdbi_db *,p)
{
  int back = 0;
  
  
  return back;
}


#endif
#endif

