/*
Copyright (c) 2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/


/**	@file uau.c	User structure module. */



/** In uau module. */
#define UAU_C	1

#include "useraudi.h"




#line 50 "uau.ctr"




void
uau_group_delete DK_P1(UAG *,g) {
  char *x;
  if(g) {
    if(g->n) {
      x = g->n; dk_delete(x); g->n = NULL;
    } g->g = 0;
    dk_delete(g);
  }
}



UAG *
uau_group_new DK_P2(char *,name, gid_t,gid) {
  UAG *back = NULL;
  if(name) {
    back = dk_new(UAG,1);
    if(back) {
      back->g = gid;
      back->n = dkstr_dup(name);
      if(!(back->n)) {
        uau_group_delete(back); back = NULL;
      }
    }
  }
  return back;
}



void
uau_property_delete DK_P1(UAP *,uap) {
  char *x;
  
  if(uap) {	
    if(uap->value) {
      x = uap->value; dk_delete(x); uap->value = NULL;
    }
    uap->major = uap->minor = 0;
    dk_delete(uap);
  } 
}



UAP *
uau_property_new DK_P3(int,maj, int,min, char *,v) {
  UAP *back = NULL;
  if(v) {
    back = dk_new(UAP,1);
    if(back) {
      back->major = maj; back->minor = min;
      back->value = dkstr_dup(v);
      if(!(back->value)) {
        uau_property_delete(back); back = NULL;
      }
    }
  }
  return back;
}



void
uau_delete DK_P1(UAU *,u) {
  char *x;
  UAG *g;
  UAP *uap;
  
  if(u) {
    if(u->user_name) {
      x = u->user_name; dk_delete(x); u->user_name = NULL;
    }
    if(u->pw_hash) {
      x = u->pw_hash; dk_delete(x); u->pw_hash = NULL;
    }
    if(u->pg_name) {
      x = u->pg_name; dk_delete(x); u->pg_name = NULL;
    }
    if(u->gecos) {
      x = u->gecos; dk_delete(x); u->gecos = NULL;
    }
    if(u->s_g) {
      if(u->i_g) {
        dksto_it_reset(u->i_g);
	while((g = (UAG *)dksto_it_next(u->i_g)) != NULL) {
	  uau_group_delete(g);
	}
        dksto_it_close(u->i_g);
      }
      dksto_close(u->s_g);
    } u->s_g = NULL; u->i_g = NULL;
    if(u->s_p) {
      if(u->i_p) {
        dksto_it_reset(u->i_p);
	while((uap = (UAP *)dksto_it_next(u->i_p)) != NULL) {
	  uau_property_delete(uap);
	}
        dksto_it_close(u->i_p);
      }
      dksto_close(u->s_p);
    } u->s_p = NULL; u->i_p = NULL;
    dk_delete(u);
  } 
}



UAU *
uau_new DK_P1(char *,n) {
  UAU *back = NULL;
  if(n) {
    back = dk_new(UAU,1);
    if(back) {
      back->pw_hash = NULL;
      back->pg_name = NULL;
      back->s_g = NULL;
      back->i_g = NULL;
      back->s_p = NULL;
      back->i_p = NULL;
      back->gecos = NULL;
      back->uid = (uid_t)0;
      back->primary_group = (gid_t)0;
      back->ht = 0;
      back->st = 0;
      back->sl = 0;
      back->user_name = dkstr_dup(n);
      if(!(back->user_name)) {
        uau_delete(back); back = NULL;
      }
    }
  }
  return back;
}



