package netdocu;

my $ingerman = 0;

my @enpreamble = (
  "\\documentclass[12pt,a4paper,titlepage]{article}",
  "\\usepackage{lscape}",
  "\\usepackage{ifpdf}",
  "\\usepackage[latin1]{inputenc}",
  "\\usepackage[T1]{fontenc}",
  "\\usepackage{textcomp}",
  "\\usepackage{newcent}",
  "\\usepackage{array}",
  "\\usepackage{enumerate}",
  "\\usepackage{longtable}",
  "\\usepackage{latexsym}",
  "\\usepackage{varioref}",
  "\\usepackage{color}",
  "\\ifpdf",
  "\\usepackage[pdftex]{graphicx}",
  "\\usepackage{epstopdf}",
  "\\pdfcompresslevel=9",
  "\\usepackage[",
  "  pdftex,",
  "  a4paper=true,",
  "  pdftitle={Network documentation},",
  "  pdfsubject={Network documentation},",
  "  pdfauthor={The network administrator},",
  "  colorlinks=true,",
  "  linkcolor=linkgreen,",
  "  pdfpagemode=None,",
  "  pdfstartview=FitH",
  "]{hyperref}",
  "\\definecolor{linkgreen}{rgb}{0,0.5,0}",
  "\\else",
  "\\usepackage[dvips]{graphicx}",
  "\\DeclareGraphicsRule{.png}{eps}{.bb}{`bmeps #1}",
  "\\usepackage[",
  "  dvips,",
  "  colorlinks=true,",
  "  linkcolor=linkgreen",
  "]{hyperref}",
  "\\definecolor{linkgreen}{rgb}{0,0.5,0}",
  "\\fi",
  "\\setlength{\\parindent}{0cm}",
  "\\author{The network administrator}",
  "\\title{Network documentation}",
  "\\setcounter{secnumdepth}{1}\n",
  "\\setcounter{tocdepth}{2}\n",
  "\\def\\leftsideoftable{0.18\\linewidth}",
  "\\def\\rightsideoftable{0.8\\linewidth}",
  "\\begin{document}",
  "\\begin{sloppy}",
  "\\maketitle",
  "\\tableofcontents",
  "",
  undef
);

my @depreamble = (
  "\\documentclass[ngerman,12pt,a4paper,titlepage]{scrartcl}",
  "\\usepackage{ngerman}",
  "\\usepackage{lscape}",
  "\\usepackage{ifpdf}",
  "\\usepackage[latin1]{inputenc}",
  "\\usepackage[T1]{fontenc}",
  "\\usepackage{textcomp}",
  "\\usepackage{newcent}",
  "\\usepackage{array}",
  "\\usepackage{enumerate}",
  "\\usepackage{longtable}",
  "\\usepackage{latexsym}",
  "\\usepackage[ngerman]{varioref}",
  "\\usepackage{color}",
  "\\ifpdf",
  "\\usepackage[pdftex]{graphicx}",
  "\\usepackage{epstopdf}",
  "\\pdfcompresslevel=9",
  "\\usepackage[",
  "  pdftex,",
  "  a4paper=true,",
  "  pdftitle={Netzwerk-Dokumentation},",
  "  pdfsubject={Netzwerk-Dokumentation},",
  "  pdfauthor={Der Netzwerk-Administrator},",
  "  colorlinks=true,",
  "  linkcolor=linkgreen,",
  "  pdfpagemode=None,",
  "  pdfstartview=FitH",
  "]{hyperref}",
  "\\definecolor{linkgreen}{rgb}{0,0.5,0}",
  "\\else",
  "\\usepackage[dvips]{graphicx}",
  "\\DeclareGraphicsRule{.png}{eps}{.bb}{`bmeps #1}",
  "\\usepackage[",
  "  dvips,\n  a4paper=true,",
  "  colorlinks=true,",
  "  linkcolor=linkgreen",
  "]{hyperref}",
  "\\definecolor{linkgreen}{rgb}{0,0.5,0}",
  "\\fi",
  "\\setlength{\\parindent}{0cm}",
  "\\author{Netzwerk-Administrator}",
  "\\title{Netzwerk-Dokumentation}",
  "\\setcounter{secnumdepth}{1}\n",
  "\\setcounter{tocdepth}{2}\n",
  "\\renewcommand*{\\sectfont}{\\bfseries}",
  "\\def\\leftsideoftable{0.18\\linewidth}",
  "\\def\\rightsideoftable{0.8\\linewidth}",
  "\\begin{document}",
  "\\begin{sloppy}",
  "\\maketitle",
  "\\tableofcontents",
  "",
  undef
);

my @postamble = (
  "\\end{sloppy}",
  "\\end{document}",
  undef
);

sub get_preamble
{
  my $class = shift;
  my $ts = shift;
  if($ts) {
    $enpreamble[0] =
    "\\documentclass[12pt,a4paper,titlepage,twoside]{article}";
    $depreamble[0] =
    "\\documentclass[ngerman,12pt,a4paper,titlepage,twoside]{scrartcl}";
  }
  my $back = \@enpreamble;
  if($ingerman) { $back = \@depreamble; }
  return $back;
}

sub get_postamble
{
  my $back = \@postamble;
  return $back;
}

my @englishstrings = (
  # 0 Hosts : section name for Hosts section
  "Hosts",
  # 1 Network : subsubsection name
  "Network",
  # 2 unknown
  "\\emph{unknown}",
  "IP address",		# 3 IP address
  "Ethernet address",	# 4 ethernet address
  "Overview",		# 5
  "User",		# 6
  "Administrator",	# 7
  "DNS domain name",	# 8
  "DNS aliases",	# 9
  "Purpose",		# 10
  "Serial number",	# 11
  "Inventory number",	# 12
  "Patch entry",	# 13
  "Network segment",	# 14
  "Host ID",		# 15
  "allowed",		# 16
  "denied",		# 17
  "NIS access",		# 18
  "NIS netgroups",	# 19
  "Inherited NIS netgroups", # 20
  "NIS netgroups",	# 21
  "Overview",		# 22
  "Location",		# 23
  "Purpose",		# 24
  "Member of",		# 25
  "Member groups",	# 26
  "Member hosts",	# 27
  "Name",		# 28
  "Classification / Permissions", 	# 29
);

my @germanstrings = (
  # 0 Hosts : Kapitelueberschrift Hosts
  "Hosts",
  # 1 Netzwerk
  "Netzwerk",
  # 2 unbekannt
  "\\emph{nicht bekannt}",
  "IP-Adresse",		# 3 IP-Adresse
  "Ethernet-Adresse",	# 4 Ethernet-Adresse
  "berblick",		# 5
  "Benutzer",		# 6
  "Administrator",	# 7
  "DNS-Domne",		# 8
  "Host-Name-Aliases",	# 9
  "Verwendung",		# 10
  "Seriennummer",	# 11
  "Inventarnummer",	# 12
  "Datendose",		# 13
  "Netz-Segment",	# 14
  "Host-ID",		# 15
  "gestattet",		# 16
  "verboten",		# 17
  "NIS-Zugriff",	# 18
  "NIS netgroups",	# 19
  "NIS netgroups indirekt", # 20
  "NIS netgroups",	# 21
  "bersicht",		# 22
  "Aufstellungsort",	# 23
  "Verwendung",		# 24
  "Mitglied in NIS netgroups",	# 25
  "Mitglieds-Gruppen",	# 26
  "Mitglieds-Hosts",	# 27
  "Name",		# 28
  "Klassifikation / Zugriffsrechte",	# 29
);

sub get_string
{
  my $class = shift;
  my $number = shift;
  my $back = undef;
  if($ingerman) {
    if($number >= 0) {
      if($number <= $#germanstrings) {
	$back = $germanstrings[$number];
      }
    }
  } else {
    if($number >= 0) {
      if($number <= $#englishstrings) {
	$back = $englishstrings[$number];
      }
    } 
  }
  return $back;
}

sub set_german
{
  my $class = shift;
  my $val = shift;
  $ingerman = $val;
}

1;

