#include <dk.h>

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dkmem.h>
#include <dklogc.h>
#include <dkapp.h>

static int exval = 1;

static dk_app_t *app = NULL;

static char groupname[] = { "testprog" };

static char tablename[] = { "hello" };

static char **msg = NULL;

static dk_key_value_t kv[] = {
  { "/m/00", "Hello world!" },
  { "/m/01", "Goodbye world!" },
  { "/m/02", "Test debug message." },
  { "/m/03", "Test warning message." },
  { "/m/04", "This error" },
  { "/m/05", " example message" },
  { "/m/06", " consists of multiple parts." },
  { "/m/07", "Command line argument " },
  { "/m/08", ": " }
};
static size_t szkv = sizeof(kv)/sizeof(dk_key_value_t);

int main(int argc, char *argv[])
{
  char *msgptr[4];	/* Used in log messages. */
  char numbuffer[32];	/* Buffer for command line argument. */
  char **lfdptr;	/* Used to traverse command line arguments. */
  int  i;		/* Index of current command line argument. */
  int  maxargc;		/* Maximum index of command line arguments. */
  app = dkapp_open_ext1(argc, argv, groupname, DK_SYSCONFDIR, 0, 0);
  if(app) {
    msg = dkapp_find_key_value(app, kv, szkv, tablename);
    if(msg) {
      maxargc = dkapp_get_argc(app);
      lfdptr = dkapp_get_argv(app);
      for(i = 0; i < maxargc; i++) {
        sprintf(numbuffer, "%d", i);
	msgptr[0] = msg[7];
	msgptr[1] = numbuffer;
	msgptr[2] = msg[8];
	msgptr[3] = *(lfdptr++);
	dkapp_log_msg(app, DK_LOG_LEVEL_INFO, msgptr, 4);
      }
      exval = 0;
      dk_delete(msg);
    } else {
      /* ERROR: Failed to obtain strings. */
    }
    dkapp_close(app); app = NULL;
  } else {
    /* ERROR: Failed to open application. */
  }
  exit(exval);
  return exval;
}


