/*
Copyright (c) 2009-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	fchksum.h	Internal functions for fchksum and fchksize.
*/

#ifndef CHKSUM_H_INCLUDED
#define CHKSUM_H_INCLUDED 1

#ifdef ON_A_WINDOWS_SYSTEM
#undef ON_A_WINDOWS_SYSTEM
#endif

#if defined(_WIN32) || defined(WIN32)
/**	Indicator for compilation on Windows systems.
*/
#define ON_A_WINDOWS_SYSTEM 1
#endif

#include <dkconfig.h>


#include <stdio.h>
#if DK_HAVE_STRING_H
#include <string.h>
#endif
#if DK_HAVE_CTYPE_H
#include <ctype.h>
#endif
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK_HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_FCNTL_H
#include <fcntl.h>
#endif
#if DK_HAVE_IO_H
#include <io.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif

#if DK_HAVE_OPENSSL_MD5_H && DK_HAVE_OPENSSL_SHA_H && DK_HAVE_OPENSSL_RIPEMD_H
#include <openssl/md5.h>
#include <openssl/sha.h>
#include <openssl/ripemd.h>
#else
#error "Missing at least one OpenSSL include file!"
#endif


/**	Case-insensitive string comparison.
*/
#if DK_HAVE_STRICMP
#define STRICMP(a,b) stricmp(a,b)
#else
#if DK_HAVE_STRCASECMP
#define STRICMP(a,b) strcasecmp(a,b)
#else
#define STRICMP(a,b) portable_stricmp(a,b)
#endif
#endif

/**	Digest type: Not known (yet). */
#define CHKSUM_DIGEST_UNKNOWN		0

/**	Digest type: SHA-1. */
#define CHKSUM_DIGEST_SHA_1		1

/**	Digest type: SHA-224. */
#define CHKSUM_DIGEST_SHA_224		2

/**	Digest type: SHA-256. */
#define CHKSUM_DIGEST_SHA_256		3

/**	Digest type: SHA-384. */
#define CHKSUM_DIGEST_SHA_384		4

/**	Digest type: SHA-512. */
#define CHKSUM_DIGEST_SHA_512		5

/**	Digest type: MD5. */
#define CHKSUM_DIGEST_MD5		6

/**	Digest type: RIPEMD-160. */
#define CHKSUM_DIGEST_RIPEMD_160	7
/* +++++ Further message digest algorithms here */

/**	Checksum encoding: Not known (yet). */
#define CHKSUM_ENCODING_UNKNOWN		0

/**	Checksum encoding: Hexadecimally. */
#define CHKSUM_ENCODING_HEX		1

/**	Checksum encoding: ASCII-85. */
#define CHKSUM_ENCODING_ASCII85		2

/**	Checksum encoding: Reverse ASCII-85. */
#define CHKSUM_ENCODING_RA85		3
/* +++++ Further binary-to-ASCII encodings here */

/**	Map fread(). */
#if ON_A_WINDOWS_SYSTEM
#define FREAD(a,b,c,d) fread(a,b,c,d)
#else
#define FREAD(a,b,c,d) fread(a,b,c,d)
#endif


/**	Mathemtical error: Result out of range. */
#define DK_ERR_MATH_OOR			4

#if SIZEOF_LONG == 8
/** Maximum value for unsigned long. */
#define DK_MAX_ULONG	(0xFFFFFFFFFFFFFFFFUL)
/** Maximum value for long. */
#define DK_MAX_LONG	(0x7FFFFFFFFFFFFFFFL)
#else
/** Maximum value for unsigned long. */
#define DK_MAX_ULONG	(0xFFFFFFFFUL)
/** Maximum value for long. */
#define DK_MAX_LONG	(0x7FFFFFFFL)
#endif

/**	Longest unsigned int type available. */
#if DK_HAVE_LONG_LONG_INT
typedef long long unsigned LLU;
/**	0 in long long unsigned. */
#define ZERO_LONG_LONG_UNSIGNED 0ULL
#else
/**	LLU is long unsigned. */
typedef long unsigned LLU;
/**	0 in long long unsigned. */
#define ZERO_LONG_LONG_UNSIGNED 0UL
#endif


#endif

