/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	b2dvips.c
	Conversions.
*/



/** Inside the b2dvips.c module. */
#define B2DVIPS_C	1
#include "bmepsi.h"
#include "dktools-version.h"



#line 52 "b2dvips.ctr"




/** Version number. */
static char versnumb[] = { VERSNUMB };


/** Dummy argv array to create application structure.
*/
static char *myargv[] = { "bmeps", NULL };

/** Name of temporary file 1.
*/
static char tmp1name[64];

/** Name of temporary file 2.
*/
static char tmp2name[64];

/** Name of temporary file 3.
*/
static char tmp3name[64];

/** Name of temporary file 4.
*/
static char tmp4name[64];

/** Name of temporary file 5.
*/
static char tmp5name[64];

/** Name of temporary file 6.
*/
static char tmp6name[64];

/** Name of temporary file 7.
*/
static char tmp7name[64];

/** Bmeps option set.
*/
static BO bo;

/** Bmeps job.
*/
static BJ bj;



/**	Configure the module-wide static variables exactly once.
	@param	langdef	Name of output language.
*/
static
void
make_sure_to_have_configured DK_P1(char *,langdef)
{
  static char not_yet_configured = 0x01; /* Flag: Not yet configured . */
  unsigned long ul;			 /* PID. */
  if(not_yet_configured) {
    bmeps_bj_init(&bj);
    bj.msg = bmeps_str_base();
    bj.bo = &bo;
    bj.a = dkapp_open_ext1(1, myargv, GROUPNAME, DK_SYSCONFDIR, 1, 1);
    bj.tmp1 = tmp1name;
    bj.tmp2 = tmp2name;
    bj.tmp3 = tmp3name;
    bj.tmp4 = tmp4name;
    bj.tmp5 = tmp5name;
    bj.tmp6 = tmp6name;
    bj.tmp7 = tmp7name;
    ul = (unsigned long)dksf_getpid();
    sprintf(tmp1name, "bmeps-%lu-1.tmp", ul);
    sprintf(tmp2name, "bmeps-%lu-2.tmp", ul);
    sprintf(tmp3name, "bmeps-%lu-3.tmp", ul);
    sprintf(tmp4name, "bmeps-%lu-4.tmp", ul);
    sprintf(tmp4name, "bmeps-%lu-5.tmp", ul);
    sprintf(tmp4name, "bmeps-%lu-6.tmp", ul);
    sprintf(tmp4name, "bmeps-%lu-7.tmp", ul);
    bmeps_bo_get_configuration(&bj, langdef, 1);
    if(bj.a) {
      dkapp_close(bj.a); bj.a = NULL;
    }
  }
}



/**	Use the configuration specified here as option.
	@param	langdef	Output language name.
*/
void
bmeps_cfg DK_P1(char *,langdef)
{
  
  make_sure_to_have_configured(langdef);
  
}



/**	Print bmeps version number to output.
	@param	f	Output file.
*/
void
bmeps_version DK_P1(FILE *,f)
{
  
  fprintf(f, "%s %s\n", "% bmeps", versnumb);
}



/**	Run a conversion.
	@param	outf	Output file.
	@param	inf	Input file.
	@param	name	Input file name.
  	@return 1 on success, 0 on error.
*/
int
bmeps_run DK_P3(FILE *,outf, FILE *,inf, char *,name)
{
  int back = 1;				/* Function result. */
  
  make_sure_to_have_configured(NULL);
  bj.outf = outf;
  bj.inf = inf;
  bj.infname = name;
  bj.frame_s = 0L;
  bj.frame_e = 0L;
  bj.frame_c = 0x01;	/* we really want only the first frame */
  bmeps_convert(&bj);
  
  if(bj.exval) back = 0;
  return back;
}



/**	Check whether the file with a given name can be handled.
	@param	name	File name.
	@return	1 if the file can be handled, 0 if not.
*/
int
bmeps_can_handle DK_P1(char *,name)
{
  int back = 0;				/* Function result. */
  back = dkbif_can_handle_name(name);
  return back;
}



