#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"


#include "dkbf.h"

MODULE = DKrause::BitMatrix	PACKAGE = DKrause::BitMatrix	PREFIX = b_


PROTOTYPES: ENABLE

DKrause::BitMatrix
b_new(r,c)
		size_t r;
		size_t c;
	PREINIT:
		dk_bitmatrix_t *back = NULL;
	CODE:
		back = dkbf_matrix_open(r, c);
		if(back) {
			RETVAL = back;
		} else {
			XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL

void
b_DESTROY(b)
		DKrause::BitMatrix b;
	CODE:
		dkbf_matrix_close(b);

void
b_set(b,x,y)
		DKrause::BitMatrix b;
		size_t x;
		size_t y;
	CODE:
		dkbf_matrix_set(b,x,y,1);

void
b_reset(b,x,y)
		DKrause::BitMatrix b;
		size_t x;
		size_t y;
	CODE:
		dkbf_matrix_set(b,x,y,0);

int
b_get(b,x,y)
		DKrause::BitMatrix b;
		size_t x;
		size_t y;
	CODE:
		RETVAL = dkbf_matrix_get(b,x,y);
	OUTPUT:
		RETVAL

int
b_expand(b)
		DKrause::BitMatrix b;
	CODE:
		RETVAL = dkbf_matrix_expand(b);
	OUTPUT:
		RETVAL
