/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/


/**	@file	yalcmsg.h	Include file for yalcmsg module.
 */


#ifndef YALCMSG_INC
#define YALCMSG_INC 1

#include <dk.h>


#if defined(EXTERN)
#undef EXTERN
#endif
#ifndef DK_YALCMSG_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif

#if defined(__cplusplus)
extern "C" {
#endif

/** Progress messae: Initialize message texts
 *  @param	app	Application.
 */
EXTERN void ym_init DK_PR((dk_app_t *app));

/** Error message: Configuration incomplete.  */
EXTERN void yme_incomplete_configuration DK_PR((void));

/** Progress message: Going to complete request data.  */
EXTERN void ymp_going_to_complete_request DK_PR((void));

/** Progress message: Request data completed.  */
EXTERN void ymp_request_completed DK_PR((void));

/** Error message: Failed to complete request data.  */
EXTERN void yme_failed_to_complete_request DK_PR((void));

/** Error message: lpr operation requires printer type.  */
EXTERN void yme_requires_type_rjlb DK_PR((void));

/** Error message: Operation requires BSD or LPRng printer type. */
EXTERN void yme_requires_type_lb DK_PR((void));

/** Error message: Failed to obtain filename for temporary file. */
EXTERN void yme_could_not_find_temp_filename DK_PR((void));

/** Error message: Failed to find temporary directory. */
EXTERN void yme_could_not_find_temp_directory DK_PR((void));

/** Error message: No print data available.  */
EXTERN void yme_no_data_to_print DK_PR((void));

/** Error message: File name too long.
 *  @param	n	File name.
 */
EXTERN void yme_file_name_too_long DK_PR((char *n));

/** Error message: Failed to open file name expander for pattern.
 *  @param	n	File name.
 */
EXTERN void yme_failed_to_open_filename_expander DK_PR((char *n));

/** Error message: Failed to write to file.
 *  @param	n	File name.
 */
EXTERN void yme_failed_to_write_to_file DK_PR((char *n));

/** Error message: Failed to read from file.
 *  @param	n	File name.
 */
EXTERN void yme_failed_to_read_from_file DK_PR((char *n));

/** Error message: Queue name too long.
 *  @param	n	Quque name.
 */
EXTERN void yme_queue_name_too_long DK_PR((char *n));

/** Error message: Illegal data or control file length.
 *  @param	d	Data file length.
 *  @param	c	Control file length.
*/
EXTERN void yme_illegal_file_length DK_PR((dk_long_long_unsigned_t d, dk_long_long_unsigned_t c));

/** Error message: Failed to find local network address.  */
EXTERN void yme_failed_to_find_local_network_address DK_PR((void));

/** Error message: Failed to find remote host.
 *  @param	n	Host name.
 */
EXTERN void yme_failed_to_find_remote_host DK_PR((char *n));

/** Error message: Failed to establish communication.
 *  @param	n	Host name.
 */
EXTERN void yme_failed_to_establish_connection DK_PR((char *n));

/** Error message: Error while sending data.  */
EXTERN void yme_error_while_sending DK_PR((void));

/** Error message: Error while receiving data. */
EXTERN void yme_error_while_receiving DK_PR((void)); 

/** Error message: The server does not accept jobs.  */
EXTERN void yme_server_does_not_accept_jobs DK_PR((void));

/** Error message: Failed to find job number.  */
EXTERN void yme_failed_to_find_job_number DK_PR((void));

/** Error Message: Too few arguments for lpc, missing command.  */
EXTERN void yme_missing_command_in_lpc DK_PR((void));

/** Error message: Unknown command in lpc.  */
EXTERN void yme_unknown_command_in_lpc DK_PR((void));

/** Error message: Lpc option allowed for LPRng print servers only.  */
EXTERN void yme_lpc_for_lprng_only DK_PR((void));

/** Error message: Stat failed.
 *  @param	n	File name.
 */
EXTERN void yme_stat_failed_for_file DK_PR((char *n));

/** Progress message: Going to configure local NIC. */
EXTERN void ymp_configure_local_nic DK_PR((void));

/** Progress message: Local NIC configured. */
EXTERN void ymp_local_nic_configured DK_PR((void));

/** Progress message: Will look up remote host.
 *  @param	n	Host name.
 */
EXTERN void ymp_lookup_remote DK_PR((char *n));

/** Progress message: Lookup of remote host succeeded.
 *  @param	n	Host name.
 */
EXTERN void ymp_looked_up_remote DK_PR((char *n));

/** Progress message: Will try to connect.
 *  @param	n	Host name.
 */
EXTERN void ymp_connect DK_PR((char *n));

/** Progress message: Connected.
 *  @param	n	Host name.
 */
EXTERN void ymp_connected DK_PR((char *n));

/** Progress message: Will try to read bytes from file.
 *  @param	n	File name.
 *  @param	num	Number of bytes.
 */
EXTERN void ymp_try_read DK_PR((char *n, unsigned long num));

/** Progess message: Have read bytes from file.
 *  @param	n	File name.
 *  @param	num	Number of bytes.
 */
EXTERN void ymp_have_read DK_PR((char *n, unsigned long num));

/** Progress message: Will try to send bytes.
 *  @param	num	Number of bytes.
 */
EXTERN void ymp_try_send DK_PR((unsigned long num));

/** Progress message: Have sent bytes.
 *  @param	num	Number of bytes.
 */
EXTERN void ymp_have_send DK_PR((unsigned long num));

/** Progress message: Try to receive bytes.
 *  @param	num	Buffer length.
 */
EXTERN void ymp_try_receive DK_PR((unsigned long num));

/** Progress message: Have received bytes.
 *  @param	num	Number of bytes.
 */
EXTERN void ymp_have_received DK_PR((unsigned long num));

/** Progress message: Going to close connection. */
EXTERN void ymp_close_conn DK_PR((void));

/** Progress message: Connection closed. */
EXTERN void ymp_have_closed_conn DK_PR((void));

/** Progress message: Going to print one file.
 *  @param	n	File name.
 */
EXTERN void ymp_print_one DK_PR((char *n));

/** Progress message: Printed one file.
 *  @param	n	File name.
 */
EXTERN void ymp_printed_one DK_PR((char *n));

/** Error message: Error in sleep. */
EXTERN void yme_no_sleep DK_PR((void));

/** Error message: No configuration found for SNMP type.
 *  @param	n	Configuration file name.
 *  @param	ln	Line number.
 */
EXTERN void yme_snmp_bad_type DK_PR((char *n, unsigned long ln));

/** Error message: Error in SNMP configuration file.
 *  @param	n	Configuration file name
 *  @param	ln	Line number.
 */
EXTERN void yme_snmp_bad_conf DK_PR((char *n, unsigned long ln));

/** Error message: Missing key for OID.
 *  @param	ln	Index of OID to complain about.
 */
EXTERN void yme_snmp_missing_key DK_PR((unsigned long ln));

/** Error message: Missing value for OID.
 *  @param	ln	Index of OID to complain about.
 */
EXTERN void yme_snmp_missing_val DK_PR((unsigned long ln));

/** Error message: No variables in response.
 *  @param	ln	Number of variables.
 */
EXTERN void yme_snmp_no_var DK_PR((unsigned long ln));

/** Error message: SNMP type not found.
 *  @param	n	Type name.
 */
EXTERN void yme_snmp_type_not_found DK_PR((char *n));

/** Error message: Failed to construct request PDU. */
EXTERN void yme_snmp_request_pdu DK_PR((void));

/** Error Message: Bad OID string.
 *  @param	n	OID string to complain about.
 */
EXTERN void yme_snmp_bad_oid_string DK_PR((char *n));

/** Error message: Error in SNMP response packet. */
EXTERN void yme_snmp_response_packet DK_PR((void));

/** Error message: No SNMP response. */
EXTERN void yme_snmp_no_response DK_PR((void));

/** Progress message: Start processing SNMP configuration file. */
EXTERN void ymp_snmp_start_config_file DK_PR((void));

/** Progress message: Finished SNMP configuration file. */
EXTERN void ymp_snmp_end_config_file DK_PR((void));

/** Progress message: Start to process SNMP configuration section. */
EXTERN void ymp_snmp_start_config_section DK_PR((void));

/** Progress message: Configuration section finished. */
EXTERN void ymp_snmp_end_config_section DK_PR((void));

/** Progress message: Starting SNMP request. */
EXTERN void ymp_snmp_start_request DK_PR((void));

/** Progress message: SNMP request finished. */
EXTERN void ymp_snmp_end_request DK_PR((void));

/** Error message: Failed to open SNMP session. */
EXTERN void yme_snmp_failed_to_open_session DK_PR((void));

/** Error message: No SNMP configuration file. */
EXTERN void yme_snmp_failed_to_open_configuration DK_PR((void));

/** Error message: Missing SNMP host. */
EXTERN void yme_snmp_no_host DK_PR((void));

/** Error message: Missing SNMP type. */
EXTERN void yme_snmp_no_type DK_PR((void));

/** Error message: Missing host name. */
EXTERN void yme_err_no_hostname DK_PR((void));

/** Error message: Host name too long.
 *  @param	hn	Host name.
 */
EXTERN void yme_err_hostname_too_long DK_PR((char *hn));

/** Error message: Missing user name. */
EXTERN void yme_err_no_user_name DK_PR((void));

/** Error message: User name too long.
 *  @param	hn	User name.
 */
EXTERN void yme_err_username_too_long DK_PR((char *hn));

/** Error message: Failed to save new job ID. */
EXTERN void yme_err_save_jobid DK_PR((void));

/** Error message: Error to open registry key for job ID. */
EXTERN void yme_err_open_jobid_regkey DK_PR((char *hn));

/** Error message: Error while creating request PDU. */
EXTERN void yme_err_snmp_request_pdu DK_PR((void));

#if defined(__cplusplus)
}
#endif

#endif
/* ifndef YALCMSG_INC */

