/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include <dk.h>
#include <dkstr.h>
#include <dkmem.h>
#include <dksf.h>

#include <stdio.h>
#include <string.h>
#include <winbase.h>
#include <winreg.h>

struct _key_val_ {
  char *key;
  char *value;
} ;
typedef struct _key_val_ key_val;

static char buffer[1024];

static key_val keys_to_set_createp[] = {
  { "all/all:/password/type", "user" },
  { "all/all:/password/user/length",   "6" },
  { "all/all:/password/user/digits",   "2" },
  { "all/all:/password/user/specials", "0" },
  { "all/all:/password/user/capitals", "0" },
  { "all/all:/password/admin/length",   "8" },
  { "all/all:/password/admin/digits",   "1-3" },
  { "all/all:/password/admin/specials", "1-2" },
  { "all/all:/password/admin/capitals", "1-2" },
  { "all/all:/password/dialin/length",   "8" },
  { "all/all:/password/dialin/digits",   "2-4" },
  { "all/all:/password/dialin/specials", "0" },
  { "all/all:/password/dialin/capitals", "0" },
  { NULL, NULL }
};

static void save_the_keys_createp(void)
{
  HKEY hkTemp;
  PHKEY phkSubkey;
  DWORD disp, dwType, sz;
  LONG retval;
  key_val *kvptr;
  int ok;
  size_t maxpathlen;
  hkTemp = 0;
  phkSubkey = &hkTemp;
  maxpathlen = sizeof(buffer);
  retval = RegCreateKeyEx(
    HKEY_LOCAL_MACHINE, "Software\\Dkapp\\createp",
    0, NULL, REG_OPTION_NON_VOLATILE,
    KEY_ALL_ACCESS,
    NULL,
    phkSubkey,
    &disp
  );
  if(retval == ERROR_SUCCESS) { 
    kvptr = keys_to_set_createp;
    while(kvptr->key) { 
      if(kvptr->value) { 
	ok = 0; retval = ERROR_SUCCESS - 1L;
	sz = maxpathlen;
	phkSubkey = &hkTemp;
        retval = RegQueryValueEx(
	  hkTemp,
	  kvptr->key,
	  NULL,
	  &dwType,
	  buffer,
	  &sz
	);
	if(retval == ERROR_SUCCESS) { 
	  if(dwType == REG_SZ) { 
	    ok = 1;
	  }
	}
	if(!ok) { 
	  retval = RegSetValueEx(
	    hkTemp,
	    kvptr->key,
	    0,
	    REG_SZ,
	    kvptr->value,
	    (strlen(kvptr->value) + 1)
	  );
	  
	}
      }
      kvptr++;
    }
    RegCloseKey(hkTemp);
  }
}

int main(int argc, char *argv[])
{
  save_the_keys_createp();
  exit(0); return 0;
}
